/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka010.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import shaded.alink.kafka010.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka010.org.apache.kafka.common.protocol.Errors;
import shaded.alink.kafka010.org.apache.kafka.common.protocol.ProtoUtils;
import shaded.alink.kafka010.org.apache.kafka.common.protocol.types.Schema;
import shaded.alink.kafka010.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka010.org.apache.kafka.common.requests.AbstractRequest;
import shaded.alink.kafka010.org.apache.kafka.common.requests.AbstractResponse;
import shaded.alink.kafka010.org.apache.kafka.common.requests.SaslHandshakeResponse;

public class SaslHandshakeRequest
extends AbstractRequest {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentRequestSchema(ApiKeys.SASL_HANDSHAKE.id);
    public static final String MECHANISM_KEY_NAME = "mechanism";
    private final String mechanism;

    public SaslHandshakeRequest(String mechanism) {
        super(new Struct(CURRENT_SCHEMA), ProtoUtils.latestVersion(ApiKeys.SASL_HANDSHAKE.id));
        this.struct.set(MECHANISM_KEY_NAME, (Object)mechanism);
        this.mechanism = mechanism;
    }

    public SaslHandshakeRequest(Struct struct, short versionId) {
        super(struct, versionId);
        this.mechanism = struct.getString(MECHANISM_KEY_NAME);
    }

    public String mechanism() {
        return this.mechanism;
    }

    @Override
    public AbstractResponse getErrorResponse(Throwable e) {
        short versionId = this.version();
        switch (versionId) {
            case 0: {
                List<String> enabledMechanisms = Collections.emptyList();
                return new SaslHandshakeResponse(Errors.forException(e).code(), enabledMechanisms);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ProtoUtils.latestVersion(ApiKeys.SASL_HANDSHAKE.id)));
    }

    public static SaslHandshakeRequest parse(ByteBuffer buffer, int versionId) {
        return new SaslHandshakeRequest(ProtoUtils.parseRequest(ApiKeys.SASL_HANDSHAKE.id, versionId, buffer), (short)versionId);
    }

    public static SaslHandshakeRequest parse(ByteBuffer buffer) {
        return SaslHandshakeRequest.parse(buffer, ProtoUtils.latestVersion(ApiKeys.SASL_HANDSHAKE.id));
    }
}

