/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import shaded.alink.kafka.org.apache.kafka.common.TopicPartition;
import shaded.alink.kafka.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka.org.apache.kafka.common.protocol.CommonFields;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Errors;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Field;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Schema;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka.org.apache.kafka.common.requests.AbstractRequest;
import shaded.alink.kafka.org.apache.kafka.common.requests.AbstractResponse;
import shaded.alink.kafka.org.apache.kafka.common.requests.OffsetCommitResponse;
import shaded.alink.kafka.org.apache.kafka.common.requests.RequestUtils;
import shaded.alink.kafka.org.apache.kafka.common.utils.CollectionUtils;

public class OffsetCommitRequest
extends AbstractRequest {
    private static final Field.ComplexArray TOPICS = new Field.ComplexArray("topics", "Topics to commit offsets");
    private static final Field.ComplexArray PARTITIONS = new Field.ComplexArray("partitions", "Partitions to commit offsets");
    @Deprecated
    private static final Field.Int64 COMMIT_TIMESTAMP = new Field.Int64("timestamp", "Timestamp of the commit");
    private static final Field.Int64 RETENTION_TIME = new Field.Int64("retention_time", "Time period in ms to retain the offset.");
    private static final Field PARTITIONS_V0 = PARTITIONS.withFields(CommonFields.PARTITION_ID, CommonFields.COMMITTED_OFFSET, CommonFields.COMMITTED_METADATA);
    private static final Field TOPICS_V0 = TOPICS.withFields(CommonFields.TOPIC_NAME, PARTITIONS_V0);
    private static final Schema OFFSET_COMMIT_REQUEST_V0 = new Schema(CommonFields.GROUP_ID, TOPICS_V0);
    private static final Field PARTITIONS_V1 = PARTITIONS.withFields(CommonFields.PARTITION_ID, CommonFields.COMMITTED_OFFSET, COMMIT_TIMESTAMP, CommonFields.COMMITTED_METADATA);
    private static final Field TOPICS_V1 = TOPICS.withFields(CommonFields.TOPIC_NAME, PARTITIONS_V1);
    private static final Schema OFFSET_COMMIT_REQUEST_V1 = new Schema(CommonFields.GROUP_ID, CommonFields.GENERATION_ID, CommonFields.MEMBER_ID, TOPICS_V1);
    private static final Field PARTITIONS_V2 = PARTITIONS.withFields(CommonFields.PARTITION_ID, CommonFields.COMMITTED_OFFSET, CommonFields.COMMITTED_METADATA);
    private static final Field TOPICS_V2 = TOPICS.withFields(CommonFields.TOPIC_NAME, PARTITIONS_V2);
    private static final Schema OFFSET_COMMIT_REQUEST_V2;
    private static final Schema OFFSET_COMMIT_REQUEST_V3;
    private static final Schema OFFSET_COMMIT_REQUEST_V4;
    private static final Schema OFFSET_COMMIT_REQUEST_V5;
    private static final Field PARTITIONS_V6;
    private static final Field TOPICS_V6;
    private static final Schema OFFSET_COMMIT_REQUEST_V6;
    public static final int DEFAULT_GENERATION_ID = -1;
    public static final String DEFAULT_MEMBER_ID = "";
    public static final long DEFAULT_RETENTION_TIME = -1L;
    @Deprecated
    public static final long DEFAULT_TIMESTAMP = -1L;
    private final String groupId;
    private final String memberId;
    private final int generationId;
    private final long retentionTime;
    private final Map<TopicPartition, PartitionData> offsetData;

    public static Schema[] schemaVersions() {
        return new Schema[]{OFFSET_COMMIT_REQUEST_V0, OFFSET_COMMIT_REQUEST_V1, OFFSET_COMMIT_REQUEST_V2, OFFSET_COMMIT_REQUEST_V3, OFFSET_COMMIT_REQUEST_V4, OFFSET_COMMIT_REQUEST_V5, OFFSET_COMMIT_REQUEST_V6};
    }

    private OffsetCommitRequest(String groupId, int generationId, String memberId, long retentionTime, Map<TopicPartition, PartitionData> offsetData, short version) {
        super(ApiKeys.OFFSET_COMMIT, version);
        this.groupId = groupId;
        this.generationId = generationId;
        this.memberId = memberId;
        this.retentionTime = retentionTime;
        this.offsetData = offsetData;
    }

    public OffsetCommitRequest(Struct struct, short versionId) {
        super(ApiKeys.OFFSET_COMMIT, versionId);
        this.groupId = struct.get(CommonFields.GROUP_ID);
        this.generationId = struct.getOrElse(CommonFields.GENERATION_ID, -1);
        this.memberId = struct.getOrElse(CommonFields.MEMBER_ID, DEFAULT_MEMBER_ID);
        this.retentionTime = struct.getOrElse(RETENTION_TIME, -1L);
        this.offsetData = new HashMap<TopicPartition, PartitionData>();
        for (Object topicDataObj : struct.get(TOPICS)) {
            Struct topicData = (Struct)topicDataObj;
            String topic = topicData.get(CommonFields.TOPIC_NAME);
            for (Object partitionDataObj : topicData.get(PARTITIONS)) {
                PartitionData partitionOffset;
                Struct partitionDataStruct = (Struct)partitionDataObj;
                int partition = partitionDataStruct.get(CommonFields.PARTITION_ID);
                long offset = partitionDataStruct.get(CommonFields.COMMITTED_OFFSET);
                String metadata = partitionDataStruct.get(CommonFields.COMMITTED_METADATA);
                if (partitionDataStruct.hasField(COMMIT_TIMESTAMP)) {
                    long timestamp = partitionDataStruct.get(COMMIT_TIMESTAMP);
                    partitionOffset = new PartitionData(offset, timestamp, metadata);
                } else {
                    Optional<Integer> leaderEpochOpt = RequestUtils.getLeaderEpoch(partitionDataStruct, CommonFields.COMMITTED_LEADER_EPOCH);
                    partitionOffset = new PartitionData(offset, leaderEpochOpt, metadata);
                }
                this.offsetData.put(new TopicPartition(topic, partition), partitionOffset);
            }
        }
    }

    @Override
    public Struct toStruct() {
        short version = this.version();
        Struct struct = new Struct(ApiKeys.OFFSET_COMMIT.requestSchema(version));
        struct.set(CommonFields.GROUP_ID, this.groupId);
        Map<String, Map<Integer, PartitionData>> topicsData = CollectionUtils.groupPartitionDataByTopic(this.offsetData);
        ArrayList<Struct> topicArray = new ArrayList<Struct>();
        for (Map.Entry<String, Map<Integer, PartitionData>> topicEntry : topicsData.entrySet()) {
            Struct topicData = struct.instance(TOPICS);
            topicData.set(CommonFields.TOPIC_NAME, topicEntry.getKey());
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, PartitionData> partitionEntry : topicEntry.getValue().entrySet()) {
                PartitionData fetchPartitionData = partitionEntry.getValue();
                Struct partitionData = topicData.instance(PARTITIONS);
                partitionData.set(CommonFields.PARTITION_ID, partitionEntry.getKey());
                partitionData.set(CommonFields.COMMITTED_OFFSET, fetchPartitionData.offset);
                partitionData.setIfExists(COMMIT_TIMESTAMP, (Object)fetchPartitionData.timestamp);
                RequestUtils.setLeaderEpochIfExists(partitionData, CommonFields.COMMITTED_LEADER_EPOCH, fetchPartitionData.leaderEpoch);
                partitionData.set(CommonFields.COMMITTED_METADATA, fetchPartitionData.metadata);
                partitionArray.add(partitionData);
            }
            topicData.set(PARTITIONS, partitionArray.toArray());
            topicArray.add(topicData);
        }
        struct.set(TOPICS, topicArray.toArray());
        struct.setIfExists(CommonFields.GENERATION_ID, (Object)this.generationId);
        struct.setIfExists(CommonFields.MEMBER_ID, (Object)this.memberId);
        struct.setIfExists(RETENTION_TIME, (Object)this.retentionTime);
        return struct;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        HashMap<TopicPartition, Errors> responseData = new HashMap<TopicPartition, Errors>();
        for (Map.Entry<TopicPartition, PartitionData> entry : this.offsetData.entrySet()) {
            responseData.put(entry.getKey(), Errors.forException(e));
        }
        short versionId = this.version();
        switch (versionId) {
            case 0: 
            case 1: 
            case 2: {
                return new OffsetCommitResponse(responseData);
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return new OffsetCommitResponse(throttleTimeMs, responseData);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.OFFSET_COMMIT.latestVersion()));
    }

    public String groupId() {
        return this.groupId;
    }

    public int generationId() {
        return this.generationId;
    }

    public String memberId() {
        return this.memberId;
    }

    @Deprecated
    public long retentionTime() {
        return this.retentionTime;
    }

    public Map<TopicPartition, PartitionData> offsetData() {
        return this.offsetData;
    }

    public static OffsetCommitRequest parse(ByteBuffer buffer, short version) {
        Schema schema = ApiKeys.OFFSET_COMMIT.requestSchema(version);
        return new OffsetCommitRequest(schema.read(buffer), version);
    }

    static {
        OFFSET_COMMIT_REQUEST_V4 = OFFSET_COMMIT_REQUEST_V3 = (OFFSET_COMMIT_REQUEST_V2 = new Schema(CommonFields.GROUP_ID, CommonFields.GENERATION_ID, CommonFields.MEMBER_ID, RETENTION_TIME, TOPICS_V2));
        OFFSET_COMMIT_REQUEST_V5 = new Schema(CommonFields.GROUP_ID, CommonFields.GENERATION_ID, CommonFields.MEMBER_ID, TOPICS_V2);
        PARTITIONS_V6 = PARTITIONS.withFields(CommonFields.PARTITION_ID, CommonFields.COMMITTED_OFFSET, CommonFields.COMMITTED_LEADER_EPOCH, CommonFields.COMMITTED_METADATA);
        TOPICS_V6 = TOPICS.withFields(CommonFields.TOPIC_NAME, PARTITIONS_V6);
        OFFSET_COMMIT_REQUEST_V6 = new Schema(CommonFields.GROUP_ID, CommonFields.GENERATION_ID, CommonFields.MEMBER_ID, TOPICS_V6);
    }

    public static class Builder
    extends AbstractRequest.Builder<OffsetCommitRequest> {
        private final String groupId;
        private final Map<TopicPartition, PartitionData> offsetData;
        private String memberId = "";
        private int generationId = -1;

        public Builder(String groupId, Map<TopicPartition, PartitionData> offsetData) {
            super(ApiKeys.OFFSET_COMMIT);
            this.groupId = groupId;
            this.offsetData = offsetData;
        }

        public Builder setMemberId(String memberId) {
            this.memberId = memberId;
            return this;
        }

        public Builder setGenerationId(int generationId) {
            this.generationId = generationId;
            return this;
        }

        @Override
        public OffsetCommitRequest build(short version) {
            if (version == 0) {
                return new OffsetCommitRequest(this.groupId, -1, OffsetCommitRequest.DEFAULT_MEMBER_ID, -1L, this.offsetData, version);
            }
            return new OffsetCommitRequest(this.groupId, this.generationId, this.memberId, -1L, this.offsetData, version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=OffsetCommitRequest").append(", groupId=").append(this.groupId).append(", memberId=").append(this.memberId).append(", generationId=").append(this.generationId).append(", offsetData=").append(this.offsetData).append(")");
            return bld.toString();
        }
    }

    public static final class PartitionData {
        @Deprecated
        public final long timestamp;
        public final long offset;
        public final String metadata;
        public final Optional<Integer> leaderEpoch;

        private PartitionData(long offset, Optional<Integer> leaderEpoch, long timestamp, String metadata) {
            this.offset = offset;
            this.leaderEpoch = leaderEpoch;
            this.timestamp = timestamp;
            this.metadata = metadata;
        }

        @Deprecated
        public PartitionData(long offset, long timestamp, String metadata) {
            this(offset, Optional.empty(), timestamp, metadata);
        }

        public PartitionData(long offset, Optional<Integer> leaderEpoch, String metadata) {
            this(offset, leaderEpoch, -1L, metadata);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(timestamp=").append(this.timestamp).append(", offset=").append(this.offset).append(", leaderEpoch=").append(this.leaderEpoch).append(", metadata=").append(this.metadata).append(")");
            return bld.toString();
        }
    }
}

