/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import shaded.alink.kafka.org.apache.kafka.common.errors.UnsupportedVersionException;
import shaded.alink.kafka.org.apache.kafka.common.protocol.ApiMessage;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Message;
import shaded.alink.kafka.org.apache.kafka.common.protocol.MessageUtil;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Readable;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Writable;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.ArrayOf;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Field;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Schema;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Type;

public class OffsetCommitRequestData
implements ApiMessage {
    private String groupId;
    private int generationId;
    private String memberId;
    private long retentionTimeMs;
    private List<OffsetCommitRequestTopic> topics;
    public static final Schema SCHEMA_0 = new Schema(new Field("group_id", Type.STRING, "The unique group identifier."), new Field("topics", new ArrayOf(OffsetCommitRequestTopic.SCHEMA_0), "The topics to commit offsets for."));
    public static final Schema SCHEMA_1 = new Schema(new Field("group_id", Type.STRING, "The unique group identifier."), new Field("generation_id", Type.INT32, "The generation of the group."), new Field("member_id", Type.STRING, "The member ID assigned by the group coordinator."), new Field("topics", new ArrayOf(OffsetCommitRequestTopic.SCHEMA_1), "The topics to commit offsets for."));
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema[] SCHEMAS;

    public OffsetCommitRequestData(Readable readable, short version) {
        this.topics = new ArrayList<OffsetCommitRequestTopic>();
        this.read(readable, version);
    }

    public OffsetCommitRequestData(Struct struct, short version) {
        this.topics = new ArrayList<OffsetCommitRequestTopic>();
        this.fromStruct(struct, version);
    }

    public OffsetCommitRequestData() {
        this.groupId = "";
        this.generationId = -1;
        this.memberId = "";
        this.retentionTimeMs = -1L;
        this.topics = new ArrayList<OffsetCommitRequestTopic>();
    }

    @Override
    public short apiKey() {
        return 8;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 6;
    }

    @Override
    public void read(Readable readable, short version) {
        this.groupId = readable.readNullableString();
        this.generationId = version >= 1 ? readable.readInt() : -1;
        this.memberId = version >= 1 ? readable.readNullableString() : "";
        this.retentionTimeMs = version >= 2 && version <= 4 ? readable.readLong() : -1L;
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.topics.clear();
        } else {
            this.topics.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.topics.add(new OffsetCommitRequestTopic(readable, version));
            }
        }
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeString(this.groupId);
        if (version >= 1) {
            writable.writeInt(this.generationId);
        }
        if (version >= 1) {
            writable.writeString(this.memberId);
        }
        if (version >= 2 && version <= 4) {
            writable.writeLong(this.retentionTimeMs);
        }
        writable.writeInt(this.topics.size());
        for (OffsetCommitRequestTopic element : this.topics) {
            element.write(writable, version);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.groupId = struct.getString("group_id");
        this.generationId = version >= 1 ? struct.getInt("generation_id") : -1;
        this.memberId = version >= 1 ? struct.getString("member_id") : "";
        this.retentionTimeMs = version >= 2 && version <= 4 ? struct.getLong("retention_time_ms") : -1L;
        Object[] nestedObjects = struct.getArray("topics");
        this.topics = new ArrayList<OffsetCommitRequestTopic>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.topics.add(new OffsetCommitRequestTopic((Struct)nestedObject, version));
        }
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("group_id", (Object)this.groupId);
        if (version >= 1) {
            struct.set("generation_id", (Object)this.generationId);
        }
        if (version >= 1) {
            struct.set("member_id", (Object)this.memberId);
        }
        if (version >= 2 && version <= 4) {
            struct.set("retention_time_ms", (Object)this.retentionTimeMs);
        }
        Struct[] nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        for (OffsetCommitRequestTopic element : this.topics) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("topics", (Object)nestedObjects);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 2;
        size += MessageUtil.serializedUtf8Length(this.groupId);
        if (version >= 1) {
            size += 4;
        }
        if (version >= 1) {
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.memberId);
        }
        if (version >= 2 && version <= 4) {
            size += 8;
        }
        size += 4;
        for (OffsetCommitRequestTopic element : this.topics) {
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OffsetCommitRequestData)) {
            return false;
        }
        OffsetCommitRequestData other = (OffsetCommitRequestData)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.generationId != other.generationId) {
            return false;
        }
        if (this.memberId == null ? other.memberId != null : !this.memberId.equals(other.memberId)) {
            return false;
        }
        if (this.retentionTimeMs != other.retentionTimeMs) {
            return false;
        }
        return !(this.topics == null ? other.topics != null : !this.topics.equals(other.topics));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
        hashCode = 31 * hashCode + this.generationId;
        hashCode = 31 * hashCode + (this.memberId == null ? 0 : this.memberId.hashCode());
        hashCode = 31 * hashCode + ((int)(this.retentionTimeMs >> 32) ^ (int)this.retentionTimeMs);
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    public String toString() {
        return "OffsetCommitRequestData(groupId='" + this.groupId + "', generationId=" + this.generationId + ", memberId='" + this.memberId + "', retentionTimeMs=" + this.retentionTimeMs + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public String groupId() {
        return this.groupId;
    }

    public int generationId() {
        return this.generationId;
    }

    public String memberId() {
        return this.memberId;
    }

    public long retentionTimeMs() {
        return this.retentionTimeMs;
    }

    public List<OffsetCommitRequestTopic> topics() {
        return this.topics;
    }

    public OffsetCommitRequestData setGroupId(String v) {
        this.groupId = v;
        return this;
    }

    public OffsetCommitRequestData setGenerationId(int v) {
        this.generationId = v;
        return this;
    }

    public OffsetCommitRequestData setMemberId(String v) {
        this.memberId = v;
        return this;
    }

    public OffsetCommitRequestData setRetentionTimeMs(long v) {
        this.retentionTimeMs = v;
        return this;
    }

    public OffsetCommitRequestData setTopics(List<OffsetCommitRequestTopic> v) {
        this.topics = v;
        return this;
    }

    static {
        SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = new Schema(new Field("group_id", Type.STRING, "The unique group identifier."), new Field("generation_id", Type.INT32, "The generation of the group."), new Field("member_id", Type.STRING, "The member ID assigned by the group coordinator."), new Field("retention_time_ms", Type.INT64, "The time period in ms to retain the offset."), new Field("topics", new ArrayOf(OffsetCommitRequestTopic.SCHEMA_2), "The topics to commit offsets for.")));
        SCHEMA_5 = new Schema(new Field("group_id", Type.STRING, "The unique group identifier."), new Field("generation_id", Type.INT32, "The generation of the group."), new Field("member_id", Type.STRING, "The member ID assigned by the group coordinator."), new Field("topics", new ArrayOf(OffsetCommitRequestTopic.SCHEMA_2), "The topics to commit offsets for."));
        SCHEMA_6 = new Schema(new Field("group_id", Type.STRING, "The unique group identifier."), new Field("generation_id", Type.INT32, "The generation of the group."), new Field("member_id", Type.STRING, "The member ID assigned by the group coordinator."), new Field("topics", new ArrayOf(OffsetCommitRequestTopic.SCHEMA_6), "The topics to commit offsets for."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6};
    }

    public static class OffsetCommitRequestPartition
    implements Message {
        private int partitionIndex;
        private long committedOffset;
        private int committedLeaderEpoch;
        private long commitTimestamp;
        private String committedMetadata;
        public static final Schema SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("committed_offset", Type.INT64, "The message offset to be committed."), new Field("committed_metadata", Type.NULLABLE_STRING, "Any associated metadata the client wants to keep."));
        public static final Schema SCHEMA_1 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("committed_offset", Type.INT64, "The message offset to be committed."), new Field("commit_timestamp", Type.INT64, "The timestamp of the commit."), new Field("committed_metadata", Type.NULLABLE_STRING, "Any associated metadata the client wants to keep."));
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema[] SCHEMAS;

        public OffsetCommitRequestPartition(Readable readable, short version) {
            this.read(readable, version);
        }

        public OffsetCommitRequestPartition(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public OffsetCommitRequestPartition() {
            this.partitionIndex = 0;
            this.committedOffset = 0L;
            this.committedLeaderEpoch = -1;
            this.commitTimestamp = -1L;
            this.committedMetadata = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 6;
        }

        @Override
        public void read(Readable readable, short version) {
            this.partitionIndex = readable.readInt();
            this.committedOffset = readable.readLong();
            this.committedLeaderEpoch = version >= 6 ? readable.readInt() : -1;
            this.commitTimestamp = version >= 1 && version <= 1 ? readable.readLong() : -1L;
            this.committedMetadata = readable.readNullableString();
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeInt(this.partitionIndex);
            writable.writeLong(this.committedOffset);
            if (version >= 6) {
                writable.writeInt(this.committedLeaderEpoch);
            }
            if (version >= 1 && version <= 1) {
                writable.writeLong(this.commitTimestamp);
            }
            writable.writeNullableString(this.committedMetadata);
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.partitionIndex = struct.getInt("partition_index");
            this.committedOffset = struct.getLong("committed_offset");
            this.committedLeaderEpoch = version >= 6 ? struct.getInt("committed_leader_epoch") : -1;
            this.commitTimestamp = version >= 1 && version <= 1 ? struct.getLong("commit_timestamp") : -1L;
            this.committedMetadata = struct.getString("committed_metadata");
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("committed_offset", (Object)this.committedOffset);
            if (version >= 6) {
                struct.set("committed_leader_epoch", (Object)this.committedLeaderEpoch);
            }
            if (version >= 1 && version <= 1) {
                struct.set("commit_timestamp", (Object)this.commitTimestamp);
            }
            struct.set("committed_metadata", (Object)this.committedMetadata);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 4;
            size += 8;
            if (version >= 6) {
                size += 4;
            }
            if (version >= 1 && version <= 1) {
                size += 8;
            } else if (this.commitTimestamp != -1L) {
                throw new UnsupportedVersionException("Attempted to write a non-default commitTimestamp at version " + version);
            }
            size += 2;
            if (this.committedMetadata != null) {
                size += MessageUtil.serializedUtf8Length(this.committedMetadata);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OffsetCommitRequestPartition)) {
                return false;
            }
            OffsetCommitRequestPartition other = (OffsetCommitRequestPartition)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.committedOffset != other.committedOffset) {
                return false;
            }
            if (this.committedLeaderEpoch != other.committedLeaderEpoch) {
                return false;
            }
            if (this.commitTimestamp != other.commitTimestamp) {
                return false;
            }
            return !(this.committedMetadata == null ? other.committedMetadata != null : !this.committedMetadata.equals(other.committedMetadata));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + ((int)(this.committedOffset >> 32) ^ (int)this.committedOffset);
            hashCode = 31 * hashCode + this.committedLeaderEpoch;
            hashCode = 31 * hashCode + ((int)(this.commitTimestamp >> 32) ^ (int)this.commitTimestamp);
            hashCode = 31 * hashCode + (this.committedMetadata == null ? 0 : this.committedMetadata.hashCode());
            return hashCode;
        }

        public String toString() {
            return "OffsetCommitRequestPartition(partitionIndex=" + this.partitionIndex + ", committedOffset=" + this.committedOffset + ", committedLeaderEpoch=" + this.committedLeaderEpoch + ", commitTimestamp=" + this.commitTimestamp + ", committedMetadata='" + this.committedMetadata + "')";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public long committedOffset() {
            return this.committedOffset;
        }

        public int committedLeaderEpoch() {
            return this.committedLeaderEpoch;
        }

        public long commitTimestamp() {
            return this.commitTimestamp;
        }

        public String committedMetadata() {
            return this.committedMetadata;
        }

        public OffsetCommitRequestPartition setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public OffsetCommitRequestPartition setCommittedOffset(long v) {
            this.committedOffset = v;
            return this;
        }

        public OffsetCommitRequestPartition setCommittedLeaderEpoch(int v) {
            this.committedLeaderEpoch = v;
            return this;
        }

        public OffsetCommitRequestPartition setCommitTimestamp(long v) {
            this.commitTimestamp = v;
            return this;
        }

        public OffsetCommitRequestPartition setCommittedMetadata(String v) {
            this.committedMetadata = v;
            return this;
        }

        static {
            SCHEMA_5 = SCHEMA_4 = (SCHEMA_3 = (SCHEMA_2 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("committed_offset", Type.INT64, "The message offset to be committed."), new Field("committed_metadata", Type.NULLABLE_STRING, "Any associated metadata the client wants to keep."))));
            SCHEMA_6 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("committed_offset", Type.INT64, "The message offset to be committed."), new Field("committed_leader_epoch", Type.INT32, "The leader epoch of this partition."), new Field("committed_metadata", Type.NULLABLE_STRING, "Any associated metadata the client wants to keep."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6};
        }
    }

    public static class OffsetCommitRequestTopic
    implements Message {
        private String name;
        private List<OffsetCommitRequestPartition> partitions;
        public static final Schema SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(OffsetCommitRequestPartition.SCHEMA_0), "Each partition to commit offsets for."));
        public static final Schema SCHEMA_1 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(OffsetCommitRequestPartition.SCHEMA_1), "Each partition to commit offsets for."));
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema[] SCHEMAS;

        public OffsetCommitRequestTopic(Readable readable, short version) {
            this.partitions = new ArrayList<OffsetCommitRequestPartition>();
            this.read(readable, version);
        }

        public OffsetCommitRequestTopic(Struct struct, short version) {
            this.partitions = new ArrayList<OffsetCommitRequestPartition>();
            this.fromStruct(struct, version);
        }

        public OffsetCommitRequestTopic() {
            this.name = "";
            this.partitions = new ArrayList<OffsetCommitRequestPartition>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 6;
        }

        @Override
        public void read(Readable readable, short version) {
            this.name = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.partitions.clear();
            } else {
                this.partitions.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.partitions.add(new OffsetCommitRequestPartition(readable, version));
                }
            }
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeString(this.name);
            writable.writeInt(this.partitions.size());
            for (OffsetCommitRequestPartition element : this.partitions) {
                element.write(writable, version);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.name = struct.getString("name");
            Object[] nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<OffsetCommitRequestPartition>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.partitions.add(new OffsetCommitRequestPartition((Struct)nestedObject, version));
            }
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("name", (Object)this.name);
            Struct[] nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            for (OffsetCommitRequestPartition element : this.partitions) {
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("partitions", (Object)nestedObjects);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.name);
            size += 4;
            for (OffsetCommitRequestPartition element : this.partitions) {
                size += element.size(version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OffsetCommitRequestTopic)) {
                return false;
            }
            OffsetCommitRequestTopic other = (OffsetCommitRequestTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        public String toString() {
            return "OffsetCommitRequestTopic(name='" + this.name + "', partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<OffsetCommitRequestPartition> partitions() {
            return this.partitions;
        }

        public OffsetCommitRequestTopic setName(String v) {
            this.name = v;
            return this;
        }

        public OffsetCommitRequestTopic setPartitions(List<OffsetCommitRequestPartition> v) {
            this.partitions = v;
            return this;
        }

        static {
            SCHEMA_5 = SCHEMA_4 = (SCHEMA_3 = (SCHEMA_2 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(OffsetCommitRequestPartition.SCHEMA_2), "Each partition to commit offsets for."))));
            SCHEMA_6 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(OffsetCommitRequestPartition.SCHEMA_6), "Each partition to commit offsets for."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6};
        }
    }
}

