window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = {"version": "0.9.5", "fields": ["qualname", "fullname", "annotation", "default_value", "signature", "bases", "doc"], "ref": "fullname", "documentStore": {"docs": {"lmcat": {"fullname": "lmcat", "modulename": "lmcat", "kind": "module", "doc": "<h1 id=\"lmcat\">lmcat</h1>\n\n<p>A Python tool for concatenating files and directory structures into a single document, perfect for sharing code with language models. It respects <code>.gitignore</code> and <code>.lmignore</code> patterns and provides configurable output formatting.</p>\n\n<h2 id=\"features\">Features</h2>\n\n<ul>\n<li>Tree view of directory structure with file statistics (lines, characters, tokens)</li>\n<li>Includes file contents with clear delimiters</li>\n<li>Respects <code>.gitignore</code> patterns (can be disabled)</li>\n<li>Supports custom ignore patterns via <code>.lmignore</code></li>\n<li>Configurable via <code>pyproject.toml</code>, <code>lmcat.toml</code>, or <code>lmcat.json</code>\n<ul>\n<li>you can specify <code>glob_process</code> or <code>decider_process</code> to run on files, like if you want to convert a notebook to a markdown file</li>\n</ul></li>\n</ul>\n\n<h2 id=\"installation\">Installation</h2>\n\n<p>Install from PyPI:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code>pip<span class=\"w\"> </span>install<span class=\"w\"> </span>lmcat\n</code></pre>\n</div>\n\n<p>or, install with support for counting tokens:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code>pip<span class=\"w\"> </span>install<span class=\"w\"> </span>lmcat<span class=\"o\">[</span>tokenizers<span class=\"o\">]</span>\n</code></pre>\n</div>\n\n<h2 id=\"usage\">Usage</h2>\n\n<p>Basic usage - concatenate current directory:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># Only show directory tree</span>\npython<span class=\"w\"> </span>-m<span class=\"w\"> </span>lmcat<span class=\"w\"> </span>--tree-only\n\n<span class=\"c1\"># Write output to file</span>\npython<span class=\"w\"> </span>-m<span class=\"w\"> </span>lmcat<span class=\"w\"> </span>--output<span class=\"w\"> </span>summary.md\n\n<span class=\"c1\"># Print current configuration</span>\npython<span class=\"w\"> </span>-m<span class=\"w\"> </span>lmcat<span class=\"w\"> </span>--print-cfg\n</code></pre>\n</div>\n\n<p>The output will include a directory tree and the contents of each non-ignored file.</p>\n\n<h3 id=\"command-line-options\">Command Line Options</h3>\n\n<ul>\n<li><code>-t</code>, <code>--tree-only</code>: Only print the directory tree, not file contents</li>\n<li><code>-o</code>, <code>--output</code>: Specify an output file (defaults to stdout)</li>\n<li><code>-h</code>, <code>--help</code>: Show help message</li>\n</ul>\n\n<h3 id=\"configuration\">Configuration</h3>\n\n<p>lmcat is best configured via a <code>tool.lmcat</code> section in <code>pyproject.toml</code>:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"k\">[tool.lmcat]</span>\n<span class=\"c1\"># Tree formatting</span>\n<span class=\"n\">tree_divider</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s2\">&quot;\u2502   &quot;</span><span class=\"w\">    </span><span class=\"c1\"># Vertical lines in tree</span>\n<span class=\"n\">tree_indent</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s2\">&quot; &quot;</span><span class=\"w\">        </span><span class=\"c1\"># Indentation</span>\n<span class=\"n\">tree_file_divider</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s2\">&quot;\u251c\u2500\u2500 &quot;</span><span class=\"w\">  </span><span class=\"c1\"># File/directory entries</span>\n<span class=\"n\">content_divider</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s2\">&quot;``````&quot;</span><span class=\"w\">  </span><span class=\"c1\"># File content delimiters</span>\n\n<span class=\"c1\"># Processing pipeline</span>\n<span class=\"n\">tokenizer</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s2\">&quot;gpt2&quot;</span><span class=\"w\">  </span><span class=\"c1\"># or &quot;whitespace-split&quot;</span>\n<span class=\"n\">tree_only</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"kc\">false</span><span class=\"w\">   </span><span class=\"c1\"># Only show tree structure</span>\n<span class=\"n\">on_multiple_processors</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s2\">&quot;except&quot;</span><span class=\"w\">  </span><span class=\"c1\"># Behavior when multiple processors match</span>\n\n<span class=\"c1\"># File handling</span>\n<span class=\"n\">ignore_patterns</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"p\">[</span><span class=\"s2\">&quot;*.tmp&quot;</span><span class=\"p\">,</span><span class=\"w\"> </span><span class=\"s2\">&quot;*.log&quot;</span><span class=\"p\">]</span><span class=\"w\">  </span><span class=\"c1\"># Additional patterns to ignore</span>\n<span class=\"n\">ignore_patterns_files</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"p\">[</span><span class=\"s2\">&quot;.gitignore&quot;</span><span class=\"p\">,</span><span class=\"w\"> </span><span class=\"s2\">&quot;.lmignore&quot;</span><span class=\"p\">]</span>\n\n<span class=\"c1\"># processors</span>\n<span class=\"k\">[tool.lmcat.glob_process]</span>\n<span class=\"s2\">&quot;[mM]akefile&quot;</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s2\">&quot;makefile_recipes&quot;</span>\n<span class=\"s2\">&quot;*.ipynb&quot;</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s2\">&quot;ipynb_to_md&quot;</span>\n</code></pre>\n</div>\n\n<h2 id=\"development\">Development</h2>\n\n<h3 id=\"setup\">Setup</h3>\n\n<ol>\n<li>Clone the repository:</li>\n</ol>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code>git<span class=\"w\"> </span>clone<span class=\"w\"> </span>https://github.com/mivanit/lmcat\n<span class=\"nb\">cd</span><span class=\"w\"> </span>lmcat\n</code></pre>\n</div>\n\n<ol start=\"2\">\n<li>Set up the development environment:</li>\n</ol>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code>make<span class=\"w\"> </span>setup\n</code></pre>\n</div>\n\n<h3 id=\"development-commands\">Development Commands</h3>\n\n<p>The project uses <code>make</code> for common development tasks:</p>\n\n<ul>\n<li><code>make dep</code>: Install/update dependencies</li>\n<li><code>make format</code>: Format code using ruff and pycln</li>\n<li><code>make test</code>: Run tests</li>\n<li><code>make typing</code>: Run type checks</li>\n<li><code>make check</code>: Run all checks (format, test, typing)</li>\n<li><code>make clean</code>: Clean temporary files</li>\n<li><code>make docs</code>: Generate documentation</li>\n<li><code>make build</code>: Build the package</li>\n<li><code>make publish</code>: Publish to PyPI (maintainers only)</li>\n</ul>\n\n<p>Run <code>make help</code> to see all available commands.</p>\n\n<h3 id=\"running-tests\">Running Tests</h3>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code>make<span class=\"w\"> </span><span class=\"nb\">test</span>\n</code></pre>\n</div>\n\n<p>For verbose output:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"nv\">VERBOSE</span><span class=\"o\">=</span><span class=\"m\">1</span><span class=\"w\"> </span>make<span class=\"w\"> </span><span class=\"nb\">test</span>\n</code></pre>\n</div>\n\n<h3 id=\"roadmap\">Roadmap</h3>\n\n<ul>\n<li>more processors and deciders, like:\n<ul>\n<li>only first <code>n</code> lines if file is too large</li>\n<li>first few lines of a csv file</li>\n<li>json schema of a big json/toml/yaml file</li>\n<li>metadata extraction from images</li>\n</ul></li>\n<li>better tests, I feel like gitignore/lmignore interaction is broken</li>\n<li>llm summarization and caching of those summaries in <code>.lmsummary/</code></li>\n<li>reasonable defaults for file extensions to ignore</li>\n<li>web interface</li>\n</ul>\n"}, "lmcat.main": {"fullname": "lmcat.main", "modulename": "lmcat", "qualname": "main", "kind": "function", "doc": "<p>Main entry point for the script</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "lmcat.file_stats": {"fullname": "lmcat.file_stats", "modulename": "lmcat.file_stats", "kind": "module", "doc": "<p></p>\n"}, "lmcat.file_stats.TOKENIZERS_PRESENT": {"fullname": "lmcat.file_stats.TOKENIZERS_PRESENT", "modulename": "lmcat.file_stats", "qualname": "TOKENIZERS_PRESENT", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool", "default_value": "True"}, "lmcat.file_stats.TokenizerWrapper": {"fullname": "lmcat.file_stats.TokenizerWrapper", "modulename": "lmcat.file_stats", "qualname": "TokenizerWrapper", "kind": "class", "doc": "<p>tokenizer wrapper. stores name and provides <code>n_tokens</code> method.</p>\n\n<p>uses splitting by whitespace as a fallback -- <code>whitespace-split</code></p>\n"}, "lmcat.file_stats.TokenizerWrapper.__init__": {"fullname": "lmcat.file_stats.TokenizerWrapper.__init__", "modulename": "lmcat.file_stats", "qualname": "TokenizerWrapper.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;whitespace-split&#39;</span></span>)</span>"}, "lmcat.file_stats.TokenizerWrapper.name": {"fullname": "lmcat.file_stats.TokenizerWrapper.name", "modulename": "lmcat.file_stats", "qualname": "TokenizerWrapper.name", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "lmcat.file_stats.TokenizerWrapper.use_fallback": {"fullname": "lmcat.file_stats.TokenizerWrapper.use_fallback", "modulename": "lmcat.file_stats", "qualname": "TokenizerWrapper.use_fallback", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool"}, "lmcat.file_stats.TokenizerWrapper.tokenizer": {"fullname": "lmcat.file_stats.TokenizerWrapper.tokenizer", "modulename": "lmcat.file_stats", "qualname": "TokenizerWrapper.tokenizer", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[tokenizers.Tokenizer]"}, "lmcat.file_stats.TokenizerWrapper.n_tokens": {"fullname": "lmcat.file_stats.TokenizerWrapper.n_tokens", "modulename": "lmcat.file_stats", "qualname": "TokenizerWrapper.n_tokens", "kind": "function", "doc": "<p>Return number of tokens in text</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">text</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, "lmcat.file_stats.FileStats": {"fullname": "lmcat.file_stats.FileStats", "modulename": "lmcat.file_stats", "qualname": "FileStats", "kind": "class", "doc": "<p>Statistics for a single file</p>\n"}, "lmcat.file_stats.FileStats.__init__": {"fullname": "lmcat.file_stats.FileStats.__init__", "modulename": "lmcat.file_stats", "qualname": "FileStats.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">lines</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">chars</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">tokens</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "lmcat.file_stats.FileStats.lines": {"fullname": "lmcat.file_stats.FileStats.lines", "modulename": "lmcat.file_stats", "qualname": "FileStats.lines", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int"}, "lmcat.file_stats.FileStats.chars": {"fullname": "lmcat.file_stats.FileStats.chars", "modulename": "lmcat.file_stats", "qualname": "FileStats.chars", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int"}, "lmcat.file_stats.FileStats.tokens": {"fullname": "lmcat.file_stats.FileStats.tokens", "modulename": "lmcat.file_stats", "qualname": "FileStats.tokens", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[int]", "default_value": "None"}, "lmcat.file_stats.FileStats.from_file": {"fullname": "lmcat.file_stats.FileStats.from_file", "modulename": "lmcat.file_stats", "qualname": "FileStats.from_file", "kind": "function", "doc": "<p>Get statistics for a single file</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>path : Path</code>\nPath to the file to analyze</li>\n<li><code>tokenizer : Optional[tokenizers.Tokenizer]</code>\nTokenizer to use for counting tokens, if any</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li><code>FileStats</code>\nStatistics for the file</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span>,</span><span class=\"param\">\t<span class=\"n\">tokenizer</span><span class=\"p\">:</span> <span class=\"n\">lmcat</span><span class=\"o\">.</span><span class=\"n\">file_stats</span><span class=\"o\">.</span><span class=\"n\">TokenizerWrapper</span></span><span class=\"return-annotation\">) -> <span class=\"n\">lmcat</span><span class=\"o\">.</span><span class=\"n\">file_stats</span><span class=\"o\">.</span><span class=\"n\">FileStats</span>:</span></span>", "funcdef": "def"}, "lmcat.file_stats.TreeEntry": {"fullname": "lmcat.file_stats.TreeEntry", "modulename": "lmcat.file_stats", "qualname": "TreeEntry", "kind": "class", "doc": "<p>Entry in the tree output with optional stats</p>\n", "bases": "typing.NamedTuple"}, "lmcat.file_stats.TreeEntry.__init__": {"fullname": "lmcat.file_stats.TreeEntry.__init__", "modulename": "lmcat.file_stats", "qualname": "TreeEntry.__init__", "kind": "function", "doc": "<p>Create new instance of TreeEntry(line, stats)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">line</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">stats</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">lmcat</span><span class=\"o\">.</span><span class=\"n\">file_stats</span><span class=\"o\">.</span><span class=\"n\">FileStats</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "lmcat.file_stats.TreeEntry.line": {"fullname": "lmcat.file_stats.TreeEntry.line", "modulename": "lmcat.file_stats", "qualname": "TreeEntry.line", "kind": "variable", "doc": "<p>Alias for field number 0</p>\n", "annotation": ": str"}, "lmcat.file_stats.TreeEntry.stats": {"fullname": "lmcat.file_stats.TreeEntry.stats", "modulename": "lmcat.file_stats", "qualname": "TreeEntry.stats", "kind": "variable", "doc": "<p>Alias for field number 1</p>\n", "annotation": ": Optional[lmcat.file_stats.FileStats]"}, "lmcat.lmcat": {"fullname": "lmcat.lmcat", "modulename": "lmcat.lmcat", "kind": "module", "doc": "<p></p>\n"}, "lmcat.lmcat.LMCatConfig": {"fullname": "lmcat.lmcat.LMCatConfig", "modulename": "lmcat.lmcat", "qualname": "LMCatConfig", "kind": "class", "doc": "<p>Configuration dataclass for lmcat</p>\n", "bases": "muutils.json_serialize.serializable_dataclass.SerializableDataclass"}, "lmcat.lmcat.LMCatConfig.__init__": {"fullname": "lmcat.lmcat.LMCatConfig.__init__", "modulename": "lmcat.lmcat", "qualname": "LMCatConfig.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">content_divider</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;``````&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">tree_only</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">ignore_patterns</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">factory</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">ignore_patterns_files</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">factory</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">plugins_file</span><span class=\"p\">:</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">allow_plugins</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">glob_process</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">factory</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">decider_process</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">factory</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">on_multiple_processors</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;warn&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;except&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;do_first&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;do_last&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;skip&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;except&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">tokenizer</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;gpt2&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">tree_divider</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;\u2502   &#39;</span>,</span><span class=\"param\">\t<span class=\"n\">tree_file_divider</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;\u251c\u2500\u2500 &#39;</span>,</span><span class=\"param\">\t<span class=\"n\">tree_indent</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39; &#39;</span>,</span><span class=\"param\">\t<span class=\"n\">output</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "lmcat.lmcat.LMCatConfig.content_divider": {"fullname": "lmcat.lmcat.LMCatConfig.content_divider", "modulename": "lmcat.lmcat", "qualname": "LMCatConfig.content_divider", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str", "default_value": "&#x27;``````&#x27;"}, "lmcat.lmcat.LMCatConfig.tree_only": {"fullname": "lmcat.lmcat.LMCatConfig.tree_only", "modulename": "lmcat.lmcat", "qualname": "LMCatConfig.tree_only", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool", "default_value": "False"}, "lmcat.lmcat.LMCatConfig.ignore_patterns": {"fullname": "lmcat.lmcat.LMCatConfig.ignore_patterns", "modulename": "lmcat.lmcat", "qualname": "LMCatConfig.ignore_patterns", "kind": "variable", "doc": "<p></p>\n", "annotation": ": list[str]"}, "lmcat.lmcat.LMCatConfig.ignore_patterns_files": {"fullname": "lmcat.lmcat.LMCatConfig.ignore_patterns_files", "modulename": "lmcat.lmcat", "qualname": "LMCatConfig.ignore_patterns_files", "kind": "variable", "doc": "<p></p>\n", "annotation": ": list[pathlib.Path]"}, "lmcat.lmcat.LMCatConfig.plugins_file": {"fullname": "lmcat.lmcat.LMCatConfig.plugins_file", "modulename": "lmcat.lmcat", "qualname": "LMCatConfig.plugins_file", "kind": "variable", "doc": "<p></p>\n", "annotation": ": pathlib.Path | None", "default_value": "None"}, "lmcat.lmcat.LMCatConfig.allow_plugins": {"fullname": "lmcat.lmcat.LMCatConfig.allow_plugins", "modulename": "lmcat.lmcat", "qualname": "LMCatConfig.allow_plugins", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool", "default_value": "False"}, "lmcat.lmcat.LMCatConfig.glob_process": {"fullname": "lmcat.lmcat.LMCatConfig.glob_process", "modulename": "lmcat.lmcat", "qualname": "LMCatConfig.glob_process", "kind": "variable", "doc": "<p></p>\n", "annotation": ": dict[str, str]"}, "lmcat.lmcat.LMCatConfig.decider_process": {"fullname": "lmcat.lmcat.LMCatConfig.decider_process", "modulename": "lmcat.lmcat", "qualname": "LMCatConfig.decider_process", "kind": "variable", "doc": "<p></p>\n", "annotation": ": dict[str, str]"}, "lmcat.lmcat.LMCatConfig.on_multiple_processors": {"fullname": "lmcat.lmcat.LMCatConfig.on_multiple_processors", "modulename": "lmcat.lmcat", "qualname": "LMCatConfig.on_multiple_processors", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Literal[&#x27;warn&#x27;, &#x27;except&#x27;, &#x27;do_first&#x27;, &#x27;do_last&#x27;, &#x27;skip&#x27;]", "default_value": "&#x27;except&#x27;"}, "lmcat.lmcat.LMCatConfig.tokenizer": {"fullname": "lmcat.lmcat.LMCatConfig.tokenizer", "modulename": "lmcat.lmcat", "qualname": "LMCatConfig.tokenizer", "kind": "variable", "doc": "<p>Tokenizer to use for tokenizing the output. <code>gpt2</code> by default. passed to <code>tokenizers.Tokenizer.from_pretrained()</code>. If specified and <code>tokenizers</code> not installed, will throw exception. fallback <code>whitespace-split</code> used to avoid exception when <code>tokenizers</code> not installed.</p>\n", "annotation": ": str", "default_value": "&#x27;gpt2&#x27;"}, "lmcat.lmcat.LMCatConfig.tree_divider": {"fullname": "lmcat.lmcat.LMCatConfig.tree_divider", "modulename": "lmcat.lmcat", "qualname": "LMCatConfig.tree_divider", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str", "default_value": "&#x27;\u2502   &#x27;"}, "lmcat.lmcat.LMCatConfig.tree_file_divider": {"fullname": "lmcat.lmcat.LMCatConfig.tree_file_divider", "modulename": "lmcat.lmcat", "qualname": "LMCatConfig.tree_file_divider", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str", "default_value": "&#x27;\u251c\u2500\u2500 &#x27;"}, "lmcat.lmcat.LMCatConfig.tree_indent": {"fullname": "lmcat.lmcat.LMCatConfig.tree_indent", "modulename": "lmcat.lmcat", "qualname": "LMCatConfig.tree_indent", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str", "default_value": "&#x27; &#x27;"}, "lmcat.lmcat.LMCatConfig.output": {"fullname": "lmcat.lmcat.LMCatConfig.output", "modulename": "lmcat.lmcat", "qualname": "LMCatConfig.output", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str | None", "default_value": "None"}, "lmcat.lmcat.LMCatConfig.get_tokenizer_obj": {"fullname": "lmcat.lmcat.LMCatConfig.get_tokenizer_obj", "modulename": "lmcat.lmcat", "qualname": "LMCatConfig.get_tokenizer_obj", "kind": "function", "doc": "<p>Get the tokenizer object</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">lmcat</span><span class=\"o\">.</span><span class=\"n\">file_stats</span><span class=\"o\">.</span><span class=\"n\">TokenizerWrapper</span>:</span></span>", "funcdef": "def"}, "lmcat.lmcat.LMCatConfig.get_processing_pipeline": {"fullname": "lmcat.lmcat.LMCatConfig.get_processing_pipeline", "modulename": "lmcat.lmcat", "qualname": "LMCatConfig.get_processing_pipeline", "kind": "function", "doc": "<p>Get the processing pipeline object</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">lmcat</span><span class=\"o\">.</span><span class=\"n\">processing_pipeline</span><span class=\"o\">.</span><span class=\"n\">ProcessingPipeline</span>:</span></span>", "funcdef": "def"}, "lmcat.lmcat.LMCatConfig.read": {"fullname": "lmcat.lmcat.LMCatConfig.read", "modulename": "lmcat.lmcat", "qualname": "LMCatConfig.read", "kind": "function", "doc": "<p>Attempt to read config from pyproject.toml, lmcat.toml, or lmcat.json.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">root_dir</span><span class=\"p\">:</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span></span><span class=\"return-annotation\">) -> <span class=\"n\">lmcat</span><span class=\"o\">.</span><span class=\"n\">lmcat</span><span class=\"o\">.</span><span class=\"n\">LMCatConfig</span>:</span></span>", "funcdef": "def"}, "lmcat.lmcat.LMCatConfig.serialize": {"fullname": "lmcat.lmcat.LMCatConfig.serialize", "modulename": "lmcat.lmcat", "qualname": "LMCatConfig.serialize", "kind": "function", "doc": "<p>returns the class as a dict, implemented by using <code>@serializable_dataclass</code> decorator</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "lmcat.lmcat.LMCatConfig.load": {"fullname": "lmcat.lmcat.LMCatConfig.load", "modulename": "lmcat.lmcat", "qualname": "LMCatConfig.load", "kind": "function", "doc": "<p>takes in an appropriately structured dict and returns an instance of the class, implemented by using <code>@serializable_dataclass</code> decorator</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"o\">~</span><span class=\"n\">T</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">T</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "lmcat.lmcat.LMCatConfig.validate_fields_types": {"fullname": "lmcat.lmcat.LMCatConfig.validate_fields_types", "modulename": "lmcat.lmcat", "qualname": "LMCatConfig.validate_fields_types", "kind": "function", "doc": "<p>validate the types of all the fields on a <code>SerializableDataclass</code>. calls <code>SerializableDataclass__validate_field_type</code> for each field</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">json_serialize</span><span class=\"o\">.</span><span class=\"n\">serializable_dataclass</span><span class=\"o\">.</span><span class=\"n\">SerializableDataclass</span>,</span><span class=\"param\">\t<span class=\"n\">on_typecheck_error</span><span class=\"p\">:</span> <span class=\"n\">muutils</span><span class=\"o\">.</span><span class=\"n\">errormode</span><span class=\"o\">.</span><span class=\"n\">ErrorMode</span> <span class=\"o\">=</span> <span class=\"n\">ErrorMode</span><span class=\"o\">.</span><span class=\"n\">Except</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "lmcat.lmcat.IgnoreHandler": {"fullname": "lmcat.lmcat.IgnoreHandler", "modulename": "lmcat.lmcat", "qualname": "IgnoreHandler", "kind": "class", "doc": "<p>Handles all ignore pattern matching using igittigitt</p>\n"}, "lmcat.lmcat.IgnoreHandler.__init__": {"fullname": "lmcat.lmcat.IgnoreHandler.__init__", "modulename": "lmcat.lmcat", "qualname": "IgnoreHandler.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">root_dir</span><span class=\"p\">:</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span>, </span><span class=\"param\"><span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"n\">lmcat</span><span class=\"o\">.</span><span class=\"n\">lmcat</span><span class=\"o\">.</span><span class=\"n\">LMCatConfig</span></span>)</span>"}, "lmcat.lmcat.IgnoreHandler.root_dir": {"fullname": "lmcat.lmcat.IgnoreHandler.root_dir", "modulename": "lmcat.lmcat", "qualname": "IgnoreHandler.root_dir", "kind": "variable", "doc": "<p></p>\n", "annotation": ": pathlib.Path"}, "lmcat.lmcat.IgnoreHandler.config": {"fullname": "lmcat.lmcat.IgnoreHandler.config", "modulename": "lmcat.lmcat", "qualname": "IgnoreHandler.config", "kind": "variable", "doc": "<p></p>\n", "annotation": ": lmcat.lmcat.LMCatConfig"}, "lmcat.lmcat.IgnoreHandler.parser": {"fullname": "lmcat.lmcat.IgnoreHandler.parser", "modulename": "lmcat.lmcat", "qualname": "IgnoreHandler.parser", "kind": "variable", "doc": "<p></p>\n", "annotation": ": igittigitt.igittigitt.IgnoreParser"}, "lmcat.lmcat.IgnoreHandler.is_ignored": {"fullname": "lmcat.lmcat.IgnoreHandler.is_ignored", "modulename": "lmcat.lmcat", "qualname": "IgnoreHandler.is_ignored", "kind": "function", "doc": "<p>Check if a path should be ignored</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "lmcat.lmcat.sorted_entries": {"fullname": "lmcat.lmcat.sorted_entries", "modulename": "lmcat.lmcat", "qualname": "sorted_entries", "kind": "function", "doc": "<p>Return directory contents sorted: directories first, then files</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">directory</span><span class=\"p\">:</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "lmcat.lmcat.walk_dir": {"fullname": "lmcat.lmcat.walk_dir", "modulename": "lmcat.lmcat", "qualname": "walk_dir", "kind": "function", "doc": "<p>Recursively walk a directory, building tree lines and collecting file paths</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">directory</span><span class=\"p\">:</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span>,</span><span class=\"param\">\t<span class=\"n\">ignore_handler</span><span class=\"p\">:</span> <span class=\"n\">lmcat</span><span class=\"o\">.</span><span class=\"n\">lmcat</span><span class=\"o\">.</span><span class=\"n\">IgnoreHandler</span>,</span><span class=\"param\">\t<span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"n\">lmcat</span><span class=\"o\">.</span><span class=\"n\">lmcat</span><span class=\"o\">.</span><span class=\"n\">LMCatConfig</span>,</span><span class=\"param\">\t<span class=\"n\">tokenizer</span><span class=\"p\">:</span> <span class=\"n\">lmcat</span><span class=\"o\">.</span><span class=\"n\">file_stats</span><span class=\"o\">.</span><span class=\"n\">TokenizerWrapper</span>,</span><span class=\"param\">\t<span class=\"n\">prefix</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">lmcat</span><span class=\"o\">.</span><span class=\"n\">file_stats</span><span class=\"o\">.</span><span class=\"n\">TreeEntry</span><span class=\"p\">],</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "lmcat.lmcat.format_tree_with_stats": {"fullname": "lmcat.lmcat.format_tree_with_stats", "modulename": "lmcat.lmcat", "qualname": "format_tree_with_stats", "kind": "function", "doc": "<p>Format tree entries with aligned statistics</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>entries : list[TreeEntry]</code>\nList of tree entries with optional stats</li>\n<li><code>show_tokens : bool</code>\nWhether to show token counts</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li><code>list[str]</code>\nFormatted tree lines with aligned stats</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">entries</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">lmcat</span><span class=\"o\">.</span><span class=\"n\">file_stats</span><span class=\"o\">.</span><span class=\"n\">TreeEntry</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">show_tokens</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "lmcat.lmcat.walk_and_collect": {"fullname": "lmcat.lmcat.walk_and_collect", "modulename": "lmcat.lmcat", "qualname": "walk_and_collect", "kind": "function", "doc": "<p>Walk filesystem from root_dir and gather tree listing plus file paths</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">root_dir</span><span class=\"p\">:</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span>,</span><span class=\"param\">\t<span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"n\">lmcat</span><span class=\"o\">.</span><span class=\"n\">lmcat</span><span class=\"o\">.</span><span class=\"n\">LMCatConfig</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">],</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "lmcat.lmcat.assemble_summary": {"fullname": "lmcat.lmcat.assemble_summary", "modulename": "lmcat.lmcat", "qualname": "assemble_summary", "kind": "function", "doc": "<p>Assemble the summary output and return</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">root_dir</span><span class=\"p\">:</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span>, </span><span class=\"param\"><span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"n\">lmcat</span><span class=\"o\">.</span><span class=\"n\">lmcat</span><span class=\"o\">.</span><span class=\"n\">LMCatConfig</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "lmcat.lmcat.main": {"fullname": "lmcat.lmcat.main", "modulename": "lmcat.lmcat", "qualname": "main", "kind": "function", "doc": "<p>Main entry point for the script</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "lmcat.processing_pipeline": {"fullname": "lmcat.processing_pipeline", "modulename": "lmcat.processing_pipeline", "kind": "module", "doc": "<p></p>\n"}, "lmcat.processing_pipeline.OnMultipleProcessors": {"fullname": "lmcat.processing_pipeline.OnMultipleProcessors", "modulename": "lmcat.processing_pipeline", "qualname": "OnMultipleProcessors", "kind": "variable", "doc": "<p></p>\n", "default_value": "typing.Literal[&#x27;warn&#x27;, &#x27;except&#x27;, &#x27;do_first&#x27;, &#x27;do_last&#x27;, &#x27;skip&#x27;]"}, "lmcat.processing_pipeline.load_plugins": {"fullname": "lmcat.processing_pipeline.load_plugins", "modulename": "lmcat.processing_pipeline", "qualname": "load_plugins", "kind": "function", "doc": "<p>Load plugins from a Python file.</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>plugins_file : Path</code>\nPath to plugins file</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">plugins_file</span><span class=\"p\">:</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "lmcat.processing_pipeline.ProcessingPipeline": {"fullname": "lmcat.processing_pipeline.ProcessingPipeline", "modulename": "lmcat.processing_pipeline", "qualname": "ProcessingPipeline", "kind": "class", "doc": "<p>Manages the processing pipeline for files.</p>\n\n<h1 id=\"attributes\">Attributes:</h1>\n\n<ul>\n<li><code>glob_process : dict[str, ProcessorName]</code>\nMaps glob patterns to processor names</li>\n<li><code>decider_process : dict[DeciderName, ProcessorName]</code>\nMaps decider names to processor names</li>\n<li><code>_compiled_globs : dict[str, re.Pattern]</code>\nCached compiled glob patterns for performance</li>\n</ul>\n"}, "lmcat.processing_pipeline.ProcessingPipeline.__init__": {"fullname": "lmcat.processing_pipeline.ProcessingPipeline.__init__", "modulename": "lmcat.processing_pipeline", "qualname": "ProcessingPipeline.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">plugins_file</span><span class=\"p\">:</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span> <span class=\"o\">|</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">decider_process_keys</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">glob_process_keys</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">on_multiple_processors</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;warn&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;except&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;do_first&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;do_last&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;skip&#39;</span><span class=\"p\">]</span></span>)</span>"}, "lmcat.processing_pipeline.ProcessingPipeline.plugins_file": {"fullname": "lmcat.processing_pipeline.ProcessingPipeline.plugins_file", "modulename": "lmcat.processing_pipeline", "qualname": "ProcessingPipeline.plugins_file", "kind": "variable", "doc": "<p></p>\n", "annotation": ": pathlib.Path | None"}, "lmcat.processing_pipeline.ProcessingPipeline.decider_process_keys": {"fullname": "lmcat.processing_pipeline.ProcessingPipeline.decider_process_keys", "modulename": "lmcat.processing_pipeline", "qualname": "ProcessingPipeline.decider_process_keys", "kind": "variable", "doc": "<p></p>\n", "annotation": ": dict[str, str]"}, "lmcat.processing_pipeline.ProcessingPipeline.glob_process_keys": {"fullname": "lmcat.processing_pipeline.ProcessingPipeline.glob_process_keys", "modulename": "lmcat.processing_pipeline", "qualname": "ProcessingPipeline.glob_process_keys", "kind": "variable", "doc": "<p></p>\n", "annotation": ": dict[str, str]"}, "lmcat.processing_pipeline.ProcessingPipeline.on_multiple_processors": {"fullname": "lmcat.processing_pipeline.ProcessingPipeline.on_multiple_processors", "modulename": "lmcat.processing_pipeline", "qualname": "ProcessingPipeline.on_multiple_processors", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Literal[&#x27;warn&#x27;, &#x27;except&#x27;, &#x27;do_first&#x27;, &#x27;do_last&#x27;, &#x27;skip&#x27;]"}, "lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"fullname": "lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path", "modulename": "lmcat.processing_pipeline", "qualname": "ProcessingPipeline.get_processors_for_path", "kind": "function", "doc": "<p>Get all applicable processors for a given path.</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>path : Path</code>\nPath to get processors for</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li><code>list[ProcessorFunc]</code>\nList of applicable path processors</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span><span class=\"p\">],</span> <span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"fullname": "lmcat.processing_pipeline.ProcessingPipeline.process_file", "modulename": "lmcat.processing_pipeline", "qualname": "ProcessingPipeline.process_file", "kind": "function", "doc": "<p>Process a file through the pipeline.</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>path : Path</code>\nPath to process the content of</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li><code>tuple[str, str]</code>\nProcessed content and the processor name\nif no processor is found, will be <code>(path.read_text(), None)</code></li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "lmcat.processors": {"fullname": "lmcat.processors", "modulename": "lmcat.processors", "kind": "module", "doc": "<p></p>\n"}, "lmcat.processors.ProcessorName": {"fullname": "lmcat.processors.ProcessorName", "modulename": "lmcat.processors", "qualname": "ProcessorName", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;class &#x27;str&#x27;&gt;"}, "lmcat.processors.DeciderName": {"fullname": "lmcat.processors.DeciderName", "modulename": "lmcat.processors", "qualname": "DeciderName", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;class &#x27;str&#x27;&gt;"}, "lmcat.processors.ProcessorFunc": {"fullname": "lmcat.processors.ProcessorFunc", "modulename": "lmcat.processors", "qualname": "ProcessorFunc", "kind": "variable", "doc": "<p></p>\n", "default_value": "typing.Callable[[pathlib.Path], str]"}, "lmcat.processors.DeciderFunc": {"fullname": "lmcat.processors.DeciderFunc", "modulename": "lmcat.processors", "qualname": "DeciderFunc", "kind": "variable", "doc": "<p></p>\n", "default_value": "typing.Callable[[pathlib.Path], bool]"}, "lmcat.processors.PROCESSORS": {"fullname": "lmcat.processors.PROCESSORS", "modulename": "lmcat.processors", "qualname": "PROCESSORS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": dict[str, typing.Callable[[pathlib.Path], str]]", "default_value": "{&#x27;remove_comments&#x27;: &lt;function remove_comments&gt;, &#x27;compress_whitespace&#x27;: &lt;function compress_whitespace&gt;, &#x27;to_relative_path&#x27;: &lt;function to_relative_path&gt;, &#x27;ipynb_to_md&#x27;: &lt;function ipynb_to_md&gt;, &#x27;makefile_recipes&#x27;: &lt;function makefile_recipes&gt;, &#x27;csv_preview_5_lines&#x27;: &lt;function csv_preview_5_lines&gt;}"}, "lmcat.processors.DECIDERS": {"fullname": "lmcat.processors.DECIDERS", "modulename": "lmcat.processors", "qualname": "DECIDERS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": dict[str, typing.Callable[[pathlib.Path], bool]]", "default_value": "{&#x27;is_over_10kb&#x27;: &lt;function is_over_10kb&gt;, &#x27;is_documentation&#x27;: &lt;function is_documentation&gt;}"}, "lmcat.processors.register_processor": {"fullname": "lmcat.processors.register_processor", "modulename": "lmcat.processors", "qualname": "register_processor", "kind": "function", "doc": "<p>Register a function as a path processor</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">func</span><span class=\"p\">:</span> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span><span class=\"p\">],</span> <span class=\"nb\">str</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span><span class=\"p\">],</span> <span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "lmcat.processors.register_decider": {"fullname": "lmcat.processors.register_decider", "modulename": "lmcat.processors", "qualname": "register_decider", "kind": "function", "doc": "<p>Register a function as a decider</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">func</span><span class=\"p\">:</span> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span><span class=\"p\">],</span> <span class=\"nb\">bool</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span><span class=\"p\">],</span> <span class=\"nb\">bool</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "lmcat.processors.is_over_10kb": {"fullname": "lmcat.processors.is_over_10kb", "modulename": "lmcat.processors", "qualname": "is_over_10kb", "kind": "function", "doc": "<p>Check if file is over 10KB.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "lmcat.processors.is_documentation": {"fullname": "lmcat.processors.is_documentation", "modulename": "lmcat.processors", "qualname": "is_documentation", "kind": "function", "doc": "<p>Check if file is documentation.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "lmcat.processors.remove_comments": {"fullname": "lmcat.processors.remove_comments", "modulename": "lmcat.processors", "qualname": "remove_comments", "kind": "function", "doc": "<p>Remove single-line comments from code.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "lmcat.processors.compress_whitespace": {"fullname": "lmcat.processors.compress_whitespace", "modulename": "lmcat.processors", "qualname": "compress_whitespace", "kind": "function", "doc": "<p>Compress multiple whitespace characters into single spaces.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "lmcat.processors.to_relative_path": {"fullname": "lmcat.processors.to_relative_path", "modulename": "lmcat.processors", "qualname": "to_relative_path", "kind": "function", "doc": "<p>return the path to the file as a string</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "lmcat.processors.ipynb_to_md": {"fullname": "lmcat.processors.ipynb_to_md", "modulename": "lmcat.processors", "qualname": "ipynb_to_md", "kind": "function", "doc": "<p>Convert an IPython notebook to markdown.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "lmcat.processors.makefile_recipes": {"fullname": "lmcat.processors.makefile_recipes", "modulename": "lmcat.processors", "qualname": "makefile_recipes", "kind": "function", "doc": "<p>Process a Makefile to show only target descriptions and basic structure.</p>\n\n<p>Preserves:</p>\n\n<ul>\n<li>Comments above .PHONY targets up to first empty line</li>\n<li>The .PHONY line and target line</li>\n<li>First line after target if it starts with @echo</li>\n</ul>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>path : Path</code>\nPath to the Makefile to process</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li><code>str</code>\nProcessed Makefile content</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "lmcat.processors.csv_preview_5_lines": {"fullname": "lmcat.processors.csv_preview_5_lines", "modulename": "lmcat.processors", "qualname": "csv_preview_5_lines", "kind": "function", "doc": "<p>Preview first few lines of a CSV file (up to 5)</p>\n\n<p>Reads only first 1024 bytes and splits into lines.\nDoes not attempt to parse CSV structure.</p>\n\n<h1 id=\"parameters\">Parameters:</h1>\n\n<ul>\n<li><code>path : Path</code>\nPath to CSV file</li>\n</ul>\n\n<h1 id=\"returns\">Returns:</h1>\n\n<ul>\n<li><code>str</code>\nFirst few lines of the file</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}}, "docInfo": {"lmcat": {"qualname": 0, "fullname": 1, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 1076}, "lmcat.main": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 10, "bases": 0, "doc": 8}, "lmcat.file_stats": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "lmcat.file_stats.TOKENIZERS_PRESENT": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "lmcat.file_stats.TokenizerWrapper": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 27}, "lmcat.file_stats.TokenizerWrapper.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 3}, "lmcat.file_stats.TokenizerWrapper.name": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "lmcat.file_stats.TokenizerWrapper.use_fallback": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "lmcat.file_stats.TokenizerWrapper.tokenizer": {"qualname": 2, "fullname": 5, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "lmcat.file_stats.TokenizerWrapper.n_tokens": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 24, "bases": 0, "doc": 8}, "lmcat.file_stats.FileStats": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "lmcat.file_stats.FileStats.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 47, "bases": 0, "doc": 3}, "lmcat.file_stats.FileStats.lines": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "lmcat.file_stats.FileStats.chars": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "lmcat.file_stats.FileStats.tokens": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "lmcat.file_stats.FileStats.from_file": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 64, "bases": 0, "doc": 60}, "lmcat.file_stats.TreeEntry": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 10}, "lmcat.file_stats.TreeEntry.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 48, "bases": 0, "doc": 10}, "lmcat.file_stats.TreeEntry.line": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "lmcat.file_stats.TreeEntry.stats": {"qualname": 2, "fullname": 5, "annotation": 5, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "lmcat.lmcat": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "lmcat.lmcat.LMCatConfig": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 6, "doc": 6}, "lmcat.lmcat.LMCatConfig.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 442, "bases": 0, "doc": 3}, "lmcat.lmcat.LMCatConfig.content_divider": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "lmcat.lmcat.LMCatConfig.tree_only": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "lmcat.lmcat.LMCatConfig.ignore_patterns": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "lmcat.lmcat.LMCatConfig.ignore_patterns_files": {"qualname": 4, "fullname": 6, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "lmcat.lmcat.LMCatConfig.plugins_file": {"qualname": 3, "fullname": 5, "annotation": 5, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "lmcat.lmcat.LMCatConfig.allow_plugins": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "lmcat.lmcat.LMCatConfig.glob_process": {"qualname": 3, "fullname": 5, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "lmcat.lmcat.LMCatConfig.decider_process": {"qualname": 3, "fullname": 5, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "lmcat.lmcat.LMCatConfig.on_multiple_processors": {"qualname": 4, "fullname": 6, "annotation": 20, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "lmcat.lmcat.LMCatConfig.tokenizer": {"qualname": 2, "fullname": 4, "annotation": 2, "default_value": 5, "signature": 0, "bases": 0, "doc": 50}, "lmcat.lmcat.LMCatConfig.tree_divider": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "lmcat.lmcat.LMCatConfig.tree_file_divider": {"qualname": 4, "fullname": 6, "annotation": 2, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "lmcat.lmcat.LMCatConfig.tree_indent": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 4, "signature": 0, "bases": 0, "doc": 3}, "lmcat.lmcat.LMCatConfig.output": {"qualname": 2, "fullname": 4, "annotation": 4, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "lmcat.lmcat.LMCatConfig.get_tokenizer_obj": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 25, "bases": 0, "doc": 6}, "lmcat.lmcat.LMCatConfig.get_processing_pipeline": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 25, "bases": 0, "doc": 7}, "lmcat.lmcat.LMCatConfig.read": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 40, "bases": 0, "doc": 15}, "lmcat.lmcat.LMCatConfig.serialize": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 16}, "lmcat.lmcat.LMCatConfig.load": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 56, "bases": 0, "doc": 23}, "lmcat.lmcat.LMCatConfig.validate_fields_types": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 72, "bases": 0, "doc": 24}, "lmcat.lmcat.IgnoreHandler": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 9}, "lmcat.lmcat.IgnoreHandler.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 40, "bases": 0, "doc": 3}, "lmcat.lmcat.IgnoreHandler.root_dir": {"qualname": 3, "fullname": 5, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "lmcat.lmcat.IgnoreHandler.config": {"qualname": 2, "fullname": 4, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "lmcat.lmcat.IgnoreHandler.parser": {"qualname": 2, "fullname": 4, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "lmcat.lmcat.IgnoreHandler.is_ignored": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 29, "bases": 0, "doc": 9}, "lmcat.lmcat.sorted_entries": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 35, "bases": 0, "doc": 10}, "lmcat.lmcat.walk_dir": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 147, "bases": 0, "doc": 13}, "lmcat.lmcat.format_tree_with_stats": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 62, "bases": 0, "doc": 60}, "lmcat.lmcat.walk_and_collect": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 72, "bases": 0, "doc": 14}, "lmcat.lmcat.assemble_summary": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 45, "bases": 0, "doc": 8}, "lmcat.lmcat.main": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 10, "bases": 0, "doc": 8}, "lmcat.processing_pipeline": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "lmcat.processing_pipeline.OnMultipleProcessors": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 20, "signature": 0, "bases": 0, "doc": 3}, "lmcat.processing_pipeline.load_plugins": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 25, "bases": 0, "doc": 28}, "lmcat.processing_pipeline.ProcessingPipeline": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 63}, "lmcat.processing_pipeline.ProcessingPipeline.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 142, "bases": 0, "doc": 3}, "lmcat.processing_pipeline.ProcessingPipeline.plugins_file": {"qualname": 3, "fullname": 6, "annotation": 5, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "lmcat.processing_pipeline.ProcessingPipeline.decider_process_keys": {"qualname": 4, "fullname": 7, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "lmcat.processing_pipeline.ProcessingPipeline.glob_process_keys": {"qualname": 4, "fullname": 7, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "lmcat.processing_pipeline.ProcessingPipeline.on_multiple_processors": {"qualname": 4, "fullname": 7, "annotation": 20, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"qualname": 5, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 55, "bases": 0, "doc": 47}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 47, "bases": 0, "doc": 63}, "lmcat.processors": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "lmcat.processors.ProcessorName": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 8, "signature": 0, "bases": 0, "doc": 3}, "lmcat.processors.DeciderName": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 8, "signature": 0, "bases": 0, "doc": 3}, "lmcat.processors.ProcessorFunc": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 4, "signature": 0, "bases": 0, "doc": 3}, "lmcat.processors.DeciderFunc": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 4, "signature": 0, "bases": 0, "doc": 3}, "lmcat.processors.PROCESSORS": {"qualname": 1, "fullname": 3, "annotation": 6, "default_value": 70, "signature": 0, "bases": 0, "doc": 3}, "lmcat.processors.DECIDERS": {"qualname": 1, "fullname": 3, "annotation": 6, "default_value": 24, "signature": 0, "bases": 0, "doc": 3}, "lmcat.processors.register_processor": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 53, "bases": 0, "doc": 9}, "lmcat.processors.register_decider": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 53, "bases": 0, "doc": 8}, "lmcat.processors.is_over_10kb": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 24, "bases": 0, "doc": 9}, "lmcat.processors.is_documentation": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 24, "bases": 0, "doc": 8}, "lmcat.processors.remove_comments": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 24, "bases": 0, "doc": 9}, "lmcat.processors.compress_whitespace": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 24, "bases": 0, "doc": 10}, "lmcat.processors.to_relative_path": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 24, "bases": 0, "doc": 11}, "lmcat.processors.ipynb_to_md": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 24, "bases": 0, "doc": 9}, "lmcat.processors.makefile_recipes": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 24, "bases": 0, "doc": 86}, "lmcat.processors.csv_preview_5_lines": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 24, "bases": 0, "doc": 69}}, "length": 83, "save": true}, "index": {"qualname": {"root": {"1": {"0": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "b": {"docs": {"lmcat.processors.is_over_10kb": {"tf": 1}}, "df": 1}}}, "docs": {}, "df": 0}, "5": {"docs": {"lmcat.processors.csv_preview_5_lines": {"tf": 1}}, "df": 1}, "docs": {"lmcat.file_stats.TokenizerWrapper.__init__": {"tf": 1}, "lmcat.file_stats.FileStats.__init__": {"tf": 1}, "lmcat.file_stats.TreeEntry.__init__": {"tf": 1}, "lmcat.lmcat.LMCatConfig.__init__": {"tf": 1}, "lmcat.lmcat.IgnoreHandler.__init__": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.__init__": {"tf": 1}}, "df": 6, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"lmcat.main": {"tf": 1}, "lmcat.lmcat.main": {"tf": 1}}, "df": 2}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.processors.makefile_recipes": {"tf": 1}}, "df": 1}}}}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.lmcat.LMCatConfig.on_multiple_processors": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.on_multiple_processors": {"tf": 1}}, "df": 2}}}}}}}, "d": {"docs": {"lmcat.processors.ipynb_to_md": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "o": {"docs": {"lmcat.processors.to_relative_path": {"tf": 1}, "lmcat.processors.ipynb_to_md": {"tf": 1}}, "df": 2, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.file_stats.TokenizerWrapper.tokenizer": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1}, "lmcat.lmcat.LMCatConfig.get_tokenizer_obj": {"tf": 1}}, "df": 3, "s": {"docs": {"lmcat.file_stats.TOKENIZERS_PRESENT": {"tf": 1}}, "df": 1}, "w": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.file_stats.TokenizerWrapper": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper.__init__": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper.name": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper.use_fallback": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper.tokenizer": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper.n_tokens": {"tf": 1}}, "df": 6}}}}}}}}}}}, "s": {"docs": {"lmcat.file_stats.TokenizerWrapper.n_tokens": {"tf": 1}, "lmcat.file_stats.FileStats.tokens": {"tf": 1}}, "df": 2}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.lmcat.LMCatConfig.tree_only": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tree_divider": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tree_file_divider": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tree_indent": {"tf": 1}, "lmcat.lmcat.format_tree_with_stats": {"tf": 1}}, "df": 5, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"lmcat.file_stats.TreeEntry": {"tf": 1}, "lmcat.file_stats.TreeEntry.__init__": {"tf": 1}, "lmcat.file_stats.TreeEntry.line": {"tf": 1}, "lmcat.file_stats.TreeEntry.stats": {"tf": 1}}, "df": 4}}}}}}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.file_stats.TOKENIZERS_PRESENT": {"tf": 1}}, "df": 1}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "w": {"docs": {"lmcat.processors.csv_preview_5_lines": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.lmcat.LMCatConfig.glob_process": {"tf": 1}, "lmcat.lmcat.LMCatConfig.decider_process": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.decider_process_keys": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.glob_process_keys": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}}, "df": 5, "o": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.processors.register_processor": {"tf": 1}}, "df": 1, "s": {"docs": {"lmcat.lmcat.LMCatConfig.on_multiple_processors": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.on_multiple_processors": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 1}, "lmcat.processors.PROCESSORS": {"tf": 1}}, "df": 4}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.processors.ProcessorName": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {"lmcat.processors.ProcessorFunc": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lmcat.lmcat.LMCatConfig.get_processing_pipeline": {"tf": 1}}, "df": 1, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.processing_pipeline.ProcessingPipeline": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.__init__": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.plugins_file": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.decider_process_keys": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.glob_process_keys": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.on_multiple_processors": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}}, "df": 8}}}}}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.lmcat.LMCatConfig.ignore_patterns": {"tf": 1}, "lmcat.lmcat.LMCatConfig.ignore_patterns_files": {"tf": 1}}, "df": 2}}}}}, "h": {"docs": {"lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 1}, "lmcat.processors.to_relative_path": {"tf": 1}}, "df": 2}}, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.lmcat.IgnoreHandler.parser": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.lmcat.LMCatConfig.plugins_file": {"tf": 1}, "lmcat.lmcat.LMCatConfig.allow_plugins": {"tf": 1}, "lmcat.processing_pipeline.load_plugins": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.plugins_file": {"tf": 1}}, "df": 4}}}}}}, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.lmcat.LMCatConfig.get_processing_pipeline": {"tf": 1}}, "df": 1}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.file_stats.TokenizerWrapper.__init__": {"tf": 1}, "lmcat.file_stats.FileStats.__init__": {"tf": 1}, "lmcat.file_stats.TreeEntry.__init__": {"tf": 1}, "lmcat.lmcat.LMCatConfig.__init__": {"tf": 1}, "lmcat.lmcat.IgnoreHandler.__init__": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.__init__": {"tf": 1}}, "df": 6}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.LMCatConfig.tree_indent": {"tf": 1}}, "df": 1}}}}}, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.lmcat.LMCatConfig.ignore_patterns": {"tf": 1}, "lmcat.lmcat.LMCatConfig.ignore_patterns_files": {"tf": 1}}, "df": 2, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.lmcat.IgnoreHandler": {"tf": 1}, "lmcat.lmcat.IgnoreHandler.__init__": {"tf": 1}, "lmcat.lmcat.IgnoreHandler.root_dir": {"tf": 1}, "lmcat.lmcat.IgnoreHandler.config": {"tf": 1}, "lmcat.lmcat.IgnoreHandler.parser": {"tf": 1}, "lmcat.lmcat.IgnoreHandler.is_ignored": {"tf": 1}}, "df": 6}}}}}}}, "d": {"docs": {"lmcat.lmcat.IgnoreHandler.is_ignored": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {"lmcat.lmcat.IgnoreHandler.is_ignored": {"tf": 1}, "lmcat.processors.is_over_10kb": {"tf": 1}, "lmcat.processors.is_documentation": {"tf": 1}}, "df": 3}, "p": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "b": {"docs": {"lmcat.processors.ipynb_to_md": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {"lmcat.file_stats.TokenizerWrapper.n_tokens": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.file_stats.TokenizerWrapper.name": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.file_stats.TokenizerWrapper.use_fallback": {"tf": 1}}, "df": 1}}}, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"lmcat.file_stats.TokenizerWrapper.use_fallback": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.file_stats.FileStats.from_file": {"tf": 1}, "lmcat.lmcat.LMCatConfig.plugins_file": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tree_file_divider": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.plugins_file": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}}, "df": 5, "s": {"docs": {"lmcat.lmcat.LMCatConfig.ignore_patterns_files": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.file_stats.FileStats": {"tf": 1}, "lmcat.file_stats.FileStats.__init__": {"tf": 1}, "lmcat.file_stats.FileStats.lines": {"tf": 1}, "lmcat.file_stats.FileStats.chars": {"tf": 1}, "lmcat.file_stats.FileStats.tokens": {"tf": 1}, "lmcat.file_stats.FileStats.from_file": {"tf": 1}}, "df": 6}}}}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"lmcat.file_stats.FileStats.from_file": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 1}}, "df": 1, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.format_tree_with_stats": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.file_stats.TreeEntry.line": {"tf": 1}}, "df": 1, "s": {"docs": {"lmcat.file_stats.FileStats.lines": {"tf": 1}, "lmcat.processors.csv_preview_5_lines": {"tf": 1}}, "df": 2}}}}, "m": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"lmcat.lmcat.LMCatConfig": {"tf": 1}, "lmcat.lmcat.LMCatConfig.__init__": {"tf": 1}, "lmcat.lmcat.LMCatConfig.content_divider": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tree_only": {"tf": 1}, "lmcat.lmcat.LMCatConfig.ignore_patterns": {"tf": 1}, "lmcat.lmcat.LMCatConfig.ignore_patterns_files": {"tf": 1}, "lmcat.lmcat.LMCatConfig.plugins_file": {"tf": 1}, "lmcat.lmcat.LMCatConfig.allow_plugins": {"tf": 1}, "lmcat.lmcat.LMCatConfig.glob_process": {"tf": 1}, "lmcat.lmcat.LMCatConfig.decider_process": {"tf": 1}, "lmcat.lmcat.LMCatConfig.on_multiple_processors": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tree_divider": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tree_file_divider": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tree_indent": {"tf": 1}, "lmcat.lmcat.LMCatConfig.output": {"tf": 1}, "lmcat.lmcat.LMCatConfig.get_tokenizer_obj": {"tf": 1}, "lmcat.lmcat.LMCatConfig.get_processing_pipeline": {"tf": 1}, "lmcat.lmcat.LMCatConfig.read": {"tf": 1}, "lmcat.lmcat.LMCatConfig.serialize": {"tf": 1}, "lmcat.lmcat.LMCatConfig.load": {"tf": 1}, "lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1}}, "df": 22}}}}}}}}}}, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"lmcat.lmcat.LMCatConfig.load": {"tf": 1}, "lmcat.processing_pipeline.load_plugins": {"tf": 1}}, "df": 2}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.file_stats.FileStats.chars": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.LMCatConfig.content_divider": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"lmcat.lmcat.IgnoreHandler.config": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.walk_and_collect": {"tf": 1}}, "df": 1}}}}}, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.processors.remove_comments": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.processors.compress_whitespace": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {}, "df": 0, "v": {"docs": {"lmcat.processors.csv_preview_5_lines": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.file_stats.TreeEntry.stats": {"tf": 1}, "lmcat.lmcat.format_tree_with_stats": {"tf": 1}}, "df": 2}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.lmcat.LMCatConfig.serialize": {"tf": 1}}, "df": 1}}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"lmcat.lmcat.sorted_entries": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"lmcat.lmcat.assemble_summary": {"tf": 1}}, "df": 1}}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.lmcat.LMCatConfig.content_divider": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tree_divider": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tree_file_divider": {"tf": 1}}, "df": 3}}}}}, "r": {"docs": {"lmcat.lmcat.IgnoreHandler.root_dir": {"tf": 1}, "lmcat.lmcat.walk_dir": {"tf": 1}}, "df": 2}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.lmcat.LMCatConfig.decider_process": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.decider_process_keys": {"tf": 1}, "lmcat.processors.register_decider": {"tf": 1}}, "df": 3, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.processors.DeciderName": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {"lmcat.processors.DeciderFunc": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {"lmcat.processors.DECIDERS": {"tf": 1}}, "df": 1}}}}}}}, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lmcat.processors.is_documentation": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {"lmcat.lmcat.LMCatConfig.on_multiple_processors": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.on_multiple_processors": {"tf": 1}}, "df": 2, "l": {"docs": {}, "df": 0, "y": {"docs": {"lmcat.lmcat.LMCatConfig.tree_only": {"tf": 1}}, "df": 1}}, "m": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.processing_pipeline.OnMultipleProcessors": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.LMCatConfig.output": {"tf": 1}}, "df": 1}}}}}, "b": {"docs": {}, "df": 0, "j": {"docs": {"lmcat.lmcat.LMCatConfig.get_tokenizer_obj": {"tf": 1}}, "df": 1}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.processors.is_over_10kb": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {"lmcat.lmcat.LMCatConfig.allow_plugins": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"lmcat.lmcat.walk_and_collect": {"tf": 1}}, "df": 1}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.lmcat.assemble_summary": {"tf": 1}}, "df": 1}}}}}}}}, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "b": {"docs": {"lmcat.lmcat.LMCatConfig.glob_process": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.glob_process_keys": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.LMCatConfig.get_tokenizer_obj": {"tf": 1}, "lmcat.lmcat.LMCatConfig.get_processing_pipeline": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 1}}, "df": 3}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"lmcat.lmcat.LMCatConfig.read": {"tf": 1}}, "df": 1}}, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.processors.register_processor": {"tf": 1}, "lmcat.processors.register_decider": {"tf": 1}}, "df": 2}}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.processors.remove_comments": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.processors.to_relative_path": {"tf": 1}}, "df": 1}}}}}}, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.processors.makefile_recipes": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.IgnoreHandler.root_dir": {"tf": 1}}, "df": 1}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1}}, "df": 1}}}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.lmcat.sorted_entries": {"tf": 1}}, "df": 1}}}}}}}, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "k": {"docs": {"lmcat.lmcat.walk_dir": {"tf": 1}, "lmcat.lmcat.walk_and_collect": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"lmcat.lmcat.format_tree_with_stats": {"tf": 1}}, "df": 1}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.processors.compress_whitespace": {"tf": 1}}, "df": 1}}}}}}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.processing_pipeline.ProcessingPipeline.decider_process_keys": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.glob_process_keys": {"tf": 1}}, "df": 2}}}}}}, "fullname": {"root": {"1": {"0": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "b": {"docs": {"lmcat.processors.is_over_10kb": {"tf": 1}}, "df": 1}}}, "docs": {}, "df": 0}, "5": {"docs": {"lmcat.processors.csv_preview_5_lines": {"tf": 1}}, "df": 1}, "docs": {"lmcat.file_stats.TokenizerWrapper.__init__": {"tf": 1}, "lmcat.file_stats.FileStats.__init__": {"tf": 1}, "lmcat.file_stats.TreeEntry.__init__": {"tf": 1}, "lmcat.lmcat.LMCatConfig.__init__": {"tf": 1}, "lmcat.lmcat.IgnoreHandler.__init__": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.__init__": {"tf": 1}}, "df": 6, "l": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"lmcat": {"tf": 1}, "lmcat.main": {"tf": 1}, "lmcat.file_stats": {"tf": 1}, "lmcat.file_stats.TOKENIZERS_PRESENT": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper.__init__": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper.name": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper.use_fallback": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper.tokenizer": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper.n_tokens": {"tf": 1}, "lmcat.file_stats.FileStats": {"tf": 1}, "lmcat.file_stats.FileStats.__init__": {"tf": 1}, "lmcat.file_stats.FileStats.lines": {"tf": 1}, "lmcat.file_stats.FileStats.chars": {"tf": 1}, "lmcat.file_stats.FileStats.tokens": {"tf": 1}, "lmcat.file_stats.FileStats.from_file": {"tf": 1}, "lmcat.file_stats.TreeEntry": {"tf": 1}, "lmcat.file_stats.TreeEntry.__init__": {"tf": 1}, "lmcat.file_stats.TreeEntry.line": {"tf": 1}, "lmcat.file_stats.TreeEntry.stats": {"tf": 1}, "lmcat.lmcat": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.__init__": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.content_divider": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.tree_only": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.ignore_patterns": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.ignore_patterns_files": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.plugins_file": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.allow_plugins": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.glob_process": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.decider_process": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.on_multiple_processors": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.tree_divider": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.tree_file_divider": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.tree_indent": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.output": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.get_tokenizer_obj": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.get_processing_pipeline": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.read": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.serialize": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.load": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1.4142135623730951}, "lmcat.lmcat.IgnoreHandler": {"tf": 1.4142135623730951}, "lmcat.lmcat.IgnoreHandler.__init__": {"tf": 1.4142135623730951}, "lmcat.lmcat.IgnoreHandler.root_dir": {"tf": 1.4142135623730951}, "lmcat.lmcat.IgnoreHandler.config": {"tf": 1.4142135623730951}, "lmcat.lmcat.IgnoreHandler.parser": {"tf": 1.4142135623730951}, "lmcat.lmcat.IgnoreHandler.is_ignored": {"tf": 1.4142135623730951}, "lmcat.lmcat.sorted_entries": {"tf": 1.4142135623730951}, "lmcat.lmcat.walk_dir": {"tf": 1.4142135623730951}, "lmcat.lmcat.format_tree_with_stats": {"tf": 1.4142135623730951}, "lmcat.lmcat.walk_and_collect": {"tf": 1.4142135623730951}, "lmcat.lmcat.assemble_summary": {"tf": 1.4142135623730951}, "lmcat.lmcat.main": {"tf": 1.4142135623730951}, "lmcat.processing_pipeline": {"tf": 1}, "lmcat.processing_pipeline.OnMultipleProcessors": {"tf": 1}, "lmcat.processing_pipeline.load_plugins": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.__init__": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.plugins_file": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.decider_process_keys": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.glob_process_keys": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.on_multiple_processors": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}, "lmcat.processors": {"tf": 1}, "lmcat.processors.ProcessorName": {"tf": 1}, "lmcat.processors.DeciderName": {"tf": 1}, "lmcat.processors.ProcessorFunc": {"tf": 1}, "lmcat.processors.DeciderFunc": {"tf": 1}, "lmcat.processors.PROCESSORS": {"tf": 1}, "lmcat.processors.DECIDERS": {"tf": 1}, "lmcat.processors.register_processor": {"tf": 1}, "lmcat.processors.register_decider": {"tf": 1}, "lmcat.processors.is_over_10kb": {"tf": 1}, "lmcat.processors.is_documentation": {"tf": 1}, "lmcat.processors.remove_comments": {"tf": 1}, "lmcat.processors.compress_whitespace": {"tf": 1}, "lmcat.processors.to_relative_path": {"tf": 1}, "lmcat.processors.ipynb_to_md": {"tf": 1}, "lmcat.processors.makefile_recipes": {"tf": 1}, "lmcat.processors.csv_preview_5_lines": {"tf": 1}}, "df": 83, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"lmcat.lmcat.LMCatConfig": {"tf": 1}, "lmcat.lmcat.LMCatConfig.__init__": {"tf": 1}, "lmcat.lmcat.LMCatConfig.content_divider": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tree_only": {"tf": 1}, "lmcat.lmcat.LMCatConfig.ignore_patterns": {"tf": 1}, "lmcat.lmcat.LMCatConfig.ignore_patterns_files": {"tf": 1}, "lmcat.lmcat.LMCatConfig.plugins_file": {"tf": 1}, "lmcat.lmcat.LMCatConfig.allow_plugins": {"tf": 1}, "lmcat.lmcat.LMCatConfig.glob_process": {"tf": 1}, "lmcat.lmcat.LMCatConfig.decider_process": {"tf": 1}, "lmcat.lmcat.LMCatConfig.on_multiple_processors": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tree_divider": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tree_file_divider": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tree_indent": {"tf": 1}, "lmcat.lmcat.LMCatConfig.output": {"tf": 1}, "lmcat.lmcat.LMCatConfig.get_tokenizer_obj": {"tf": 1}, "lmcat.lmcat.LMCatConfig.get_processing_pipeline": {"tf": 1}, "lmcat.lmcat.LMCatConfig.read": {"tf": 1}, "lmcat.lmcat.LMCatConfig.serialize": {"tf": 1}, "lmcat.lmcat.LMCatConfig.load": {"tf": 1}, "lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1}}, "df": 22}}}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.file_stats.TreeEntry.line": {"tf": 1}}, "df": 1, "s": {"docs": {"lmcat.file_stats.FileStats.lines": {"tf": 1}, "lmcat.processors.csv_preview_5_lines": {"tf": 1}}, "df": 2}}}}, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"lmcat.lmcat.LMCatConfig.load": {"tf": 1}, "lmcat.processing_pipeline.load_plugins": {"tf": 1}}, "df": 2}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"lmcat.main": {"tf": 1}, "lmcat.lmcat.main": {"tf": 1}}, "df": 2}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.processors.makefile_recipes": {"tf": 1}}, "df": 1}}}}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.lmcat.LMCatConfig.on_multiple_processors": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.on_multiple_processors": {"tf": 1}}, "df": 2}}}}}}}, "d": {"docs": {"lmcat.processors.ipynb_to_md": {"tf": 1}}, "df": 1}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.file_stats": {"tf": 1}, "lmcat.file_stats.TOKENIZERS_PRESENT": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper.__init__": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper.name": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper.use_fallback": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper.tokenizer": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper.n_tokens": {"tf": 1}, "lmcat.file_stats.FileStats": {"tf": 1}, "lmcat.file_stats.FileStats.__init__": {"tf": 1}, "lmcat.file_stats.FileStats.lines": {"tf": 1}, "lmcat.file_stats.FileStats.chars": {"tf": 1}, "lmcat.file_stats.FileStats.tokens": {"tf": 1}, "lmcat.file_stats.FileStats.from_file": {"tf": 1.4142135623730951}, "lmcat.file_stats.TreeEntry": {"tf": 1}, "lmcat.file_stats.TreeEntry.__init__": {"tf": 1}, "lmcat.file_stats.TreeEntry.line": {"tf": 1}, "lmcat.file_stats.TreeEntry.stats": {"tf": 1}, "lmcat.lmcat.LMCatConfig.plugins_file": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tree_file_divider": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.plugins_file": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}}, "df": 22, "s": {"docs": {"lmcat.lmcat.LMCatConfig.ignore_patterns_files": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.file_stats.FileStats": {"tf": 1}, "lmcat.file_stats.FileStats.__init__": {"tf": 1}, "lmcat.file_stats.FileStats.lines": {"tf": 1}, "lmcat.file_stats.FileStats.chars": {"tf": 1}, "lmcat.file_stats.FileStats.tokens": {"tf": 1}, "lmcat.file_stats.FileStats.from_file": {"tf": 1}}, "df": 6}}}}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"lmcat.file_stats.TokenizerWrapper.use_fallback": {"tf": 1}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"lmcat.file_stats.FileStats.from_file": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 1}}, "df": 1, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.format_tree_with_stats": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.file_stats": {"tf": 1}, "lmcat.file_stats.TOKENIZERS_PRESENT": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper.__init__": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper.name": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper.use_fallback": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper.tokenizer": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper.n_tokens": {"tf": 1}, "lmcat.file_stats.FileStats": {"tf": 1}, "lmcat.file_stats.FileStats.__init__": {"tf": 1}, "lmcat.file_stats.FileStats.lines": {"tf": 1}, "lmcat.file_stats.FileStats.chars": {"tf": 1}, "lmcat.file_stats.FileStats.tokens": {"tf": 1}, "lmcat.file_stats.FileStats.from_file": {"tf": 1}, "lmcat.file_stats.TreeEntry": {"tf": 1}, "lmcat.file_stats.TreeEntry.__init__": {"tf": 1}, "lmcat.file_stats.TreeEntry.line": {"tf": 1}, "lmcat.file_stats.TreeEntry.stats": {"tf": 1.4142135623730951}, "lmcat.lmcat.format_tree_with_stats": {"tf": 1}}, "df": 19}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.lmcat.LMCatConfig.serialize": {"tf": 1}}, "df": 1}}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"lmcat.lmcat.sorted_entries": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"lmcat.lmcat.assemble_summary": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "o": {"docs": {"lmcat.processors.to_relative_path": {"tf": 1}, "lmcat.processors.ipynb_to_md": {"tf": 1}}, "df": 2, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.file_stats.TokenizerWrapper.tokenizer": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1}, "lmcat.lmcat.LMCatConfig.get_tokenizer_obj": {"tf": 1}}, "df": 3, "s": {"docs": {"lmcat.file_stats.TOKENIZERS_PRESENT": {"tf": 1}}, "df": 1}, "w": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.file_stats.TokenizerWrapper": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper.__init__": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper.name": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper.use_fallback": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper.tokenizer": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper.n_tokens": {"tf": 1}}, "df": 6}}}}}}}}}}}, "s": {"docs": {"lmcat.file_stats.TokenizerWrapper.n_tokens": {"tf": 1}, "lmcat.file_stats.FileStats.tokens": {"tf": 1}}, "df": 2}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.lmcat.LMCatConfig.tree_only": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tree_divider": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tree_file_divider": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tree_indent": {"tf": 1}, "lmcat.lmcat.format_tree_with_stats": {"tf": 1}}, "df": 5, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"lmcat.file_stats.TreeEntry": {"tf": 1}, "lmcat.file_stats.TreeEntry.__init__": {"tf": 1}, "lmcat.file_stats.TreeEntry.line": {"tf": 1}, "lmcat.file_stats.TreeEntry.stats": {"tf": 1}}, "df": 4}}}}}}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.file_stats.TOKENIZERS_PRESENT": {"tf": 1}}, "df": 1}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "w": {"docs": {"lmcat.processors.csv_preview_5_lines": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.lmcat.LMCatConfig.glob_process": {"tf": 1}, "lmcat.lmcat.LMCatConfig.decider_process": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.decider_process_keys": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.glob_process_keys": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}}, "df": 5, "o": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.processors.register_processor": {"tf": 1}}, "df": 1, "s": {"docs": {"lmcat.lmcat.LMCatConfig.on_multiple_processors": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.on_multiple_processors": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 1}, "lmcat.processors": {"tf": 1}, "lmcat.processors.ProcessorName": {"tf": 1}, "lmcat.processors.DeciderName": {"tf": 1}, "lmcat.processors.ProcessorFunc": {"tf": 1}, "lmcat.processors.DeciderFunc": {"tf": 1}, "lmcat.processors.PROCESSORS": {"tf": 1.4142135623730951}, "lmcat.processors.DECIDERS": {"tf": 1}, "lmcat.processors.register_processor": {"tf": 1}, "lmcat.processors.register_decider": {"tf": 1}, "lmcat.processors.is_over_10kb": {"tf": 1}, "lmcat.processors.is_documentation": {"tf": 1}, "lmcat.processors.remove_comments": {"tf": 1}, "lmcat.processors.compress_whitespace": {"tf": 1}, "lmcat.processors.to_relative_path": {"tf": 1}, "lmcat.processors.ipynb_to_md": {"tf": 1}, "lmcat.processors.makefile_recipes": {"tf": 1}, "lmcat.processors.csv_preview_5_lines": {"tf": 1}}, "df": 20}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.processors.ProcessorName": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {"lmcat.processors.ProcessorFunc": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lmcat.lmcat.LMCatConfig.get_processing_pipeline": {"tf": 1}, "lmcat.processing_pipeline": {"tf": 1}, "lmcat.processing_pipeline.OnMultipleProcessors": {"tf": 1}, "lmcat.processing_pipeline.load_plugins": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.__init__": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.plugins_file": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.decider_process_keys": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.glob_process_keys": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.on_multiple_processors": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}}, "df": 12, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.processing_pipeline.ProcessingPipeline": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.__init__": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.plugins_file": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.decider_process_keys": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.glob_process_keys": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.on_multiple_processors": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}}, "df": 8}}}}}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.lmcat.LMCatConfig.ignore_patterns": {"tf": 1}, "lmcat.lmcat.LMCatConfig.ignore_patterns_files": {"tf": 1}}, "df": 2}}}}}, "h": {"docs": {"lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 1}, "lmcat.processors.to_relative_path": {"tf": 1}}, "df": 2}}, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.lmcat.IgnoreHandler.parser": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.lmcat.LMCatConfig.plugins_file": {"tf": 1}, "lmcat.lmcat.LMCatConfig.allow_plugins": {"tf": 1}, "lmcat.processing_pipeline.load_plugins": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.plugins_file": {"tf": 1}}, "df": 4}}}}}}, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.lmcat.LMCatConfig.get_processing_pipeline": {"tf": 1}, "lmcat.processing_pipeline": {"tf": 1}, "lmcat.processing_pipeline.OnMultipleProcessors": {"tf": 1}, "lmcat.processing_pipeline.load_plugins": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.__init__": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.plugins_file": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.decider_process_keys": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.glob_process_keys": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.on_multiple_processors": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}}, "df": 12}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.file_stats.TokenizerWrapper.__init__": {"tf": 1}, "lmcat.file_stats.FileStats.__init__": {"tf": 1}, "lmcat.file_stats.TreeEntry.__init__": {"tf": 1}, "lmcat.lmcat.LMCatConfig.__init__": {"tf": 1}, "lmcat.lmcat.IgnoreHandler.__init__": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.__init__": {"tf": 1}}, "df": 6}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.LMCatConfig.tree_indent": {"tf": 1}}, "df": 1}}}}}, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.lmcat.LMCatConfig.ignore_patterns": {"tf": 1}, "lmcat.lmcat.LMCatConfig.ignore_patterns_files": {"tf": 1}}, "df": 2, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.lmcat.IgnoreHandler": {"tf": 1}, "lmcat.lmcat.IgnoreHandler.__init__": {"tf": 1}, "lmcat.lmcat.IgnoreHandler.root_dir": {"tf": 1}, "lmcat.lmcat.IgnoreHandler.config": {"tf": 1}, "lmcat.lmcat.IgnoreHandler.parser": {"tf": 1}, "lmcat.lmcat.IgnoreHandler.is_ignored": {"tf": 1}}, "df": 6}}}}}}}, "d": {"docs": {"lmcat.lmcat.IgnoreHandler.is_ignored": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {"lmcat.lmcat.IgnoreHandler.is_ignored": {"tf": 1}, "lmcat.processors.is_over_10kb": {"tf": 1}, "lmcat.processors.is_documentation": {"tf": 1}}, "df": 3}, "p": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "b": {"docs": {"lmcat.processors.ipynb_to_md": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {"lmcat.file_stats.TokenizerWrapper.n_tokens": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.file_stats.TokenizerWrapper.name": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.file_stats.TokenizerWrapper.use_fallback": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.file_stats.FileStats.chars": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.LMCatConfig.content_divider": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"lmcat.lmcat.IgnoreHandler.config": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.walk_and_collect": {"tf": 1}}, "df": 1}}}}}, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.processors.remove_comments": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.processors.compress_whitespace": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {}, "df": 0, "v": {"docs": {"lmcat.processors.csv_preview_5_lines": {"tf": 1}}, "df": 1}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.lmcat.LMCatConfig.content_divider": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tree_divider": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tree_file_divider": {"tf": 1}}, "df": 3}}}}}, "r": {"docs": {"lmcat.lmcat.IgnoreHandler.root_dir": {"tf": 1}, "lmcat.lmcat.walk_dir": {"tf": 1}}, "df": 2}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.lmcat.LMCatConfig.decider_process": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.decider_process_keys": {"tf": 1}, "lmcat.processors.register_decider": {"tf": 1}}, "df": 3, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.processors.DeciderName": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {"lmcat.processors.DeciderFunc": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {"lmcat.processors.DECIDERS": {"tf": 1}}, "df": 1}}}}}}}, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lmcat.processors.is_documentation": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {"lmcat.lmcat.LMCatConfig.on_multiple_processors": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.on_multiple_processors": {"tf": 1}}, "df": 2, "l": {"docs": {}, "df": 0, "y": {"docs": {"lmcat.lmcat.LMCatConfig.tree_only": {"tf": 1}}, "df": 1}}, "m": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.processing_pipeline.OnMultipleProcessors": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.LMCatConfig.output": {"tf": 1}}, "df": 1}}}}}, "b": {"docs": {}, "df": 0, "j": {"docs": {"lmcat.lmcat.LMCatConfig.get_tokenizer_obj": {"tf": 1}}, "df": 1}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.processors.is_over_10kb": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {"lmcat.lmcat.LMCatConfig.allow_plugins": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"lmcat.lmcat.walk_and_collect": {"tf": 1}}, "df": 1}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.lmcat.assemble_summary": {"tf": 1}}, "df": 1}}}}}}}}, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "b": {"docs": {"lmcat.lmcat.LMCatConfig.glob_process": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.glob_process_keys": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.LMCatConfig.get_tokenizer_obj": {"tf": 1}, "lmcat.lmcat.LMCatConfig.get_processing_pipeline": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 1}}, "df": 3}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"lmcat.lmcat.LMCatConfig.read": {"tf": 1}}, "df": 1}}, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.processors.register_processor": {"tf": 1}, "lmcat.processors.register_decider": {"tf": 1}}, "df": 2}}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.processors.remove_comments": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.processors.to_relative_path": {"tf": 1}}, "df": 1}}}}}}, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.processors.makefile_recipes": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.IgnoreHandler.root_dir": {"tf": 1}}, "df": 1}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1}}, "df": 1}}}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.lmcat.sorted_entries": {"tf": 1}}, "df": 1}}}}}}}, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "k": {"docs": {"lmcat.lmcat.walk_dir": {"tf": 1}, "lmcat.lmcat.walk_and_collect": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"lmcat.lmcat.format_tree_with_stats": {"tf": 1}}, "df": 1}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.processors.compress_whitespace": {"tf": 1}}, "df": 1}}}}}}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.processing_pipeline.ProcessingPipeline.decider_process_keys": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.glob_process_keys": {"tf": 1}}, "df": 2}}}}}}, "annotation": {"root": {"docs": {"lmcat.file_stats.TOKENIZERS_PRESENT": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper.name": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper.use_fallback": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper.tokenizer": {"tf": 1}, "lmcat.file_stats.FileStats.lines": {"tf": 1}, "lmcat.file_stats.FileStats.chars": {"tf": 1}, "lmcat.file_stats.FileStats.tokens": {"tf": 1}, "lmcat.file_stats.TreeEntry.line": {"tf": 1}, "lmcat.file_stats.TreeEntry.stats": {"tf": 1}, "lmcat.lmcat.LMCatConfig.content_divider": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tree_only": {"tf": 1}, "lmcat.lmcat.LMCatConfig.ignore_patterns": {"tf": 1}, "lmcat.lmcat.LMCatConfig.ignore_patterns_files": {"tf": 1}, "lmcat.lmcat.LMCatConfig.plugins_file": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.allow_plugins": {"tf": 1}, "lmcat.lmcat.LMCatConfig.glob_process": {"tf": 1}, "lmcat.lmcat.LMCatConfig.decider_process": {"tf": 1}, "lmcat.lmcat.LMCatConfig.on_multiple_processors": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tree_divider": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tree_file_divider": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tree_indent": {"tf": 1}, "lmcat.lmcat.LMCatConfig.output": {"tf": 1.4142135623730951}, "lmcat.lmcat.IgnoreHandler.root_dir": {"tf": 1}, "lmcat.lmcat.IgnoreHandler.config": {"tf": 1}, "lmcat.lmcat.IgnoreHandler.parser": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.plugins_file": {"tf": 1.4142135623730951}, "lmcat.processing_pipeline.ProcessingPipeline.decider_process_keys": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.glob_process_keys": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.on_multiple_processors": {"tf": 1.4142135623730951}, "lmcat.processors.PROCESSORS": {"tf": 1}, "lmcat.processors.DECIDERS": {"tf": 1}}, "df": 32, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"lmcat.file_stats.TOKENIZERS_PRESENT": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper.use_fallback": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tree_only": {"tf": 1}, "lmcat.lmcat.LMCatConfig.allow_plugins": {"tf": 1}, "lmcat.processors.DECIDERS": {"tf": 1}}, "df": 5}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.file_stats.TokenizerWrapper.name": {"tf": 1}, "lmcat.file_stats.TreeEntry.line": {"tf": 1}, "lmcat.lmcat.LMCatConfig.content_divider": {"tf": 1}, "lmcat.lmcat.LMCatConfig.glob_process": {"tf": 1}, "lmcat.lmcat.LMCatConfig.decider_process": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tree_divider": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tree_file_divider": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tree_indent": {"tf": 1}, "lmcat.lmcat.LMCatConfig.output": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.decider_process_keys": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.glob_process_keys": {"tf": 1}, "lmcat.processors.PROCESSORS": {"tf": 1}}, "df": 13}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.file_stats.TreeEntry.stats": {"tf": 1}}, "df": 1}}}}, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {"lmcat.lmcat.LMCatConfig.on_multiple_processors": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.on_multiple_processors": {"tf": 1}}, "df": 2}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.file_stats.TokenizerWrapper.tokenizer": {"tf": 1}}, "df": 1}}}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.file_stats.FileStats.tokens": {"tf": 1}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.file_stats.TreeEntry.stats": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.file_stats.TokenizerWrapper.tokenizer": {"tf": 1}}, "df": 1}}}}}}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lmcat.processors.PROCESSORS": {"tf": 1}, "lmcat.processors.DECIDERS": {"tf": 1}}, "df": 2}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.file_stats.FileStats.lines": {"tf": 1}, "lmcat.file_stats.FileStats.chars": {"tf": 1}}, "df": 2}}, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.IgnoreHandler.parser": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.lmcat.IgnoreHandler.parser": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.file_stats.TreeEntry.stats": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.file_stats.TreeEntry.stats": {"tf": 1}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.LMCatConfig.on_multiple_processors": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.on_multiple_processors": {"tf": 1}}, "df": 2}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.lmcat.LMCatConfig.ignore_patterns": {"tf": 1}}, "df": 1}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {"lmcat.lmcat.LMCatConfig.ignore_patterns_files": {"tf": 1}}, "df": 1}}}}}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"lmcat.lmcat.LMCatConfig.on_multiple_processors": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.on_multiple_processors": {"tf": 1}}, "df": 2}}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.LMCatConfig.on_multiple_processors": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.on_multiple_processors": {"tf": 1}}, "df": 2}}}, "m": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.IgnoreHandler.config": {"tf": 1.4142135623730951}}, "df": 1, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"lmcat.lmcat.IgnoreHandler.config": {"tf": 1}}, "df": 1}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"lmcat.lmcat.LMCatConfig.ignore_patterns_files": {"tf": 1}, "lmcat.lmcat.LMCatConfig.plugins_file": {"tf": 1}, "lmcat.lmcat.IgnoreHandler.root_dir": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.plugins_file": {"tf": 1}, "lmcat.processors.PROCESSORS": {"tf": 1}, "lmcat.processors.DECIDERS": {"tf": 1}}, "df": 6, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {"lmcat.lmcat.LMCatConfig.plugins_file": {"tf": 1}, "lmcat.lmcat.IgnoreHandler.root_dir": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.plugins_file": {"tf": 1}}, "df": 3}}}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.lmcat.LMCatConfig.plugins_file": {"tf": 1}, "lmcat.lmcat.LMCatConfig.output": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.plugins_file": {"tf": 1}}, "df": 3}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.lmcat.LMCatConfig.glob_process": {"tf": 1}, "lmcat.lmcat.LMCatConfig.decider_process": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.decider_process_keys": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.glob_process_keys": {"tf": 1}, "lmcat.processors.PROCESSORS": {"tf": 1}, "lmcat.processors.DECIDERS": {"tf": 1}}, "df": 6}}}}}}}, "o": {"docs": {"lmcat.lmcat.LMCatConfig.on_multiple_processors": {"tf": 1.4142135623730951}, "lmcat.processing_pipeline.ProcessingPipeline.on_multiple_processors": {"tf": 1.4142135623730951}}, "df": 2}}, "x": {"2": {"7": {"docs": {"lmcat.lmcat.LMCatConfig.on_multiple_processors": {"tf": 3.1622776601683795}, "lmcat.processing_pipeline.ProcessingPipeline.on_multiple_processors": {"tf": 3.1622776601683795}}, "df": 2}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"lmcat.lmcat.LMCatConfig.on_multiple_processors": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.on_multiple_processors": {"tf": 1}}, "df": 2}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.LMCatConfig.on_multiple_processors": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.on_multiple_processors": {"tf": 1}}, "df": 2}}}}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {"lmcat.processors.PROCESSORS": {"tf": 1}, "lmcat.processors.DECIDERS": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}}}, "default_value": {"root": {"1": {"0": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "b": {"docs": {"lmcat.processors.DECIDERS": {"tf": 1.4142135623730951}}, "df": 1}}}, "docs": {}, "df": 0}, "5": {"docs": {"lmcat.processors.PROCESSORS": {"tf": 1.4142135623730951}}, "df": 1}, "docs": {"lmcat.lmcat.LMCatConfig.content_divider": {"tf": 1.7320508075688772}, "lmcat.lmcat.LMCatConfig.on_multiple_processors": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.tree_divider": {"tf": 1.7320508075688772}, "lmcat.lmcat.LMCatConfig.tree_file_divider": {"tf": 1.7320508075688772}, "lmcat.lmcat.LMCatConfig.tree_indent": {"tf": 1.4142135623730951}, "lmcat.processing_pipeline.OnMultipleProcessors": {"tf": 1}, "lmcat.processors.ProcessorName": {"tf": 1.4142135623730951}, "lmcat.processors.DeciderName": {"tf": 1.4142135623730951}, "lmcat.processors.PROCESSORS": {"tf": 2.8284271247461903}, "lmcat.processors.DECIDERS": {"tf": 2}}, "df": 11, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.file_stats.TOKENIZERS_PRESENT": {"tf": 1}}, "df": 1}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lmcat.processing_pipeline.OnMultipleProcessors": {"tf": 1}, "lmcat.processors.ProcessorFunc": {"tf": 1}, "lmcat.processors.DeciderFunc": {"tf": 1}}, "df": 3}}}}}, "o": {"docs": {"lmcat.processors.PROCESSORS": {"tf": 2}}, "df": 1}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.file_stats.FileStats.tokens": {"tf": 1}, "lmcat.lmcat.LMCatConfig.plugins_file": {"tf": 1}, "lmcat.lmcat.LMCatConfig.output": {"tf": 1}}, "df": 3}}}}, "x": {"2": {"7": {"docs": {"lmcat.lmcat.LMCatConfig.content_divider": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.on_multiple_processors": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.tree_divider": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.tree_file_divider": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.tree_indent": {"tf": 1.4142135623730951}, "lmcat.processing_pipeline.OnMultipleProcessors": {"tf": 3.1622776601683795}, "lmcat.processors.ProcessorName": {"tf": 1.4142135623730951}, "lmcat.processors.DeciderName": {"tf": 1.4142135623730951}, "lmcat.processors.PROCESSORS": {"tf": 3.4641016151377544}, "lmcat.processors.DECIDERS": {"tf": 2}}, "df": 11}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.lmcat.LMCatConfig.tree_only": {"tf": 1}, "lmcat.lmcat.LMCatConfig.allow_plugins": {"tf": 1}}, "df": 2}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.processing_pipeline.OnMultipleProcessors": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lmcat.processors.PROCESSORS": {"tf": 2.449489742783178}, "lmcat.processors.DECIDERS": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.LMCatConfig.on_multiple_processors": {"tf": 1}, "lmcat.processing_pipeline.OnMultipleProcessors": {"tf": 1}}, "df": 2}}}}}}, "g": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"2": {"docs": {"lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}}, "t": {"docs": {"lmcat.processors.ProcessorName": {"tf": 1}, "lmcat.processors.DeciderName": {"tf": 1}, "lmcat.processors.PROCESSORS": {"tf": 2.449489742783178}, "lmcat.processors.DECIDERS": {"tf": 1.4142135623730951}}, "df": 4}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"lmcat.processing_pipeline.OnMultipleProcessors": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.processors.PROCESSORS": {"tf": 1.4142135623730951}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.processing_pipeline.OnMultipleProcessors": {"tf": 1}}, "df": 1}}}, "t": {"docs": {"lmcat.processors.ProcessorName": {"tf": 1}, "lmcat.processors.DeciderName": {"tf": 1}, "lmcat.processors.PROCESSORS": {"tf": 2.449489742783178}, "lmcat.processors.DECIDERS": {"tf": 1.4142135623730951}}, "df": 4}}, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"lmcat.processing_pipeline.OnMultipleProcessors": {"tf": 1}}, "df": 1}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.processors.PROCESSORS": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}, "d": {"docs": {}, "df": 0, "o": {"docs": {"lmcat.processing_pipeline.OnMultipleProcessors": {"tf": 1.4142135623730951}}, "df": 1, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lmcat.processors.DECIDERS": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}}}}, "s": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {"lmcat.processing_pipeline.OnMultipleProcessors": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.processors.ProcessorName": {"tf": 1}, "lmcat.processors.DeciderName": {"tf": 1}, "lmcat.processors.ProcessorFunc": {"tf": 1}}, "df": 3}}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.processors.ProcessorName": {"tf": 1}, "lmcat.processors.DeciderName": {"tf": 1}}, "df": 2}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {"lmcat.processors.ProcessorFunc": {"tf": 1}, "lmcat.processors.DeciderFunc": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.processors.PROCESSORS": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.processors.PROCESSORS": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "s": {"docs": {}, "df": 0, "v": {"docs": {"lmcat.processors.PROCESSORS": {"tf": 1.4142135623730951}}, "df": 1}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"lmcat.processors.ProcessorFunc": {"tf": 1}, "lmcat.processors.DeciderFunc": {"tf": 1}, "lmcat.processors.PROCESSORS": {"tf": 1.4142135623730951}}, "df": 3}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "w": {"docs": {"lmcat.processors.PROCESSORS": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"lmcat.processors.DeciderFunc": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.processors.PROCESSORS": {"tf": 1.4142135623730951}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.processors.PROCESSORS": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.processors.PROCESSORS": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "b": {"docs": {"lmcat.processors.PROCESSORS": {"tf": 1.4142135623730951}}, "df": 1}}}}, "s": {"docs": {"lmcat.processors.DECIDERS": {"tf": 2}}, "df": 1}}, "m": {"docs": {}, "df": 0, "d": {"docs": {"lmcat.processors.PROCESSORS": {"tf": 1.4142135623730951}}, "df": 1}, "a": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.processors.PROCESSORS": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.processors.DECIDERS": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "signature": {"root": {"3": {"9": {"docs": {"lmcat.file_stats.TokenizerWrapper.__init__": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.__init__": {"tf": 4.69041575982343}, "lmcat.lmcat.walk_dir": {"tf": 1.4142135623730951}, "lmcat.processing_pipeline.ProcessingPipeline.__init__": {"tf": 3.1622776601683795}}, "df": 4}, "docs": {}, "df": 0}, "docs": {"lmcat.main": {"tf": 3}, "lmcat.file_stats.TokenizerWrapper.__init__": {"tf": 4.47213595499958}, "lmcat.file_stats.TokenizerWrapper.n_tokens": {"tf": 4.47213595499958}, "lmcat.file_stats.FileStats.__init__": {"tf": 6.244997998398398}, "lmcat.file_stats.FileStats.from_file": {"tf": 7.14142842854285}, "lmcat.file_stats.TreeEntry.__init__": {"tf": 6.244997998398398}, "lmcat.lmcat.LMCatConfig.__init__": {"tf": 18.49324200890693}, "lmcat.lmcat.LMCatConfig.get_tokenizer_obj": {"tf": 4.47213595499958}, "lmcat.lmcat.LMCatConfig.get_processing_pipeline": {"tf": 4.47213595499958}, "lmcat.lmcat.LMCatConfig.read": {"tf": 5.656854249492381}, "lmcat.lmcat.LMCatConfig.serialize": {"tf": 5.0990195135927845}, "lmcat.lmcat.LMCatConfig.load": {"tf": 6.855654600401044}, "lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 7.483314773547883}, "lmcat.lmcat.IgnoreHandler.__init__": {"tf": 5.656854249492381}, "lmcat.lmcat.IgnoreHandler.is_ignored": {"tf": 4.898979485566356}, "lmcat.lmcat.sorted_entries": {"tf": 5.385164807134504}, "lmcat.lmcat.walk_dir": {"tf": 10.816653826391969}, "lmcat.lmcat.format_tree_with_stats": {"tf": 7.0710678118654755}, "lmcat.lmcat.walk_and_collect": {"tf": 7.615773105863909}, "lmcat.lmcat.assemble_summary": {"tf": 6}, "lmcat.lmcat.main": {"tf": 3}, "lmcat.processing_pipeline.load_plugins": {"tf": 4.47213595499958}, "lmcat.processing_pipeline.ProcessingPipeline.__init__": {"tf": 10.198039027185569}, "lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 6.708203932499369}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 6.244997998398398}, "lmcat.processors.register_processor": {"tf": 6.6332495807108}, "lmcat.processors.register_decider": {"tf": 6.6332495807108}, "lmcat.processors.is_over_10kb": {"tf": 4.47213595499958}, "lmcat.processors.is_documentation": {"tf": 4.47213595499958}, "lmcat.processors.remove_comments": {"tf": 4.47213595499958}, "lmcat.processors.compress_whitespace": {"tf": 4.47213595499958}, "lmcat.processors.to_relative_path": {"tf": 4.47213595499958}, "lmcat.processors.ipynb_to_md": {"tf": 4.47213595499958}, "lmcat.processors.makefile_recipes": {"tf": 4.47213595499958}, "lmcat.processors.csv_preview_5_lines": {"tf": 4.47213595499958}}, "df": 35, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.main": {"tf": 1}, "lmcat.file_stats.FileStats.__init__": {"tf": 1}, "lmcat.file_stats.TreeEntry.__init__": {"tf": 1}, "lmcat.lmcat.LMCatConfig.__init__": {"tf": 2}, "lmcat.lmcat.main": {"tf": 1}, "lmcat.processing_pipeline.load_plugins": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.__init__": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}}, "df": 8}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.file_stats.TokenizerWrapper.__init__": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.file_stats.TokenizerWrapper.__init__": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper.n_tokens": {"tf": 1}, "lmcat.file_stats.TreeEntry.__init__": {"tf": 1}, "lmcat.lmcat.LMCatConfig.__init__": {"tf": 3.3166247903554}, "lmcat.lmcat.LMCatConfig.serialize": {"tf": 1}, "lmcat.lmcat.LMCatConfig.load": {"tf": 1}, "lmcat.lmcat.walk_dir": {"tf": 1}, "lmcat.lmcat.format_tree_with_stats": {"tf": 1}, "lmcat.lmcat.walk_and_collect": {"tf": 1}, "lmcat.lmcat.assemble_summary": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.__init__": {"tf": 2}, "lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1.4142135623730951}, "lmcat.processors.register_processor": {"tf": 1.4142135623730951}, "lmcat.processors.remove_comments": {"tf": 1}, "lmcat.processors.compress_whitespace": {"tf": 1}, "lmcat.processors.to_relative_path": {"tf": 1}, "lmcat.processors.ipynb_to_md": {"tf": 1}, "lmcat.processors.makefile_recipes": {"tf": 1}, "lmcat.processors.csv_preview_5_lines": {"tf": 1}}, "df": 20}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.file_stats.FileStats.from_file": {"tf": 1.4142135623730951}, "lmcat.file_stats.TreeEntry.__init__": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.get_tokenizer_obj": {"tf": 1}, "lmcat.lmcat.walk_dir": {"tf": 1.4142135623730951}, "lmcat.lmcat.format_tree_with_stats": {"tf": 1}}, "df": 5}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.file_stats.TokenizerWrapper.__init__": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "f": {"docs": {"lmcat.file_stats.TokenizerWrapper.n_tokens": {"tf": 1}, "lmcat.lmcat.LMCatConfig.get_tokenizer_obj": {"tf": 1}, "lmcat.lmcat.LMCatConfig.get_processing_pipeline": {"tf": 1}, "lmcat.lmcat.LMCatConfig.serialize": {"tf": 1}, "lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1}, "lmcat.lmcat.IgnoreHandler.is_ignored": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}}, "df": 8}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1}}, "df": 1}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1}}, "df": 1, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {"lmcat.lmcat.LMCatConfig.__init__": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.__init__": {"tf": 1}}, "df": 2}}}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {"lmcat.lmcat.format_tree_with_stats": {"tf": 1}}, "df": 1}}}}, "w": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.file_stats.TokenizerWrapper.__init__": {"tf": 1}}, "df": 1}}}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"lmcat.lmcat.LMCatConfig.__init__": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.__init__": {"tf": 1}}, "df": 2}}}}, "t": {"docs": {"lmcat.lmcat.LMCatConfig.load": {"tf": 1.4142135623730951}}, "df": 1, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.file_stats.TokenizerWrapper.n_tokens": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.file_stats.FileStats.__init__": {"tf": 1}, "lmcat.lmcat.format_tree_with_stats": {"tf": 1}}, "df": 2}, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.file_stats.FileStats.from_file": {"tf": 1}, "lmcat.lmcat.LMCatConfig.__init__": {"tf": 1}, "lmcat.lmcat.walk_dir": {"tf": 1}}, "df": 3, "w": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.file_stats.FileStats.from_file": {"tf": 1}, "lmcat.lmcat.LMCatConfig.get_tokenizer_obj": {"tf": 1}, "lmcat.lmcat.walk_dir": {"tf": 1}}, "df": 3}}}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.lmcat.LMCatConfig.__init__": {"tf": 2}}, "df": 1, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"lmcat.lmcat.walk_dir": {"tf": 1}, "lmcat.lmcat.format_tree_with_stats": {"tf": 1}}, "df": 2}}}}}}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lmcat.lmcat.LMCatConfig.serialize": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 1}}, "df": 2}}}, "e": {"docs": {"lmcat.lmcat.LMCatConfig.load": {"tf": 1}}, "df": 1, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1}}, "df": 1}}}}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.lmcat.walk_dir": {"tf": 1}, "lmcat.lmcat.walk_and_collect": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}}, "df": 3}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.file_stats.TokenizerWrapper.n_tokens": {"tf": 1}, "lmcat.file_stats.FileStats.__init__": {"tf": 1.7320508075688772}}, "df": 2}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.LMCatConfig.__init__": {"tf": 1}}, "df": 1}}}}}, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.lmcat.LMCatConfig.__init__": {"tf": 1.4142135623730951}, "lmcat.lmcat.walk_dir": {"tf": 1}}, "df": 2, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.lmcat.walk_dir": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.file_stats.TreeEntry.__init__": {"tf": 1}}, "df": 1, "s": {"docs": {"lmcat.file_stats.FileStats.__init__": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.LMCatConfig.__init__": {"tf": 1.4142135623730951}, "lmcat.lmcat.sorted_entries": {"tf": 1}, "lmcat.lmcat.walk_dir": {"tf": 1.4142135623730951}, "lmcat.lmcat.format_tree_with_stats": {"tf": 1.4142135623730951}, "lmcat.lmcat.walk_and_collect": {"tf": 1.4142135623730951}, "lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 1}}, "df": 6}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"lmcat.lmcat.LMCatConfig.__init__": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.__init__": {"tf": 1}}, "df": 2}}}}}}, "m": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.file_stats.FileStats.from_file": {"tf": 1.4142135623730951}, "lmcat.file_stats.TreeEntry.__init__": {"tf": 1}, "lmcat.lmcat.LMCatConfig.get_tokenizer_obj": {"tf": 1}, "lmcat.lmcat.LMCatConfig.get_processing_pipeline": {"tf": 1}, "lmcat.lmcat.LMCatConfig.read": {"tf": 1.4142135623730951}, "lmcat.lmcat.IgnoreHandler.__init__": {"tf": 1.4142135623730951}, "lmcat.lmcat.walk_dir": {"tf": 2.449489742783178}, "lmcat.lmcat.format_tree_with_stats": {"tf": 1}, "lmcat.lmcat.walk_and_collect": {"tf": 1.4142135623730951}, "lmcat.lmcat.assemble_summary": {"tf": 1.4142135623730951}}, "df": 10, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"lmcat.lmcat.LMCatConfig.read": {"tf": 1}, "lmcat.lmcat.IgnoreHandler.__init__": {"tf": 1}, "lmcat.lmcat.walk_dir": {"tf": 1}, "lmcat.lmcat.walk_and_collect": {"tf": 1}, "lmcat.lmcat.assemble_summary": {"tf": 1}}, "df": 5}}}}}}}}}}, "t": {"docs": {"lmcat.lmcat.LMCatConfig.__init__": {"tf": 2}}, "df": 1}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.LMCatConfig.__init__": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.__init__": {"tf": 1}}, "df": 2}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.file_stats.FileStats.__init__": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.file_stats.FileStats.from_file": {"tf": 1}, "lmcat.lmcat.LMCatConfig.read": {"tf": 1}, "lmcat.lmcat.LMCatConfig.load": {"tf": 1}}, "df": 3}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.LMCatConfig.__init__": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"lmcat.lmcat.IgnoreHandler.__init__": {"tf": 1}, "lmcat.lmcat.walk_dir": {"tf": 1}, "lmcat.lmcat.walk_and_collect": {"tf": 1}, "lmcat.lmcat.assemble_summary": {"tf": 1}}, "df": 4}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 1}, "lmcat.processors.register_processor": {"tf": 1.4142135623730951}, "lmcat.processors.register_decider": {"tf": 1.4142135623730951}}, "df": 3}}}}}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"lmcat.file_stats.FileStats.__init__": {"tf": 1}, "lmcat.file_stats.TreeEntry.__init__": {"tf": 1}}, "df": 2}}}}}}}, "n": {"docs": {"lmcat.lmcat.LMCatConfig.__init__": {"tf": 1}, "lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.__init__": {"tf": 1}}, "df": 3, "l": {"docs": {}, "df": 0, "y": {"docs": {"lmcat.lmcat.LMCatConfig.__init__": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.LMCatConfig.__init__": {"tf": 1}}, "df": 1}}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"lmcat.file_stats.FileStats.from_file": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.__init__": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.read": {"tf": 1}, "lmcat.lmcat.IgnoreHandler.__init__": {"tf": 1}, "lmcat.lmcat.IgnoreHandler.is_ignored": {"tf": 1.4142135623730951}, "lmcat.lmcat.sorted_entries": {"tf": 1.4142135623730951}, "lmcat.lmcat.walk_dir": {"tf": 1.4142135623730951}, "lmcat.lmcat.walk_and_collect": {"tf": 1.4142135623730951}, "lmcat.lmcat.assemble_summary": {"tf": 1}, "lmcat.processing_pipeline.load_plugins": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.__init__": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 1.7320508075688772}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1.4142135623730951}, "lmcat.processors.register_processor": {"tf": 1.4142135623730951}, "lmcat.processors.register_decider": {"tf": 1.4142135623730951}, "lmcat.processors.is_over_10kb": {"tf": 1.4142135623730951}, "lmcat.processors.is_documentation": {"tf": 1.4142135623730951}, "lmcat.processors.remove_comments": {"tf": 1.4142135623730951}, "lmcat.processors.compress_whitespace": {"tf": 1.4142135623730951}, "lmcat.processors.to_relative_path": {"tf": 1.4142135623730951}, "lmcat.processors.ipynb_to_md": {"tf": 1.4142135623730951}, "lmcat.processors.makefile_recipes": {"tf": 1.4142135623730951}, "lmcat.processors.csv_preview_5_lines": {"tf": 1.4142135623730951}}, "df": 23, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {"lmcat.file_stats.FileStats.from_file": {"tf": 1}, "lmcat.lmcat.LMCatConfig.__init__": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.read": {"tf": 1}, "lmcat.lmcat.IgnoreHandler.__init__": {"tf": 1}, "lmcat.lmcat.IgnoreHandler.is_ignored": {"tf": 1}, "lmcat.lmcat.sorted_entries": {"tf": 1.4142135623730951}, "lmcat.lmcat.walk_dir": {"tf": 1.4142135623730951}, "lmcat.lmcat.walk_and_collect": {"tf": 1.4142135623730951}, "lmcat.lmcat.assemble_summary": {"tf": 1}, "lmcat.processing_pipeline.load_plugins": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.__init__": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 1.4142135623730951}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}, "lmcat.processors.register_processor": {"tf": 1.4142135623730951}, "lmcat.processors.register_decider": {"tf": 1.4142135623730951}, "lmcat.processors.is_over_10kb": {"tf": 1}, "lmcat.processors.is_documentation": {"tf": 1}, "lmcat.processors.remove_comments": {"tf": 1}, "lmcat.processors.compress_whitespace": {"tf": 1}, "lmcat.processors.to_relative_path": {"tf": 1}, "lmcat.processors.ipynb_to_md": {"tf": 1}, "lmcat.processors.makefile_recipes": {"tf": 1}, "lmcat.processors.csv_preview_5_lines": {"tf": 1}}, "df": 23}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.lmcat.LMCatConfig.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.lmcat.LMCatConfig.__init__": {"tf": 1.4142135623730951}, "lmcat.processing_pipeline.load_plugins": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.__init__": {"tf": 1}}, "df": 3}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.lmcat.LMCatConfig.__init__": {"tf": 1.4142135623730951}, "lmcat.processing_pipeline.ProcessingPipeline.__init__": {"tf": 1.4142135623730951}}, "df": 2, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.lmcat.LMCatConfig.__init__": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.__init__": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lmcat.lmcat.LMCatConfig.get_processing_pipeline": {"tf": 1}}, "df": 1, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.lmcat.LMCatConfig.get_processing_pipeline": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {"lmcat.lmcat.walk_dir": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.lmcat.LMCatConfig.get_processing_pipeline": {"tf": 1}}, "df": 1}}}}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.file_stats.FileStats.from_file": {"tf": 1.4142135623730951}, "lmcat.file_stats.TreeEntry.__init__": {"tf": 1}, "lmcat.lmcat.LMCatConfig.__init__": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.get_tokenizer_obj": {"tf": 1}, "lmcat.lmcat.walk_dir": {"tf": 1.4142135623730951}, "lmcat.lmcat.format_tree_with_stats": {"tf": 1}, "lmcat.processing_pipeline.load_plugins": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.__init__": {"tf": 1}}, "df": 8, "s": {"docs": {"lmcat.lmcat.LMCatConfig.__init__": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.file_stats.FileStats.from_file": {"tf": 1}, "lmcat.file_stats.TreeEntry.__init__": {"tf": 1}}, "df": 2}}}}}}}, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.LMCatConfig.__init__": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.__init__": {"tf": 1}}, "df": 2}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.lmcat.LMCatConfig.__init__": {"tf": 1.4142135623730951}, "lmcat.lmcat.format_tree_with_stats": {"tf": 1}}, "df": 2}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"lmcat.lmcat.LMCatConfig.__init__": {"tf": 2}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {"lmcat.processors.register_processor": {"tf": 1}, "lmcat.processors.register_decider": {"tf": 1}}, "df": 2}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.lmcat.LMCatConfig.__init__": {"tf": 1.7320508075688772}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.LMCatConfig.__init__": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.serialize": {"tf": 1}, "lmcat.lmcat.LMCatConfig.load": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.__init__": {"tf": 1.4142135623730951}}, "df": 4}}, "r": {"docs": {"lmcat.lmcat.LMCatConfig.read": {"tf": 1}, "lmcat.lmcat.IgnoreHandler.__init__": {"tf": 1}, "lmcat.lmcat.walk_and_collect": {"tf": 1}, "lmcat.lmcat.assemble_summary": {"tf": 1}}, "df": 4, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"lmcat.lmcat.sorted_entries": {"tf": 1}, "lmcat.lmcat.walk_dir": {"tf": 1}}, "df": 2}}}}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.lmcat.LMCatConfig.__init__": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.__init__": {"tf": 1}}, "df": 2}}}}}}, "o": {"docs": {"lmcat.lmcat.LMCatConfig.__init__": {"tf": 1.4142135623730951}, "lmcat.processing_pipeline.ProcessingPipeline.__init__": {"tf": 1.4142135623730951}}, "df": 2}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"lmcat.lmcat.LMCatConfig.load": {"tf": 1}}, "df": 1, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1}}, "df": 1}}}}}}}}}, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"lmcat.lmcat.LMCatConfig.__init__": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1}, "lmcat.lmcat.IgnoreHandler.is_ignored": {"tf": 1}, "lmcat.lmcat.format_tree_with_stats": {"tf": 1}, "lmcat.processors.register_decider": {"tf": 1.4142135623730951}, "lmcat.processors.is_over_10kb": {"tf": 1}, "lmcat.processors.is_documentation": {"tf": 1}}, "df": 7}}}}, "g": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.LMCatConfig.__init__": {"tf": 2}}, "df": 1}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "b": {"docs": {"lmcat.lmcat.LMCatConfig.__init__": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.__init__": {"tf": 1}}, "df": 2}}}, "p": {"docs": {}, "df": 0, "t": {"2": {"docs": {"lmcat.lmcat.LMCatConfig.__init__": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {"lmcat.lmcat.LMCatConfig.__init__": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "y": {"docs": {"lmcat.lmcat.LMCatConfig.serialize": {"tf": 1}, "lmcat.lmcat.LMCatConfig.load": {"tf": 1}}, "df": 2}}}, "m": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.lmcat.LMCatConfig.__init__": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.__init__": {"tf": 1}}, "df": 2}}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.LMCatConfig.__init__": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.__init__": {"tf": 1}}, "df": 3}}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1}}, "df": 1, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1.7320508075688772}}, "df": 1}}}}}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.lmcat.format_tree_with_stats": {"tf": 1}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.LMCatConfig.read": {"tf": 1}, "lmcat.lmcat.IgnoreHandler.__init__": {"tf": 1}, "lmcat.lmcat.walk_and_collect": {"tf": 1}, "lmcat.lmcat.assemble_summary": {"tf": 1}}, "df": 4}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lmcat.lmcat.LMCatConfig.load": {"tf": 1}}, "df": 1}}}}}, "j": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1}}, "df": 1}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.lmcat.walk_dir": {"tf": 1}}, "df": 1}}}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.processing_pipeline.ProcessingPipeline.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "bases": {"root": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lmcat.file_stats.TreeEntry": {"tf": 1}}, "df": 1}}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.file_stats.TreeEntry": {"tf": 1}}, "df": 1}}}}}}}}}}, "m": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.lmcat.LMCatConfig": {"tf": 1}}, "df": 1}}}}}}}, "j": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lmcat.lmcat.LMCatConfig": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.lmcat.LMCatConfig": {"tf": 1}}, "df": 1}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.lmcat.LMCatConfig": {"tf": 1}}, "df": 1, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.lmcat.LMCatConfig": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.lmcat.LMCatConfig": {"tf": 1}}, "df": 1}}}}}}}}}}}, "doc": {"root": {"0": {"docs": {"lmcat.file_stats.TreeEntry.line": {"tf": 1}}, "df": 1}, "1": {"0": {"2": {"4": {"docs": {"lmcat.processors.csv_preview_5_lines": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "b": {"docs": {"lmcat.processors.is_over_10kb": {"tf": 1}}, "df": 1}}}, "docs": {"lmcat": {"tf": 1}, "lmcat.file_stats.TreeEntry.stats": {"tf": 1}}, "df": 2}, "5": {"docs": {"lmcat.processors.csv_preview_5_lines": {"tf": 1}}, "df": 1}, "docs": {"lmcat": {"tf": 24.779023386727733}, "lmcat.main": {"tf": 1.4142135623730951}, "lmcat.file_stats": {"tf": 1.7320508075688772}, "lmcat.file_stats.TOKENIZERS_PRESENT": {"tf": 1.7320508075688772}, "lmcat.file_stats.TokenizerWrapper": {"tf": 3}, "lmcat.file_stats.TokenizerWrapper.__init__": {"tf": 1.7320508075688772}, "lmcat.file_stats.TokenizerWrapper.name": {"tf": 1.7320508075688772}, "lmcat.file_stats.TokenizerWrapper.use_fallback": {"tf": 1.7320508075688772}, "lmcat.file_stats.TokenizerWrapper.tokenizer": {"tf": 1.7320508075688772}, "lmcat.file_stats.TokenizerWrapper.n_tokens": {"tf": 1.4142135623730951}, "lmcat.file_stats.FileStats": {"tf": 1.4142135623730951}, "lmcat.file_stats.FileStats.__init__": {"tf": 1.7320508075688772}, "lmcat.file_stats.FileStats.lines": {"tf": 1.7320508075688772}, "lmcat.file_stats.FileStats.chars": {"tf": 1.7320508075688772}, "lmcat.file_stats.FileStats.tokens": {"tf": 1.7320508075688772}, "lmcat.file_stats.FileStats.from_file": {"tf": 5.291502622129181}, "lmcat.file_stats.TreeEntry": {"tf": 1.4142135623730951}, "lmcat.file_stats.TreeEntry.__init__": {"tf": 1.7320508075688772}, "lmcat.file_stats.TreeEntry.line": {"tf": 1.4142135623730951}, "lmcat.file_stats.TreeEntry.stats": {"tf": 1.4142135623730951}, "lmcat.lmcat": {"tf": 1.7320508075688772}, "lmcat.lmcat.LMCatConfig": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.__init__": {"tf": 1.7320508075688772}, "lmcat.lmcat.LMCatConfig.content_divider": {"tf": 1.7320508075688772}, "lmcat.lmcat.LMCatConfig.tree_only": {"tf": 1.7320508075688772}, "lmcat.lmcat.LMCatConfig.ignore_patterns": {"tf": 1.7320508075688772}, "lmcat.lmcat.LMCatConfig.ignore_patterns_files": {"tf": 1.7320508075688772}, "lmcat.lmcat.LMCatConfig.plugins_file": {"tf": 1.7320508075688772}, "lmcat.lmcat.LMCatConfig.allow_plugins": {"tf": 1.7320508075688772}, "lmcat.lmcat.LMCatConfig.glob_process": {"tf": 1.7320508075688772}, "lmcat.lmcat.LMCatConfig.decider_process": {"tf": 1.7320508075688772}, "lmcat.lmcat.LMCatConfig.on_multiple_processors": {"tf": 1.7320508075688772}, "lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 3.7416573867739413}, "lmcat.lmcat.LMCatConfig.tree_divider": {"tf": 1.7320508075688772}, "lmcat.lmcat.LMCatConfig.tree_file_divider": {"tf": 1.7320508075688772}, "lmcat.lmcat.LMCatConfig.tree_indent": {"tf": 1.7320508075688772}, "lmcat.lmcat.LMCatConfig.output": {"tf": 1.7320508075688772}, "lmcat.lmcat.LMCatConfig.get_tokenizer_obj": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.get_processing_pipeline": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.read": {"tf": 1.7320508075688772}, "lmcat.lmcat.LMCatConfig.serialize": {"tf": 2}, "lmcat.lmcat.LMCatConfig.load": {"tf": 2}, "lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 2.449489742783178}, "lmcat.lmcat.IgnoreHandler": {"tf": 1.4142135623730951}, "lmcat.lmcat.IgnoreHandler.__init__": {"tf": 1.7320508075688772}, "lmcat.lmcat.IgnoreHandler.root_dir": {"tf": 1.7320508075688772}, "lmcat.lmcat.IgnoreHandler.config": {"tf": 1.7320508075688772}, "lmcat.lmcat.IgnoreHandler.parser": {"tf": 1.7320508075688772}, "lmcat.lmcat.IgnoreHandler.is_ignored": {"tf": 1.4142135623730951}, "lmcat.lmcat.sorted_entries": {"tf": 1.4142135623730951}, "lmcat.lmcat.walk_dir": {"tf": 1.4142135623730951}, "lmcat.lmcat.format_tree_with_stats": {"tf": 5.291502622129181}, "lmcat.lmcat.walk_and_collect": {"tf": 1.4142135623730951}, "lmcat.lmcat.assemble_summary": {"tf": 1.4142135623730951}, "lmcat.lmcat.main": {"tf": 1.4142135623730951}, "lmcat.processing_pipeline": {"tf": 1.7320508075688772}, "lmcat.processing_pipeline.OnMultipleProcessors": {"tf": 1.7320508075688772}, "lmcat.processing_pipeline.load_plugins": {"tf": 3.7416573867739413}, "lmcat.processing_pipeline.ProcessingPipeline": {"tf": 5}, "lmcat.processing_pipeline.ProcessingPipeline.__init__": {"tf": 1.7320508075688772}, "lmcat.processing_pipeline.ProcessingPipeline.plugins_file": {"tf": 1.7320508075688772}, "lmcat.processing_pipeline.ProcessingPipeline.decider_process_keys": {"tf": 1.7320508075688772}, "lmcat.processing_pipeline.ProcessingPipeline.glob_process_keys": {"tf": 1.7320508075688772}, "lmcat.processing_pipeline.ProcessingPipeline.on_multiple_processors": {"tf": 1.7320508075688772}, "lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 4.898979485566356}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 5.291502622129181}, "lmcat.processors": {"tf": 1.7320508075688772}, "lmcat.processors.ProcessorName": {"tf": 1.7320508075688772}, "lmcat.processors.DeciderName": {"tf": 1.7320508075688772}, "lmcat.processors.ProcessorFunc": {"tf": 1.7320508075688772}, "lmcat.processors.DeciderFunc": {"tf": 1.7320508075688772}, "lmcat.processors.PROCESSORS": {"tf": 1.7320508075688772}, "lmcat.processors.DECIDERS": {"tf": 1.7320508075688772}, "lmcat.processors.register_processor": {"tf": 1.4142135623730951}, "lmcat.processors.register_decider": {"tf": 1.4142135623730951}, "lmcat.processors.is_over_10kb": {"tf": 1.7320508075688772}, "lmcat.processors.is_documentation": {"tf": 1.7320508075688772}, "lmcat.processors.remove_comments": {"tf": 1.7320508075688772}, "lmcat.processors.compress_whitespace": {"tf": 1.7320508075688772}, "lmcat.processors.to_relative_path": {"tf": 1.4142135623730951}, "lmcat.processors.ipynb_to_md": {"tf": 1.7320508075688772}, "lmcat.processors.makefile_recipes": {"tf": 6}, "lmcat.processors.csv_preview_5_lines": {"tf": 5.196152422706632}}, "df": 83, "l": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"lmcat": {"tf": 3.605551275463989}, "lmcat.lmcat.LMCatConfig": {"tf": 1}, "lmcat.lmcat.LMCatConfig.read": {"tf": 1.4142135623730951}}, "df": 3}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 1.7320508075688772}}, "df": 1}}}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 1}, "lmcat.file_stats.TreeEntry.__init__": {"tf": 1}, "lmcat.processors.remove_comments": {"tf": 1}, "lmcat.processors.makefile_recipes": {"tf": 2}}, "df": 4, "s": {"docs": {"lmcat": {"tf": 2}, "lmcat.lmcat.walk_dir": {"tf": 1}, "lmcat.lmcat.format_tree_with_stats": {"tf": 1}, "lmcat.processors.csv_preview_5_lines": {"tf": 1.7320508075688772}}, "df": 4}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 1.7320508075688772}}, "df": 1}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.format_tree_with_stats": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 1}}, "df": 2, "[": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"lmcat.lmcat.format_tree_with_stats": {"tf": 1}}, "df": 1}}}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.lmcat.format_tree_with_stats": {"tf": 1}}, "df": 1}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {"lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lmcat.lmcat.walk_and_collect": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "g": {"docs": {"lmcat": {"tf": 1}}, "df": 1}, "a": {"docs": {}, "df": 0, "d": {"docs": {"lmcat.processing_pipeline.load_plugins": {"tf": 1}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "m": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}, "a": {"docs": {"lmcat": {"tf": 2.8284271247461903}, "lmcat.file_stats.TokenizerWrapper": {"tf": 1}, "lmcat.file_stats.FileStats": {"tf": 1}, "lmcat.file_stats.FileStats.from_file": {"tf": 1}, "lmcat.lmcat.LMCatConfig.serialize": {"tf": 1}, "lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1}, "lmcat.lmcat.IgnoreHandler.is_ignored": {"tf": 1}, "lmcat.lmcat.walk_dir": {"tf": 1}, "lmcat.processing_pipeline.load_plugins": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}, "lmcat.processors.register_processor": {"tf": 1.4142135623730951}, "lmcat.processors.register_decider": {"tf": 1.4142135623730951}, "lmcat.processors.to_relative_path": {"tf": 1}, "lmcat.processors.makefile_recipes": {"tf": 1}, "lmcat.processors.csv_preview_5_lines": {"tf": 1}}, "df": 16, "n": {"docs": {"lmcat": {"tf": 1}, "lmcat.lmcat.LMCatConfig.load": {"tf": 1.4142135623730951}, "lmcat.processors.ipynb_to_md": {"tf": 1}}, "df": 3, "d": {"docs": {"lmcat": {"tf": 2.6457513110645907}, "lmcat.file_stats.TokenizerWrapper": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1}, "lmcat.lmcat.LMCatConfig.load": {"tf": 1}, "lmcat.lmcat.walk_dir": {"tf": 1}, "lmcat.lmcat.walk_and_collect": {"tf": 1}, "lmcat.lmcat.assemble_summary": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}, "lmcat.processors.makefile_recipes": {"tf": 1.4142135623730951}, "lmcat.processors.csv_preview_5_lines": {"tf": 1}}, "df": 10}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.file_stats.FileStats.from_file": {"tf": 1}}, "df": 1}}}}}, "y": {"docs": {"lmcat.file_stats.FileStats.from_file": {"tf": 1}}, "df": 1}}, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"lmcat": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1}, "lmcat.lmcat.IgnoreHandler": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 1}}, "df": 4}, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.file_stats.TreeEntry.line": {"tf": 1}, "lmcat.file_stats.TreeEntry.stats": {"tf": 1}}, "df": 2}}, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"lmcat.lmcat.format_tree_with_stats": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}}}, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {"lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {"lmcat.file_stats.TokenizerWrapper": {"tf": 1}, "lmcat.lmcat.LMCatConfig.serialize": {"tf": 1}, "lmcat.processors.register_processor": {"tf": 1}, "lmcat.processors.register_decider": {"tf": 1}, "lmcat.processors.to_relative_path": {"tf": 1}}, "df": 5, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.lmcat.assemble_summary": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.LMCatConfig.read": {"tf": 1}, "lmcat.processors.csv_preview_5_lines": {"tf": 1}}, "df": 2}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.processing_pipeline.ProcessingPipeline": {"tf": 1}}, "df": 1}}}}}}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"lmcat.lmcat.LMCatConfig.load": {"tf": 1}}, "df": 1}}}}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.processors.makefile_recipes": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.processors.makefile_recipes": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lmcat": {"tf": 2}, "lmcat.processing_pipeline.load_plugins": {"tf": 1}}, "df": 2}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"lmcat": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.read": {"tf": 1}}, "df": 2}}}}}}, "i": {"docs": {"lmcat": {"tf": 1.4142135623730951}}, "df": 1}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "n": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.processing_pipeline.ProcessingPipeline": {"tf": 1}}, "df": 1}}}}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"lmcat.lmcat.IgnoreHandler": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline": {"tf": 1}}, "df": 2, "s": {"docs": {"lmcat": {"tf": 2.449489742783178}, "lmcat.processing_pipeline.ProcessingPipeline": {"tf": 1.4142135623730951}}, "df": 2}}}}}, "h": {"docs": {"lmcat.file_stats.FileStats.from_file": {"tf": 1.7320508075688772}, "lmcat.lmcat.IgnoreHandler.is_ignored": {"tf": 1}, "lmcat.processing_pipeline.load_plugins": {"tf": 1.4142135623730951}, "lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 2.23606797749979}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 2}, "lmcat.processors.register_processor": {"tf": 1}, "lmcat.processors.to_relative_path": {"tf": 1}, "lmcat.processors.makefile_recipes": {"tf": 1.7320508075688772}, "lmcat.processors.csv_preview_5_lines": {"tf": 1.7320508075688772}}, "df": 9, "s": {"docs": {"lmcat.lmcat.walk_dir": {"tf": 1}, "lmcat.lmcat.walk_and_collect": {"tf": 1}}, "df": 2}}}, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.file_stats.FileStats.from_file": {"tf": 1}, "lmcat.lmcat.format_tree_with_stats": {"tf": 1}, "lmcat.processing_pipeline.load_plugins": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}, "lmcat.processors.makefile_recipes": {"tf": 1}, "lmcat.processors.csv_preview_5_lines": {"tf": 1}}, "df": 7}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.processors.csv_preview_5_lines": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lmcat": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper": {"tf": 1}}, "df": 2}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"lmcat": {"tf": 1.7320508075688772}, "lmcat.processing_pipeline.ProcessingPipeline": {"tf": 1.4142135623730951}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1.4142135623730951}, "lmcat.processors.makefile_recipes": {"tf": 1.4142135623730951}}, "df": 4, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lmcat": {"tf": 1}, "lmcat.lmcat.LMCatConfig.get_processing_pipeline": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline": {"tf": 1}}, "df": 3}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.processing_pipeline.ProcessingPipeline": {"tf": 1.4142135623730951}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1.4142135623730951}, "lmcat.processors.register_processor": {"tf": 1}}, "df": 3, "s": {"docs": {"lmcat": {"tf": 2}, "lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 1.7320508075688772}}, "df": 2}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.processing_pipeline.ProcessingPipeline": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}, "lmcat.processors.makefile_recipes": {"tf": 1}}, "df": 2}}}}}}, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"lmcat": {"tf": 1.7320508075688772}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.processors.makefile_recipes": {"tf": 1}}, "df": 1}}}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "w": {"docs": {"lmcat.processors.csv_preview_5_lines": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "p": {"docs": {"lmcat": {"tf": 1.4142135623730951}}, "df": 1, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 1}, "lmcat.lmcat.LMCatConfig.get_processing_pipeline": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}}, "df": 4}}}}}}}, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {"lmcat": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.main": {"tf": 1}, "lmcat.lmcat.main": {"tf": 1}}, "df": 2}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.lmcat.walk_and_collect": {"tf": 1}}, "df": 1}, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.processing_pipeline.load_plugins": {"tf": 1.7320508075688772}}, "df": 1}}}}}}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "y": {"docs": {"lmcat.processors.makefile_recipes": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "t": {"docs": {"lmcat": {"tf": 1}}, "df": 1, "o": {"docs": {"lmcat": {"tf": 3.1622776601683795}, "lmcat.file_stats.FileStats.from_file": {"tf": 1.7320508075688772}, "lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1.7320508075688772}, "lmcat.lmcat.LMCatConfig.read": {"tf": 1}, "lmcat.lmcat.format_tree_with_stats": {"tf": 1}, "lmcat.processing_pipeline.load_plugins": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline": {"tf": 1.4142135623730951}, "lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}, "lmcat.processors.to_relative_path": {"tf": 1}, "lmcat.processors.ipynb_to_md": {"tf": 1}, "lmcat.processors.makefile_recipes": {"tf": 2}, "lmcat.processors.csv_preview_5_lines": {"tf": 1.7320508075688772}}, "df": 13, "o": {"docs": {"lmcat": {"tf": 1}}, "df": 1, "l": {"docs": {"lmcat": {"tf": 2}}, "df": 1}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"lmcat.lmcat.format_tree_with_stats": {"tf": 1}}, "df": 1, "s": {"docs": {"lmcat": {"tf": 1.4142135623730951}, "lmcat.file_stats.TokenizerWrapper": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper.n_tokens": {"tf": 1}, "lmcat.file_stats.FileStats.from_file": {"tf": 1}, "lmcat.lmcat.format_tree_with_stats": {"tf": 1}}, "df": 5}, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper": {"tf": 1}, "lmcat.file_stats.FileStats.from_file": {"tf": 1.7320508075688772}, "lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.get_tokenizer_obj": {"tf": 1}}, "df": 5, "s": {"docs": {"lmcat": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1.7320508075688772}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1}}, "df": 1}}}}}}}}, "m": {"docs": {}, "df": 0, "l": {"docs": {"lmcat": {"tf": 1.7320508075688772}, "lmcat.lmcat.LMCatConfig.read": {"tf": 1.4142135623730951}}, "df": 2}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 3.605551275463989}, "lmcat.file_stats.TreeEntry": {"tf": 1}, "lmcat.lmcat.walk_dir": {"tf": 1}, "lmcat.lmcat.format_tree_with_stats": {"tf": 1.7320508075688772}, "lmcat.lmcat.walk_and_collect": {"tf": 1}}, "df": 5, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"lmcat.file_stats.TreeEntry.__init__": {"tf": 1}}, "df": 1}}}}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 2.6457513110645907}, "lmcat.main": {"tf": 1}, "lmcat.file_stats.FileStats.from_file": {"tf": 1.4142135623730951}, "lmcat.file_stats.TreeEntry": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1}, "lmcat.lmcat.LMCatConfig.get_tokenizer_obj": {"tf": 1}, "lmcat.lmcat.LMCatConfig.get_processing_pipeline": {"tf": 1}, "lmcat.lmcat.LMCatConfig.serialize": {"tf": 1}, "lmcat.lmcat.LMCatConfig.load": {"tf": 1}, "lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1.4142135623730951}, "lmcat.lmcat.assemble_summary": {"tf": 1}, "lmcat.lmcat.main": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1.7320508075688772}, "lmcat.processors.to_relative_path": {"tf": 1.4142135623730951}, "lmcat.processors.makefile_recipes": {"tf": 1.4142135623730951}, "lmcat.processors.csv_preview_5_lines": {"tf": 1}}, "df": 17, "n": {"docs": {"lmcat.lmcat.sorted_entries": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {"lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1}}, "df": 1}, "u": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {"lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}}, "df": 1}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.lmcat.LMCatConfig.load": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.processors.makefile_recipes": {"tf": 1.7320508075688772}}, "df": 1, "s": {"docs": {"lmcat.processors.makefile_recipes": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"lmcat": {"tf": 2}}, "df": 1, "s": {"docs": {"lmcat": {"tf": 1.7320508075688772}}, "df": 1}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}}}, "x": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.file_stats.TokenizerWrapper.n_tokens": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}}, "df": 2}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lmcat": {"tf": 1.4142135623730951}}, "df": 1}}}, "e": {"docs": {"lmcat": {"tf": 1}, "lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1}}, "df": 2, "s": {"docs": {"lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}}, "df": 1}}}}}}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"lmcat": {"tf": 2.449489742783178}, "lmcat.main": {"tf": 1}, "lmcat.file_stats.FileStats": {"tf": 1}, "lmcat.file_stats.FileStats.from_file": {"tf": 1.7320508075688772}, "lmcat.file_stats.TreeEntry.line": {"tf": 1}, "lmcat.file_stats.TreeEntry.stats": {"tf": 1}, "lmcat.lmcat.LMCatConfig": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1}, "lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1}, "lmcat.lmcat.main": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline": {"tf": 1.4142135623730951}, "lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 1.4142135623730951}}, "df": 12, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"lmcat": {"tf": 1.7320508075688772}, "lmcat.lmcat.format_tree_with_stats": {"tf": 1}}, "df": 2, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lmcat": {"tf": 1.4142135623730951}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"lmcat.lmcat.format_tree_with_stats": {"tf": 1}}, "df": 1}}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 3.7416573867739413}, "lmcat.file_stats.FileStats": {"tf": 1}, "lmcat.file_stats.FileStats.from_file": {"tf": 1.7320508075688772}, "lmcat.lmcat.walk_dir": {"tf": 1}, "lmcat.lmcat.walk_and_collect": {"tf": 1}, "lmcat.processing_pipeline.load_plugins": {"tf": 1.7320508075688772}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}, "lmcat.processors.is_over_10kb": {"tf": 1}, "lmcat.processors.is_documentation": {"tf": 1}, "lmcat.processors.to_relative_path": {"tf": 1}, "lmcat.processors.csv_preview_5_lines": {"tf": 1.7320508075688772}}, "df": 11, "s": {"docs": {"lmcat": {"tf": 2}, "lmcat.lmcat.sorted_entries": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline": {"tf": 1}}, "df": 3, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.file_stats.FileStats.from_file": {"tf": 1}}, "df": 1}}}}, "y": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {"lmcat.lmcat.walk_and_collect": {"tf": 1}}, "df": 1}}}}}}, "/": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"lmcat": {"tf": 1.4142135623730951}, "lmcat.lmcat.sorted_entries": {"tf": 1}, "lmcat.processors.makefile_recipes": {"tf": 1.4142135623730951}, "lmcat.processors.csv_preview_5_lines": {"tf": 1.7320508075688772}}, "df": 4}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"lmcat.file_stats.TreeEntry.line": {"tf": 1}, "lmcat.file_stats.TreeEntry.stats": {"tf": 1}, "lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1.4142135623730951}}, "df": 3, "s": {"docs": {"lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}}, "w": {"docs": {"lmcat": {"tf": 1}, "lmcat.processors.csv_preview_5_lines": {"tf": 1.4142135623730951}}, "df": 2}, "e": {"docs": {}, "df": 0, "l": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"lmcat": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1}, "lmcat.lmcat.LMCatConfig.read": {"tf": 1}, "lmcat.lmcat.walk_and_collect": {"tf": 1}, "lmcat.processing_pipeline.load_plugins": {"tf": 1}, "lmcat.processors.remove_comments": {"tf": 1}}, "df": 6}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}, "l": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"lmcat.file_stats.TokenizerWrapper": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1}}, "df": 2}}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lmcat.processors.register_processor": {"tf": 1}, "lmcat.processors.register_decider": {"tf": 1}}, "df": 2}}}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}, "e": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"lmcat.lmcat.LMCatConfig.read": {"tf": 1}}, "df": 1, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 1.4142135623730951}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lmcat": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig": {"tf": 1}}, "df": 2}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"lmcat": {"tf": 1.4142135623730951}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1.4142135623730951}, "lmcat.processors.makefile_recipes": {"tf": 1}}, "df": 3, "s": {"docs": {"lmcat": {"tf": 1.7320508075688772}, "lmcat.lmcat.sorted_entries": {"tf": 1}}, "df": 2}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"lmcat": {"tf": 1}, "lmcat.processors.ipynb_to_md": {"tf": 1}}, "df": 2}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 1.4142135623730951}, "lmcat.processors.remove_comments": {"tf": 1}}, "df": 2}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lmcat": {"tf": 1}, "lmcat.file_stats.FileStats.from_file": {"tf": 1}}, "df": 2}}}, "s": {"docs": {"lmcat.lmcat.format_tree_with_stats": {"tf": 1}}, "df": 1}}}}, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"lmcat": {"tf": 1}}, "df": 1, "s": {"docs": {"lmcat": {"tf": 1.4142135623730951}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.processors.remove_comments": {"tf": 1}, "lmcat.processors.makefile_recipes": {"tf": 1}}, "df": 2}}}}}, "/": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"lmcat.processing_pipeline.ProcessingPipeline": {"tf": 1.4142135623730951}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.processors.compress_whitespace": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lmcat.lmcat.walk_dir": {"tf": 1}}, "df": 1}}}}}}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"lmcat": {"tf": 1}, "lmcat.processors.compress_whitespace": {"tf": 1}}, "df": 2}}}}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"lmcat": {"tf": 1}, "lmcat.lmcat.IgnoreHandler.is_ignored": {"tf": 1}, "lmcat.processors.is_over_10kb": {"tf": 1}, "lmcat.processors.is_documentation": {"tf": 1}}, "df": 4, "s": {"docs": {"lmcat": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"lmcat": {"tf": 1}}, "df": 1}, "n": {"docs": {"lmcat": {"tf": 1.4142135623730951}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 1.4142135623730951}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.lmcat.LMCatConfig.serialize": {"tf": 1}, "lmcat.lmcat.LMCatConfig.load": {"tf": 1}}, "df": 2}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {"lmcat": {"tf": 1.4142135623730951}}, "df": 1}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"lmcat.processing_pipeline.ProcessingPipeline": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"lmcat": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "f": {"docs": {}, "df": 0, "g": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}, "d": {"docs": {"lmcat": {"tf": 1}}, "df": 1}, "s": {"docs": {}, "df": 0, "v": {"docs": {"lmcat": {"tf": 1}, "lmcat.processors.csv_preview_5_lines": {"tf": 1.7320508075688772}}, "df": 2}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.file_stats.TreeEntry.__init__": {"tf": 1}}, "df": 1}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.lmcat.walk_and_collect": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"lmcat": {"tf": 2.449489742783178}, "lmcat.lmcat.sorted_entries": {"tf": 1}, "lmcat.lmcat.walk_dir": {"tf": 1}}, "df": 3}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.lmcat.sorted_entries": {"tf": 1}}, "df": 1}}}}}}}}}, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat": {"tf": 1.7320508075688772}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.LMCatConfig.serialize": {"tf": 1}, "lmcat.lmcat.LMCatConfig.load": {"tf": 1}}, "df": 2, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.processing_pipeline.ProcessingPipeline": {"tf": 1.4142135623730951}}, "df": 1}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.processing_pipeline.ProcessingPipeline": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"lmcat": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lmcat": {"tf": 1}, "lmcat.processors.is_documentation": {"tf": 1}}, "df": 2}}}}}}}}}}, "s": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.processors.csv_preview_5_lines": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"lmcat": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline": {"tf": 1.4142135623730951}, "lmcat.processors.register_decider": {"tf": 1}}, "df": 3, "s": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.lmcat.LMCatConfig.serialize": {"tf": 1}, "lmcat.lmcat.LMCatConfig.load": {"tf": 1}}, "df": 2}}}}}}}, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1}}, "df": 1, "s": {"docs": {"lmcat": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"lmcat": {"tf": 2}}, "df": 1}}}}}}}}}, "p": {"docs": {"lmcat": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}}}}}}, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.processors.makefile_recipes": {"tf": 1}}, "df": 1}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.lmcat.LMCatConfig": {"tf": 1}, "lmcat.lmcat.LMCatConfig.serialize": {"tf": 1}, "lmcat.lmcat.LMCatConfig.load": {"tf": 1}}, "df": 3}}}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}, "lmcat.processors.makefile_recipes": {"tf": 1}, "lmcat.processors.csv_preview_5_lines": {"tf": 1}}, "df": 3, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 1.4142135623730951}, "lmcat.processors.makefile_recipes": {"tf": 1}, "lmcat.processors.csv_preview_5_lines": {"tf": 1}}, "df": 3, "s": {"docs": {"lmcat": {"tf": 1}}, "df": 1}, "d": {"docs": {"lmcat.lmcat.LMCatConfig.load": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lmcat.processors.to_relative_path": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {"lmcat": {"tf": 1}, "lmcat.file_stats.FileStats": {"tf": 1}, "lmcat.file_stats.FileStats.from_file": {"tf": 1.4142135623730951}, "lmcat.lmcat.format_tree_with_stats": {"tf": 1}}, "df": 4}}}}}}, "s": {"docs": {"lmcat.file_stats.TreeEntry": {"tf": 1}, "lmcat.file_stats.TreeEntry.__init__": {"tf": 1}, "lmcat.lmcat.format_tree_with_stats": {"tf": 1.4142135623730951}}, "df": 3}}, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.processors.makefile_recipes": {"tf": 1}}, "df": 1}}}}, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.file_stats.TokenizerWrapper": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 1}, "lmcat.file_stats.FileStats": {"tf": 1}, "lmcat.file_stats.FileStats.from_file": {"tf": 1}, "lmcat.processors.remove_comments": {"tf": 1}, "lmcat.processors.compress_whitespace": {"tf": 1}}, "df": 5}}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "w": {"docs": {"lmcat": {"tf": 1.7320508075688772}, "lmcat.lmcat.format_tree_with_stats": {"tf": 1.4142135623730951}, "lmcat.processors.makefile_recipes": {"tf": 1}}, "df": 3}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"lmcat.lmcat.IgnoreHandler.is_ignored": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"lmcat": {"tf": 1}}, "df": 1, "s": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}}, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"lmcat": {"tf": 1}, "lmcat.lmcat.assemble_summary": {"tf": 1}}, "df": 2}, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "y": {"docs": {"lmcat": {"tf": 1.4142135623730951}}, "df": 1}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"lmcat": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1}}, "df": 3, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lmcat.file_stats.TokenizerWrapper": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {"lmcat.processors.csv_preview_5_lines": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.processors.compress_whitespace": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {"lmcat": {"tf": 1}}, "df": 1, "u": {"docs": {}, "df": 0, "p": {"docs": {"lmcat": {"tf": 1.4142135623730951}}, "df": 1}}}, "e": {"docs": {"lmcat": {"tf": 1}}, "df": 1}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.lmcat.LMCatConfig.serialize": {"tf": 1}, "lmcat.lmcat.LMCatConfig.load": {"tf": 1}}, "df": 2, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.main": {"tf": 1}, "lmcat.lmcat.main": {"tf": 1}}, "df": 2}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"lmcat.lmcat.sorted_entries": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {"lmcat": {"tf": 1}}, "df": 1, "n": {"docs": {"lmcat": {"tf": 1.7320508075688772}, "lmcat.file_stats.TokenizerWrapper.n_tokens": {"tf": 1}, "lmcat.file_stats.TreeEntry": {"tf": 1}, "lmcat.lmcat.LMCatConfig.load": {"tf": 1}}, "df": 4, "t": {"docs": {}, "df": 0, "o": {"docs": {"lmcat": {"tf": 1}, "lmcat.processors.compress_whitespace": {"tf": 1}, "lmcat.processors.csv_preview_5_lines": {"tf": 1}}, "df": 3}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}}, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 1}}, "df": 1, "s": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"lmcat": {"tf": 2}}, "df": 1, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}, "/": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1.4142135623730951}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.file_stats.TreeEntry.__init__": {"tf": 1}, "lmcat.lmcat.LMCatConfig.load": {"tf": 1}}, "df": 2}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"lmcat": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}}}}}}, "t": {"docs": {"lmcat": {"tf": 1}, "lmcat.processors.makefile_recipes": {"tf": 1}}, "df": 2}, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 2.23606797749979}, "lmcat.lmcat.IgnoreHandler": {"tf": 1}}, "df": 2, "d": {"docs": {"lmcat": {"tf": 1}, "lmcat.lmcat.IgnoreHandler.is_ignored": {"tf": 1}}, "df": 2}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.IgnoreHandler": {"tf": 1}}, "df": 1}}}}}}}}}, "f": {"docs": {"lmcat": {"tf": 1.4142135623730951}, "lmcat.file_stats.FileStats.from_file": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1}, "lmcat.lmcat.IgnoreHandler.is_ignored": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}, "lmcat.processors.is_over_10kb": {"tf": 1}, "lmcat.processors.is_documentation": {"tf": 1}, "lmcat.processors.makefile_recipes": {"tf": 1}}, "df": 8}, "s": {"docs": {"lmcat": {"tf": 1.7320508075688772}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}, "lmcat.processors.is_over_10kb": {"tf": 1}, "lmcat.processors.is_documentation": {"tf": 1}}, "df": 4}, "p": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "b": {"docs": {"lmcat": {"tf": 1.4142135623730951}}, "df": 1}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lmcat.processors.ipynb_to_md": {"tf": 1}}, "df": 1}}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"lmcat.lmcat.LMCatConfig.serialize": {"tf": 1}, "lmcat.lmcat.LMCatConfig.load": {"tf": 1}}, "df": 2}}}}}}}}}}}, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"lmcat": {"tf": 2}, "lmcat.file_stats.TreeEntry": {"tf": 1}, "lmcat.lmcat.format_tree_with_stats": {"tf": 1.7320508075688772}, "lmcat.processors.makefile_recipes": {"tf": 1}}, "df": 4}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"lmcat": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}}, "df": 3}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}, "l": {"docs": {}, "df": 0, "k": {"docs": {"lmcat.lmcat.walk_dir": {"tf": 1}, "lmcat.lmcat.walk_and_collect": {"tf": 1}}, "df": 2}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.file_stats.TokenizerWrapper": {"tf": 1}}, "df": 1}}}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1}, "lmcat.processors.compress_whitespace": {"tf": 1}}, "df": 4}}}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {"lmcat": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1}}, "df": 2}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.lmcat.format_tree_with_stats": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "b": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}, "m": {"docs": {"lmcat": {"tf": 1.7320508075688772}}, "df": 1, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "n": {"docs": {"lmcat": {"tf": 1}, "lmcat.processors.ipynb_to_md": {"tf": 1}}, "df": 2}}}}}}, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"lmcat": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lmcat.lmcat.IgnoreHandler": {"tf": 1}}, "df": 1}}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 3.7416573867739413}}, "df": 1, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 1}, "lmcat.processors.makefile_recipes": {"tf": 1.7320508075688772}}, "df": 2}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"lmcat.main": {"tf": 1}, "lmcat.lmcat.main": {"tf": 1}}, "df": 2, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.processing_pipeline.ProcessingPipeline": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.processing_pipeline.ProcessingPipeline": {"tf": 1.4142135623730951}}, "df": 1}}}, "d": {"docs": {"lmcat": {"tf": 1.4142135623730951}}, "df": 1}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"lmcat.file_stats.TokenizerWrapper": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 1.4142135623730951}, "lmcat.processors.compress_whitespace": {"tf": 1}}, "df": 2}}}}}}}, "m": {"docs": {}, "df": 0, "]": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.processing_pipeline.ProcessingPipeline": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"lmcat": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"lmcat.lmcat.walk_dir": {"tf": 1}}, "df": 1}}}}}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}}}, "d": {"docs": {"lmcat.lmcat.LMCatConfig.read": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}}, "df": 2, "s": {"docs": {"lmcat.processors.csv_preview_5_lines": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"lmcat.file_stats.TokenizerWrapper.n_tokens": {"tf": 1}, "lmcat.lmcat.sorted_entries": {"tf": 1}, "lmcat.lmcat.assemble_summary": {"tf": 1}, "lmcat.processors.to_relative_path": {"tf": 1}}, "df": 4, "s": {"docs": {"lmcat.file_stats.FileStats.from_file": {"tf": 1}, "lmcat.lmcat.LMCatConfig.serialize": {"tf": 1}, "lmcat.lmcat.LMCatConfig.load": {"tf": 1}, "lmcat.lmcat.format_tree_with_stats": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}, "lmcat.processors.makefile_recipes": {"tf": 1}, "lmcat.processors.csv_preview_5_lines": {"tf": 1}}, "df": 8}}}}}, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.processors.register_processor": {"tf": 1}, "lmcat.processors.register_decider": {"tf": 1}}, "df": 2}}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.processors.remove_comments": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {"lmcat": {"tf": 2.23606797749979}}, "df": 1, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}, "f": {"docs": {}, "df": 0, "f": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.walk_and_collect": {"tf": 1}}, "df": 1}}}}, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"lmcat": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 1.7320508075688772}}, "df": 1, "/": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "b": {"docs": {"lmcat": {"tf": 1.4142135623730951}, "lmcat.processing_pipeline.ProcessingPipeline": {"tf": 1.7320508075688772}}, "df": 2, "s": {"docs": {"lmcat.processing_pipeline.ProcessingPipeline": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "t": {"2": {"docs": {"lmcat": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {"lmcat.file_stats.FileStats.from_file": {"tf": 1}, "lmcat.lmcat.LMCatConfig.get_tokenizer_obj": {"tf": 1}, "lmcat.lmcat.LMCatConfig.get_processing_pipeline": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 1.4142135623730951}}, "df": 4}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.lmcat.walk_and_collect": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {"lmcat": {"tf": 1}}, "df": 1, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"lmcat": {"tf": 2.6457513110645907}, "lmcat.file_stats.TreeEntry": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1}, "lmcat.lmcat.assemble_summary": {"tf": 1}}, "df": 4}}}}}, "f": {"docs": {"lmcat": {"tf": 2.23606797749979}, "lmcat.file_stats.TokenizerWrapper.n_tokens": {"tf": 1}, "lmcat.file_stats.TreeEntry.__init__": {"tf": 1}, "lmcat.lmcat.LMCatConfig.load": {"tf": 1}, "lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1}, "lmcat.lmcat.format_tree_with_stats": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.get_processors_for_path": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}, "lmcat.processors.csv_preview_5_lines": {"tf": 1.4142135623730951}}, "df": 9}, "r": {"docs": {"lmcat": {"tf": 2}, "lmcat.lmcat.LMCatConfig.read": {"tf": 1}}, "df": 2}, "n": {"docs": {"lmcat": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1}}, "df": 2, "l": {"docs": {}, "df": 0, "y": {"docs": {"lmcat": {"tf": 2.8284271247461903}, "lmcat.processors.makefile_recipes": {"tf": 1}, "lmcat.processors.csv_preview_5_lines": {"tf": 1}}, "df": 3}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"lmcat": {"tf": 1}}, "df": 1}, "a": {"docs": {}, "df": 0, "l": {"docs": {"lmcat.file_stats.TreeEntry": {"tf": 1}, "lmcat.lmcat.format_tree_with_stats": {"tf": 1}}, "df": 2, "[": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.file_stats.FileStats.from_file": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"lmcat.lmcat.LMCatConfig.get_tokenizer_obj": {"tf": 1}, "lmcat.lmcat.LMCatConfig.get_processing_pipeline": {"tf": 1}}, "df": 2}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.processors.is_over_10kb": {"tf": 1}}, "df": 1}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "w": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}, "a": {"docs": {"lmcat": {"tf": 1.7320508075688772}}, "df": 1}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "b": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 1}, "lmcat.lmcat.IgnoreHandler.is_ignored": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}}, "df": 3, "s": {"docs": {}, "df": 0, "t": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"lmcat": {"tf": 1}, "lmcat.processors.makefile_recipes": {"tf": 1}}, "df": 2}}}}, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"lmcat": {"tf": 1.4142135623730951}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lmcat.lmcat.walk_dir": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}, "y": {"docs": {"lmcat.file_stats.TokenizerWrapper": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1}, "lmcat.lmcat.LMCatConfig.serialize": {"tf": 1}, "lmcat.lmcat.LMCatConfig.load": {"tf": 1}}, "df": 4, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.processors.csv_preview_5_lines": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"lmcat.lmcat.format_tree_with_stats": {"tf": 1}}, "df": 1}}}}, "j": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lmcat": {"tf": 1.4142135623730951}, "lmcat.lmcat.LMCatConfig.read": {"tf": 1}}, "df": 2, "/": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}, "y": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {"lmcat": {"tf": 1.4142135623730951}}, "df": 1}}}, "n": {"docs": {"lmcat": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper": {"tf": 1}}, "df": 2, "o": {"docs": {"lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}}, "df": 1, "t": {"docs": {"lmcat": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1.4142135623730951}, "lmcat.processors.csv_preview_5_lines": {"tf": 1}}, "df": 3, "e": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "k": {"docs": {"lmcat": {"tf": 1}, "lmcat.processors.ipynb_to_md": {"tf": 1}}, "df": 2}}}}}}, "n": {"docs": {"lmcat": {"tf": 1}}, "df": 1, "e": {"docs": {"lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"lmcat.file_stats.TokenizerWrapper": {"tf": 1}, "lmcat.processing_pipeline.ProcessingPipeline.process_file": {"tf": 1}}, "df": 2, "s": {"docs": {"lmcat.processing_pipeline.ProcessingPipeline": {"tf": 1.7320508075688772}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lmcat.file_stats.TokenizerWrapper.n_tokens": {"tf": 1}, "lmcat.file_stats.TreeEntry.line": {"tf": 1}, "lmcat.file_stats.TreeEntry.stats": {"tf": 1}}, "df": 3}}}}}, "e": {"docs": {}, "df": 0, "w": {"docs": {"lmcat.file_stats.TreeEntry.__init__": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"lmcat": {"tf": 1.4142135623730951}}, "df": 1}}}, "e": {"docs": {"lmcat.file_stats.FileStats.from_file": {"tf": 1}, "lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1}}, "df": 2, "s": {"docs": {"lmcat": {"tf": 1}, "lmcat.file_stats.TokenizerWrapper": {"tf": 1}}, "df": 2}, "d": {"docs": {"lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lmcat": {"tf": 1}, "lmcat.lmcat.LMCatConfig.serialize": {"tf": 1}, "lmcat.lmcat.LMCatConfig.load": {"tf": 1}, "lmcat.lmcat.IgnoreHandler": {"tf": 1}}, "df": 4}}}}, "p": {"docs": {"lmcat": {"tf": 1}, "lmcat.processors.makefile_recipes": {"tf": 1}, "lmcat.processors.csv_preview_5_lines": {"tf": 1}}, "df": 3}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"lmcat": {"tf": 1}, "lmcat.lmcat.LMCatConfig.validate_fields_types": {"tf": 1}}, "df": 2}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lmcat": {"tf": 1}, "lmcat.lmcat.format_tree_with_stats": {"tf": 1.7320508075688772}}, "df": 2}}}, "y": {"docs": {"lmcat.main": {"tf": 1}, "lmcat.file_stats.TreeEntry": {"tf": 1}, "lmcat.lmcat.main": {"tf": 1}}, "df": 3}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}}}}}}, "x": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"lmcat": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lmcat.lmcat.LMCatConfig.tokenizer": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"lmcat.processors.makefile_recipes": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {"lmcat.processors.makefile_recipes": {"tf": 1}}, "df": 1}}}}, "h": {"docs": {"lmcat": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "p": {"docs": {"lmcat": {"tf": 1.7320508075688772}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"lmcat.lmcat.IgnoreHandler": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, ":": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {"lmcat": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"lmcat": {"tf": 5.477225575051661}}, "df": 1}}}}}}}, "pipeline": ["trimmer"], "_isPrebuiltIndex": true};

    // mirrored in build-search-index.js (part 1)
    // Also split on html tags. this is a cheap heuristic, but good enough.
    elasticlunr.tokenizer.setSeperator(/[\s\-.;&_'"=,()]+|<[^>]*>/);

    let searchIndex;
    if (docs._isPrebuiltIndex) {
        console.info("using precompiled search index");
        searchIndex = elasticlunr.Index.load(docs);
    } else {
        console.time("building search index");
        // mirrored in build-search-index.js (part 2)
        searchIndex = elasticlunr(function () {
            this.pipeline.remove(elasticlunr.stemmer);
            this.pipeline.remove(elasticlunr.stopWordFilter);
            this.addField("qualname");
            this.addField("fullname");
            this.addField("annotation");
            this.addField("default_value");
            this.addField("signature");
            this.addField("bases");
            this.addField("doc");
            this.setRef("fullname");
        });
        for (let doc of docs) {
            searchIndex.addDoc(doc);
        }
        console.timeEnd("building search index");
    }

    return (term) => searchIndex.search(term, {
        fields: {
            qualname: {boost: 4},
            fullname: {boost: 2},
            annotation: {boost: 2},
            default_value: {boost: 2},
            signature: {boost: 2},
            bases: {boost: 2},
            doc: {boost: 1},
        },
        expand: true
    });
})();