"""Helpers to help with encoding Open Peer Power objects in JSON."""
from datetime import datetime
import json
from typing import Any


class JSONEncoder(json.JSONEncoder):
    """JSONEncoder that supports Open Peer Power objects."""

    def default(self, o: Any) -> Any:
        """Convert Open Peer Power objects.

        Hand other objects to the original method.
        """
        if isinstance(o, datetime):
            return o.isoformat()
        if isinstance(o, set):
            return list(o)
        if hasattr(o, "as_dict"):
            return o.as_dict()

        return json.JSONEncoder.default(self, o)
