# List of Examples

* [autotune.py](autotune.py): Automate finding the best parameters for an efficient simulation.
* [harmonic_repulsive_3d.py](harmonic_repulsive_3d.py): 3D harmonic repulsive system.
* [harmonic_repulsive_two_rods.py](harmonic_repulsive_two_rods.py): Two rods with harmonic repulsive potential in 1D.
* [lammps_dump.py](lammps_dump.py): Generate a LAMMPS dump file.
* [lennard_jones.py](lennard_jones.py): Lennard-Jones simulation.
* [minimal.py](minimal.py): Minimal example of a (default) simulation
* [minimal_descriptive.py](minimal_descriptive.py): Minimal descriptive example
* [pair_potential_plot.py](pair_potential_plot.py): Plot the pair potential and force
* [progress_bar.py](progress_bar.py): Progress bar during simulation.
* [radial_distribution.py](radial_distribution.py): Calculate the radial distribution function at runtime
* [simulation_from_disk.py](simulation_from_disk.py): Load simulation data from disk.
* [simulation_to_disk.py](simulation_to_disk.py): Save simulation data to disk.
* [thermodynamic_properties.py](thermodynamic_properties.py): Evaluate thermodynamic properties
* [wahnstrom_mixture.py](wahnstrom_mixture.py): Simulation of the Wahnström mixture

