/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.parser.callbacks;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.parser.callbacks.XCallbacks;
import org.xcsp.parser.callbacks.XCallbacks2;
import org.xcsp.parser.entries.XConstraints;
import org.xcsp.parser.entries.XObjectives;
import org.xcsp.parser.entries.XVariables;

public class FeatureDisplayer
implements XCallbacks2 {
    private static final String INVALID = "invalid";
    private XCallbacks.Implem implem = new XCallbacks.Implem(this);
    private boolean competitionMode;
    private int n;
    private int e;
    private Repartitioner<Integer> sizes = new Repartitioner("size");
    private Repartitioner<Integer> degrees = new Repartitioner("degree");
    private Repartitioner<Integer> arities = new Repartitioner("arity");
    private Repartitioner<Types.TypeCtr> constraints = new Repartitioner("type");
    private XObjectives.XObj obj;

    public static void main(String[] args) throws Exception {
        boolean competitionMode = args.length > 0 && args[0].equals("-cm");
        String[] stringArray = args = competitionMode ? Arrays.copyOfRange(args, 1, args.length) : args;
        if (args.length != 1) {
            System.out.println("Usage: " + FeatureDisplayer.class.getName() + " [-cm] <instanceFilename | directoryName> ");
            System.out.println("\tcm stands for competition mode");
        } else {
            new FeatureDisplayer(competitionMode, args[0]);
        }
    }

    @Override
    public XCallbacks.Implem implem() {
        return this.implem;
    }

    private void reset() {
        this.e = 0;
        this.n = 0;
        ((Repartitioner)this.sizes).clear();
        ((Repartitioner)this.degrees).clear();
        ((Repartitioner)this.arities).clear();
        ((Repartitioner)this.constraints).clear();
        this.obj = null;
    }

    @Override
    public void loadInstance(String fileName, String ... discardedClasses) throws Exception {
        try {
            this.reset();
            XCallbacks2.super.loadInstance(fileName, discardedClasses);
            if (this.competitionMode) {
                System.out.print("nbVar=" + this.n + ",nbConstr=" + this.e + ",nbDomains=" + this.implem().cache4DomObject.size());
                System.out.print(",domainsSize='" + this.sizes + "',minDomSize=" + ((Repartitioner)this.sizes).first() + ",maxDomSize=" + ((Repartitioner)this.sizes).last());
                System.out.print(",variablesDegree='" + this.degrees + "',minDegree=" + ((Repartitioner)this.degrees).first() + ",maxDegree=" + ((Repartitioner)this.degrees).last());
                System.out.print(",constraintArities='" + this.arities + "',minConstrArity=" + ((Repartitioner)this.arities).first() + ",maxConstrArity=" + ((Repartitioner)this.arities).last());
                int nIntension = ((Repartitioner)this.constraints).repartition.getOrDefault((Object)Types.TypeCtr.intension, 0);
                int nExtension = ((Repartitioner)this.constraints).repartition.getOrDefault((Object)Types.TypeCtr.extension, 0);
                System.out.print(",globalConstraints='" + this.constraints + "',nbPredicateConstr=" + nIntension + ",nbRelationConstr=" + nExtension);
                boolean objVar = this.obj == null ? false : this.obj.type == Types.TypeObjective.EXPRESSION && ((XObjectives.OObjectiveExpr)this.obj).rootNode.getType() == Types.TypeExpr.VAR;
                System.out.print(",hasObjective=" + (this.obj != null) + (this.obj != null ? ",objectiveType='" + (this.obj.minimize ? "min" : "max") + ' ' + (objVar ? "VAR" : this.obj.type) + "'" : ""));
            }
        }
        catch (Throwable e) {
            if (e.getMessage().equals(INVALID)) {
                System.out.print("Instance with some unimplemented method(s)");
            }
            System.out.print("Unable to be (totally) parsed");
        }
        System.out.println();
    }

    private void recursiveHandling(File file) throws Exception {
        if (!file.exists()) {
            Utilities.exit("The file " + file.getName() + " does not exist (or has not been found)");
        }
        if (file.isFile()) {
            if (file.getName().endsWith(".xml") || file.getName().endsWith(".lzma")) {
                this.loadInstance(file.getAbsolutePath(), new String[0]);
            } else {
                Utilities.exit("The file " + file.getName() + " has not a proper suffix (.xml or .lzma)");
            }
        } else {
            for (File f2 : Stream.of(file.listFiles(f -> f.getName().endsWith(".xml") || f.getName().endsWith(".lzma"))).sorted().collect(Collectors.toList())) {
                this.recursiveHandling(f2);
            }
        }
    }

    public FeatureDisplayer(boolean competitionMode, String name) throws Exception {
        this.competitionMode = competitionMode;
        Utilities.control(competitionMode, "For the moment, the competition mode is the only implemented mode");
        this.implem().rawParameters();
        this.recursiveHandling(new File(name));
    }

    @Override
    public Object unimplementedCase(Object ... objects) {
        throw new RuntimeException(INVALID);
    }

    @Override
    public void buildVarInteger(XVariables.XVarInteger x, int minValue, int maxValue) {
        ((Repartitioner)this.sizes).add(Integer.valueOf(maxValue - minValue + 1));
    }

    @Override
    public void buildVarInteger(XVariables.XVarInteger x, int[] values) {
        ((Repartitioner)this.sizes).add(Integer.valueOf(values.length));
    }

    @Override
    public void buildVarSymbolic(XVariables.XVarSymbolic x, String[] values) {
        ((Repartitioner)this.sizes).add(Integer.valueOf(values.length));
    }

    @Override
    public void loadVar(XVariables.XVar v) {
        ++this.n;
        ((Repartitioner)this.degrees).add(Integer.valueOf(v.degree));
        XCallbacks2.super.loadVar(v);
    }

    @Override
    public void loadCtr(XConstraints.XCtr c) {
        ++this.e;
        ((Repartitioner)this.arities).add(Integer.valueOf(c.vars().length));
        ((Repartitioner)this.constraints).add((Comparable)((Object)c.getType()));
    }

    @Override
    public void loadObj(XObjectives.XObj o) {
        this.obj = o;
    }

    private static class Repartitioner<T extends Comparable<? super T>> {
        private static final int FULL_DISPLAY_LIMIT = 50;
        private final Map<T, Integer> repartition = new HashMap<T, Integer>();
        private List<T> sortedKeys;
        private String name;

        private Repartitioner(String name) {
            this.name = name;
        }

        private void clear() {
            this.repartition.clear();
            this.sortedKeys = null;
        }

        private void add(T value) {
            Integer nb = this.repartition.get(value);
            this.repartition.put(value, nb == null ? 1 : nb + 1);
        }

        private void freeze() {
            this.sortedKeys = new ArrayList<T>(this.repartition.keySet());
            Collections.sort(this.sortedKeys);
        }

        private T first() {
            if (this.sortedKeys == null) {
                this.freeze();
            }
            return (T)(this.sortedKeys.size() == 0 ? null : (Comparable)this.sortedKeys.get(0));
        }

        private T last() {
            if (this.sortedKeys == null) {
                this.freeze();
            }
            return (T)(this.sortedKeys.size() == 0 ? null : (Comparable)this.sortedKeys.get(this.sortedKeys.size() - 1));
        }

        private String pair(T k) {
            return "{\"" + this.name + "\":" + (k instanceof Integer ? k.toString() : "\"" + k + "\"") + ",\"count\":" + this.repartition.get(k) + "}";
        }

        public String toString() {
            if (this.sortedKeys == null) {
                this.freeze();
            }
            if (this.sortedKeys.size() <= 50) {
                return "[" + this.sortedKeys.stream().map(k -> this.pair(k)).collect(Collectors.joining(",")) + "]";
            }
            String s1 = IntStream.range(0, 25).mapToObj(i -> this.pair((Comparable)this.sortedKeys.get(i))).collect(Collectors.joining(","));
            String s2 = IntStream.range(this.sortedKeys.size() - 25, this.sortedKeys.size()).mapToObj(i -> this.pair((Comparable)this.sortedKeys.get(i))).collect(Collectors.joining(", "));
            return "[" + s1 + ",\"...\"," + s2 + "]";
        }
    }
}

