/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.common;

import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.xcsp.common.IVar;
import org.xcsp.common.Range;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.domains.Values;
import org.xcsp.common.predicates.XNodeLeaf;
import org.xcsp.parser.entries.XConstraints;

public interface Condition {
    public static final /* synthetic */ boolean $assertionsDisabled;

    public static Condition buildFrom(Object operator, Object limit) {
        if (limit instanceof XConstraints.XParameter) {
            return new ConditionPar(operator, (XConstraints.XParameter)limit);
        }
        if (operator instanceof Types.TypeConditionOperatorRel) {
            Types.TypeConditionOperatorRel op = (Types.TypeConditionOperatorRel)((Object)operator);
            return limit instanceof Number ? new ConditionVal(op, ((Number)limit).longValue()) : new ConditionVar(op, (IVar)limit);
        }
        if (operator instanceof Types.TypeConditionOperatorSet) {
            Types.TypeConditionOperatorSet op = (Types.TypeConditionOperatorSet)((Object)operator);
            return limit instanceof Range ? new ConditionIntvl(op, (Range)limit) : new ConditionIntset(op, (int[])limit);
        }
        Utilities.control(operator instanceof Types.TypeConditionOperator, " Bad Argument");
        Types.TypeConditionOperator op = (Types.TypeConditionOperator)((Object)operator);
        if (limit instanceof Long) {
            return new ConditionVal(op.toRel(), (Long)limit);
        }
        if (limit instanceof IVar) {
            return new ConditionVar(op.toRel(), (IVar)limit);
        }
        if (limit instanceof XNodeLeaf && ((XNodeLeaf)limit).type == Types.TypeExpr.VAR) {
            return new ConditionVar(op.toRel(), (IVar)((XNodeLeaf)limit).value);
        }
        if (limit instanceof Values.IntegerInterval) {
            return new ConditionIntvl(op.toSet(), ((Values.IntegerInterval)limit).inf, ((Values.IntegerInterval)limit).sup);
        }
        assert (limit instanceof long[]);
        return new ConditionIntset(op.toSet(), LongStream.of((long[])limit).mapToInt(l -> Utilities.safeLong2Int(l, true)).toArray());
    }

    default public IVar involvedVar() {
        return null;
    }

    public static class ConditionIntset
    extends ConditionSet {
        public int[] t;

        public ConditionIntset(Types.TypeConditionOperatorSet operator, int[] t) {
            super(operator);
            t = IntStream.of(t).sorted().distinct().toArray();
            Utilities.control(t.length > 0, "The sepcified array is not valid.");
            this.t = t;
        }

        public String toString() {
            return "(" + this.operator.name().toLowerCase() + ",{" + Utilities.join(this.t, ",") + "})";
        }
    }

    public static class ConditionIntvl
    extends ConditionSet {
        public long min;
        public long max;

        public ConditionIntvl(Types.TypeConditionOperatorSet operator, long min, long max) {
            super(operator);
            Utilities.control(min <= max, "The sepcified bouds are not valid.");
            this.min = min;
            this.max = max;
        }

        public ConditionIntvl(Types.TypeConditionOperatorSet operator, Range range) {
            this(operator, range.startInclusive, range.endExclusive - 1);
            Utilities.control(range.step == 1, "Specified ranges must have a step equal to 1");
        }

        public String toString() {
            return "(" + this.operator.name().toLowerCase() + "," + this.min + ".." + this.max + ")";
        }
    }

    public static class ConditionPar
    implements Condition {
        public Object operator;
        public XConstraints.XParameter par;

        public ConditionPar(Object operator, XConstraints.XParameter par) {
            this.operator = operator;
            this.par = par;
        }

        public Condition concretizeWith(Object limit) {
            return Condition.buildFrom(this.operator, limit);
        }
    }

    public static abstract class ConditionRel
    implements Condition {
        public Types.TypeConditionOperatorRel operator;

        public ConditionRel(Types.TypeConditionOperatorRel operator) {
            this.operator = operator;
        }
    }

    public static abstract class ConditionSet
    implements Condition {
        public Types.TypeConditionOperatorSet operator;

        public ConditionSet(Types.TypeConditionOperatorSet operator) {
            this.operator = operator;
        }
    }

    public static class ConditionVal
    extends ConditionRel {
        public long k;

        public ConditionVal(Types.TypeConditionOperatorRel operator, long k) {
            super(operator);
            this.k = k;
        }

        public String toString() {
            return "(" + this.operator.name().toLowerCase() + "," + this.k + ")";
        }
    }

    public static class ConditionVar
    extends ConditionRel {
        public IVar x;

        public ConditionVar(Types.TypeConditionOperatorRel operator, IVar x) {
            super(operator);
            this.x = x;
        }

        @Override
        public IVar involvedVar() {
            return this.x;
        }

        public String toString() {
            return "(" + this.operator.name().toLowerCase() + "," + this.x + ")";
        }
    }
}

