/*
 * Decompiled with CFR 0.152.
 */
package variables;

import constraints.Constraint;
import heuristics.values.HeuristicValues;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Utilities;
import org.xcsp.modeler.entities.VarEntities;
import problem.Problem;
import utility.Enums;
import utility.Kit;
import utility.Reflector;
import utility.observers.ObserverBacktrackingUnsystematic;
import variables.domains.Domain;
import variables.domains.DomainInteger;

public abstract class Variable
implements IVar,
ObserverBacktrackingUnsystematic,
Comparable<Variable> {
    public static final int UNSET_NUM = -2;
    private static final int UNASSIGNED = -1;
    private static final int NB_VARIABLES_LIMIT_FOR_STORING_NEIGHBOURS = 5000;
    private static final int NB_NEIGHBOURS_LIMIT_FOR_STRORING_NEIGHBOURS = 300;
    public static final Variable[] EMPTY_ARRAY = new Variable[0];
    public static final Variable TAG = new Variable(null, null){};
    public static final Comparator<Variable> decreasingDomSizeComparator = (x, y) -> Integer.compare(y.dom.size(), x.dom.size());
    public static final Comparator<Variable> decreasingStaticDegComparator = (x, y) -> Integer.compare(y.staticDegree(), x.staticDegree());
    public final Problem pb;
    public Domain dom;
    public int num = -2;
    private String id;
    private int assignmentLevel = -1;
    public final Collection<Constraint> collectedCtrs = new LinkedList<Constraint>();
    public Constraint[] ctrs;
    protected Variable[] nghs;
    public HeuristicValues heuristicVal;
    public boolean decision = true;
    public long timestamp;
    public Object data;
    public double wdeg;

    @Override
    public void restoreAtDepthBefore(int depthBeforeBacktrack) {
        this.dom.restoreBefore(depthBeforeBacktrack);
    }

    @Override
    public int lastModificationDepth() {
        return this.dom.lastRemovedLevel();
    }

    @Override
    public int compareTo(Variable x) {
        return this.num == -2 && x.num == -2 ? Integer.parseInt(this.id.substring(1)) - Integer.parseInt(x.id.substring(1)) : this.num - x.num;
    }

    public static final boolean areNumsIncreasing(Variable ... vars) {
        return IntStream.range(0, vars.length - 1).allMatch(i -> vars[i].num < vars[i + 1].num);
    }

    public static final boolean areAllFixed(Variable ... vars) {
        return Stream.of(vars).allMatch(x -> x.dom.size() == 1);
    }

    public static final boolean areAllDistinct(Variable ... vars) {
        return IntStream.range(0, vars.length).noneMatch(i -> IntStream.range(i + 1, vars.length).anyMatch(j -> vars[i] == vars[j]));
    }

    public static final boolean areInitiallyBoolean(Variable ... vars) {
        return Stream.of(vars).allMatch(x -> x.dom.initSize() == 2 && x.dom.toIdx(0) == 0 && x.dom.toIdx(1) == 1);
    }

    public static final boolean haveSameDomainType(Variable ... vars) {
        return IntStream.range(0, vars.length - 1).allMatch(i -> vars[i].dom.typeIdentifier() == vars[i + 1].dom.typeIdentifier());
    }

    public static final Variable firstDifferentVariableIn(Variable[] vars, Variable x) {
        for (Variable y : vars) {
            if (y == x) continue;
            return y;
        }
        return null;
    }

    public static final Variable firstWipeoutVariableIn(Variable ... vars) {
        for (Variable x : vars) {
            if (x.dom.size() != 0) continue;
            return x;
        }
        return null;
    }

    public static final int maxInitDomSize(Variable ... vars) {
        return Stream.of(vars).mapToInt(x -> x.dom.initSize()).max().getAsInt();
    }

    public static boolean isValidTuple(Variable[] vars, int[] tuple, boolean indexes) {
        assert (vars.length == tuple.length);
        return IntStream.range(0, vars.length).allMatch(i -> tuple[i] == 0x7FFFFFFE || (indexes ? vars[i].dom.isPresent(tuple[i]) : vars[i].dom.isPresentValue(tuple[i])));
    }

    public static boolean isValidTuple(Variable[] vars, String[] tuple) {
        assert (vars.length == tuple.length);
        return IntStream.range(0, vars.length).allMatch(i -> ((DomainInteger.DomainSymbols)vars[i].dom).toIdx(tuple[i]) != -1);
    }

    public static int[][] filterTuples(Variable[] vars, int[][] tuples, boolean indexes) {
        return (int[][])Stream.of(tuples).filter(t -> Variable.isValidTuple(vars, t, indexes)).toArray(x$0 -> new int[x$0][]);
    }

    public static String[][] filterTuples(Variable[] vars, String[][] tuples) {
        return (String[][])Stream.of(tuples).filter(t -> Variable.isValidTuple(vars, t)).toArray(x$0 -> new String[x$0][]);
    }

    public static int[] filterValues(Variable x, int[] values, boolean indexes) {
        return IntStream.of(values).filter(v -> indexes ? x.dom.isPresent(v) : x.dom.isPresentValue(v)).toArray();
    }

    public static String[] filterValues(Variable x, String[] values) {
        return (String[])Stream.of(values).filter(v -> ((DomainInteger.DomainSymbols)x.dom).toIdx((String)v) != -1).toArray(String[]::new);
    }

    public static final Set<Integer> setOfvaluesIn(Variable ... vars) {
        HashSet<Integer> set = new HashSet<Integer>();
        for (Variable x : vars) {
            x.dom.execute(a -> set.add(x.dom.toVal((int)a)));
        }
        return set;
    }

    public static final int nInitValuesFor(Variable ... vars) {
        long l = Stream.of(vars).mapToLong(x -> x.dom.initSize()).sum();
        Kit.control(0L < l && l <= Integer.MAX_VALUE);
        return (int)l;
    }

    public static int nValidValuesFor(Variable ... vars) {
        long l = Stream.of(vars).mapToLong(x -> x.dom.size()).sum();
        Utilities.control((0L < l && l <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)("l= " + l));
        return (int)l;
    }

    public static final int nRemovedValuesFor(Variable ... vars) {
        return Stream.of(vars).mapToInt(x -> x.dom.nRemoved()).sum();
    }

    private static final long nTuplesFor(Variable[] vars, int ignoredVap, boolean initiSize) {
        long l = 1L;
        assert (Variable.firstWipeoutVariableIn(vars) == null) : Variable.firstWipeoutVariableIn(vars);
        for (int i = 0; i < vars.length; ++i) {
            int size;
            if (i == ignoredVap) continue;
            int n = size = initiSize ? vars[i].dom.initSize() : vars[i].dom.size();
            if (l > Long.MAX_VALUE / (long)size) {
                return -1L;
            }
            l *= (long)size;
        }
        return l;
    }

    public static final BigInteger nValidTuples(Variable[] vars, boolean initSize) {
        BigInteger prod = BigInteger.ONE;
        for (Variable x : vars) {
            prod = prod.multiply(BigInteger.valueOf(initSize ? (long)x.dom.initSize() : (long)x.dom.size()));
        }
        return prod;
    }

    public static final long nValidTuplesBoundedAtMaxValueFor(Variable ... vars) {
        long l = Variable.nTuplesFor(vars, -1, false);
        return l == -1L ? Long.MAX_VALUE : l;
    }

    public static final long nValidTuplesBoundedAtMaxValueFor(Variable[] vars, int ignoredVariablePosition) {
        long l = Variable.nTuplesFor(vars, ignoredVariablePosition, false);
        return l == -1L ? Long.MAX_VALUE : l;
    }

    public static final int[] buildCumulatedSizesArray(Variable[] vars, boolean initSize) {
        int[] sizes = new int[vars.length];
        for (int i = 1; i < sizes.length; ++i) {
            sizes[i] = sizes[i - 1] + (initSize ? vars[i - 1].dom.initSize() : vars[i - 1].dom.size());
        }
        return sizes;
    }

    public static Litterals litterals(Variable[] vars) {
        return new Litterals(vars);
    }

    public static int[][] initDomainValues(Variable[] vars) {
        return (int[][])Stream.of(vars).map(x -> IntStream.range(0, x.dom.initSize()).map(a -> x.dom.toVal(a)).toArray()).toArray(x$0 -> new int[x$0][]);
    }

    public static int[][] currDomainValues(Variable[] vars) {
        return (int[][])Stream.of(vars).map(x -> IntStream.range(0, x.dom.initSize()).filter(a -> x.dom.isPresent(a)).map(a -> x.dom.toVal(a)).toArray()).toArray(x$0 -> new int[x$0][]);
    }

    public static final boolean areSimilarArrays(Variable[] vars1, Variable ... vars2) {
        return vars1.length == vars2.length && Stream.of(vars1).noneMatch(x -> Stream.of(vars2).noneMatch(y -> x == y));
    }

    public static final boolean contains(Variable[] vars1, Variable ... vars2) {
        assert (Variable.areNumsIncreasing(vars1) && Variable.areNumsIncreasing(vars2));
        int i = 0;
        for (int j = 0; j < vars2.length; ++j) {
            while (i < vars1.length && vars1[i].num < vars2[j].num) {
                ++i;
            }
            if (i != vars1.length && vars1[i].num == vars2[j].num) continue;
            return false;
        }
        return true;
    }

    public static final boolean isPermutationElligible(Variable ... vars) {
        return vars[0].pb.rs.cp.constraints.recognizePermutations && vars[0].dom.initSize() == vars.length && Variable.haveSameDomainType(vars);
    }

    public static final int[] domSizeArrayOf(Variable[] vars, boolean initSize) {
        return Stream.of(vars).mapToInt(x -> initSize ? x.dom.initSize() : x.dom.size()).toArray();
    }

    public static final Domain[] buildDomainsArrayFor(Variable ... vars) {
        return (Domain[])Stream.of(vars).map(x -> x.dom).toArray(Domain[]::new);
    }

    public static final StringBuilder signatureFor(Variable ... vars) {
        StringBuilder sb = new StringBuilder();
        for (Variable x : vars) {
            sb.append(x.dom.typeName()).append(' ');
        }
        return sb;
    }

    public static final String joinNames(Variable[] vars, String glue) {
        return Stream.of(vars).map(x -> x.id()).collect(Collectors.joining(glue));
    }

    public static final boolean areNumsNormalized(Variable ... vars) {
        return IntStream.range(0, vars.length).allMatch(i -> i == vars[i].num);
    }

    public static final boolean areAllDomainsContainingValue(Variable[] vars, int val) {
        return Stream.of(vars).allMatch(x -> x.dom.isPresentValue(val));
    }

    public static final boolean areDomainsFull(Variable ... vars) {
        return Stream.of(vars).allMatch(x -> x.dom.nRemoved() == 0);
    }

    public static final boolean areSortedDomainsIn(Variable ... vars) {
        return Stream.of(vars).allMatch(x -> IntStream.range(0, x.dom.initSize() - 1).allMatch(i -> x.dom.toVal(i) < x.dom.toVal(i + 1)));
    }

    public static final boolean isInducedBy(Variable x, boolean[] presentConstraints) {
        for (Constraint c : x.ctrs) {
            if (!presentConstraints[c.num]) continue;
            return true;
        }
        return false;
    }

    public static String instantiationOf(Object obj, String prefix) {
        if (obj == null) {
            return "*";
        }
        if (obj instanceof Variable) {
            return ((Variable)obj).dom.prettyValueOf(((Variable)obj).dom.unique()).toString();
        }
        assert (obj.getClass().isArray());
        if (obj instanceof Variable[]) {
            assert (Stream.of((Variable[])obj).noneMatch(x -> x != null && x.dom.size() != 1));
            return "[" + Stream.of((Variable[])obj).map(x -> Variable.instantiationOf(x, prefix)).collect(Collectors.joining(", ")) + "]";
        }
        return "[\n" + prefix + " " + Stream.of((Object[])obj).map(o -> Variable.instantiationOf(o, prefix)).collect(Collectors.joining(",\n" + prefix + " ")) + "]";
    }

    public static String rawInstantiationOf(Object array, String prefix) {
        if (array instanceof Variable[]) {
            assert (Stream.of((Variable[])array).noneMatch(x -> x != null && x.dom.size() != 1));
            return Stream.of((Variable[])array).map(x -> Variable.instantiationOf(x, prefix)).collect(Collectors.joining(" "));
        }
        return Stream.of((Object[])array).map(o -> Variable.rawInstantiationOf(o, prefix)).collect(Collectors.joining(" "));
    }

    private Variable[] computeNeighbours(int neighborArityLimit) {
        if (this.ctrs.length == 0 || this.ctrs[this.ctrs.length - 1].scp.length > neighborArityLimit) {
            return null;
        }
        TreeSet<Variable> set = new TreeSet<Variable>();
        for (Constraint c : this.ctrs) {
            for (Variable x : c.scp) {
                if (x == this) continue;
                set.add(x);
                if (set.size() <= neighborArityLimit) continue;
                return null;
            }
        }
        return set.toArray(new Variable[set.size()]);
    }

    public final void whenFinishedProblemConstruction() {
        this.ctrs = (Constraint[])this.collectedCtrs.stream().sorted((c1, c2) -> c1.scp.length - c2.scp.length).toArray(Constraint[]::new);
        this.nghs = this.pb.variables.length > 5000 ? null : this.computeNeighbours(300);
        this.resetWdeg();
    }

    public Variable(Problem pb, String id) {
        this.pb = pb;
        this.id = id;
        Kit.control(id == null == (pb == null));
    }

    public void reset(boolean preserveWeightedDegrees) {
        Kit.control(this.isFuture());
        Kit.control(this.dom.controlStructures());
        if (!preserveWeightedDegrees) {
            this.resetWdeg();
        }
        this.timestamp = 0L;
    }

    public void reset() {
        this.reset(false);
    }

    public final String defaultId() {
        return "V" + this.num;
    }

    public final String id() {
        return this.id;
    }

    public final String getId(boolean defaultId) {
        return defaultId ? this.defaultId() : this.id();
    }

    public final void setId(String id) {
        this.id = id;
        VarEntities.VarAlone va = (VarEntities.VarAlone)this.pb.varEntities.varToVarAlone.get(this);
        if (va != null) {
            va.id = id;
        }
    }

    public final int assignmentLevel() {
        return this.assignmentLevel;
    }

    public final boolean isAssigned() {
        return this.assignmentLevel >= 0;
    }

    public final boolean isFuture() {
        return this.assignmentLevel == -1;
    }

    public final void resetWdeg() {
        this.wdeg = this.pb.rs.cp.varh.weighting == Enums.EWeighting.CA_CD ? 0.0 : (double)this.ctrs.length;
    }

    public final void buildValueOrderingHeuristic() {
        if (this.heuristicVal == null) {
            this.heuristicVal = Reflector.buildObject(this.pb.rs.cp.valh.classForValHeuristic, HeuristicValues.class, this, this.pb.rs.cp.valh.anti);
        }
    }

    public final Constraint firstBinaryConstraintWith(Variable x) {
        assert (this != x);
        for (Constraint c : this.ctrs) {
            if (c.scp.length != 2 || !c.involves(x)) continue;
            return c;
        }
        return null;
    }

    public final Variable[] getNeighbours() {
        return this.nghs;
    }

    public final boolean isNeighbourOf(Variable x) {
        if (this.nghs != null) {
            return Arrays.binarySearch(this.nghs, x) >= 0;
        }
        if (this.ctrs.length > x.ctrs.length) {
            return x.isNeighbourOf(this);
        }
        for (Constraint c : this.ctrs) {
            if (!c.involves(x)) continue;
            return true;
        }
        return false;
    }

    public final void doAssignment(int a) {
        assert (this.isFuture() && this.dom.isPresent(a));
        this.dom.reduceToElementary(a);
        this.assignmentLevel = this.pb.solver.depth();
        for (Constraint c : this.ctrs) {
            c.doPastVariable(this);
        }
    }

    public final void undoAssignment() {
        for (Constraint c : this.ctrs) {
            c.undoPastVariable(this);
        }
        this.assignmentLevel = -1;
    }

    public final int staticDegree() {
        return this.ctrs.length;
    }

    public final int ddeg() {
        int cnt = 0;
        for (Constraint c : this.ctrs) {
            if (c.futvars.size() < 2) continue;
            ++cnt;
        }
        return cnt;
    }

    public final double ddegOnDom() {
        return (double)this.ddeg() / (double)this.dom.size();
    }

    public final double wdegOnDom() {
        return this.wdeg / (double)this.dom.size();
    }

    public final String toString() {
        return this.id();
    }

    public final void display(boolean exhaustively) {
        Kit.log.finer("Variable " + this + " with num=" + this.num + ", degree=" + this.ctrs.length + ", " + this.dom.size() + " values {" + this.dom.stringListOfValues() + "} and domain type " + this.dom.typeName() + " " + (this.isAssigned() ? " is assigned" : ""));
        if (exhaustively) {
            this.dom.display(exhaustively);
            Kit.log.finer("  ctrs = {" + Kit.join((Object)this.ctrs, new String[0]) + "}\n  nghs = {" + Kit.join((Object)(this.nghs != null ? this.nghs : this.computeNeighbours(Integer.MAX_VALUE)), new String[0]) + "}\n");
        }
    }

    public static class VarVal {
        public Variable x;
        public int a;

        public VarVal(Variable x, int a) {
            this.x = x;
            this.a = a;
        }
    }

    public static class Litterals {
        private Variable[] vars;
        private boolean initSize = true;

        private Litterals(Variable[] vars) {
            this.vars = vars;
        }

        public boolean[][] booleanArray() {
            return (boolean[][])Stream.of(this.vars).map(x -> new boolean[this.initSize ? x.dom.initSize() : x.dom.size()]).toArray((int x$0) -> new boolean[x$0][]);
        }

        public short[][] shortArray() {
            return (short[][])Stream.of(this.vars).map(x -> new short[this.initSize ? x.dom.initSize() : x.dom.size()]).toArray((int x$0) -> new short[x$0][]);
        }

        public int[][] intArray() {
            return (int[][])Stream.of(this.vars).map(x -> new int[this.initSize ? x.dom.initSize() : x.dom.size()]).toArray((int x$0) -> new int[x$0][]);
        }

        public int[][] intArray(int value) {
            return (int[][])Stream.of(this.vars).map(x -> Kit.repeat(value, this.initSize ? x.dom.initSize() : x.dom.size())).toArray((int x$0) -> new int[x$0][]);
        }

        public long[][] longArray() {
            return (long[][])Stream.of(this.vars).map(x -> new long[this.initSize ? x.dom.initSize() : x.dom.size()]).toArray((int x$0) -> new long[x$0][]);
        }

        public long[][][] longArray(int thirdDimensionSize) {
            return (long[][][])Stream.of(this.vars).map(x -> new long[this.initSize ? x.dom.initSize() : x.dom.size()][thirdDimensionSize]).toArray((int x$0) -> new long[x$0][][]);
        }

        public <E> List<E>[][] listArray() {
            return (List[][])Stream.of(this.vars).map(x -> (List[])IntStream.range(0, this.initSize ? x.dom.initSize() : x.dom.size()).mapToObj(i -> new ArrayList()).toArray(List[]::new)).toArray((int x$0) -> new List[x$0][]);
        }

        public <T> T[][] toArray(Class<T> clazz) {
            Object[][] a = Utilities.buildArray(clazz, (int)this.vars.length, (int)0);
            for (int i = 0; i < this.vars.length; ++i) {
                a[i] = Utilities.buildArray(clazz, (int)(this.initSize ? this.vars[i].dom.initSize() : this.vars[i].dom.size()));
            }
            return a;
        }
    }
}

