/*
 * Decompiled with CFR 0.152.
 */
package utility.sets;

import utility.Kit;

public final class SetSparseByte {
    public byte[] dense;
    public byte[] sparse;
    public byte limit;

    public SetSparseByte(int capacity, boolean initiallyFull) {
        Kit.control(0 < capacity && capacity <= 127);
        this.dense = Kit.range((byte)capacity);
        this.sparse = Kit.range((byte)capacity);
        this.limit = (byte)(initiallyFull ? this.dense.length - 1 : -1);
    }

    public boolean isPresent(byte e) {
        return this.sparse[e] <= this.limit;
    }

    public boolean add(byte e) {
        byte i = this.sparse[e];
        if (i <= this.limit) {
            return false;
        }
        this.limit = (byte)(this.limit + 1);
        if (i > this.limit) {
            byte f;
            this.dense[i] = f = this.dense[this.limit];
            this.dense[this.limit] = e;
            this.sparse[e] = this.limit;
            this.sparse[f] = i;
        }
        return true;
    }

    public boolean remove(byte e) {
        byte i = this.sparse[e];
        if (i > this.limit) {
            return false;
        }
        if (i != this.limit) {
            byte f;
            this.dense[i] = f = this.dense[this.limit];
            this.dense[this.limit] = e;
            this.sparse[e] = this.limit;
            this.sparse[f] = i;
        }
        this.limit = (byte)(this.limit - 1);
        return true;
    }
}

