/*
 * Decompiled with CFR 0.152.
 */
package utility.operations;

import java.util.stream.IntStream;
import utility.Kit;

public class Base {
    public static long decimalValueFor(int[] number, int base) {
        assert (IntStream.of(number).noneMatch(v -> v >= base));
        double decimalValue = number[0];
        for (int i = 1; i < number.length; ++i) {
            decimalValue = decimalValue * (double)base + (double)number[i];
        }
        assert (decimalValue <= 9.223372036854776E18) : "The decimal value = " + decimalValue + "is too big to be represented by a long integer";
        return (long)decimalValue;
    }

    public static long decimalValueFor(int[] number, int[] bases) {
        assert (number.length == bases.length && IntStream.range(0, number.length).noneMatch(i -> number[i] >= bases[i]));
        double decimalValue = number[0];
        for (int i2 = 1; i2 < number.length; ++i2) {
            decimalValue = decimalValue * (double)bases[i2] + (double)number[i2];
        }
        assert (decimalValue <= 9.223372036854776E18) : "The decimal value = " + decimalValue + "is too big to be represented by a long integer";
        return (long)decimalValue;
    }

    public static int[] baseValueFor(long decimalValue, int length, int base) {
        int[] value = new int[length];
        for (int i = value.length - 1; i >= 0; --i) {
            value[i] = (int)(decimalValue % (long)base);
            decimalValue /= (long)base;
        }
        assert (decimalValue == 0L) : "The given array is too small to contain all the digits of the conversion";
        return value;
    }

    public static int[] valueFor(long decimalValue, int[] value, int[] bases) {
        for (int i = value.length - 1; i >= 0; --i) {
            value[i] = (int)(decimalValue % (long)bases[i]);
            decimalValue /= (long)bases[i];
        }
        Kit.control(decimalValue == 0L, () -> "The given array is too small to contain all the digits of the conversion");
        return value;
    }
}

