/*
 * Decompiled with CFR 0.152.
 */
package utility;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import utility.Kit;
import utility.exceptions.UnreachableCodeException;
import utility.interfaces.TagExperimental;

public class Reflector {
    public static final char JAR_SEPARATOR_CHAR = '/';
    private static final Map<String, String> mapOfClassNames = Collections.synchronizedMap(new HashMap());

    private static String absoluteClassNameOf(File classFile, String basicPackageName) {
        String s = Kit.replaceAll(classFile.getAbsolutePath(), File.separatorChar, '.');
        int firstIndex = s.indexOf(basicPackageName);
        assert (firstIndex != -1);
        int lastIndex = s.lastIndexOf(".");
        return s.substring(firstIndex, lastIndex);
    }

    public static String findFieldName(Object parentObject, Object fieldObject) {
        for (Field field : parentObject.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                if (field.get(parentObject) != fieldObject) continue;
                return field.getName();
            }
            catch (Exception e) {
                throw new UnreachableCodeException();
            }
        }
        return null;
    }

    private static void updateListIfSubclassing(List<Class<?>> list, Class<?> rootClass, String absoluteClassName, int requiredModifiers, int forbiddenModifiers) {
        try {
            Class<?> c = Class.forName(absoluteClassName);
            if ((c.getModifiers() & requiredModifiers) == requiredModifiers && (c.getModifiers() & forbiddenModifiers) == 0 && rootClass.isAssignableFrom(c) && !TagExperimental.class.isAssignableFrom(c)) {
                list.add(c);
            }
        }
        catch (ClassNotFoundException e) {
            (e.getCause() == null ? e : e.getCause()).printStackTrace();
        }
    }

    public static List<Class<?>> searchClassesInheritingFromIn(Class<?> rootClass, File directory, int requiredModifiers, int forbiddenModifiers) {
        assert (directory.isDirectory());
        ArrayList list = new ArrayList();
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                list.addAll(Reflector.searchClassesInheritingFromIn(rootClass, file, requiredModifiers, forbiddenModifiers));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            Reflector.updateListIfSubclassing(list, rootClass, Reflector.absoluteClassNameOf(file, rootClass.getPackage().getName()), requiredModifiers, forbiddenModifiers);
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<Class<?>> searchClassesInheretingFromInJar(Class<?> rootClass, String jarName, int requiredModifiers, int forbiddenModifiers) {
        ArrayList list = new ArrayList();
        try (JarFile jf = new JarFile(jarName);){
            Enumeration<JarEntry> enumeration = jf.entries();
            if (enumeration == null) {
                ArrayList arrayList = list;
                return arrayList;
            }
            while (enumeration.hasMoreElements()) {
                String name = enumeration.nextElement().getName();
                String packTmp = Kit.replaceAll(rootClass.getPackage().getName(), '.', '/');
                if (!name.endsWith(".class") || !name.startsWith(packTmp)) continue;
                name = Kit.replaceAll(name.substring(0, name.lastIndexOf(".")), '/', '.');
                Reflector.updateListIfSubclassing(list, rootClass, name, requiredModifiers, forbiddenModifiers);
            }
            return list;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static File getDirectoryOf(String classPathToken, String basicDirectory) {
        return new File(classPathToken + (classPathToken.endsWith(File.separator) ? "" : File.separator) + Kit.replaceAll(basicDirectory, '.', File.separatorChar));
    }

    public static Class<?>[] searchClassesInheritingFrom(Class<?> rootClass, int requiredModifiers, int forbiddenModifiers) {
        ArrayList classes = new ArrayList();
        StringTokenizer st = new StringTokenizer(System.getProperty("java.class.path", "."), File.pathSeparator);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.endsWith(".jar")) {
                classes.addAll(Reflector.searchClassesInheretingFromInJar(rootClass, token, requiredModifiers, forbiddenModifiers));
                continue;
            }
            File file = Reflector.getDirectoryOf(token, rootClass.getPackage().getName());
            if (!file.exists() || !file.isDirectory()) continue;
            classes.addAll(Reflector.searchClassesInheritingFromIn(rootClass, file, requiredModifiers, forbiddenModifiers));
        }
        return classes.toArray(new Class[classes.size()]);
    }

    public static Class<?>[] searchClassesInheritingFrom(Class<?> rootClass) {
        return Reflector.searchClassesInheritingFrom(rootClass, 1, 1024);
    }

    public static String searchClassInDirectory(File dir, String name) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                String path = Reflector.searchClassInDirectory(f, name);
                if (path == null) continue;
                return path;
            }
            if (!f.getName().equals(name)) continue;
            return f.getPath();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String searchClassInJar(String jarName, String basicDirectory, String className) {
        try (JarFile jf = new JarFile(jarName);){
            String name;
            Enumeration<JarEntry> enumeration = jf.entries();
            if (enumeration == null) {
                String string = null;
                return string;
            }
            do {
                if (!enumeration.hasMoreElements()) return null;
            } while (!(name = enumeration.nextElement().getName()).startsWith(basicDirectory) || !name.substring(name.lastIndexOf(47) + 1).equals(className));
            String string = Kit.replaceAll(name.substring(0, name.lastIndexOf(".")), '/', '.');
            return string;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String searchAbsoluteNameOf(String basicPackage, String className) {
        StringTokenizer st = new StringTokenizer(System.getProperty("java.class.path", "."), File.pathSeparator);
        while (st.hasMoreTokens()) {
            String path;
            String classPathToken = st.nextToken();
            if (classPathToken.endsWith(".jar")) {
                String basicDirectory = Kit.replaceAll(basicPackage, '.', '/');
                path = Reflector.searchClassInJar(classPathToken, basicDirectory, className + ".class");
                if (path == null) continue;
                return path;
            }
            File f = Reflector.getDirectoryOf(classPathToken, basicPackage);
            if (!f.exists() || !f.isDirectory() || (path = Reflector.searchClassInDirectory(f, className + ".class")) == null) continue;
            path = path.substring(classPathToken.length() + (classPathToken.endsWith(File.separator) ? 0 : 1), path.lastIndexOf("."));
            return Kit.replaceAll(path, File.separatorChar, '.');
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String computeAbsoluteClassName(String className, Class<?> rootClass) {
        String classPackageName = rootClass.getPackage().getName();
        int i = rootClass.getName().lastIndexOf(36);
        if (i != -1) {
            className = rootClass.getName().substring(classPackageName.length() + 1, i + 1) + className;
        }
        String key = classPackageName + className;
        String absoluteClassName = null;
        Map<String, String> map = mapOfClassNames;
        synchronized (map) {
            absoluteClassName = mapOfClassNames.get(key);
            if (absoluteClassName == null) {
                absoluteClassName = Reflector.searchAbsoluteNameOf(classPackageName, className);
                if (absoluteClassName == null) {
                    absoluteClassName = className;
                }
                mapOfClassNames.put(key, absoluteClassName);
            }
        }
        return absoluteClassName;
    }

    public static <T> T buildObject(String className, Class<T> rootClass, Object ... parameters) {
        try {
            Class<?> cn = Class.forName(Reflector.computeAbsoluteClassName(className, rootClass));
            Class<?> rcn = Class.forName(rootClass.getName());
            Kit.control(rcn.isAssignableFrom(cn), () -> className + " does not extend " + rootClass.getName());
            Kit.control(!Modifier.isAbstract(cn.getModifiers()), () -> className + " is abstract");
            for (Constructor<?> constructor : cn.getConstructors()) {
                if (constructor.getGenericParameterTypes().length != parameters.length) continue;
                return (T)constructor.newInstance(parameters);
            }
            return null;
        }
        catch (Exception e) {
            (e.getCause() == null ? e : e.getCause()).printStackTrace();
            return null;
        }
    }

    public static <T> T buildObject(String className, Object ... parameters) {
        try {
            Class<?> cn = Class.forName(className);
            Kit.control(!Modifier.isAbstract(cn.getModifiers()), () -> className + " is abstract");
            for (Constructor<?> constructor : cn.getConstructors()) {
                if (constructor.getGenericParameterTypes().length != parameters.length) continue;
                return (T)constructor.newInstance(parameters);
            }
            return null;
        }
        catch (Exception e) {
            (e.getCause() == null ? e : e.getCause()).printStackTrace();
            return null;
        }
    }

    public static Object buildObject(String className) throws Exception {
        Constructor<?> c = Class.forName(className).getDeclaredConstructors()[0];
        c.setAccessible(true);
        return c.newInstance(new Object[0]);
    }

    public static Class<?> getLastButOneSuperclassOf(Class<?> clazz) {
        for (Class<?> superclass = clazz.getSuperclass(); superclass != Object.class; superclass = superclass.getSuperclass()) {
            clazz = superclass;
        }
        return clazz;
    }

    public static <T> T buildObject2(String className, Set<Class<?>> classes, Object ... parameters) {
        try {
            Class clazz = classes.stream().filter(c -> c.getName().endsWith(className)).findFirst().orElse(null);
            Kit.control(clazz != null, () -> "It was impossible to load " + className);
            Constructor cstr = Stream.of(clazz.getConstructors()).filter(c -> c.getGenericParameterTypes().length == parameters.length).findFirst().orElse(null);
            Kit.control(cstr != null, () -> "It was impossible to find the appropriate constructor for " + className);
            return cstr.newInstance(parameters);
        }
        catch (Exception e) {
            (e.getCause() == null ? e : e.getCause()).printStackTrace();
            return null;
        }
    }
}

