/*
 * Decompiled with CFR 0.152.
 */
package utility;

import dashboard.Arguments;
import executables.Resolution;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.xcsp.common.Utilities;

public final class Kit {
    public static Logger log = Logger.getLogger("Logger AbsCon");
    public static final Comparator<byte[]> lexComparatorByte;
    public static final Comparator<short[]> lexComparatorShort;
    public static final Comparator<long[]> lexComparatorLong;
    public static final Comparator<int[]> lexComparatorGeneral;

    private Kit() {
    }

    public static boolean[] toPrimitive(Stream<Boolean> stream) {
        Boolean[] t1 = (Boolean[])stream.toArray(Boolean[]::new);
        boolean[] t2 = new boolean[t1.length];
        IntStream.range(0, t2.length).forEach(i -> {
            t2[i] = t1[i];
        });
        return t2;
    }

    public static String dateOf(Class<?> clazz) {
        try {
            File f = new File(clazz.getResource(clazz.getSimpleName() + ".class").toURI());
            return new SimpleDateFormat("(dd MMM yyyy 'at' HH:mm)").format(f.lastModified()).toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static int getPositionOfLastDigitAtHeadOf(String s) {
        return IntStream.range(0, s.length()).filter(i -> !Character.isDigit(s.charAt(i))).findFirst().orElse(s.length()) - 1;
    }

    public static String getTokenPossiblyRemovedFromHeadNumber(String s) {
        int pos = Kit.getPositionOfLastDigitAtHeadOf(s);
        return pos == -1 ? s : s.substring(pos + 1);
    }

    public static int[] pickDifferentValues(int length, int nPossibleValues, Random random) {
        assert (length < nPossibleValues);
        if (length == 0) {
            return new int[0];
        }
        int[] source = Kit.range(nPossibleValues);
        int[] target = new int[length];
        for (int i = 0; i < length; ++i) {
            int pos = random.nextInt(source.length - i);
            target[i] = source[pos];
            source[pos] = source[source.length - i - 1];
        }
        return Kit.sort(target);
    }

    public static Object control(boolean conditionToBeRespected, Supplier<String> message) {
        return conditionToBeRespected ? null : Kit.exit(message.get(), new Exception());
    }

    public static Object control(boolean conditionToBeRespected) {
        return Kit.control(conditionToBeRespected, () -> "");
    }

    public static Object exit(String message, Throwable e) {
        if (!(Thread.currentThread() instanceof Resolution) || ((Resolution)Thread.currentThread()).cp.general.makeExceptionsVisible) {
            e.printStackTrace();
        }
        System.out.println(message);
        System.exit(1);
        return null;
    }

    public static Object exit(String message) {
        return Kit.exit(message, new Exception());
    }

    public static Object exit(Throwable e) {
        return Kit.exit("", e);
    }

    private static void collectObjects(Object o, List<Object> list) {
        if (o != null) {
            if (o.getClass().isArray()) {
                IntStream.range(0, Array.getLength(o)).forEach(i -> Kit.collectObjects(Array.get(o, i), list));
            } else {
                list.add(o);
            }
        }
    }

    public static Object[] concat(Object first, Object ... next) {
        ArrayList<Object> list = new ArrayList<Object>();
        Kit.collectObjects(first, list);
        Stream.of(next).forEach(o -> Kit.collectObjects(o, list));
        return list.toArray(new Object[list.size()]);
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sort(Map<K, V> map, Comparator<? super Map.Entry<K, V>> cmp) {
        LinkedHashMap result = new LinkedHashMap();
        map.entrySet().stream().sorted(cmp).forEachOrdered(e -> {
            Comparable cfr_ignored_0 = (Comparable)result.put(e.getKey(), e.getValue());
        });
        return result;
    }

    public static String capitalize(String s) {
        char[] t = s.toCharArray();
        IntStream.range(0, t.length).forEach(i -> {
            t[i] = i == 0 ? Character.toUpperCase(t[i]) : Character.toLowerCase(t[i]);
        });
        return new String(t);
    }

    public static String camelCaseOf(String s) {
        return Stream.of(s.split("_")).map(tok -> Kit.capitalize(tok)).collect(Collectors.joining());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFirstLineIn(String fileName) {
        try (BufferedReader br = new BufferedReader(new FileReader(fileName));){
            String string = br.readLine().trim();
            return string;
        }
        catch (Exception e) {
            return (String)Kit.exit(e);
        }
    }

    public static boolean[] and(boolean[] inOut, boolean[] in) {
        assert (inOut.length == in.length);
        for (int i = 0; i < inOut.length; ++i) {
            inOut[i] = inOut[i] && in[i];
        }
        return inOut;
    }

    public static boolean[] or(boolean[] inOut, boolean[] in) {
        assert (inOut.length == in.length);
        for (int i = 0; i < inOut.length; ++i) {
            inOut[i] = inOut[i] || in[i];
        }
        return inOut;
    }

    public static boolean isSubsumed(boolean[] t1, boolean[] t2) {
        assert (t1.length == t2.length);
        for (int i = 0; i < t1.length; ++i) {
            if (!t1[i] || t2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean[] repeat(boolean value, int length) {
        boolean[] t = new boolean[length];
        Arrays.fill(t, value);
        return t;
    }

    public static char[] repeat(char value, int length) {
        char[] t = new char[length];
        Arrays.fill(t, value);
        return t;
    }

    public static short[] repeat(short value, int length) {
        short[] t = new short[length];
        Arrays.fill(t, value);
        return t;
    }

    public static int[] repeat(int value, int length) {
        int[] t = new int[length];
        Arrays.fill(t, value);
        return t;
    }

    public static long[] repeat(long value, int length) {
        long[] t = new long[length];
        Arrays.fill(t, value);
        return t;
    }

    public static double[] repeat(double value, int length) {
        double[] t = new double[length];
        Arrays.fill(t, value);
        return t;
    }

    public static int[][] repeat(int value, int length1, int length2) {
        int[][] m;
        for (int[] t : m = new int[length1][length2]) {
            Arrays.fill(t, value);
        }
        return m;
    }

    public static byte[] range(byte length) {
        Kit.control(0 < length);
        byte[] t = new byte[length];
        for (int i = 0; i < t.length; i = (int)((byte)(i + 1))) {
            t[i] = i;
        }
        return t;
    }

    public static short[] range(short minIncluded, short maxIncluded) {
        Kit.control(minIncluded <= maxIncluded, () -> minIncluded + ".." + maxIncluded);
        short[] t = new short[maxIncluded - minIncluded + 1];
        for (short i = minIncluded; i <= maxIncluded; i = (short)(i + 1)) {
            t[i - minIncluded] = i;
        }
        return t;
    }

    public static short[] range(short length) {
        return Kit.range((short)0, (short)(length - 1));
    }

    public static int[] range(int minIncluded, int maxIncluded, int step) {
        Kit.control(minIncluded <= maxIncluded);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = minIncluded; i <= maxIncluded; i += step) {
            list.add(i);
        }
        return Kit.intArray(list);
    }

    public static int[] range(int minIncluded, int maxIncluded) {
        Kit.control(minIncluded <= maxIncluded);
        return IntStream.range(minIncluded, maxIncluded + 1).toArray();
    }

    public static int[] range(int length) {
        return Kit.range(0, length - 1);
    }

    public static long[] range(long length) {
        Kit.control(0L < length && length <= Integer.MAX_VALUE);
        return LongStream.range(0L, length).toArray();
    }

    public static boolean[][] cloneDeeply(boolean[][] m) {
        return (boolean[][])Stream.of(m).map(t -> (boolean[])t.clone()).toArray(x$0 -> new boolean[x$0][]);
    }

    public static boolean[][][] cloneDeeply(boolean[][][] c) {
        return (boolean[][][])Stream.of(c).map(m -> Kit.cloneDeeply(m)).toArray(x$0 -> new boolean[x$0][][]);
    }

    public static int[][] cloneDeeply(int[][] m) {
        return (int[][])Stream.of(m).map(t -> (int[])t.clone()).toArray(x$0 -> new int[x$0][]);
    }

    public static int[][][] cloneDeeply(int[][][] c) {
        return (int[][][])Stream.of(c).map(m -> Kit.cloneDeeply(m)).toArray(x$0 -> new int[x$0][][]);
    }

    public static long[][] cloneDeeply(long[][] m) {
        return (long[][])Stream.of(m).map(t -> (long[])t.clone()).toArray(x$0 -> new long[x$0][]);
    }

    public static void fill(boolean[][] m, boolean value) {
        for (boolean[] t : m) {
            Arrays.fill(t, value);
        }
    }

    public static void fill(int[][] m, int value) {
        for (int[] t : m) {
            Arrays.fill(t, value);
        }
    }

    public static void fill(Object[][] m, Object value) {
        for (Object[] t : m) {
            Arrays.fill(t, value);
        }
    }

    public static short[] shortArray(Collection<Short> collection) {
        short[] t = new short[collection.size()];
        Iterator<Short> it = collection.iterator();
        for (int i = 0; i < t.length; ++i) {
            t[i] = it.next();
        }
        return t;
    }

    public static short[][] shortArray2D(Collection<Short>[] array) {
        return (short[][])Stream.of(array).map(c -> Kit.shortArray(c)).toArray(x$0 -> new short[x$0][]);
    }

    public static short[][][] shortArray3D(Collection<Short>[][] array) {
        return (short[][][])Stream.of(array).map(c -> Kit.shortArray2D(c)).toArray(x$0 -> new short[x$0][][]);
    }

    public static int[][] intArray2D(Collection<Integer>[] array) {
        return (int[][])Stream.of(array).map(c -> Kit.intArray(c)).toArray(x$0 -> new int[x$0][]);
    }

    public static int[][][] intArray3D(Collection<Integer>[][] array) {
        return (int[][][])Stream.of(array).map(c -> Kit.intArray2D(c)).toArray(x$0 -> new int[x$0][][]);
    }

    public static int[] intArray(Collection<Integer> collection) {
        return collection.stream().mapToInt(i -> i).toArray();
    }

    public static int[][] intArray2D(Collection<int[]> collection) {
        return (int[][])collection.stream().toArray(x$0 -> new int[x$0][]);
    }

    public static int[][][] intArray3D(Collection<int[][]> collection) {
        return (int[][][])collection.stream().toArray(x$0 -> new int[x$0][][]);
    }

    public static <T> boolean isPresent(T value, T[] t) {
        return Stream.of(t).anyMatch(v -> v == value);
    }

    public static <T> boolean isPresent(String s, String[][] m) {
        return Stream.of(m).anyMatch(t -> Kit.isPresent(s, t));
    }

    public static boolean isPresent(char value, char[] ... m) {
        return Arrays.stream(m).anyMatch(t -> IntStream.range(0, ((char[])t).length).anyMatch(i -> t[i] == value));
    }

    public static boolean isPresent(char value, String ... t) {
        return Arrays.stream(t).anyMatch(s -> s.indexOf(value) != -1);
    }

    public static boolean isPresent(int value, int[] t) {
        return IntStream.of(t).anyMatch(v -> v == value);
    }

    public static boolean isPresent(int value, int[] ... m) {
        return Stream.of(m).anyMatch(t -> Kit.isPresent(value, t));
    }

    public static boolean withOnly(int value, int[] t) {
        return IntStream.range(0, t.length).noneMatch(i -> t[i] != value);
    }

    public static boolean withNoNegativeValues(long[][] m) {
        return Stream.of(m).noneMatch(t -> Arrays.stream(t).anyMatch(v -> v < 0L));
    }

    public static boolean allDifferentValues(int ... t) {
        return IntStream.range(0, t.length).noneMatch(i -> IntStream.range(i + 1, t.length).anyMatch(j -> t[i] == t[j]));
    }

    public static boolean allDifferentValues(int[] t, int ... except) {
        for (int i = 0; i < t.length; ++i) {
            if (Utilities.indexOf((int)t[i], (int[])except) != -1) continue;
            for (int j = i + 1; j < t.length; ++j) {
                if (t[i] != t[j]) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isIncreasing(int[] t) {
        return IntStream.range(0, t.length - 1).noneMatch(i -> t[i] > t[i + 1]);
    }

    public static boolean isIncreasing(double[] t) {
        return IntStream.range(0, t.length - 1).noneMatch(i -> t[i] > t[i + 1]);
    }

    public static boolean isStrictlyIncreasing(int[] t) {
        return IntStream.range(0, t.length - 1).noneMatch(i -> t[i] >= t[i + 1]);
    }

    public static <T extends Comparable<T>> boolean isStrictlyIncreasing(T[] t) {
        return IntStream.range(0, t.length - 1).noneMatch(i -> t[i].compareTo(t[i + 1]) >= 0);
    }

    public static boolean isLexIncreasing(int[][] t) {
        return IntStream.range(0, t.length - 1).noneMatch(i -> Utilities.lexComparatorInt.compare(t[i], t[i + 1]) > 0);
    }

    public static boolean isLexStrictlyIncreasing(int[][] t) {
        return IntStream.range(0, t.length - 1).noneMatch(i -> Utilities.lexComparatorInt.compare(t[i], t[i + 1]) >= 0);
    }

    public static boolean isLexStrictlyIncreasing(long[][] t) {
        return IntStream.range(0, t.length - 1).noneMatch(i -> lexComparatorLong.compare(t[i], t[i + 1]) >= 0);
    }

    public static boolean isArrayOnlyContainingTuplesWithSameSize(int[][] t) {
        return IntStream.range(0, t.length - 1).noneMatch(i -> t[i].length != t[i + 1].length);
    }

    public static boolean isPrefix(int[] t1, int[] t2) {
        return t1.length <= t2.length && IntStream.range(0, t1.length).noneMatch(i -> t1[i] != t2[i]);
    }

    public static boolean isSubtuple(int[] subtuple, int[] tuple, int from) {
        return from + subtuple.length < tuple.length && IntStream.range(0, subtuple.length).noneMatch(i -> subtuple[i] != tuple[from + i]);
    }

    public static int countIn(char c, String s) {
        return IntStream.range(0, s.length()).filter(i -> s.charAt(i) == c).map(i -> 1).sum();
    }

    public static int countIn(int value, int[] t) {
        return Arrays.stream(t).filter(v -> v == value).map(v -> 1).sum();
    }

    public static int countIn(int value, int[] t, int from, int to) {
        return IntStream.range(from, to).filter(i -> t[i] == value).map(i -> 1).sum();
    }

    public static int countIn(boolean value, boolean[] t) {
        return IntStream.range(0, t.length).filter(i -> t[i] == value).map(i -> 1).sum();
    }

    public static int[][] appendTuple(int[][] t, int ... tuple) {
        int[][] tt = new int[t.length + 1][];
        System.arraycopy(t, 0, tt, 0, t.length);
        tt[t.length] = tuple;
        return tt;
    }

    public static int[][] appendTuples(int[][] t, int[] ... tuples) {
        int[][] tt = new int[t.length + tuples.length][];
        System.arraycopy(t, 0, tt, 0, t.length);
        for (int i = 0; i < tuples.length; ++i) {
            tt[t.length + i] = tuples[i];
        }
        return tt;
    }

    public static int[][] cartesianProduct(int[] t1, int ... t2) {
        int[][] tt = new int[t1.length * t2.length][];
        for (int i = 0; i < t1.length; ++i) {
            for (int j = 0; j < t2.length; ++j) {
                tt[i * t2.length + j] = new int[]{t1[i], t2[j]};
            }
        }
        return tt;
    }

    public static long sum(int[] t, int from) {
        return IntStream.range(from, t.length).map(i -> t[i]).sum();
    }

    public static long sum(int[] t) {
        return Kit.sum(t, 0);
    }

    public static long sum(int[][] m) {
        return Stream.of(m).mapToLong(t -> Kit.sum(t)).sum();
    }

    public static long weightedSum(int[] t, int[] coeffs) {
        assert (t.length == coeffs.length);
        long sum = 0L;
        for (int i = 0; i < t.length; ++i) {
            sum += (long)(coeffs[i] * t[i]);
        }
        return sum;
    }

    public static double computeAnp(int n, int p) {
        Kit.control(n >= p);
        double d = 1.0;
        for (int i = n; i > n - p; --i) {
            d *= (double)i;
        }
        return d;
    }

    public static double computeCnp(int n, int p) {
        double d = Kit.computeAnp(n, p);
        for (int i = 2; i <= p; ++i) {
            d /= (double)i;
        }
        return d;
    }

    public static void copy(String srcFileName, String dstFileName) {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(srcFileName));
             BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dstFileName));){
            byte[] bytes = new byte[1024];
            int nb = in.read(bytes, 0, bytes.length);
            while (nb > 0) {
                out.write(bytes, 0, nb);
                nb = in.read(bytes, 0, bytes.length);
            }
        }
        catch (Exception e) {
            Kit.exit(e);
        }
    }

    public static int[] buildMapping(int[] src, int[] dst) {
        int[] mapping = new int[src.length];
        for (int i = 0; i < src.length; ++i) {
            mapping[i] = Utilities.indexOf((int)src[i], (int[])dst);
        }
        return mapping;
    }

    public static int[] buildMapping(Object[] src, Object[] dst) {
        int[] mapping = new int[src.length];
        for (int i = 0; i < src.length; ++i) {
            mapping[i] = Utilities.indexOf((Object)src[i], (Object[])dst);
        }
        return mapping;
    }

    public static int[] buildPermutation(Random random, int size) {
        int[] values = Kit.range(size);
        int[] t = new int[size];
        for (int i = 0; i < size; ++i) {
            int j = random.nextInt(size - i);
            t[i] = values[j];
            values[j] = values[size - i - 1];
        }
        return t;
    }

    public static int[] mapTuple(int[] src, int[] dst, int[] mapping) {
        for (int i = 0; i < Math.min(dst.length, mapping.length); ++i) {
            dst[i] = src[mapping[i]];
        }
        return dst;
    }

    public static int[] mapTuple(int[] src, int[] mapping) {
        return Kit.mapTuple(src, (int[])src.clone(), mapping);
    }

    public static long[] mapTuple(long[] src, long[] dst, int[] mapping) {
        for (int i = 0; i < Math.min(dst.length, mapping.length); ++i) {
            dst[i] = src[mapping[i]];
        }
        return dst;
    }

    public static long[] mapTuple(long[] src, int[] mapping) {
        return Kit.mapTuple(src, (long[])src.clone(), mapping);
    }

    public static long[][] mapTuples(long[][] src, int[] mapping) {
        return (long[][])Stream.of(src).map(t -> Kit.mapTuple(t, mapping)).toArray(x$0 -> new long[x$0][]);
    }

    public static String transformThroughMap(String s, Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(s);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            String newToken = map.get(token);
            sb.append(newToken == null ? token : newToken);
            if (!st.hasMoreTokens()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public static int[] buildReverseMapping(int[] mapping) {
        int[] reverseMapping = new int[mapping.length];
        for (int i = 0; i < reverseMapping.length; ++i) {
            reverseMapping[mapping[i]] = i;
        }
        return reverseMapping;
    }

    public static boolean areMappedTuples(int[] tuple1, int[] tuple2, int[][] mapping) {
        return Stream.of(mapping).noneMatch(t -> tuple1[t[0]] != tuple2[t[1]]);
    }

    public static int[] sort(int[] t) {
        Arrays.sort(t);
        return t;
    }

    public static long[] sort(long[] t) {
        Arrays.sort(t);
        return t;
    }

    public static double[] sort(double[] t) {
        Arrays.sort(t);
        return t;
    }

    public static <E> E[] sort(E[] t) {
        Arrays.sort(t);
        return t;
    }

    public static <E> E[] sort(E[] t, Comparator<E> comparator) {
        Arrays.sort(t, comparator);
        return t;
    }

    public static int[] reverse(int[] t) {
        for (int i = 0; i < t.length / 2; ++i) {
            int tmp = t[i];
            t[i] = t[t.length - i - 1];
            t[t.length - i - 1] = tmp;
        }
        return t;
    }

    public static long[] reverse(long[] t) {
        for (int i = 0; i < t.length / 2; ++i) {
            long tmp = t[i];
            t[i] = t[t.length - i - 1];
            t[t.length - i - 1] = tmp;
        }
        return t;
    }

    public static boolean selectInDirectory(List<String> list, File dir, int limit, FileFilter fileFilter) {
        String[] listDirectory;
        for (String s2 : listDirectory = Kit.sort(dir.list())) {
            File f2 = new File(dir, s2);
            if (!f2.isFile() || !fileFilter.accept(f2)) continue;
            list.add(f2.getAbsolutePath());
            if (list.size() < limit) continue;
            return true;
        }
        return Stream.of(listDirectory).map(s -> new File(dir, (String)s)).anyMatch(f -> f.isDirectory() && Kit.selectInDirectory(list, f, limit, fileFilter));
    }

    public static String getRawInstanceName(String s) {
        int first = s.lastIndexOf(File.separator) != -1 ? s.lastIndexOf(File.separator) + 1 : 0;
        int last = s.lastIndexOf(".") != -1 ? s.lastIndexOf(".") : s.length();
        return first > last ? s.substring(first) : s.substring(first, last);
    }

    public static String getXMLBaseNameOf(String s) {
        int first = s.lastIndexOf(File.separator);
        first = first == -1 ? 0 : first + 1;
        int last = s.toLowerCase().lastIndexOf(".xml");
        last = last == -1 ? s.length() : last;
        return s.substring(first, last);
    }

    public static Integer parseInteger(String token) {
        try {
            return Integer.parseInt(token);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Long parseLong(String token) {
        try {
            return Long.parseLong(token);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String getFormattedCurrentDate() {
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(System.currentTimeMillis());
        int year = c.get(1);
        int month = c.get(2);
        int day = c.get(5);
        int hour = c.get(11);
        int minute = c.get(12);
        DecimalFormat df = new DecimalFormat("00");
        return year + "_" + df.format(month) + "_" + df.format(day) + "_" + df.format(hour) + "_" + df.format(minute);
    }

    public static String getFormattedMemorySize(long size) {
        long m = size / 1000000L;
        long k = size / 1000L - m * 1000L;
        return m + "M" + k;
    }

    public static long getUsedMemory() {
        Runtime rt = Runtime.getRuntime();
        return rt.totalMemory() - rt.freeMemory();
    }

    public static String getFormattedUsedMemorySize() {
        return Kit.getFormattedMemorySize(Kit.getUsedMemory());
    }

    public static void copy(int[] src, int[] dst) {
        for (int i = dst.length - 1; i >= 0; --i) {
            dst[i] = src[i];
        }
    }

    public static final <T> int[][] mappingBetween(T[] t1, T[] t2) {
        return (int[][])IntStream.range(0, t1.length).mapToObj(i -> new int[]{i, Utilities.indexOf((Object)t1[i], (Object[])t2)}).filter(t -> t[1] != -1).toArray(x$0 -> new int[x$0][]);
    }

    public static int[] swap(int[] tuple, int i, int j) {
        int tmp = tuple[i];
        tuple[i] = tuple[j];
        tuple[j] = tmp;
        return tuple;
    }

    public static <T> void swap(T[] objects, int i, int j) {
        T tmp = objects[i];
        objects[i] = objects[j];
        objects[j] = tmp;
    }

    private static int maxDepthOf(Object o) {
        return o == null || !o.getClass().isArray() ? 0 : 1 + IntStream.range(0, Array.getLength(o)).map(i -> Kit.maxDepthOf(Array.get(o, i))).max().orElse(0);
    }

    private static String delimiterFor(int distToMaxDepth) {
        return distToMaxDepth == 0 ? " " : (distToMaxDepth == 1 ? "\n" : (distToMaxDepth == 2 ? "\n\n" : (distToMaxDepth == 3 ? "\n\n\n" : "\n\n\n\n")));
    }

    private static <T> StringBuilder join(StringBuilder sb, Object array, int length, int depth, int maxDepth, Function<T, String> mapper, String ... delimiters) {
        for (int i = 0; i < length; ++i) {
            Object item = Array.get(array, i);
            if (item == null) {
                sb.append("null");
            } else if (item.getClass().isArray()) {
                Kit.join(sb, item, Array.getLength(item), depth + 1, maxDepth, mapper, delimiters);
            } else {
                sb.append(mapper == null ? item.toString() : mapper.apply(item));
            }
            sb.append(i < length - 1 ? (depth - 1 < delimiters.length ? delimiters[depth - 1] : Kit.delimiterFor(maxDepth - depth)) : "");
        }
        return sb;
    }

    public static StringBuilder join(StringBuilder sb, Object array, int length, String ... delimiters) {
        return Kit.join(sb, array, length, 1, Kit.maxDepthOf(array), null, delimiters);
    }

    public static StringBuilder join(StringBuilder sb, Object array, String ... delimiters) {
        return Kit.join(sb, array, Array.getLength(array), delimiters);
    }

    public static <T> String join(Object array, int length, Function<T, String> mapper, String ... delimiters) {
        return Kit.join(new StringBuilder(), array, length, 1, Kit.maxDepthOf(array), mapper, delimiters).toString();
    }

    public static String join(Object array, int length, String ... delimiters) {
        return Kit.join(new StringBuilder(), array, length, 1, Kit.maxDepthOf(array), null, delimiters).toString();
    }

    public static <T> String join(Object array, Function<T, String> mapper, String ... delimiters) {
        return Kit.join(array, Array.getLength(array), mapper, delimiters);
    }

    public static String join(Object array, String ... delimiters) {
        return Kit.join(array, Array.getLength(array), delimiters);
    }

    public static String join(Collection<? extends Object> c, String ... delimiters) {
        return Kit.join((Object)c.toArray(), delimiters);
    }

    public static String[] split(StringTokenizer st, int nb) {
        return (String[])IntStream.range(0, nb).mapToObj(i -> st.nextToken()).toArray(String[]::new);
    }

    public static String[] split(StringTokenizer st) {
        return Kit.split(st, st.countTokens());
    }

    public static String replaceAll(String s, char oldChar, char newChar) {
        StringBuilder sb = new StringBuilder(s);
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != oldChar) continue;
            sb.setCharAt(i, newChar);
        }
        return sb.toString();
    }

    public static String getFileNameOf(String pathAndFileName) {
        int last = pathAndFileName.lastIndexOf("/");
        return last == -1 ? pathAndFileName.trim() : pathAndFileName.substring(last + 1);
    }

    public static String getPathOf(String pathAndFileName) {
        int last = pathAndFileName.lastIndexOf("/");
        return last == -1 ? "" : pathAndFileName.substring(0, last + 1);
    }

    public static double[] computeQuantileOf(double[] t, int nbIntervals, boolean mustBeSorted) {
        double[] tt;
        double[] dArray = tt = mustBeSorted ? Kit.sort((double[])t.clone()) : t;
        assert (Kit.isIncreasing(tt));
        return IntStream.range(0, nbIntervals - 1).mapToDouble(i -> tt[(int)Math.ceil((double)((i + 1) * tt.length) / (double)nbIntervals) - 1]).toArray();
    }

    public static int computeMaxOf(int[] t) {
        return Arrays.stream(t).max().orElse(Integer.MIN_VALUE);
    }

    public static long computeMaxOf(long[] t) {
        return Arrays.stream(t).max().orElse(Long.MIN_VALUE);
    }

    public static int computeMaxOf(int[][] m) {
        return Stream.of(m).mapToInt(t -> Kit.computeMaxOf(t)).max().orElse(Integer.MIN_VALUE);
    }

    public static double computeAveragePositionOf(int[] t) {
        int nbElements = 0;
        long sum = 0L;
        for (int i = 0; i < t.length; ++i) {
            nbElements += t[i];
            sum += (long)(t[i] * i);
        }
        return nbElements == 0 ? -1.0 : (double)sum / (double)nbElements;
    }

    public static double computeVarianceOf(double[] t) {
        double sum = Arrays.stream(t).sum();
        double average = sum / (double)t.length;
        double gapSum = Arrays.stream(t).map(d -> (d - average) * (d - average)).sum();
        return gapSum / (double)t.length;
    }

    public static int[] computePrimes(int limitIncluded) {
        Boolean[] primes = (Boolean[])IntStream.range(0, limitIncluded + 1).mapToObj(i -> i < 2 ? Boolean.FALSE : Boolean.TRUE).toArray(Boolean[]::new);
        return IntStream.range(2, limitIncluded + 1).filter(i -> primes[i]).map(i -> {
            for (int j = i * 2; j < primes.length; j += i) {
                primes[j] = false;
            }
            return i;
        }).toArray();
    }

    static {
        LogManager.getLogManager().reset();
        StreamHandler handler = new StreamHandler(){

            @Override
            public void publish(LogRecord record) {
                if (record.getLevel().intValue() < Level.INFO.intValue()) {
                    if (Arguments.multiThreads) {
                        System.out.println("From " + ((Resolution)Thread.currentThread()).cp.settingsFilename + " :");
                    }
                    System.out.println(record.getMessage());
                } else {
                    Thread t;
                    if (Arguments.multiThreads) {
                        System.err.println("From " + ((Resolution)Thread.currentThread()).cp.settingsFilename + " :");
                    }
                    if ((t = Resolution.currentThread()) instanceof Resolution && !((Resolution)t).cp.competitionMode) {
                        System.err.println("\n" + record.getLevel() + " : " + record.getMessage());
                    }
                    if (record.getLevel() == Level.SEVERE) {
                        System.err.println(record.getLevel() + " forces us to stop");
                        System.out.println("\ns UNSUPPORTED");
                        System.exit(2);
                    }
                }
            }
        };
        log.addHandler(handler);
        lexComparatorByte = (t1, t2) -> {
            for (int i = 0; i < ((byte[])t1).length; ++i) {
                if (t1[i] < t2[i]) {
                    return -1;
                }
                if (t1[i] <= t2[i]) continue;
                return 1;
            }
            return 0;
        };
        lexComparatorShort = (t1, t2) -> {
            for (int i = 0; i < ((short[])t1).length; ++i) {
                if (t1[i] < t2[i]) {
                    return -1;
                }
                if (t1[i] <= t2[i]) continue;
                return 1;
            }
            return 0;
        };
        lexComparatorLong = (t1, t2) -> {
            for (int i = 0; i < ((long[])t1).length; ++i) {
                if (t1[i] < t2[i]) {
                    return -1;
                }
                if (t1[i] <= t2[i]) continue;
                return 1;
            }
            return 0;
        };
        lexComparatorGeneral = (t1, t2) -> {
            for (int i = 0; i < ((int[])t1).length; ++i) {
                if (i > ((int[])t2).length - 1 || t1[i] > t2[i]) {
                    return 1;
                }
                if (t1[i] >= t2[i]) continue;
                return -1;
            }
            return ((int[])t1).length < ((int[])t2).length ? -1 : 0;
        };
    }

    public static class Stopwatch {
        private boolean cpuTimeSupported = ManagementFactory.getThreadMXBean().isCurrentThreadCpuTimeSupported();
        private long startWallClockTime;

        public Stopwatch() {
            this.start();
        }

        private long computeCpuTime() {
            assert (this.cpuTimeSupported);
            ThreadMXBean threads = ManagementFactory.getThreadMXBean();
            return Arrays.stream(threads.getAllThreadIds()).map(id -> threads.getThreadCpuTime(id)).sum();
        }

        public void start() {
            this.startWallClockTime = System.currentTimeMillis();
        }

        public long getWckTime() {
            return System.currentTimeMillis() - this.startWallClockTime;
        }

        public long getCpuTime() {
            return this.cpuTimeSupported ? this.computeCpuTime() / 1000000L : -1L;
        }

        public String getCpuTimeInSeconds() {
            return this.cpuTimeSupported ? (double)this.getCpuTime() / 1000.0 + "" : "-1";
        }
    }

    public static class IntWithLongArrayScoreReverse
    implements Comparable<IntWithLongArrayScoreReverse> {
        public int index;
        public long[] score;

        public IntWithLongArrayScoreReverse() {
        }

        public IntWithLongArrayScoreReverse(int index) {
            this.index = index;
        }

        public IntWithLongArrayScoreReverse(int index, long[] score) {
            this.index = index;
            this.score = (long[])score.clone();
        }

        private int comp(long[] t1, long[] t2) {
            int d = t2.length - t1.length;
            for (int i = t1.length - 1; i >= 0; --i) {
                if (t1[i] <= t2[i + d]) continue;
                return 1;
            }
            return 0;
        }

        @Override
        public int compareTo(IntWithLongArrayScoreReverse o) {
            int r = this.comp(this.score, o.score);
            return r != 0 ? r : this.index - o.index;
        }

        public String toString() {
            return "(" + this.index + "," + Kit.join((Object)this.score, new String[0]) + ")";
        }
    }

    public static class IntLongPairReverse
    implements Comparable<IntLongPairReverse> {
        public int index;
        public long value;

        public IntLongPairReverse() {
        }

        public IntLongPairReverse(int index) {
            this.index = index;
        }

        public IntLongPairReverse(int index, long value) {
            this.index = index;
            this.value = value;
        }

        @Override
        public int compareTo(IntLongPairReverse o) {
            return this.value < o.value ? 1 : (this.value > o.value ? -1 : this.index - o.index);
        }

        public String toString() {
            return "(" + this.index + "," + this.value + ")";
        }
    }

    public static class IntLongPair
    implements Comparable<IntLongPair> {
        public int index;
        public long value;

        public IntLongPair() {
        }

        public IntLongPair(int index, long value) {
            this.index = index;
            this.value = value;
        }

        @Override
        public int compareTo(IntLongPair o) {
            return this.value < o.value ? -1 : (this.value > o.value ? 1 : 0);
        }

        public String toString() {
            return "(" + this.index + "," + this.value + ")";
        }
    }

    public static class IntArrayWithLongScore
    implements Comparable<IntArrayWithLongScore> {
        public int[] t;
        public long score;

        public void set(int[] t, long score) {
            this.t = t;
            this.score = score;
        }

        @Override
        public int compareTo(IntArrayWithLongScore o) {
            return this.score < o.score ? -1 : (this.score > o.score ? 1 : lexComparatorGeneral.compare(this.t, o.t));
        }
    }

    public static class IntArrayWithScore
    implements Comparable<IntArrayWithScore> {
        public int[] t;
        public int score;

        public IntArrayWithScore(int[] t, int score) {
            this.t = t;
            this.score = score;
        }

        @Override
        public int compareTo(IntArrayWithScore o) {
            return this.score < o.score ? -1 : (this.score > o.score ? 1 : lexComparatorGeneral.compare(this.t, o.t));
        }
    }

    public static class LongArrayHashKey {
        public long[] t;

        public LongArrayHashKey() {
        }

        public LongArrayHashKey(long[] t) {
            this.t = t;
        }

        public int hashCode() {
            return Arrays.hashCode(this.t);
        }

        public boolean equals(Object object) {
            return Arrays.equals(this.t, ((LongArrayHashKey)object).t);
        }
    }

    public static class IntArrayHashKey {
        public int[] t;

        public IntArrayHashKey() {
        }

        public IntArrayHashKey(int[] t) {
            this.t = t;
        }

        public int hashCode() {
            return Arrays.hashCode(this.t);
        }

        public boolean equals(Object object) {
            return Arrays.equals(this.t, ((IntArrayHashKey)object).t);
        }
    }

    public static class ByteArrayHashKey {
        public byte[] t;

        public ByteArrayHashKey() {
        }

        public ByteArrayHashKey(byte[] t) {
            this.t = t;
        }

        public int hashCode() {
            return Arrays.hashCode(this.t);
        }

        public boolean equals(Object object) {
            return Arrays.equals(this.t, ((ByteArrayHashKey)object).t);
        }
    }

    public static class Contractor {
        private Map<IntArrayHashKey, int[]> map = new HashMap<IntArrayHashKey, int[]>(2000);
        private IntArrayHashKey hashKey;

        public void clear() {
            this.map.clear();
        }

        public void contract(int[][] m) {
            for (int i = 0; i < m.length; ++i) {
                if (this.hashKey == null) {
                    this.hashKey = new IntArrayHashKey();
                }
                this.hashKey.t = m[i];
                int[] t = this.map.get(this.hashKey);
                if (t == null) {
                    this.map.put(this.hashKey, m[i]);
                    this.hashKey = null;
                    continue;
                }
                m[i] = t;
            }
        }

        public void contract(Collection<int[][]> collection) {
            for (int[][] m : collection) {
                this.contract(m);
            }
        }
    }
}

