/*
 * Decompiled with CFR 0.152.
 */
package tools.wood;

import abscon.Resolution;
import dashboard.Arguments;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;
import problem.Problem;
import problems.Void;
import search.backtrack.SolverBacktrack;
import utility.observers.ObserverConstructionProblem;
import variables.Variable;

public class Wooder {
    private Problem problem;
    private SolverBacktrack solver;

    private Problem myProblem(Resolution resolution) {
        Void api = new Void();
        Problem p = new Problem((ProblemAPI)api, "", "", "", false, new String[0], resolution);
        IVar.Var x = api.var("x", api.dom(0, new int[]{1, 2, 3}), new Types.TypeClass[0]);
        IVar.Var y = api.var("y", api.dom(0, new int[]{1, 2, 3}), new Types.TypeClass[0]);
        IVar.Var[] t = api.array("t", api.size(4), api.dom(api.range(4)), new Types.TypeClass[0]);
        p.variables = p.stuff.collectedVarsAtInit.toArray(new Variable[p.stuff.collectedVarsAtInit.size()]);
        api.extension(new IVar.Var[]{x, y}, new int[][]{{0, 1}, {1, 0}, {3, 2}});
        api.extension(t, new int[][]{{0, 1, 2, 3}, {2, 1, 1, 0}, {1, 2, 3, 0}});
        p.storeConstraintsToArray();
        return p;
    }

    public Wooder(String[] args) {
        String[] stringArray;
        boolean debug = true;
        if (debug) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "-search=no";
            stringArray2[1] = "-v=2";
            stringArray = stringArray2;
            stringArray2[2] = "-positive=ct";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "-search=no";
            stringArray3[1] = "-v=0";
            stringArray = stringArray3;
            stringArray3[2] = "-cm=true";
        }
        Arguments.loadArguments(args, stringArray);
        Resolution resolution = new Resolution(Arguments.userSettingsFilename);
        resolution.observersConstructionProblem.clear();
        resolution.observersConstructionSolver.clear();
        this.problem = this.myProblem(resolution);
        for (ObserverConstructionProblem obs : resolution.observersConstructionProblem) {
            obs.onConstructionProblemFinished();
        }
        this.problem.display();
        this.solver = (SolverBacktrack)resolution.buildSolver();
        this.solver.solve();
    }

    public int[] computePropagations(int ... positiveDecisions) {
        for (int dec : positiveDecisions) {
            assert (dec > 0) : "only positive decisions (i.e., variable assignments)";
            Variable x = this.solver.dr.varIn(dec);
            int a = this.solver.dr.idxIn(dec);
            this.solver.assign(x, a);
            this.solver.propagation.queue.add(x);
        }
        int nBefore = this.problem.nValuesRemoved;
        boolean consistent = this.solver.propagation.propagate();
        if (!consistent) {
            this.solver.backtrackToTheRoot();
            return null;
        }
        int nAfter = this.problem.nValuesRemoved;
        if (nAfter == nBefore) {
            return new int[0];
        }
        int[] t = new int[nAfter - nBefore];
        int cnt = 0;
        Variable x = this.solver.futVars.first();
        while (x != null) {
            int a = x.dom.lastRemoved();
            while (a != -1) {
                t[cnt++] = this.solver.dr.negativeDecisionFor(x.num, a);
                a = x.dom.prevRemoved(a);
            }
            x = this.solver.futVars.next(x);
        }
        this.solver.backtrackToTheRoot();
        return t;
    }

    public static void main(String[] args) {
        Wooder tw = new Wooder(args);
        for (int cnt = 0; cnt < 100000; ++cnt) {
            for (int i = 0; i < 4; ++i) {
                int[] t = tw.computePropagations(tw.solver.dr.positiveDecisionFor(0, i));
                System.out.print("i = " + i + " ");
                if (t == null) {
                    System.out.println(" incocnistency");
                    continue;
                }
                System.out.println(IntStream.of(t).mapToObj(dec -> tw.solver.dr.stringOf(dec)).collect(Collectors.joining(" ")));
            }
        }
    }

    class MyLogger
    extends Logger {
        protected MyLogger(String name, String resourceBundleName) {
            super(name, resourceBundleName);
        }
    }
}

