/*
 * Decompiled with CFR 0.152.
 */
package tools.remote.visualization;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.IRangePolicy;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ITracePainter;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyHighestValues;
import info.monitorenter.gui.chart.traces.Trace2DSimple;
import info.monitorenter.gui.chart.traces.painters.TracePainterVerticalBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import tools.remote.visualization.TracePainter;

public class Visualization {
    private JFrame frame;
    public ITrace2D traceVariables;
    public ITrace2D traceDecisions;
    public ITrace2D traceWdegCtr;
    public ITrace2D traceWdegVar;
    public ITrace2D traceDomainsPositive;
    public ITrace2D traceDomainsNegative;
    private Color colorBg = Color.WHITE;
    private Color colorFg = Color.BLACK;
    private Color colorVars = new Color(0.0f, 0.78f, 0.09f);
    private Color colorCtrs = Color.RED;
    private Color colorDecisions = Color.BLUE;

    private ITrace2D addTraceToChart(Chart2D chart, String title, TracePainter.EPainter p, Color color) {
        Trace2DSimple trace = new Trace2DSimple(title);
        trace.setTracePainter((ITracePainter)(p == null ? new TracePainterVerticalBar(chart) : new TracePainter(p)));
        trace.setColor(color);
        chart.addTrace((ITrace2D)trace);
        trace.setZIndex(Integer.valueOf(100));
        return trace;
    }

    private ITrace2D buildChartWithTrace(String title, String titleX, String titleY, TracePainter.EPainter p, Color color, int range) {
        Chart2D chart = new Chart2D();
        chart.getAxisX().setAxisTitle(new IAxis.AxisTitle(titleX));
        chart.getAxisY().setAxisTitle(new IAxis.AxisTitle(titleY));
        if (range != -1) {
            chart.getAxisY().setRangePolicy((IRangePolicy)new RangePolicyHighestValues(range));
        }
        return this.addTraceToChart(chart, title, p, color);
    }

    public Visualization() {
        this.traceVariables = this.buildChartWithTrace("Decision variables", "Variable index", "Time", TracePainter.EPainter.PLUS, this.colorVars, 8000);
        this.traceDecisions = this.buildChartWithTrace("Decision level", "Time", "Decision level", TracePainter.EPainter.PLUS, this.colorDecisions, 8000);
        this.traceWdegCtr = this.buildChartWithTrace("Weight", "Constraint index", "Contraint weight", null, this.colorCtrs, -1);
        this.traceWdegVar = this.buildChartWithTrace("Weight", "Variable index", "Variable weight", null, this.colorVars, -1);
        this.traceDomainsPositive = this.buildChartWithTrace("Assigned value", "Variable index", "Domain value index", TracePainter.EPainter.DISC, this.colorVars, -1);
        this.traceDomainsNegative = this.addTraceToChart(this.traceDomainsPositive.getRenderer(), "Deleted value", TracePainter.EPainter.CROSS, this.colorCtrs);
        this.frame = new JFrame("Visualisation");
        this.frame.getContentPane().setLayout(new GridLayout(2, 3, 5, 5));
        this.frame.add(new MyChartPanel(this.traceVariables.getRenderer(), "Index of decision variables", this.colorBg, this.colorFg));
        this.frame.add(new MyChartPanel(this.traceWdegVar.getRenderer(), "Variable weights", this.colorBg, this.colorFg));
        this.frame.add(new MyChartPanel(this.traceWdegCtr.getRenderer(), "Constraint weights", this.colorBg, this.colorFg));
        this.frame.add(new MyChartPanel(this.traceDecisions.getRenderer(), "Decision levels", this.colorBg, this.colorFg));
        this.frame.add(new MyChartPanel(this.traceDomainsPositive.getRenderer(), "Domains", this.colorBg, this.colorFg));
        this.frame.setBackground(this.colorBg);
        this.frame.setForeground(this.colorFg);
        this.frame.setSize(800, 400);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Visualization.this.frame.dispose();
            }
        });
        this.frame.setVisible(true);
    }

    public void start() {
        this.frame.setVisible(true);
    }

    private class MyChartPanel
    extends JPanel {
        public MyChartPanel(Chart2D chart, String title, Color bg, Color fg) {
            this.setBorder(new EmptyBorder(4, 4, 4, 4));
            this.setLayout(new BorderLayout());
            JPanel panel = new JPanel();
            panel.setBackground(bg);
            panel.setForeground(fg);
            JLabel titleLabel = new JLabel(title);
            titleLabel.setFont(titleLabel.getFont().deriveFont(titleLabel.getFont().getStyle() ^ 1));
            panel.add(titleLabel);
            this.add((Component)panel, "North");
            chart.setBackground(bg);
            chart.setForeground(fg);
            this.add((Component)chart, "Center");
        }
    }
}

