/*
 * Decompiled with CFR 0.152.
 */
package tools.remote.panels;

import executables.Resolution;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import tools.remote.Remote;

public class PanelRestarts
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String CURRENT_CUTOFF = "Base Cutoff :";
    private static final String CUTOFF_RESET_PERIOD = "Cutoff Reset Period :";
    private static final String RESTARTS_FACTOR = "Restarts Factor :";
    private static final String INFINITY = "Infinity";
    private static final String RESTART = "Restart now";
    private static final String APPLY = "Apply";
    private JTextField cutoffField;
    private JTextField periodField;
    private JTextField factorField;
    private final Remote remote;

    private JTextField addLabelAndField(String s, JPanel p) {
        JLabel label = new JLabel(s);
        JTextField field = new JTextField();
        field.setColumns(10);
        label.setLabelFor(field);
        p.add(label);
        p.add(field);
        return field;
    }

    public PanelRestarts(Remote remote) {
        this.remote = remote;
        this.setLayout(new BorderLayout());
        JPanel paramPanel = new JPanel(new BorderLayout());
        paramPanel.setBorder(new TitledBorder("Restart parameters"));
        JPanel fields = new JPanel();
        this.cutoffField = this.addLabelAndField(CURRENT_CUTOFF, fields);
        this.periodField = this.addLabelAndField(CUTOFF_RESET_PERIOD, fields);
        this.factorField = this.addLabelAndField(RESTARTS_FACTOR, fields);
        paramPanel.add((Component)fields, "North");
        JPanel apply = new JPanel();
        ((JButton)apply.add(new JButton(APPLY))).addActionListener(e -> this.applyChanges());
        paramPanel.add((Component)apply, "South");
        JPanel manualPanel = new JPanel();
        manualPanel.setBorder(new TitledBorder("Manual restart"));
        ((JButton)manualPanel.add(new JButton(RESTART))).addActionListener(arg0 -> this.restart());
        this.add((Component)paramPanel, "Center");
        this.add((Component)manualPanel, "South");
    }

    private void restart() {
        this.remote.resolution.solver.restarter.reset();
        System.out.println("MODIF : Solver has just restarted");
    }

    private void applyChanges() {
        Resolution resolution = this.remote.resolution;
        if (resolution != null) {
            if (this.cutoffField.getText().length() > 0) {
                try {
                    long cutoff;
                    long l = cutoff = this.cutoffField.getText().equals(INFINITY) ? Long.MAX_VALUE : Long.parseLong(this.cutoffField.getText());
                    if (cutoff != resolution.solver.restarter.baseCutoff) {
                        resolution.cp.restarting.cutoff = cutoff;
                        resolution.solver.restarter.reset();
                        System.out.println("MODIF : Changed the value of cutoff to " + cutoff);
                    }
                }
                catch (NumberFormatException e) {
                    System.out.println("ERROR : Value in cutoff field should be an integer or equal to Infinity");
                }
            }
            if (this.periodField.getText().length() > 0) {
                try {
                    int valueCutoffReset;
                    int n = valueCutoffReset = this.periodField.getText().equals(INFINITY) ? Integer.MAX_VALUE : Integer.parseInt(this.periodField.getText());
                    if (valueCutoffReset != resolution.cp.restarting.nRestartsResetPeriod) {
                        resolution.cp.restarting.nRestartsResetPeriod = valueCutoffReset;
                        System.out.println("MODIF : Changed the value of cutoff reset period to " + valueCutoffReset);
                    }
                }
                catch (NumberFormatException e) {
                    System.out.println("ERROR : Value in cutoff reset period field should be an integer");
                }
            }
            if (this.factorField.getText().length() > 0) {
                try {
                    double valueRestartsFactor = Double.parseDouble(this.factorField.getText());
                    if (valueRestartsFactor != resolution.cp.restarting.factor) {
                        resolution.cp.restarting.factor = valueRestartsFactor;
                        System.out.println("MODIF : Changed the value of restarts factor to " + valueRestartsFactor);
                    }
                }
                catch (NumberFormatException e) {
                    System.out.println("ERROR : Value in reset factor field should be a double");
                }
            }
        }
    }

    public void solverStarted() {
        if (this.remote.resolution != null && this.remote.resolution.solver != null) {
            long baseCutoff = this.remote.resolution.solver.restarter.baseCutoff;
            this.cutoffField.setText(baseCutoff != Long.MAX_VALUE ? baseCutoff + "" : INFINITY);
            int cutOffReset = this.remote.resolution.cp.restarting.nRestartsResetPeriod;
            this.periodField.setText(cutOffReset != Integer.MAX_VALUE ? cutOffReset + "" : INFINITY);
            this.factorField.setText(this.remote.resolution.cp.restarting.factor + "");
        }
    }
}

