/*
 * Decompiled with CFR 0.152.
 */
package tools.remote.panels;

import executables.Resolution;
import heuristics.variables.HeuristicVariables;
import heuristics.variables.HeuristicVariablesDirect;
import heuristics.variables.HeuristicVariablesDynamic;
import heuristics.variables.HeuristicVariablesFixed;
import heuristics.variables.direct.Activity;
import heuristics.variables.dynamic.Dom;
import heuristics.variables.fixed.Deg;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.xcsp.common.Types;
import search.backtrack.SolverBacktrack;
import tools.remote.Remote;
import utility.Reflector;
import variables.Variable;

public class PanelHeuristicsVar
extends JPanel {
    private static final String HEURISTIC = "Variable Heuristic :";
    private static final String STATIC = "Static Ones";
    private static final String DYNAMIC = "Dynamic Ones";
    private static final String RAW = "Raw Ones";
    private static final String OPTIMIZATION_TYPE = "Optimization Type :";
    private static final String APPLY = "Apply";
    private static final String LAST_MODE = "Last Mode :";
    private Remote remote;
    private JRadioButton staticRadio;
    private JRadioButton dynamicRadio;
    private JRadioButton rawRadio;
    private JComboBox<String> hrsCombo;
    private JComboBox<Types.TypeOptimization> optCombo;
    private JTextField lastModeField;
    private String[] staticList = Remote.getArrayFrom(Deg.class, HeuristicVariablesFixed.class.getName(), false);
    private String[] dynamicList = Remote.getArrayFrom(Dom.class, HeuristicVariablesDynamic.class.getName(), false);
    private String[] rawList = Remote.getArrayFrom(Activity.class, HeuristicVariablesDirect.class.getName(), false);

    public PanelHeuristicsVar(Remote remote) {
        this.remote = remote;
        this.setLayout(new BoxLayout(this, 1));
        JPanel radioPanel = new JPanel();
        radioPanel.setLayout(new BoxLayout(radioPanel, 0));
        ButtonGroup g = new ButtonGroup();
        ActionListener listener = arg0 -> {
            this.hrsCombo.setModel(new DefaultComboBoxModel<String>(this.staticRadio.isSelected() ? this.staticList : (this.dynamicRadio.isSelected() ? this.dynamicList : this.rawList)));
            this.repaint();
        };
        this.staticRadio = Remote.addRadio(STATIC, g, radioPanel, listener);
        radioPanel.add(Box.createRigidArea(new Dimension(10, 50)));
        this.dynamicRadio = Remote.addRadio(DYNAMIC, g, radioPanel, listener);
        this.rawRadio = Remote.addRadio(RAW, g, radioPanel, listener);
        this.dynamicRadio.setSelected(true);
        this.add(radioPanel);
        JPanel hrsPanel = new JPanel();
        hrsPanel.add(new JLabel(HEURISTIC));
        this.hrsCombo = new JComboBox<String>(new DefaultComboBoxModel<String>(this.dynamicList));
        hrsPanel.add(this.hrsCombo);
        this.add(hrsPanel);
        JPanel optPanel = new JPanel();
        optPanel.add(new JLabel(OPTIMIZATION_TYPE));
        this.optCombo = new JComboBox<Types.TypeOptimization>(new DefaultComboBoxModel<Types.TypeOptimization>(Types.TypeOptimization.values()));
        optPanel.add(this.optCombo);
        this.add(optPanel);
        JPanel lastModePanel = new JPanel();
        lastModePanel.add(new JLabel(LAST_MODE));
        this.lastModeField = new JTextField(20);
        lastModePanel.add(this.lastModeField);
        this.add(lastModePanel);
        ((JButton)this.add(new JButton(APPLY))).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PanelHeuristicsVar.this.applyChanges();
            }
        });
    }

    private void applyChanges() {
        Resolution resolution = this.remote.resolution;
        if (resolution != null && resolution.solver instanceof SolverBacktrack) {
            SolverBacktrack solver = (SolverBacktrack)resolution.solver;
            HeuristicVariables hrs = solver.heuristicVars;
            if (!this.hrsCombo.getSelectedItem().equals(hrs.getClass().getSimpleName())) {
                System.out.println("\n   MODIF : Variable Heuristics is now " + this.hrsCombo.getSelectedItem() + " with " + this.optCombo.getSelectedItem());
                resolution.cp.varh.classForVarHeuristic = this.hrsCombo.getSelectedItem().toString();
                solver.heuristicVars = Reflector.buildObject(resolution.cp.varh.classForVarHeuristic, HeuristicVariables.class, solver, false);
                for (Variable var : solver.pb.variables) {
                    var.buildValueOrderingHeuristic();
                }
            }
            if (this.lastModeField.getText().length() > 0) {
                try {
                    int lastConflict = Integer.parseInt(this.lastModeField.getText());
                    if (lastConflict != resolution.cp.varh.lastConflictSize) {
                        resolution.cp.varh.lastConflictSize = lastConflict;
                        solver.lcReasoner.setMode(lastConflict);
                        System.out.println("MODIF : Changed the value of last mode to " + lastConflict);
                    }
                }
                catch (NumberFormatException e) {
                    System.out.println("ERROR : Value in last cmode field should be an integer or equal to Infinity");
                }
            }
        }
    }

    public void solverStarted() {
        Resolution resolution = this.remote.resolution;
        if (resolution != null && resolution.solver instanceof SolverBacktrack) {
            HeuristicVariables hrs = ((SolverBacktrack)resolution.solver).heuristicVars;
            JRadioButton radio = hrs instanceof HeuristicVariablesFixed ? this.staticRadio : (hrs instanceof HeuristicVariablesDynamic ? this.dynamicRadio : this.rawRadio);
            radio.setSelected(true);
            this.hrsCombo.setSelectedItem(hrs.getClass().getSimpleName());
            this.lastModeField.setText(resolution.cp.varh.lastConflictSize + "");
            this.repaint();
        }
    }
}

