/*
 * Decompiled with CFR 0.152.
 */
package tools.remote.panels;

import dashboard.Arguments;
import executables.Resolution;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import problem.Problem;
import problems.BorderArray;
import tools.remote.Remote;
import tools.remote.listeners.ObserverDecisions;
import tools.remote.listeners.ObserverDomains;
import tools.remote.listeners.ObserverMultiple;
import tools.remote.listeners.ObserverVariables;
import tools.remote.listeners.ObserverWdegCtr;
import tools.remote.listeners.ObserverWdegVar;
import tools.remote.listeners.ObsserverPause;
import tools.remote.visualization.TracingChart;
import tools.remote.visualization.Visualization;

public class PanelCommand
extends JPanel {
    private static final String CHOOSE_PROBLEM = "Choose a Problem";
    private static final String CHOOSE_INSTANCE = "Choose a XCSP Instance";
    private static final String COMMAND_TEXT_FIELD_LABEL = "Arguments :";
    private static final String CSP = "CSP";
    private static final String WCSP = "WCSP";
    private static final String MAXCSP = "MAXCSP";
    private static final String COP = "COP";
    private static final String START = "Start";
    private static final String STOP = "Stop";
    private static final String PAUSE = "Pause";
    private static final String RESUME = "Resume";
    private static final String BROWSE = "Browse";
    private Remote remote;
    private JPanel choicePanel;
    private JPanel configureProblemPanel;
    private JRadioButton problemRadio;
    private JComboBox<String> problemCombo;
    private JTextField instanceField;
    private JButton browseButton;
    private JPanel configurationPanel;
    private JTextField commandField;
    private JRadioButton cspRadioButton;
    private JRadioButton wcspRadioButton;
    private JRadioButton maxcspRadioButton;
    private JRadioButton copRadioButton;
    private String[] problemsList = Remote.getArrayFrom(BorderArray.class, Problem.class.getName(), true);

    public PanelCommand(Remote frame) {
        this.remote = frame;
        this.setLayout(new BoxLayout(this, 1));
        this.configureProblemPanel = new JPanel();
        this.configureProblemPanel.setLayout(new BoxLayout(this.configureProblemPanel, 1));
        JPanel problemPanel = new JPanel(new BorderLayout());
        problemPanel.setBorder(new TitledBorder("Problem"));
        JPanel radioPanel = new JPanel();
        radioPanel.setLayout(new BoxLayout(radioPanel, 1));
        ButtonGroup g = new ButtonGroup();
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PanelCommand.this.configureChoosePanel();
            }
        };
        this.problemRadio = Remote.addRadio(CHOOSE_PROBLEM, g, radioPanel, listener);
        Remote.addRadio(CHOOSE_INSTANCE, g, radioPanel, listener);
        this.problemRadio.setSelected(true);
        problemPanel.add((Component)radioPanel, "North");
        this.choicePanel = new JPanel();
        this.problemCombo = new JComboBox<String>(this.problemsList);
        this.instanceField = new JTextField(20);
        this.browseButton = new JButton(BROWSE);
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelCommand.this.openFileChooser();
            }
        });
        problemPanel.add((Component)this.choicePanel, "Center");
        this.configureProblemPanel.add(problemPanel);
        this.configurationPanel = new JPanel(new BorderLayout());
        this.configurationPanel.setBorder(new TitledBorder("Configuration"));
        JPanel p = new JPanel();
        p.add(new JLabel(COMMAND_TEXT_FIELD_LABEL));
        this.commandField = new JTextField(20);
        p.add(this.commandField);
        this.configurationPanel.add((Component)p, "Center");
        this.configureProblemPanel.add(this.configurationPanel);
        this.add(this.configureProblemPanel);
        JPanel resolutionModePanel = new JPanel(new BorderLayout());
        resolutionModePanel.setBorder(new TitledBorder("Resolution Mode"));
        JPanel tmpPanel = new JPanel();
        tmpPanel.setLayout(new BoxLayout(tmpPanel, 1));
        this.cspRadioButton = new JRadioButton(CSP);
        this.wcspRadioButton = new JRadioButton(WCSP);
        this.maxcspRadioButton = new JRadioButton(MAXCSP);
        this.copRadioButton = new JRadioButton(COP);
        ButtonGroup groupMode = new ButtonGroup();
        groupMode.add(this.cspRadioButton);
        groupMode.add(this.wcspRadioButton);
        groupMode.add(this.maxcspRadioButton);
        groupMode.add(this.copRadioButton);
        tmpPanel.add(this.cspRadioButton);
        tmpPanel.add(this.wcspRadioButton);
        tmpPanel.add(this.maxcspRadioButton);
        tmpPanel.add(this.copRadioButton);
        this.cspRadioButton.setSelected(true);
        resolutionModePanel.add((Component)tmpPanel, "Center");
        this.add(resolutionModePanel);
        JPanel startPausePanel = new JPanel();
        final JButton startStopButton = new JButton(START);
        startStopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (startStopButton.getText().equals(PanelCommand.START)) {
                    startStopButton.setText(PanelCommand.STOP);
                    PanelCommand.this.launchAbsCon();
                } else {
                    startStopButton.setText(PanelCommand.START);
                    PanelCommand.this.stopAbsCon();
                }
            }
        });
        startPausePanel.add(startStopButton);
        final JButton pauseResumeButton = new JButton(PAUSE);
        pauseResumeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (pauseResumeButton.getText().equals(PanelCommand.PAUSE)) {
                    pauseResumeButton.setText(PanelCommand.RESUME);
                    ((PanelCommand)PanelCommand.this).remote.resolution.observerRemote.onPause();
                } else {
                    pauseResumeButton.setText(PanelCommand.PAUSE);
                    ((PanelCommand)PanelCommand.this).remote.resolution.observerRemote.onResume();
                }
            }
        });
        startPausePanel.add(pauseResumeButton);
        this.add(startPausePanel);
        this.configureChoosePanel();
    }

    private void launchAbsCon() {
        String cmd;
        String string = cmd = this.problemRadio.isSelected() ? (String)this.problemCombo.getSelectedItem() : this.instanceField.getText().trim();
        if (cmd.length() == 0) {
            System.out.println("Could not find any command : running a toy example instead");
            cmd = "problems.acad.AllInterval 30 -v=0";
        } else if (this.commandField.getText() != null) {
            cmd = cmd + " " + this.commandField.getText().trim();
        }
        cmd = cmd + (this.cspRadioButton.isSelected() ? " -f=csp" : (this.wcspRadioButton.isSelected() ? " -f=wcsp" : (this.maxcspRadioButton.isSelected() ? " -f=maxcsp" : (this.copRadioButton.isSelected() ? " -f=cop" : ""))));
        System.out.println("Testing for " + cmd);
        Arguments.loadArguments(cmd.split(" "));
        Resolution resolution = new Resolution();
        Visualization visualization = new Visualization();
        ObserverMultiple listener = new ObserverMultiple(new ObserverVariables(new TracingChart(visualization.traceVariables)), new ObserverDecisions(new TracingChart(visualization.traceDecisions)), new ObserverWdegCtr(new TracingChart(visualization.traceWdegCtr, TracingChart.EMemorize.X_MEM)), new ObserverWdegVar(new TracingChart(visualization.traceWdegVar, TracingChart.EMemorize.X_MEM)), new ObserverDomains(new TracingChart(visualization.traceDomainsPositive, TracingChart.EMemorize.X_Y_MEM), new TracingChart(visualization.traceDomainsNegative, TracingChart.EMemorize.X_Y_MEM), resolution), new ObsserverPause());
        resolution.observerRemote = listener;
        resolution.start();
        visualization.start();
        this.remote.solverStarted(resolution);
    }

    private void stopAbsCon() {
        this.remote.resolution.stop();
    }

    public void openFileChooser() {
        JFileChooser fc = new JFileChooser();
        if (fc.showDialog(this, "Choose instance") == 0) {
            this.instanceField.setText(fc.getSelectedFile().getAbsolutePath());
        }
    }

    private void configureChoosePanel() {
        this.choicePanel.removeAll();
        if (this.problemRadio.isSelected()) {
            this.choicePanel.add(this.problemCombo);
        } else {
            this.choicePanel.add(this.instanceField);
            this.choicePanel.add(this.browseButton);
        }
        this.choicePanel.repaint();
        this.configureProblemPanel.paintAll(this.configureProblemPanel.getGraphics());
    }
}

