/*
 * Decompiled with CFR 0.152.
 */
package tools.remote.listeners;

import constraints.Constraint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import tools.remote.listeners.ObserverRemote;
import variables.Variable;

public class ObserverMultiple
implements ObserverRemote {
    private final Collection<ObserverRemote> listeners = new ArrayList<ObserverRemote>();

    public ObserverMultiple(ObserverRemote ... listeners) {
        this.listeners.addAll(Arrays.asList(listeners));
    }

    public ObserverMultiple(List<ObserverRemote> listenersList) {
        this.listeners.addAll(listenersList);
    }

    @Override
    public void onAssigned(Variable var, int idx) {
        for (ObserverRemote l : this.listeners) {
            l.onAssigned(var, idx);
        }
    }

    @Override
    public void onBacktrack() {
        for (ObserverRemote l : this.listeners) {
            l.onBacktrack();
        }
    }

    @Override
    public void onWdegModified(Variable var) {
        for (ObserverRemote l : this.listeners) {
            l.onWdegModified(var);
        }
    }

    @Override
    public void onWdegModified(Constraint ctr) {
        for (ObserverRemote l : this.listeners) {
            l.onWdegModified(ctr);
        }
    }

    @Override
    public void onRemoved(Variable var, int idx) {
        for (ObserverRemote l : this.listeners) {
            l.onRemoved(var, idx);
        }
    }

    @Override
    public void onSolutionFound() {
        for (ObserverRemote l : this.listeners) {
            l.onSolutionFound();
        }
    }

    @Override
    public void onPause() {
        for (ObserverRemote l : this.listeners) {
            l.onPause();
        }
    }

    @Override
    public void onResume() {
        for (ObserverRemote l : this.listeners) {
            l.onResume();
        }
    }
}

