/*
 * Decompiled with CFR 0.152.
 */
package tools.remote;

import executables.Resolution;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.text.DefaultCaret;
import tools.remote.panels.PanelCommand;
import tools.remote.panels.PanelConstraints;
import tools.remote.panels.PanelHeuristicsVal;
import tools.remote.panels.PanelHeuristicsVar;
import tools.remote.panels.PanelPropagation;
import tools.remote.panels.PanelRestarts;
import utility.Kit;
import utility.Reflector;
import utility.interfaces.TagExperimental;

public class Remote
extends JFrame {
    public Resolution resolution;
    private PanelRestarts panelRestarts;
    private PanelHeuristicsVar panelVarHeuristic;
    private PanelHeuristicsVal panelValHeuristic;
    private PanelPropagation panelPropagation;
    private PanelConstraints panelConstraints;

    private static Set<String> findNamesOfClassesInheritingFrom(String packageName, Class<?> rootClass, boolean fullName) {
        String DOT_CLASS = ".class";
        HashSet<String> set = new HashSet<String>();
        String name = packageName.startsWith("/") ? packageName : "/" + packageName;
        URL url = Reflector.class.getResource(name = name.replace('.', '/'));
        if (url == null) {
            return null;
        }
        File directory = new File(url.getFile());
        if (directory.exists()) {
            File[] dirs;
            for (String file : directory.list()) {
                if (!file.endsWith(".class") || file.contains("$") || name.contains("crossword") || name.contains("pseudo")) continue;
                String classname = file.substring(0, file.length() - ".class".length());
                try {
                    Class<?> clazz = Class.forName(packageName + "." + classname);
                    if (!rootClass.isAssignableFrom(clazz) || clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers()) || TagExperimental.class.isAssignableFrom(clazz)) continue;
                    set.add(fullName ? packageName + "." + classname : classname);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            for (File dir : dirs = directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return new File(dir.getAbsolutePath() + "/" + name).isDirectory();
                }
            })) {
                String subpackageName = packageName + "." + dir.getName();
                Set<String> tmp = Remote.findNamesOfClassesInheritingFrom(subpackageName, rootClass, fullName);
                if (tmp == null) continue;
                set.addAll(tmp);
            }
        } else {
            try {
                JarURLConnection connection = (JarURLConnection)url.openConnection();
                String starts = connection.getEntryName();
                Enumeration<JarEntry> entries = connection.getJarFile().entries();
                while (entries.hasMoreElements()) {
                    Class<?> clazz;
                    String entryName = entries.nextElement().getName();
                    if (!entryName.startsWith(starts) || !entryName.endsWith(".class")) continue;
                    String classname = entryName.substring(0, entryName.length() - ".class".length());
                    if (classname.startsWith("/")) {
                        classname = classname.substring(1);
                    }
                    if (!rootClass.isAssignableFrom(clazz = Class.forName(classname = classname.replace('/', '.'))) || clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) continue;
                    set.add(fullName ? classname : classname.substring(classname.lastIndexOf(46) + 1));
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return set;
    }

    private static Set<String> findNamesOfClassesInheritingFrom(String packageName, String rootClassName, boolean fullName) {
        HashSet<String> set = new HashSet();
        try {
            set = Remote.findNamesOfClassesInheritingFrom(packageName, Class.forName(rootClassName), fullName);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Class " + rootClassName + " not found!");
        }
        return set;
    }

    public static String[] getArrayFrom(Class<?> packageSubclassName, String rootClassName, boolean fullName) {
        return Kit.sort(Remote.findNamesOfClassesInheritingFrom(packageSubclassName.getPackage().getName(), rootClassName, fullName).toArray(new String[0]));
    }

    public static JRadioButton addRadio(String text, ButtonGroup group, JPanel panel, ActionListener listener) {
        JRadioButton radio = new JRadioButton(text);
        radio.addActionListener(listener);
        group.add(radio);
        panel.add(radio);
        return radio;
    }

    private void setMenu() {
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu fileMenu = new JMenu("File");
        menuBar.add(fileMenu);
        JMenuItem quitItem = new JMenuItem("Quit");
        quitItem.addActionListener(e -> System.exit(0));
        fileMenu.add(quitItem);
    }

    public Remote() {
        super("AbsCon Remote");
        this.setMenu();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JTabbedPane tabbedPane = new JTabbedPane(1);
        tabbedPane.addTab("Problem", new PanelCommand(this));
        this.panelRestarts = new PanelRestarts(this);
        tabbedPane.addTab("Restarter", this.panelRestarts);
        this.panelVarHeuristic = new PanelHeuristicsVar(this);
        tabbedPane.addTab("Variable Heuristic", this.panelVarHeuristic);
        this.panelValHeuristic = new PanelHeuristicsVal(this);
        tabbedPane.addTab("Value Heuristic", this.panelValHeuristic);
        this.panelPropagation = new PanelPropagation(this);
        tabbedPane.addTab("Propagation", this.panelPropagation);
        this.panelConstraints = new PanelConstraints(this);
        tabbedPane.addTab("Constraints", this.panelConstraints);
        this.getContentPane().add(tabbedPane);
        JTextArea console = new JTextArea(15, 50);
        ((DefaultCaret)console.getCaret()).setUpdatePolicy(2);
        System.setOut(new PrintStream(new JTextAreaOutputStream(console)));
        JScrollPane scrollPane = new JScrollPane(console);
        scrollPane.setMinimumSize(new Dimension(100, 350));
        scrollPane.setPreferredSize(new Dimension(100, 350));
        this.getContentPane().add(scrollPane);
        this.setDefaultCloseOperation(3);
        this.pack();
        this.setVisible(true);
    }

    public void solverStarted(Resolution resolution) {
        this.resolution = resolution;
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.panelRestarts.solverStarted();
        this.panelVarHeuristic.solverStarted();
        this.panelValHeuristic.solverStarted();
        this.panelPropagation.solverStarted();
        this.panelConstraints.solverStarted();
        this.repaint();
    }

    public static void main(String[] args) {
        new Remote();
    }

    private class JTextAreaOutputStream
    extends OutputStream {
        private JTextArea textArea;

        public JTextAreaOutputStream(JTextArea textArea) {
            this.textArea = textArea;
        }

        @Override
        public void write(int b) {
            byte[] bytes = new byte[]{(byte)b};
            String s = new String(bytes);
            this.textArea.append(s);
            this.textArea.repaint();
        }

        @Override
        public void write(byte[] bytes) {
            String s = new String(bytes);
            this.textArea.append(s);
            this.textArea.repaint();
        }
    }
}

