/*
 * Decompiled with CFR 0.152.
 */
package tools.random;

import dashboard.Arguments;
import executables.Resolution;
import org.xcsp.common.Utilities;
import problems.rand.ExplicitRandomQuestion;
import utility.Kit;

public class ModelRB {
    private static boolean respectCondition1(int k, double alpha) {
        return alpha > 1.0 / (double)k;
    }

    private static boolean respectCondition2(int k, double alpha, double r) {
        return (double)k * Math.exp(-alpha / r) >= 1.0;
    }

    private static void manageThreshod(double alpha, double r) {
        System.out.println("\t The threshold value is pcrit = " + (1.0 - Math.exp(-alpha / r)));
    }

    private static void manageTheorem2(int k, double alpha, double r) {
        if (ModelRB.respectCondition1(k, alpha) && ModelRB.respectCondition2(k, alpha, r)) {
            System.out.println("\t Theorem 2 is valid");
            System.out.println("\t  - as alpha = " + alpha + " is strictly greater than 1/k = " + 1.0 / (double)k);
            System.out.println("\t  - as ke^(-alpha/r) = " + (double)k * Math.exp(-alpha / r) + " is greater than or equal to 1");
        } else {
            System.out.println("\t Theorem 2 is not valid");
            if (!ModelRB.respectCondition1(k, alpha)) {
                System.out.println("\t  - as alpha = " + alpha + " is not strictly greater than 1/k = " + 1.0 / (double)k);
            }
            if (!ModelRB.respectCondition2(k, alpha, r)) {
                System.out.println("\t  - as ke^(-alpha/r) = " + (double)k * Math.exp(-alpha / r) + " is not greater than or equal to 1");
            }
        }
    }

    private static void usage0(String[] args) {
        int k = Utilities.toInteger((String)args[0], v -> v >= 2);
        double alpha = Utilities.toDouble((String)args[1]);
        double r = Utilities.toDouble((String)args[2]);
        Kit.control(alpha > 0.0 && r > 0.0);
        ModelRB.manageThreshod(alpha, r);
        ModelRB.manageTheorem2(k, alpha, r);
    }

    private static void usage1(String[] args) {
        int k = Utilities.toInteger((String)args[0], v -> v >= 2);
        int n = Utilities.toInteger((String)args[1], v -> v >= 2);
        double alpha = Utilities.toDouble((String)args[2]);
        double r = Utilities.toDouble((String)args[3]);
        ModelRB.manageThreshod(alpha, r);
        ModelRB.manageTheorem2(k, alpha, r);
        int d = (int)Math.round(Math.pow(n, alpha));
        int m = (int)Math.round(r * (double)n * Math.log(n));
        double realAlpha = Math.log(d) / Math.log(n);
        double realR = (double)m / ((double)n * Math.log(n));
        double realCrit = 1.0 - Math.pow(Math.E, -realAlpha / realR);
        System.out.println("\t Rounding values gives:");
        System.out.println("\t -  the domain size d  = " + d + " (alpha = " + realAlpha + ")");
        System.out.println("\t  - the number of constraints m = " + m + "(r = " + realR + ")");
        System.out.println("\t  - the threshold value pcrit = " + realCrit);
    }

    private static void usage2(String[] args) {
        int k = Utilities.toInteger((String)args[0], v -> v >= 2);
        int n = Utilities.toInteger((String)args[1], v -> v >= 2);
        int d = Utilities.toInteger((String)args[2], v -> v >= 2);
        int m = Utilities.toInteger((String)args[3], v -> v >= 2);
        double alpha = Math.log(d) / Math.log(n);
        double r = (double)m / ((double)n * Math.log(n));
        System.out.println("\t We have:");
        System.out.println("\t -  alpha = " + alpha);
        System.out.println("\t -  r = " + r);
        ModelRB.manageThreshod(alpha, r);
        ModelRB.manageTheorem2(k, alpha, r);
    }

    private static void usage3(String[] args) {
        int delta;
        double realR;
        int k = Utilities.toInteger((String)args[0], v -> v >= 2);
        int n = Utilities.toInteger((String)args[1], v -> v >= 2);
        double alpha = Utilities.toDouble((String)args[2]);
        double r = Utilities.toDouble((String)args[3]);
        int d = (int)Math.round(Math.pow(n, alpha));
        int e = (int)Math.round(r * (double)n * Math.log(n));
        double realAlpha = Math.log(d) / Math.log(n);
        double realCrit = 1.0 - Math.pow(Math.E, -realAlpha / (realR = (double)e / ((double)n * Math.log(n))));
        int roundedRealCrit = (int)Math.round(realCrit * 1000.0);
        int t = roundedRealCrit + (delta = Utilities.toInteger((String)args[4]).intValue());
        Kit.control(t >= 0 && t <= 1000, () -> "parameter should be between 0 and 1000");
        boolean forced = Utilities.toBoolean((String)args[5]);
        boolean merged = Utilities.toBoolean((String)args[6]);
        int seed = Utilities.toInteger((String)args[7], v -> v >= 0);
        int nbInstances = Utilities.toInteger((String)args[8], v -> v >= 1);
        String s = nbInstances + " " + ExplicitRandomQuestion.class.getName() + " " + n + " " + d + " " + e + " " + k + " 1 " + (double)t / 1000.0 + " " + seed + " 0  0 " + (merged ? "n" : "y") + " " + (forced ? "y" : "n") + " n 0 -export=file";
        System.out.println("Command : " + s);
        Arguments.loadArguments(s.split("\\s+"));
        new Resolution().start();
    }

    public static void main(String[] args) {
        if (args.length == 3) {
            ModelRB.usage0(args);
        } else if (args.length == 4) {
            ModelRB.usage1(args);
        } else if (args.length == 5) {
            ModelRB.usage2(args);
        } else if (args.length == 9) {
            ModelRB.usage3(args);
        } else {
            System.out.println("GeneratorRB 2.0");
            System.out.println("usage 0: java " + ModelRB.class.getName() + " <arity> <alpha> <r>");
            System.out.println("usage 1: java " + ModelRB.class.getName() + " <arity> <nVariables> <alpha> <r>");
            System.out.println("usage 2: java " + ModelRB.class.getName() + " <arity> <nVariables> <domainSize> <nConstraints> <tightness>");
            System.out.println("usage 3: java " + ModelRB.class.getName() + " <arity> <nVariables> <alpha> <r> <delta> <forced> <merged> <seed> <nInstances>");
        }
    }
}

