/*
 * Decompiled with CFR 0.152.
 */
package search.local.neighborHeuristics;

import search.local.SolverLocal;
import search.local.neighborHeuristics.HeuristicNeighborsUnit;
import variables.Variable;

public class BestGlobal
extends HeuristicNeighborsUnit {
    private int evaluationLimit = 0;

    public BestGlobal(SolverLocal solver) {
        super(solver);
    }

    private void assess(Variable x, boolean b) {
        if (x == this.lastAssignedVariable || x.dom.size() == 1) {
            return;
        }
        int variableEvaluation = this.solverLocal.conflictManager.currEvaluationOf(x);
        if (this.bestEvolution < -variableEvaluation || variableEvaluation < this.evaluationLimit == b) {
            return;
        }
        int idx = this.selectIndexWithLowestEvolution(x, this.bestEvolution);
        if (idx == -1) {
            return;
        }
        assert (this.localBestEvolution <= this.bestEvolution);
        if (this.localBestEvolution < this.bestEvolution) {
            this.bestVariable = x;
            this.bestIndex = idx;
            this.bestEvolution = this.localBestEvolution;
        } else {
            assert (this.localBestEvolution == this.bestEvolution);
            if (this.counters[x.num] < this.counters[this.bestVariable.num]) {
                this.bestVariable = x;
                this.bestIndex = idx;
            }
        }
    }

    @Override
    public void selectNeighbor() {
        int position;
        int i;
        this.bestVariable = null;
        this.bestIndex = -1;
        this.bestEvolution = Integer.MAX_VALUE;
        Variable[] variables = this.solverLocal.decisionVars;
        for (i = position = this.random.nextInt(variables.length); i < variables.length; ++i) {
            this.assess(variables[i], true);
        }
        for (i = 0; i < position; ++i) {
            this.assess(variables[i], true);
        }
        if (this.evaluationLimit != 0 && this.bestEvolution > -this.evaluationLimit) {
            for (i = position; i < variables.length; ++i) {
                this.assess(variables[i], false);
            }
            for (i = 0; i < position; ++i) {
                this.assess(variables[i], false);
            }
        }
    }
}

