/*
 * Decompiled with CFR 0.152.
 */
package search.backtrack.decomposers;

import search.backtrack.decomposers.Decomposer;
import search.backtrack.decomposers.DecomposerSolver;
import variables.Variable;
import variables.domains.Domain;

public class SplitterDecomposer
extends Decomposer {
    private Variable var;
    private int nbPieces;
    private Variable varo;
    private int[] t = new int[this.nMaxValidTuples().intValueExact()];
    private int tlength;

    public SplitterDecomposer(DecomposerSolver solver) {
        super(solver);
    }

    @Override
    public int getNbPieces() {
        return this.nbPieces;
    }

    @Override
    public void initialize(Variable var) {
        this.var = var;
    }

    @Override
    public void split() {
        this.varo = this.solver.heuristicVars.bestVar();
        Domain dom = this.varo.dom;
        int size = dom.size();
        if (this.varo == this.var || size == 1) {
            this.nbPieces = 1;
        } else {
            int i = 0;
            int idx = dom.first();
            while (idx != -1) {
                this.t[i++] = idx;
                idx = dom.next(idx);
            }
            this.tlength = i;
            this.nbPieces = 2;
        }
    }

    @Override
    public int buildPiece(int num) {
        if (this.nbPieces == 1) {
            return 1;
        }
        if (num == 0) {
            for (int i = 0; i < this.tlength / 2; ++i) {
                this.varo.dom.removeElementary(this.t[i]);
            }
        } else {
            for (int i = this.tlength / 2; i < this.tlength; ++i) {
                this.varo.dom.removeElementary(this.t[i]);
            }
        }
        return this.solver.propagation.runAfterRefutation(this.varo) ? 1 : 0;
    }
}

