/*
 * Decompiled with CFR 0.152.
 */
package search.backtrack;

import java.util.stream.Stream;
import search.Solver;
import utility.observers.ObserverBacktrackingUnsystematic;
import variables.Variable;

public final class GlobalObserver {
    private Solver solver;
    public int top = -1;
    public final ObserverBacktrackingUnsystematic[] stack;

    public void reset() {
        this.top = -1;
    }

    public GlobalObserver(Solver solver, int size) {
        this.solver = solver;
        this.stack = new ObserverBacktrackingUnsystematic[size];
    }

    public void push(ObserverBacktrackingUnsystematic oberver) {
        if (this.top == -1 || this.stack[this.top].lastModificationDepth() != this.solver.depth()) {
            this.stack[++this.top] = null;
        }
        this.stack[++this.top] = oberver;
    }

    public void restoreAtDepthBefore(int depthBeforeBacktrack) {
        if (this.top == -1 || this.stack[this.top].lastModificationDepth() < depthBeforeBacktrack) {
            return;
        }
        while (this.stack[this.top] != null) {
            this.stack[this.top].restoreAtDepthBefore(depthBeforeBacktrack);
            --this.top;
        }
        --this.top;
        assert (this.controlStack(depthBeforeBacktrack));
    }

    private boolean controlStack(int depthBeforeBacktrack) {
        if (this.top >= 0 && this.stack[this.top] == null) {
            return false;
        }
        return this.top <= -1 || !(this.stack[this.top] instanceof Variable ? Stream.of(this.solver.pb.variables).anyMatch(x -> x.lastModificationDepth() >= depthBeforeBacktrack) : Stream.of(this.solver.pb.constraints).anyMatch(c -> c.extStructure() instanceof ObserverBacktrackingUnsystematic && ((ObserverBacktrackingUnsystematic)((Object)c.extStructure())).lastModificationDepth() >= depthBeforeBacktrack));
    }
}

