/*
 * Decompiled with CFR 0.152.
 */
package propagation.structures.revisers;

import constraints.CtrHard;
import propagation.order1.PropagationForward;
import variables.Variable;

public abstract class Reviser {
    protected PropagationForward propagation;
    public long nRevisions;
    public long nUselessRevisions;

    public Reviser(PropagationForward propagation) {
        this.propagation = propagation;
    }

    public abstract boolean mustBeAppliedTo(CtrHard var1, Variable var2);

    public abstract void applyTo(CtrHard var1, Variable var2);

    public final boolean revise(CtrHard c, Variable x) {
        assert (!x.isAssigned() && c.involves(x));
        if (this.mustBeAppliedTo(c, x)) {
            ++this.nRevisions;
            int sizeBefore = x.dom.size();
            this.applyTo(c, x);
            int sizeAfter = x.dom.size();
            if (sizeBefore == sizeAfter) {
                ++this.nUselessRevisions;
            } else if (!this.propagation.handleReduction(x, sizeAfter)) {
                return false;
            }
        }
        return true;
    }
}

