/*
 * Decompiled with CFR 0.152.
 */
package propagation.soft.sac;

import constraints.Constraint;
import constraints.CtrSoft;
import constraints.soft.extension.CtrSoftExtension;
import constraints.soft.extension.structures.SoftMatrix2D;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import propagation.PropagationQueue;
import propagation.structures.supporters.SupporterSoft;
import search.Solver;
import search.backtrack.DecisionRecorder;
import search.backtrack.SolverBacktrack;
import utility.Kit;
import utility.operations.Calculator;
import variables.Variable;
import variables.domains.Domain;

public class SoftSubstitutor {
    private Solver solver;
    private DecisionRecorder dr;
    private long[][] c1s;
    private PropagationQueue queue;
    private int nbRemovedSubstitutableValues;
    private long[][] sumMaxCosts;
    private Set<Integer> valuesToBeRemoved = new HashSet<Integer>();
    private Constraint[][] residues1;
    private Constraint[][][] residues;
    private Kit.IntLongPair[] currentPairs;
    long timestamp;
    int testSub;
    private int[] t = new int[2];
    private boolean test = false;

    private void buildSubStructures() {
        int j;
        int size22;
        Constraint ctr;
        int n;
        Constraint firstNonUnaryConstraint;
        int i;
        Variable[] variables = this.solver.pb.variables;
        this.sumMaxCosts = Variable.litterals(variables).longArray();
        this.residues1 = new Constraint[variables.length][];
        for (i = 0; i < variables.length; ++i) {
            firstNonUnaryConstraint = null;
            Constraint[] constraintArray = variables[i].ctrs;
            int n2 = constraintArray.length;
            for (n = 0; n < n2; ++n) {
                ctr = constraintArray[n];
                if (ctr.scp.length <= 1) continue;
                firstNonUnaryConstraint = ctr;
                break;
            }
            size22 = variables[i].dom.initSize();
            this.residues1[i] = new Constraint[size22];
            for (j = 0; j < size22; ++j) {
                this.residues1[i][j] = firstNonUnaryConstraint;
            }
        }
        this.residues = new Constraint[variables.length][][];
        for (i = 0; i < variables.length; ++i) {
            firstNonUnaryConstraint = null;
            Constraint[] size22 = variables[i].ctrs;
            j = size22.length;
            for (n = 0; n < j; ++n) {
                ctr = size22[n];
                if (ctr.scp.length <= 1) continue;
                firstNonUnaryConstraint = ctr;
                break;
            }
            size22 = variables[i].dom.initSize();
            this.residues[i] = new Constraint[size22][size22];
            for (j = 0; j < size22; ++j) {
                for (int k = 0; k < size22; ++k) {
                    if (j == k) continue;
                    this.residues[i][j][k] = firstNonUnaryConstraint;
                }
            }
        }
        this.currentPairs = new Kit.IntLongPair[Variable.maxInitDomSize(variables)];
        for (i = 0; i < this.currentPairs.length; ++i) {
            this.currentPairs[i] = new Kit.IntLongPair();
        }
    }

    public SoftSubstitutor(Solver solver, long[][] c1s, PropagationQueue queue) {
        this.solver = solver;
        this.dr = ((SolverBacktrack)solver).dr;
        this.c1s = c1s;
        this.queue = queue;
        this.testSub = solver.rs.cp.optimizing.softSubstituability;
        if (this.testSub != 0) {
            this.buildSubStructures();
        }
    }

    public int getNbRemovedSubstitutableValues() {
        return this.nbRemovedSubstitutableValues;
    }

    private void updateNbRemovedSubstitutableValues(int increment) {
        this.nbRemovedSubstitutableValues += increment;
        if (this.solver.depth() == 0) {
            Kit.log.info("nbRemovedSubstitutableValues=" + this.nbRemovedSubstitutableValues);
        }
    }

    private void removeValues() {
        this.updateNbRemovedSubstitutableValues(this.valuesToBeRemoved.size());
        for (int negativeDecision : this.valuesToBeRemoved) {
            Variable var = this.dr.varIn(negativeDecision);
            var.dom.removeElementary(this.dr.idxIn(negativeDecision));
            this.queue.add(var);
        }
    }

    private boolean removeSubstitutableValues1() {
        this.valuesToBeRemoved.clear();
        Variable x = this.solver.futVars.first();
        while (x != null) {
            Domain dom = x.dom;
            int a = dom.first();
            while (a != -1) {
                long sum = this.c1s[x.num][a];
                for (Constraint c : x.ctrs) {
                    if (c.scp.length <= 1) continue;
                    assert (((SupporterSoft)c.supporter()).findMinCostFor(x, a) == 0L) : c + " " + x;
                    sum = Calculator.add(sum, ((CtrSoftExtension)c).getMaxCostFor(c.positionOf(x), a));
                }
                this.sumMaxCosts[x.num][a] = Math.min(Integer.MAX_VALUE, sum);
                a = dom.next(a);
            }
            int idx1 = dom.first();
            while (idx1 != -1) {
                int idx2 = dom.next(idx1);
                while (idx2 != -1) {
                    if (this.c1s[x.num][idx2] >= this.sumMaxCosts[x.num][idx1]) {
                        this.valuesToBeRemoved.add(this.dr.negativeDecisionFor(x.num, idx2));
                    } else if (this.c1s[x.num][idx1] >= this.sumMaxCosts[x.num][idx2]) {
                        this.valuesToBeRemoved.add(this.dr.negativeDecisionFor(x.num, idx1));
                        break;
                    }
                    idx2 = dom.next(idx2);
                }
                idx1 = dom.next(idx1);
            }
            x = this.solver.futVars.next(x);
        }
        this.removeValues();
        return true;
    }

    private boolean removeSubstitutableValues1Bis() {
        int nbRemovedValuesBefore = this.solver.pb.nValuesRemoved;
        Variable x = this.solver.futVars.first();
        while (x != null) {
            Domain dom = x.dom;
            int a = dom.first();
            while (a != -1) {
                long sum = this.c1s[x.num][a];
                for (Constraint c : x.ctrs) {
                    if (c.scp.length <= 1) continue;
                    sum = Calculator.add(sum, ((CtrSoftExtension)c).getMaxCostFor(c.positionOf(x), a));
                }
                this.sumMaxCosts[x.num][a] = Math.min(Integer.MAX_VALUE, sum);
                a = dom.next(a);
            }
            int sizeBefore = dom.size();
            int a2 = dom.first();
            while (a2 != -1) {
                int b = dom.first();
                while (b != -1) {
                    if (a2 != b && this.c1s[x.num][b] >= this.sumMaxCosts[x.num][a2]) {
                        x.dom.removeElementary(b);
                    }
                    b = dom.next(b);
                }
                a2 = dom.next(a2);
            }
            assert (dom.size() > 0);
            if (dom.size() != sizeBefore) {
                this.queue.add(x);
            }
            x = this.solver.futVars.next(x);
        }
        this.updateNbRemovedSubstitutableValues(this.solver.pb.nValuesRemoved - nbRemovedValuesBefore);
        return true;
    }

    private int sortPairs(Variable var) {
        Domain dom = var.dom;
        int nbPairs = 0;
        int idx = dom.first();
        while (idx != -1) {
            Kit.IntLongPair pair = this.currentPairs[nbPairs++];
            pair.index = idx;
            pair.value = this.c1s[var.num][idx];
            idx = dom.next(idx);
        }
        Arrays.sort(this.currentPairs, 0, nbPairs);
        return nbPairs;
    }

    private boolean removeSubstitutableValues1Ter() {
        this.valuesToBeRemoved.clear();
        Variable x = this.solver.futVars.first();
        while (x != null) {
            int nbPairs = this.sortPairs(x);
            long tieValue = -1L;
            int tieFrontier = -1;
            int left = 0;
            int right = nbPairs - 1;
            while (left < right) {
                long initialDifference = Calculator.add(this.currentPairs[right].value, -this.currentPairs[left].value);
                assert (initialDifference >= 0L) : initialDifference + " " + left + " " + right;
                int indexLeft = this.currentPairs[left].index;
                long currentDifference = initialDifference;
                Constraint residue = this.residues1[x.num][indexLeft];
                if ((currentDifference = Calculator.add(currentDifference, -(residue != null ? ((CtrSoftExtension)residue).getMaxCostFor(residue.positionOf(x), indexLeft, currentDifference) : 0L))) >= 0L) {
                    for (Constraint ctr : x.ctrs) {
                        if (ctr.scp.length <= 1 || ctr == residue) continue;
                        long d = ((CtrSoftExtension)ctr).getMaxCostFor(ctr.positionOf(x), indexLeft, currentDifference);
                        if (d > initialDifference) {
                            this.residues1[x.num][indexLeft] = ctr;
                        }
                        if ((currentDifference = Calculator.add(currentDifference, -d)) < 0L) break;
                    }
                }
                if (currentDifference < 0L) {
                    long value = this.currentPairs[left].value;
                    if (value == this.currentPairs[left + 1].value) {
                        if (value == tieValue) {
                            if (left + 1 == tieFrontier) {
                                left += 2;
                                while (left < right && value == this.currentPairs[left].value) {
                                    ++left;
                                }
                                continue;
                            }
                            assert (left < tieFrontier - 1);
                            Kit.swap(this.currentPairs, --tieFrontier, left);
                            continue;
                        }
                        tieValue = value;
                        tieFrontier = left + 1;
                        while (tieFrontier + 1 < right && value == this.currentPairs[tieFrontier + 1].value) {
                            ++tieFrontier;
                        }
                        Kit.swap(this.currentPairs, tieFrontier, left);
                        continue;
                    }
                    ++left;
                    continue;
                }
                long maxLeftCost = Calculator.add(this.currentPairs[right].value, -currentDifference);
                Kit.control(maxLeftCost <= this.currentPairs[right].value);
                this.valuesToBeRemoved.add(this.dr.negativeDecisionFor(x.num, this.currentPairs[right].index));
                --right;
                while (left < right && maxLeftCost <= this.currentPairs[right].value) {
                    this.valuesToBeRemoved.add(this.dr.negativeDecisionFor(x.num, this.currentPairs[right].index));
                    --right;
                }
            }
            x = this.solver.futVars.next(x);
        }
        this.removeValues();
        return true;
    }

    private long computeDiff(Variable var, int idx1, int idx2) {
        long upperBound = this.solver.solManager.bestBound;
        long initialDifference = Calculator.add(this.c1s[var.num][idx2], -this.c1s[var.num][idx1]);
        if (initialDifference < 0L) {
            return initialDifference;
        }
        long currentDifference = initialDifference;
        Constraint residue = this.residues[var.num][idx1][idx2];
        if ((currentDifference = Calculator.add(currentDifference, residue != null ? ((CtrSoft)residue).getMinDiffCostTupleFor(residue.positionOf(var), idx1, idx2, upperBound, -currentDifference) : 0L)) < 0L) {
            return currentDifference;
        }
        for (Constraint ctr : var.ctrs) {
            if (ctr.scp.length == 1 || ctr == residue) continue;
            long d = ((CtrSoft)ctr).getMinDiffCostTupleFor(ctr.positionOf(var), idx1, idx2, upperBound, -currentDifference);
            assert (Math.abs(this.testSub) != 11 || d <= 0L && d >= -upperBound) : "Since AC*";
            if (d < -initialDifference) {
                this.residues[var.num][idx1][idx2] = ctr;
            }
            if ((currentDifference = Calculator.add(currentDifference, d)) >= 0L) continue;
            return currentDifference;
        }
        return currentDifference;
    }

    private long computeFullDiff(Variable var, int idx1, int idx2) {
        long upperBound = this.solver.solManager.bestBound;
        long currentDifference = Calculator.add(this.c1s[var.num][idx2], -this.c1s[var.num][idx1]);
        for (Constraint ctr : var.ctrs) {
            if (ctr.scp.length == 1) continue;
            long d = ((CtrSoft)ctr).getMinDiffCostTupleFor(ctr.positionOf(var), idx1, idx2, upperBound, Long.MIN_VALUE);
            assert (Math.abs(this.testSub) != 11 || d <= 0L && d >= -upperBound) : "Since AC*";
            if ((currentDifference = Calculator.add(currentDifference, d)) > -upperBound) continue;
            return currentDifference;
        }
        return currentDifference;
    }

    private void removeSubstitutableTuples3() {
        long upperBound = this.solver.solManager.bestBound;
        for (Variable var1 : this.solver.pb.variables) {
            Domain dom = var1.dom;
            int idxa = dom.first();
            while (idxa != -1) {
                int idxb = dom.first();
                while (idxb != -1) {
                    long fullDifference;
                    if (idxa != idxb && (fullDifference = this.computeFullDiff(var1, idxa, idxb)) > -upperBound) {
                        for (Variable var2 : this.solver.pb.variables) {
                            CtrSoftExtension constraint;
                            if (var2 == var1 || (constraint = (CtrSoftExtension)var2.firstBinaryConstraintWith(var1)) == null) continue;
                            int vap1 = constraint.positionOf(var1);
                            int vap2 = vap1 == 1 ? 0 : 1;
                            long fulld = Calculator.add(fullDifference, -constraint.getMinDiffCostTupleFor(vap1, idxa, idxb, upperBound, Long.MIN_VALUE));
                            this.t[vap1] = idxb;
                            Domain dom2 = var2.dom;
                            int idx2 = dom2.first();
                            while (idx2 != -1) {
                                long gap;
                                this.t[vap2] = idx2;
                                long cost2 = constraint.costOfIdxs(this.t);
                                if (cost2 < upperBound && (gap = Calculator.add(fulld, cost2)) >= 0L) {
                                    this.t[vap1] = idxa;
                                    long cost1 = constraint.costOfIdxs(this.t);
                                    this.t[vap1] = idxb;
                                    if (Calculator.add(gap, -cost1) >= 0L) {
                                        ((SoftMatrix2D)constraint.extStructure()).setCostOfIndexes(this.t, upperBound);
                                    }
                                }
                                idx2 = dom2.next(idx2);
                            }
                        }
                    }
                    idxb = dom.next(idxb);
                }
                idxa = dom.next(idxa);
            }
        }
    }

    private boolean isSubEligible(Variable var) {
        if (this.timestamp == 0L) {
            return true;
        }
        for (Variable varSib : var.getNeighbours()) {
            if (varSib.timestamp <= this.timestamp) continue;
            return true;
        }
        return false;
    }

    private boolean removeSubstitutableValues2() {
        this.valuesToBeRemoved.clear();
        Variable x = this.solver.futVars.first();
        while (x != null) {
            if (this.isSubEligible(x)) {
                int b;
                if (this.test) {
                    int nbPairs = this.sortPairs(x);
                    block1: for (int right = nbPairs - 1; right >= 0; --right) {
                        b = this.currentPairs[right].index;
                        if (b == -1) continue;
                        for (int left = 0; left < right; ++left) {
                            int a = this.currentPairs[left].index;
                            if (a == -1) continue;
                            if (this.computeDiff(x, a, b) >= 0L) {
                                this.valuesToBeRemoved.add(this.dr.negativeDecisionFor(x.num, b));
                                this.currentPairs[right].index = -1;
                                continue block1;
                            }
                            if (this.computeDiff(x, b, a) < 0L) continue;
                            this.valuesToBeRemoved.add(this.dr.negativeDecisionFor(x.num, a));
                            this.currentPairs[left].index = -1;
                        }
                    }
                } else {
                    Domain dom = x.dom;
                    int a = dom.first();
                    while (a != -1) {
                        b = dom.next(a);
                        while (b != -1) {
                            if (this.computeDiff(x, a, b) >= 0L) {
                                this.valuesToBeRemoved.add(this.dr.negativeDecisionFor(x.num, b));
                            } else if (this.computeDiff(x, b, a) >= 0L) {
                                this.valuesToBeRemoved.add(this.dr.negativeDecisionFor(x.num, a));
                                break;
                            }
                            b = dom.next(b);
                        }
                        a = dom.next(a);
                    }
                }
            }
            x = this.solver.futVars.next(x);
        }
        this.timestamp = this.solver.propagation.incrementTime();
        int nbRemovals = this.valuesToBeRemoved.size();
        this.removeValues();
        if (this.testSub == 13 && nbRemovals == 0 && this.solver.depth() == 0) {
            this.removeSubstitutableTuples3();
        }
        return true;
    }

    private boolean removeSubstitutableValues2Bis() {
        int nbRemovedValuesBefore = this.solver.pb.nValuesRemoved;
        Variable x = this.solver.futVars.first();
        while (x != null) {
            Domain dom = x.dom;
            int sizeBefore = dom.size();
            int a = dom.first();
            while (a != -1) {
                int b = dom.first();
                while (b != -1) {
                    if (b != a && this.computeDiff(x, a, b) >= 0L) {
                        x.dom.removeElementary(b);
                    }
                    b = dom.next(b);
                }
                a = dom.next(a);
            }
            assert (dom.size() > 0);
            if (dom.size() != sizeBefore) {
                this.queue.add(x);
            }
            x = this.solver.futVars.next(x);
        }
        this.updateNbRemovedSubstitutableValues(this.solver.pb.nValuesRemoved - nbRemovedValuesBefore);
        return true;
    }

    boolean removeSubstitutableValues() {
        if (this.testSub == 0) {
            return true;
        }
        int ts = Math.abs(this.testSub);
        if (ts == 11 || ts == 13) {
            return this.removeSubstitutableValues2();
        }
        assert (ts == 12);
        return this.removeSubstitutableValues2Bis();
    }

    boolean isSubConsistent() {
        if (this.testSub == 0) {
            return true;
        }
        for (Variable var : this.solver.pb.variables) {
            Domain dom = var.dom;
            int idx1 = dom.first();
            while (idx1 != -1) {
                int idx2 = dom.next(idx1);
                while (idx2 != -1) {
                    if (this.computeDiff(var, idx1, idx2) >= 0L || this.computeDiff(var, idx2, idx1) >= 0L) {
                        Kit.log.info("pb sub with " + var + "  " + idx1 + " " + idx2 + " " + Kit.join((Object)var.getNeighbours(), new String[0]));
                        return false;
                    }
                    idx2 = dom.next(idx2);
                }
                idx1 = dom.next(idx1);
            }
        }
        return true;
    }
}

