/*
 * Decompiled with CFR 0.152.
 */
package propagation.soft.pfc;

import constraints.Constraint;
import propagation.soft.pfc.PFC;
import propagation.soft.pfc.PartitionOfConstraints;
import search.Solver;
import utility.Kit;
import utility.exceptions.UnreachableCodeException;
import utility.operations.Calculator;
import variables.Variable;
import variables.domains.Domain;

public class RDAC_WCSP_STR
extends PFC {
    protected long timestamp;

    public RDAC_WCSP_STR(Solver solver) {
        super(solver);
        this.partitionOfConstraints = new PartitionOfConstraintsW2(solver);
    }

    @Override
    protected long computeMniOf(Variable x, boolean recomputeNbInconsistencies) {
        long ub = this.solver.solManager.bestBound;
        long[] t = this.sumMinCosts[x.num];
        int argMin = -1;
        int argMax = -1;
        Domain dom = x.dom;
        int a = dom.first();
        while (a != -1) {
            if (t[a] == -this.timestamp) {
                t[a] = ub;
            } else if (recomputeNbInconsistencies) {
                t[a] = this.partitionOfConstraints.computeSumMinCostsOf(x, a);
            }
            if (argMin == -1) {
                argMin = argMax = a;
            } else if (t[a] < t[argMin]) {
                argMin = a;
            } else if (t[a] > t[argMax]) {
                argMax = a;
            }
            a = dom.next(a);
        }
        this.argMinSumMinCosts[x.num] = argMin;
        this.argMaxSumMinCosts[x.num] = argMax;
        return t[argMin];
    }

    protected boolean filterDomains() {
        assert (this.queue.size() == 0);
        long ub = this.solver.solManager.bestBound;
        Variable x = this.solver.futVars.first();
        while (x != null) {
            long[] t = this.sumMinCosts[x.num];
            long base = Calculator.add(this.partitionOfConstraints.distance, this.sumMnis, -t[this.argMinSumMinCosts[x.num]]);
            if (Calculator.add(base, t[this.argMaxSumMinCosts[x.num]]) >= ub) {
                Domain dom = x.dom;
                int sizeBefore = dom.size();
                int a = dom.first();
                while (a != -1) {
                    assert (t[a] == ub || t[a] == this.partitionOfConstraints.computeSumMinCostsOf(x, a));
                    if (Calculator.add(Calculator.add(base, t[a]), this.computeOffset(x, a)) >= ub) {
                        dom.removeElementary(a);
                    }
                    a = dom.next(a);
                }
                Kit.control(sizeBefore - dom.size() > 0);
                if (dom.size() == 0) {
                    x.wdeg += 1.0;
                    return false;
                }
                this.queue.add(x);
            }
            x = this.solver.futVars.next(x);
        }
        return true;
    }

    public boolean go(boolean incremental) {
        ++this.timestamp;
        this.partitionOfConstraints.init(incremental && this.solver.depth() > 1);
        do {
            boolean consistent;
            boolean bl = consistent = this.computeSumMnis(true) && this.filterDomains();
            if (!consistent) {
                return false;
            }
            if (this.queue.size() != 0) continue;
            return true;
        } while (super.propagate());
        return false;
    }

    @Override
    public boolean runInitially() {
        if (!super.runInitially()) {
            return false;
        }
        return this.go(false);
    }

    @Override
    public boolean runAfterAssignment(Variable x) {
        if (!super.runAfterAssignment(x)) {
            return false;
        }
        return this.go(true);
    }

    @Override
    public boolean runAfterRefutation(Variable x) {
        this.queue.addFutureVariables();
        if (!super.propagate()) {
            return false;
        }
        return this.go(false);
    }

    public final class PartitionOfConstraintsW2
    extends PartitionOfConstraints {
        protected PartitionOfConstraintsW2(Solver solver) {
            super(solver);
        }

        @Override
        protected double evaluate(Constraint c, Variable x, boolean incremental) {
            int vap = c.positionOf(x);
            long sumVariableMinCost = 0L;
            long ub = this.solver.solManager.bestBound;
            Domain dom = x.dom;
            int a = dom.first();
            while (a != -1) {
                long minCost = Math.min(ub, c.minCostOfTuplesWith(vap, a));
                sumVariableMinCost = Calculator.add(sumVariableMinCost, minCost);
                a = dom.next(a);
            }
            return (double)sumVariableMinCost / (double)x.dom.size();
        }

        @Override
        protected void updateStructures(Constraint c, Variable x) {
            throw new UnreachableCodeException();
        }

        @Override
        protected void incrementalInit() {
            Variable x = this.solver.futVars.lastPast();
            for (Constraint c : x.ctrs) {
                if (c.futvars.size() == 0) {
                    this.dealWithPastConstraint(c);
                    continue;
                }
                if (this.membership[c.num] != x.num) continue;
                this.dealWithFutureConstraint(c, true);
            }
            this.first[x.num] = -1;
            assert (this.controlPartition());
        }

        @Override
        public long computeSumMinCostsOf(Variable x, int a) {
            assert (!x.isAssigned());
            long cnt = 0L;
            int cnum = this.first[x.num];
            while (cnum != -1) {
                cnt = Calculator.add(cnt, this.ctrs[cnum].minCostOfTuplesWith(this.ctrs[cnum].positionOf(x), a));
                cnum = this.next[cnum];
            }
            return cnt;
        }
    }
}

