/*
 * Decompiled with CFR 0.152.
 */
package propagation.soft.pfc;

import constraints.Constraint;
import org.xcsp.common.Types;
import propagation.soft.pfc.PartitionOfConstraints;
import propagation.soft.pfc.RDACAbstract;
import search.Solver;
import utility.Kit;
import utility.operations.Calculator;
import variables.Variable;
import variables.domains.Domain;

public class RDAC_WCSP
extends RDACAbstract {
    public RDAC_WCSP(Solver solver) {
        super(solver);
        Kit.control(solver.pb.framework == Types.TypeFramework.WCSP, () -> "WCSP is not indicated in your configuration");
        this.partitionOfConstraints = new PartitionOfConstraintsW(solver);
    }

    @Override
    protected void updateStructuresFromRemovals() {
        long ub = this.solver.solManager.bestBound;
        while (this.queue.size() > 0) {
            Variable x = this.queue.pickAndDelete(0);
            for (Constraint c : x.ctrs) {
                if (c.futvars.size() == 0) continue;
                Variable partitionVariable = this.solver.pb.variables[this.partitionOfConstraints.membership[c.num]];
                long[] t = this.sumMinCosts[partitionVariable.num];
                for (int j = 0; j < c.scp.length; ++j) {
                    Variable y = c.scp[j];
                    if (y.isAssigned() || y == x) continue;
                    long[] mc = this.minCosts[c.num][j];
                    Domain dom = y.dom;
                    int a = dom.first();
                    while (a != -1) {
                        long costBefore = mc[a];
                        mc[a] = Math.min(ub, c.minCostOfTuplesWith(j, a));
                        if (mc[a] == ub) {
                            this.sumMinCosts[y.num][a] = -this.timestamp;
                        } else if (y == partitionVariable && t[a] != -this.timestamp) {
                            Calculator.add(t, a, Calculator.add(mc[a], -costBefore));
                        }
                        a = dom.next(a);
                    }
                }
            }
        }
    }

    public final class PartitionOfConstraintsW
    extends PartitionOfConstraints {
        protected PartitionOfConstraintsW(Solver solver) {
            super(solver);
        }

        @Override
        protected double evaluate(Constraint c, Variable x, boolean incremental) {
            long ub = this.solver.solManager.bestBound;
            int vap = c.positionOf(x);
            long[] mc = RDAC_WCSP.this.minCosts[c.num][vap];
            long sumVariableMinCost = 0L;
            Domain dom = x.dom;
            if (!incremental) {
                int a = dom.first();
                while (a != -1) {
                    mc[a] = Math.min(ub, c.minCostOfTuplesWith(vap, a));
                    sumVariableMinCost = Calculator.add(sumVariableMinCost, mc[a]);
                    if (mc[a] == ub) {
                        RDAC_WCSP.this.sumMinCosts[x.num][a] = -RDAC_WCSP.this.timestamp;
                    }
                    a = dom.next(a);
                }
            } else {
                int a = dom.first();
                while (a != -1) {
                    mc[a] = Math.min(ub, c.minCostOfTuplesWith(vap, a));
                    sumVariableMinCost = Calculator.add(sumVariableMinCost, mc[a]);
                    if (mc[a] == ub) {
                        RDAC_WCSP.this.sumMinCosts[x.num][a] = -RDAC_WCSP.this.timestamp;
                    }
                    a = dom.next(a);
                }
            }
            return (double)sumVariableMinCost / (double)dom.size();
        }

        @Override
        protected void updateStructures(Constraint c, Variable x) {
            long ub = this.solver.solManager.bestBound;
            int vap = c.positionOf(x);
            long[] mc = RDAC_WCSP.this.minCosts[c.num][vap];
            Domain dom = x.dom;
            int a = dom.first();
            while (a != -1) {
                assert (mc[a] < ub) : "up = " + ub + "mc= " + mc[a] + " " + c + " " + x;
                mc[a] = Math.min(ub, c.minCostOfTuplesWith(vap, a));
                if (mc[a] >= ub) {
                    RDAC_WCSP.this.sumMinCosts[x.num][a] = -RDAC_WCSP.this.timestamp;
                }
                a = dom.next(a);
            }
        }

        @Override
        public long computeSumMinCostsOf(Variable x, int a) {
            assert (!x.isAssigned());
            long cnt = 0L;
            int cnum = this.first[x.num];
            while (cnum != -1) {
                cnt = Calculator.add(cnt, RDAC_WCSP.this.minCosts[cnum][this.ctrs[cnum].positionOf(x)][a]);
                cnum = this.next[cnum];
            }
            return cnt;
        }
    }
}

