/*
 * Decompiled with CFR 0.152.
 */
package propagation.soft.pfc;

import constraints.Constraint;
import java.util.Arrays;
import search.Solver;
import utility.Kit;
import utility.operations.Calculator;
import variables.Variable;

public abstract class PartitionOfConstraints {
    protected Solver solver;
    protected Constraint[] ctrs;
    protected long distance;
    public int[] membership;
    protected int[] first;
    protected int[] next;
    protected int[] size;
    protected int firstPast;

    protected PartitionOfConstraints(Solver solver) {
        this.solver = solver;
        this.ctrs = solver.pb.constraints;
        this.membership = new int[solver.pb.constraints.length];
        this.next = new int[solver.pb.constraints.length];
        this.first = new int[solver.pb.variables.length];
        this.size = new int[solver.pb.variables.length];
    }

    protected void dealWithPastConstraint(Constraint c) {
        this.membership[c.num] = -1;
        this.next[c.num] = this.firstPast;
        this.firstPast = c.num;
        this.distance = Calculator.add(this.distance, c.costOfCurrInstantiation());
    }

    protected abstract double evaluate(Constraint var1, Variable var2, boolean var3);

    protected final void dealWithFutureConstraint(Constraint c, boolean incremental) {
        int xnum = -1;
        double bestEval = -1.0;
        for (Variable x : c.scp) {
            double eval;
            if (x.isAssigned() || !((eval = this.evaluate(c, x, incremental)) > bestEval)) continue;
            xnum = x.num;
            bestEval = eval;
        }
        assert (xnum != -1);
        this.membership[c.num] = xnum;
        this.next[c.num] = this.first[xnum];
        this.first[xnum] = c.num;
        int n = xnum;
        this.size[n] = this.size[n] + 1;
    }

    public final void totalInit() {
        Arrays.fill(this.first, -1);
        Arrays.fill(this.size, 0);
        this.firstPast = -1;
        this.distance = this.solver.rs.cp.optimizing.lowerBound;
        for (Constraint ctr : this.ctrs) {
            if (ctr.futvars.size() == 0) {
                this.dealWithPastConstraint(ctr);
                continue;
            }
            this.dealWithFutureConstraint(ctr, false);
        }
        assert (this.controlPartition());
    }

    protected abstract void updateStructures(Constraint var1, Variable var2);

    protected void incrementalInit() {
        Variable x = this.solver.futVars.lastPast();
        for (Constraint c : x.ctrs) {
            if (c.futvars.size() == 0) {
                this.dealWithPastConstraint(c);
                continue;
            }
            if (this.membership[c.num] == x.num) {
                this.dealWithFutureConstraint(c, true);
                continue;
            }
            for (int i = c.futvars.limit; i >= 0; --i) {
                this.updateStructures(c, c.scp[c.futvars.dense[i]]);
            }
        }
        this.first[x.num] = -1;
        assert (this.controlPartition());
    }

    public void init(boolean incremental) {
        if (incremental) {
            this.incrementalInit();
        } else {
            this.totalInit();
        }
    }

    public abstract long computeSumMinCostsOf(Variable var1, int var2);

    protected boolean controlPartition() {
        for (Variable variable : this.solver.pb.variables) {
            int cnum = this.first[variable.num];
            while (cnum != -1) {
                Kit.control(this.membership[cnum] == variable.num, () -> "pb with membership");
                cnum = this.next[cnum];
            }
        }
        for (Comparable<Variable> comparable : this.solver.pb.constraints) {
            if (this.membership[((Constraint)comparable).num] == -1) {
                Kit.control(((Constraint)comparable).futvars.size() == 0, () -> "not all assigned in  ");
                continue;
            }
            boolean found = false;
            int cnum = this.first[this.membership[((Constraint)comparable).num]];
            while (!found && cnum != -1) {
                if (cnum == ((Constraint)comparable).num) {
                    found = true;
                }
                cnum = this.next[cnum];
            }
            Kit.control(found, () -> "constraint not found");
        }
        return true;
    }

    protected void displayPartition() {
        for (Variable x : this.solver.pb.variables) {
            Kit.log.fine(x + " of size " + this.size[x.num] + " :");
            int cnum = this.first[x.num];
            while (cnum != -1) {
                Kit.log.fine(this.ctrs[cnum] + " ");
                cnum = this.next[cnum];
            }
        }
    }
}

