/*
 * Decompiled with CFR 0.152.
 */
package propagation.order2.path;

import constraints.CtrHard;
import problem.cliques.CliqueManager;
import propagation.order2.SecondOrderConsistency;
import search.Solver;
import variables.domains.Domain;

public class CPC1
extends SecondOrderConsistency {
    protected CliqueManager cliqueManager;
    protected int[] nSupports;
    private boolean modified;

    public CPC1(Solver solver) {
        super(solver);
        this.cliqueManager = new CliqueManager(solver.pb);
        this.nSupports = new int[solver.pb.constraints.length];
    }

    private boolean filterConstraint(CtrHard c) {
        Domain dom0 = c.scp[0].dom;
        Domain dom1 = c.scp[1].dom;
        int sizeBefore0 = dom0.size();
        int sizeBefore1 = dom1.size();
        int[] tuple = c.tupleManager.localTuple;
        boolean foundSupport = c.seekFirstSupport();
        while (foundSupport) {
            if (!this.cliqueManager.isPathConsistent(c, tuple)) {
                this.modified = true;
                c.removeTuple(tuple);
                if (this.variant > 1) {
                    if (!c.findArcSupportFor(0, tuple[0])) {
                        dom0.removeElementary(tuple[0]);
                        if (dom0.size() == 0) {
                            return false;
                        }
                    }
                    if (!c.findArcSupportFor(1, tuple[1])) {
                        dom1.removeElementary(tuple[1]);
                        if (dom1.size() == 0) {
                            return false;
                        }
                    }
                }
            }
            foundSupport = c.seekNextSupport();
        }
        if (this.variant > 1) {
            assert (this.queue.isEmpty());
            if (sizeBefore0 != dom0.size()) {
                this.queue.add(c.scp[0]);
            }
            if (sizeBefore1 != dom1.size()) {
                this.queue.add(c.scp[1]);
            }
            return this.propagate();
        }
        return true;
    }

    public boolean establishOnePass() {
        for (CtrHard c : this.hards) {
            if (c.scp.length != 2 || this.filterConstraint(c)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean enforceSecondOrderConsistency() {
        do {
            this.modified = false;
            if (!this.establishOnePass()) {
                return false;
            }
            System.out.println(" CPC : " + this.pb().nTuplesRemoved + " tuples removed " + this.pb().nValuesRemoved + " values removed");
        } while (this.modified);
        return true;
    }
}

