/*
 * Decompiled with CFR 0.152.
 */
package propagation.order2.dual;

import constraints.Constraint;
import propagation.order2.SecondOrderConsistency;
import search.Solver;
import search.backtrack.SolverBacktrack;
import utility.Kit;
import utility.exceptions.UnreachableCodeException;
import variables.Variable;
import variables.domains.Domain;

public abstract class DualBasedConsistency
extends SecondOrderConsistency {
    protected int time;
    protected boolean performingTest;
    protected int[] tmp = new int[2];

    protected boolean isMarkLastDropped(Domain dom) {
        return dom.indexAtMark() == dom.lastRemoved();
    }

    protected void actAfterFirstPropagationStep() {
        this.solver.setDomainsMarks();
        this.performingTest = false;
    }

    @Override
    public boolean propagate() {
        while (this.queue.size() != 0) {
            if (!this.pickAndFilter()) {
                return false;
            }
            if (!this.performingTest) continue;
            this.actAfterFirstPropagationStep();
        }
        return true;
    }

    public DualBasedConsistency(Solver solver) {
        super(solver);
    }

    protected boolean removeTuplesFrom(Variable x, int a, Constraint c) {
        int q = c.scp[0] != x ? 0 : 1;
        Variable y = c.scp[q];
        Domain dy = y.dom;
        if (this.isMarkLastDropped(dy)) {
            return false;
        }
        int p = q == 0 ? 1 : 0;
        this.tmp[p] = a;
        int stop = dy.indexAtMark();
        int b = dy.lastRemoved();
        while (b != stop) {
            this.tmp[q] = b;
            if (!c.removeTuple(this.tmp)) {
                throw new UnreachableCodeException();
            }
            b = dy.prevRemoved(b);
        }
        dy.setMark();
        return true;
    }

    protected abstract int removeTuplesAfterSingletonTestOn(Variable var1, int var2);

    protected int performSingletonTest(Variable x, int a) {
        ++this.nSingletonTests;
        int nbValuesBefore = this.pb().nValuesRemoved;
        this.solver.assign(x, a);
        this.performingTest = true;
        boolean consistent = super.runAfterAssignment(x);
        this.performingTest = false;
        assert (!consistent || this.controlArcConsistency()) : "problem after singleton test: " + x + " = " + a;
        int nbTuplesRemoved = consistent ? this.removeTuplesAfterSingletonTestOn(x, a) : -1;
        this.solver.backtrack(x);
        this.pb().nValuesRemoved = nbValuesBefore;
        if (!consistent) {
            ++this.nEffectiveSingletonTests;
            x.dom.removeElementary(a);
        }
        return nbTuplesRemoved;
    }

    protected boolean performDecisionTestsOf(Variable x) {
        boolean modified = false;
        Domain dom = x.dom;
        int a = dom.first();
        while (a != -1) {
            if (this.performSingletonTest(x, a) != 0) {
                modified = true;
            }
            a = dom.next(a);
        }
        return modified;
    }

    protected void updateStructures(Variable uniqueModifiedVariable) {
    }

    @Override
    public boolean enforceSecondOrderConsistency() {
        Variable x;
        int nbValuesBefore = this.pb().nValuesRemoved;
        int nbNogoodsBefore = this.solver instanceof SolverBacktrack ? ((SolverBacktrack)this.solver).learnerNogoods.nNogoods : 0;
        int nbTuplesBefore = this.pb().nTuplesRemoved;
        int nbConstraintsBefore = this.solver.pb.constraints.length;
        Variable markedVar = x = this.solver.pb.variables[0];
        do {
            ++this.time;
            if (x.dom.size() > 1) {
                int nb = this.pb().nValuesRemoved;
                if (this.performDecisionTestsOf(x)) {
                    if (x.dom.size() == 0) {
                        return false;
                    }
                    if (!super.runAfterRefutation(x)) {
                        return false;
                    }
                    this.updateStructures(this.pb().nValuesRemoved == nb ? x : null);
                    markedVar = x;
                }
            }
            x = this.solver.pb.variables[(x.num + 1) % this.solver.pb.variables.length];
            if (x.num != 0) continue;
            this.displayInfo("after turn", nbConstraintsBefore, nbTuplesBefore, nbNogoodsBefore, nbValuesBefore);
        } while (x != markedVar);
        this.displayInfo("finally", nbConstraintsBefore, nbTuplesBefore, nbNogoodsBefore, nbValuesBefore);
        return true;
    }

    private void displayInfo(String prefix, int n1, int n2, int n3, int n4) {
        Kit.log.info(prefix + ", nbAddedConstraints=" + (this.solver.pb.constraints.length - n1) + " nbTuplesRemoved=" + (this.pb().nTuplesRemoved - n2) + (this.solver instanceof SolverBacktrack ? " nbNogoodsRemoved=" + (((SolverBacktrack)this.solver).learnerNogoods.nNogoods - n3) : "") + " nbValuesRemoved=" + (this.pb().nValuesRemoved - n4));
    }
}

