/*
 * Decompiled with CFR 0.152.
 */
package propagation.order2.dual;

import constraints.Constraint;
import constraints.hard.CtrExtension;
import propagation.order2.dual.DualBasedConsistency;
import search.Solver;
import search.backtrack.DecisionRecorder;
import search.backtrack.SolverBacktrack;
import utility.sets.SetSparse;
import variables.Variable;

public abstract class DCAbstract
extends DualBasedConsistency {
    private SetSparse sparseSet;
    protected final DecisionRecorder dr;

    public DCAbstract(Solver solver) {
        super(solver);
        this.sparseSet = new SetSparse(solver.pb.variables.length, true);
        this.dr = ((SolverBacktrack)solver).dr;
    }

    protected abstract boolean removeAdditionalTuples(Variable var1, int var2, Variable var3);

    @Override
    protected int removeTuplesAfterSingletonTestOn(Variable x, int a) {
        int nbTuplesBefore = this.pb().nTuplesRemoved;
        this.sparseSet.fill();
        this.sparseSet.remove(x.num);
        for (Constraint c : x.ctrs) {
            if (c.scp.length != 2 || !(c instanceof CtrExtension)) continue;
            this.removeTuplesFrom(x, a, c);
            this.sparseSet.remove(Variable.firstDifferentVariableIn((Variable[])c.scp, (Variable)x).num);
        }
        Variable[] variables = this.solver.pb.variables;
        for (int i = 0; i <= this.sparseSet.limit; ++i) {
            this.removeAdditionalTuples(x, a, variables[this.sparseSet.dense[i]]);
        }
        return this.pb().nTuplesRemoved - nbTuplesBefore;
    }
}

