/*
 * Decompiled with CFR 0.152.
 */
package propagation.order2.dual;

import learning.LearnerNogoodsAdvanced;
import propagation.order2.dual.DC2Abstract;
import search.Solver;
import search.backtrack.SolverBacktrack;
import variables.Variable;
import variables.domains.Domain;

public final class DC2NR
extends DC2Abstract {
    private LearnerNogoodsAdvanced nogoodManager;

    public DC2NR(Solver solver) {
        super(solver);
    }

    @Override
    protected boolean removeAdditionalTuples(Variable x, int a, Variable y) {
        Domain dy = y.dom;
        int stop = dy.indexAtMark();
        if (stop == dy.lastRemoved()) {
            return false;
        }
        int dec = this.dr.negativeDecisionFor(x.num, a);
        int b = dy.lastRemoved();
        while (b != stop) {
            int[] nogood = new int[]{dec, this.dr.negativeDecisionFor(y.num, b)};
            this.nogoodManager.addNogoodFrom(nogood);
            b = dy.prevRemoved(b);
        }
        this.stamp[y.num] = this.time;
        return true;
    }

    @Override
    protected int removeTuplesAfterSingletonTestOn(Variable x, int a) {
        int nbNogoodsBefore = this.nogoodManager.nNogoods;
        int nbTuplesRemoved = super.removeTuplesAfterSingletonTestOn(x, a);
        return nbTuplesRemoved + this.nogoodManager.nNogoods - nbNogoodsBefore;
    }

    @Override
    public boolean runInitially() {
        this.nogoodManager = (LearnerNogoodsAdvanced)((SolverBacktrack)this.solver).learnerNogoods;
        return super.runInitially();
    }
}

