/*
 * Decompiled with CFR 0.152.
 */
package propagation.order2.dual;

import constraints.Constraint;
import propagation.PropagationQueue;
import propagation.order2.dual.DCAbstract;
import search.Solver;
import variables.Variable;

public abstract class DC2Abstract
extends DCAbstract {
    protected int[] stamp;
    private PropagationQueue queue;

    public DC2Abstract(Solver solver) {
        super(solver);
        this.stamp = new int[solver.pb.variables.length];
        this.queue = ((DCAbstract)this).queue;
    }

    @Override
    protected final void actAfterFirstPropagationStep() {
        Variable[] variables = this.solver.pb.variables;
        if (this.time > variables.length) {
            int lastCheck = this.time - variables.length;
            int i = 0;
            while (i < this.queue.size()) {
                Variable var = this.queue.var(i);
                if (this.stamp[var.num] <= lastCheck || this.isMarkLastDropped(var.dom)) {
                    this.queue.remove(var.num);
                    continue;
                }
                ++i;
            }
        }
        super.actAfterFirstPropagationStep();
    }

    @Override
    protected final boolean removeTuplesFrom(Variable x, int a, Constraint c) {
        boolean effective = super.removeTuplesFrom(x, a, c);
        if (effective) {
            this.stamp[Variable.firstDifferentVariableIn((Variable[])c.scp, (Variable)x).num] = this.time;
        }
        return effective;
    }

    @Override
    protected final int performSingletonTest(Variable x, int a) {
        if (this.time > this.solver.pb.variables.length) {
            this.solver.setDomainsMarks();
        }
        return super.performSingletonTest(x, a);
    }

    @Override
    protected final void updateStructures(Variable uniqueModifiedVariable) {
        if (uniqueModifiedVariable == null) {
            for (Variable x : this.solver.pb.variables) {
                this.stamp[x.num] = this.time;
            }
        } else {
            this.stamp[uniqueModifiedVariable.num] = this.time;
        }
    }
}

