/*
 * Decompiled with CFR 0.152.
 */
package propagation.order1.singleton;

import java.util.stream.Stream;
import propagation.order1.singleton.SAC3;
import propagation.structures.forSac.Branch;
import propagation.structures.forSac.BranchExtended;
import propagation.structures.forSac.InferenceUnit;
import propagation.structures.forSac.QueueOfCells;
import search.Solver;
import variables.Variable;
import variables.domains.Domain;

public final class SAC3p
extends SAC3 {
    private final BranchExtended[] branches;
    private int nCurrentBranches;

    private BranchExtended getBranch(int i) {
        if (this.branches[i] == null) {
            this.branches[i] = new BranchExtended(this.solver);
        }
        return this.branches[i];
    }

    public SAC3p(Solver solver) {
        super(solver);
        this.branches = new BranchExtended[Variable.nInitValuesFor(solver.pb.variables)];
    }

    private boolean checkConsistencyOf(BranchExtended branch) {
        assert (this.queue.isEmpty() && branch.controlModified());
        if (!branch.isModified()) {
            return true;
        }
        if (branch.isInconsistent()) {
            return false;
        }
        for (int i = 0; i < branch.size; ++i) {
            this.solver.assign(branch.vars[i], branch.idxs[i]);
        }
        for (Variable x : this.solver.pb.variables) {
            if (x.isAssigned()) continue;
            assert (!branch.has(x));
            InferenceUnit inferenceUnit = branch.inferenceUnits[x.num];
            Domain dom = x.dom;
            int idx = dom.first();
            while (idx != -1) {
                if (inferenceUnit.isAbsent(idx)) {
                    x.dom.removeElementary(idx);
                }
                idx = dom.next(idx);
            }
            if (dom.size() == 0) {
                for (int cnt = 0; cnt < branch.size; ++cnt) {
                    this.solver.backtrack();
                }
                return false;
            }
            if (!inferenceUnit.modified) continue;
            this.queue.add(x);
        }
        assert (this.queue.size() > 0);
        boolean consistent = this.propagate();
        if (consistent) {
            branch.recordProblemDomain();
        }
        for (int cnt = 0; cnt < branch.size; ++cnt) {
            this.solver.backtrack();
        }
        return consistent;
    }

    private void updateBranchesAfterRemovalOf(Variable x, int a) {
        for (int i = 0; i < this.nCurrentBranches; ++i) {
            this.branches[i].updateAfterRemovalOf(x, a);
        }
    }

    private void updateQueueFromInconsistentBranches() {
        for (int i = 0; i < this.nCurrentBranches; ++i) {
            BranchExtended branch = this.branches[i];
            if (this.checkConsistencyOf(branch)) continue;
            for (int j = 0; j < branch.size; ++j) {
                this.queueOfCells.add(branch.vars[j], branch.idxs[j]);
            }
            this.branches[i] = this.branches[this.nCurrentBranches - 1];
            this.branches[this.nCurrentBranches - 1] = branch;
            branch.clear();
            --this.nCurrentBranches;
            --i;
        }
    }

    protected boolean reestablishAC(Variable x) {
        for (Variable y : this.solver.pb.variables) {
            y.dom.setMark();
        }
        if (!super.enforceArcConsistencyAfterRefutation(x)) {
            return false;
        }
        for (Variable y : this.solver.pb.variables) {
            int mark = y.dom.indexAtMark();
            int a = y.dom.lastRemoved();
            while (a != mark) {
                this.updateBranchesAfterRemovalOf(y, a);
                a = y.dom.prevRemoved(a);
            }
        }
        return true;
    }

    @Override
    protected boolean manageInconsistentValue(Variable x, int a) {
        ++this.nEffectiveSingletonTests;
        x.dom.removeElementary(a);
        if (this.shavingEvaluator != null) {
            this.shavingEvaluator.updateRatioAfterShavingSuccess(x);
        }
        if (x.dom.size() == 0) {
            return false;
        }
        this.updateBranchesAfterRemovalOf(x, a);
        if (!this.reestablishAC(x)) {
            return false;
        }
        if (this.lastConflictMode == 2) {
            this.queueOfCells.setPriorityOf(x);
        }
        return true;
    }

    protected void eraseLastBuiltBranch(Branch branch) {
        if (branch.size > 0) {
            ++this.nCurrentBranches;
            ((BranchExtended)branch).recordProblemDomain();
        }
        super.eraseLastBuiltBranch(branch.size);
    }

    protected boolean buildBranch(Branch branch) {
        branch.clear();
        QueueOfCells.Cell cell = this.queueOfCells.pickNextCell();
        while (cell != null) {
            Variable x = cell.x;
            int a = cell.a;
            if (x.dom.size() == 1) {
                ++this.nFoundSingletons;
            }
            assert (!x.isAssigned() && x.dom.isPresent(a) && this.queue.isEmpty());
            ++this.nSingletonTests;
            this.solver.assign(x, a);
            if (this.enforceArcConsistencyAfterAssignment(x)) {
                branch.add(x, a);
                if (this.solver.depth() == this.solver.pb.variables.length && this.stopSACWhenFoundSolution) {
                    this.solver.solManager.handleNewSolution(true);
                }
            } else {
                this.solver.backtrack(x);
                if (branch.size == 0) {
                    return this.manageInconsistentValue(x, a);
                }
                this.queueOfCells.add(x, a);
                if (!this.maximumBranchExtension) {
                    if (this.lastConflictMode <= 0) break;
                    this.queueOfCells.setPriorityTo(x, a);
                    break;
                }
            }
            cell = this.queueOfCells.pickNextCell();
        }
        this.eraseLastBuiltBranch(branch);
        return true;
    }

    @Override
    protected boolean enforceStrongConsistency() {
        this.nCurrentBranches = 0;
        this.sumBranchSizes = 0;
        this.nBranchesBuilt = 0;
        this.queueOfCells.fill();
        while (this.queueOfCells.size > 0) {
            while (this.queueOfCells.size > 0) {
                assert (this.controlBranches());
                if (!this.buildBranch(this.getBranch(this.nCurrentBranches))) {
                    return false;
                }
                if (!this.stopSACWhenFoundSolution || !this.solver.hasFinished()) continue;
                return true;
            }
            this.updateQueueFromInconsistentBranches();
        }
        assert (this.controlArcConsistency() && this.controlSingletonArcConsistency());
        return true;
    }

    private boolean controlBranches() {
        return Stream.of(this.branches).allMatch(b -> b.controlWrt(this.queueOfCells));
    }
}

