/*
 * Decompiled with CFR 0.152.
 */
package propagation.order1.partial;

import propagation.order1.partial.PickThresholdManager;
import propagation.order1.singleton.SAC;
import search.Solver;
import utility.Kit;
import utility.interfaces.TagExperimental;
import variables.Variable;

public class ACPartialLevel
extends SAC
implements TagExperimental {
    private PickThresholdManager[] pickThresholdManagers;
    public int[][] effectifFalse;
    public int[][] effectifTrue;
    public boolean displayEffectif = false;

    @Override
    public boolean propagate() {
        int nLocalPicks = 0;
        int depth = this.solver.depth();
        boolean collectStats = false;
        while (this.queue.size() != 0) {
            ++nLocalPicks;
            boolean consistent = this.pickAndFilter();
            if (!consistent) {
                if (collectStats) {
                    int[] nArray = this.effectifFalse[depth];
                    int n = nLocalPicks;
                    nArray[n] = nArray[n] + 1;
                }
                return false;
            }
            if (this.pickThresholdManagers == null || !this.pickThresholdManagers[depth].mustStopPropagation(nLocalPicks)) continue;
            break;
        }
        if (collectStats) {
            int[] nArray = this.effectifTrue[depth];
            int n = nLocalPicks;
            nArray[n] = nArray[n] + 1;
        }
        return true;
    }

    @Override
    public boolean runAfterAssignment(Variable x) {
        int level = this.solver.depth();
        if (this.pickThresholdManagers != null) {
            this.pickThresholdManagers[level].actBeforeSingletonCheck(this.queue.nPicks);
        }
        boolean b = super.runAfterAssignment(x);
        if (this.pickThresholdManagers != null) {
            this.pickThresholdManagers[level].actAfterSingletonCheck(this.queue.nPicks, b);
        }
        return b;
    }

    public ACPartialLevel(Solver solver) {
        super(solver);
        int length = 250;
        int nbVariables = solver.pb.variables.length;
        if (this.cp().shaving.limitedPropagationSamplingSize >= 0) {
            this.pickThresholdManagers = new PickThresholdManager[nbVariables + 1];
            for (int i = 0; i < this.pickThresholdManagers.length; ++i) {
                this.pickThresholdManagers[i] = new PickThresholdManager(length, this.cp().shaving.limitedPropagationSamplingSize);
            }
        }
        if (this.displayEffectif) {
            this.effectifTrue = new int[nbVariables + 1][length];
            this.effectifFalse = new int[nbVariables + 1][length];
        }
    }

    @Override
    protected boolean enforceStrongConsistency() {
        return true;
    }

    public void display() {
        if (this.displayEffectif) {
            System.out.println();
            System.out.println(this.solver.pb.name());
            for (int i = 0; i < this.effectifFalse.length; ++i) {
                if (Kit.sum(this.effectifFalse[i]) == 0L && Kit.sum(this.effectifTrue[i]) == 0L) continue;
                System.out.println("LEVEL " + i + " false (nb=" + Kit.sum(this.effectifFalse[i]) + ",avg=" + Kit.computeAveragePositionOf(this.effectifFalse[i]) + ") => " + Kit.join((Object)this.effectifFalse[i], new String[0]));
                System.out.println("                           true (nb=" + Kit.sum(this.effectifTrue[i]) + ",avg=" + Kit.computeAveragePositionOf(this.effectifTrue[i]) + ") => " + Kit.join((Object)this.effectifTrue[i], new String[0]));
            }
        }
    }
}

