/*
 * Decompiled with CFR 0.152.
 */
package propagation.order1.inverse;

import propagation.order1.inverse.GIC1;
import search.Solver;
import utility.Kit;
import variables.Variable;
import variables.domains.Domain;

public abstract class GICAdvanced
extends GIC1 {
    protected int[] nValuesToBeSupported;
    protected int nSupVariables;
    protected int[] supVariableNums;
    protected int cursor;

    public GICAdvanced(Solver solver) {
        super(solver);
        this.nValuesToBeSupported = new int[solver.pb.variables.length];
        this.supVariableNums = new int[solver.pb.variables.length];
    }

    protected abstract void intializationAdvanced();

    protected abstract boolean isInverseAdvanced(Variable var1, int var2);

    @Override
    public boolean enforceStrongConsistency() {
        this.intializationAdvanced();
        long nSolutionsBefore = this.before();
        int nValuesRemoved = 0;
        this.cursor = this.nSupVariables - 1;
        while (this.cursor >= 0) {
            Variable x = this.solver.pb.variables[this.supVariableNums[this.cursor]];
            if (this.nValuesToBeSupported[x.num] != 0) {
                Domain dom = x.dom;
                int a = dom.first();
                while (a != -1) {
                    if (!this.isInverseAdvanced(x, a)) {
                        x.dom.removeElementary(a);
                        ++nValuesRemoved;
                    }
                    a = dom.next(a);
                }
                Kit.control(dom.size() != 0, () -> "Not possible to reach inconsistency with GIC (or your instance is unsat)");
            }
            --this.cursor;
        }
        this.after(nSolutionsBefore, nValuesRemoved);
        return true;
    }
}

