/*
 * Decompiled with CFR 0.152.
 */
package propagation.order1.inverse;

import propagation.order1.inverse.GIC2;
import search.Solver;
import utility.Kit;
import variables.Variable;

public class GIC3
extends GIC2 {
    private int[][][] residues;

    public GIC3(Solver solver) {
        super(solver);
        Variable[] variables = solver.pb.variables;
        this.residues = new int[variables.length][][];
        for (int i = 0; i < variables.length; ++i) {
            this.residues[i] = new int[variables[i].dom.initSize()][];
        }
    }

    @Override
    protected void handleNewSolution(Variable x, int a) {
        int[] solution = this.solver.solManager.lastSolution;
        this.handleSolution(x, a, solution);
        if (this.residues[x.num][a] == null) {
            this.residues[x.num][a] = new int[this.solver.pb.variables.length];
        }
        Kit.copy(solution, this.residues[x.num][a]);
    }

    @Override
    protected boolean isInverseAdvanced(Variable x, int a) {
        if (this.stamps[x.num][a] == this.timestamp) {
            return true;
        }
        if (this.residues[x.num][a] != null && Variable.isValidTuple(this.solver.pb.variables, this.residues[x.num][a], true)) {
            this.handleSolution(x, a, this.residues[x.num][a]);
            return true;
        }
        return this.isInverse(x, a);
    }
}

