/*
 * Decompiled with CFR 0.152.
 */
package propagation.order1.failed;

import constraints.Constraint;
import constraints.CtrHard;
import propagation.order1.AC;
import propagation.order1.failed.FailedValueBasedConsistency;
import search.backtrack.DecisionRecorder;
import search.backtrack.SolverBacktrack;
import variables.Variable;

public class FailedValueConsistency
extends FailedValueBasedConsistency {
    private static final int CONFLICT_SEEKING_LIMIT = 1000;
    private Constraint[][] residues;

    public FailedValueConsistency(AC arcConsistency) {
        super(arcConsistency);
    }

    @Override
    public void buildStructures() {
        Variable[] variables = this.arcConsistency.solver.pb.variables;
        this.residues = new Constraint[variables.length][];
        for (int i = 0; i < this.residues.length; ++i) {
            this.residues[i] = new Constraint[variables[i].dom.initSize()];
            for (int j = 0; j < this.residues[i].length; ++j) {
                this.residues[i][j] = variables[i].ctrs[0];
            }
        }
    }

    private Constraint seekConflictingConstraintFor(Variable x, int a) {
        Constraint residueConstraint = this.residues[x.num][a];
        int p = residueConstraint.positionOf(x);
        if (Variable.nValidTuplesBoundedAtMaxValueFor(residueConstraint.scp, p) > 1000L || ((CtrHard)residueConstraint).seekFirstConflictWith(p, a)) {
            return residueConstraint;
        }
        for (Constraint c : x.ctrs) {
            if (c == residueConstraint || Variable.nValidTuplesBoundedAtMaxValueFor(c.scp, p = c.positionOf(x)) <= 1000L && !((CtrHard)c).seekFirstConflictWith(p, a)) continue;
            return c;
        }
        return null;
    }

    @Override
    public boolean enforce() {
        DecisionRecorder dr = ((SolverBacktrack)this.arcConsistency.solver).dr;
        for (int i = dr.decisions.limit; i >= 0; --i) {
            int a;
            int dec = dr.decisions.dense[i];
            if (dec > 0 || dr.isFailedAssignment(i)) continue;
            Variable x = dr.varIn(dec);
            Constraint ctr = this.seekConflictingConstraintFor(x, a = dr.idxIn(dec));
            if (ctr == null) {
                ++this.nInferredBacktracks;
                return false;
            }
            this.residues[x.num][a] = ctr;
        }
        return true;
    }
}

