/*
 * Decompiled with CFR 0.152.
 */
package problems.xcsp2;

import constraints.Constraint;
import constraints.hard.CtrGlobal;
import constraints.hard.global.AllEqual;
import constraints.hard.global.Among;
import constraints.hard.global.CardinalityConstant;
import constraints.hard.global.Count;
import constraints.hard.global.Extremum;
import constraints.hard.global.NotAllEqual;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.IntStream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.modeler.definitions.ICtr;
import org.xcsp.modeler.entities.CtrEntities;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import problem.Problem;
import problem.Symbolic;
import problems.xcsp2.XConstraintExtension;
import problems.xcsp2.XExtension;
import problems.xcsp2.XHandler;
import problems.xcsp2.XIntension;
import utility.Enums;
import utility.Kit;
import utility.exceptions.MissingImplementationException;
import utility.interfaces.TagUnguaranteedGAC;
import variables.Variable;
import variables.VariableInteger;
import variables.domains.Domain;

public final class XHandler2
extends XHandler {
    private Map<String, int[]> mapOfDomains;
    private Map<String, String[]> mapOfDomainsSymbolic;
    private Map<String, XConstraintExtension.XRelation> mapOfRelations;
    private Map<String, String[]> mapOfPredicates;
    private String currentReference;
    private String parameters;
    private String functional;
    public static final String NAME = "name";
    public static final String PRESENTATION = "presentation";
    public static final String XCSP_2_0 = "XCSP 2.0";
    public static final String XCSP_2_1 = "XCSP 2.1";
    public static final String MIN_VIOLATED_CONSTRAINTS = "minViolatedConstraints";
    public static final String MAX_CONSTRAINT_ARITY = "maxConstraintArity";
    public static final String REFERENCE = "reference";
    public static final String NB_VARIABLES = "nbVariables";
    public static final String VARIABLE = "variable";
    public static final String DOMAIN = "domain";
    public static final String DOMAINS = "domains";
    public static final String NB_DOMAINS = "nbDomains";
    public static final String NB_VALUES = "nbValues";
    public static final String RELATIONS = "relations";
    public static final String NB_RELATIONS = "nbRelations";
    public static final String RELATION = "relation";
    public static final String NB_TUPLES = "nbTuples";
    public static final String ARITY = "arity";
    public static final String SEMANTICS = "semantics";
    public static final String PREDICATES = "predicates";
    public static final String NB_PREDICATES = "nbPredicates";
    public static final String PREDICATE = "predicate";
    public static final String FUNCTIONS = "functions";
    public static final String NB_FUNCTIONS = "nbFunctions";
    public static final String FUNCTIONAL = "functional";
    public static final String PARAMETERS = "parameters";
    public static final String EXPRESSION = "expression";
    public static final String NB_CONSTRAINTS = "nbConstraints";
    public static final String CONSTRAINT = "constraint";
    public static final String SCOPE = "scope";
    public static final String PREFIX_GLOBAL = "global:";
    public static final String ALL_DIFFERENT_EXCEPT = "allDifferentExcept";
    public static final String ALL_DIFFERENT_ETERNITY = "allDifferentEternity";
    public static final String WEIGHTED_SUM = "weightedSum";
    public static final String EXACTLY = "exactly";
    public static final String AMONG = "among";
    public static final String AT_MOST = "atMost";
    public static final String AT_LEAST = "atLeast";
    public static final String GLOBAL_CARDINALITY = "globalCardinality";
    public static final String OPTIMIZATION = "optimization";
    public static final String MAXIMAL_COST = "maximalCost";
    public static final String INITIAL_COST = "initialCost";
    public static final String NIL = "nil";
    public static final String SOLUTION = "solution";
    public static final String NB_SOLUTIONS = "nbSolutions";

    public XHandler2(Problem problem) {
        super(problem);
    }

    private VariableInteger[] extractVariablesFrom(String stringListOfVariables, Map<String, Variable> map) {
        StringTokenizer st = new StringTokenizer(stringListOfVariables, " \t\n\r\f(),");
        VariableInteger[] t = new VariableInteger[st.countTokens()];
        for (int i = 0; i < t.length; ++i) {
            t[i] = (VariableInteger)map.get(st.nextToken());
            if (t[i] != null) continue;
            return null;
        }
        return t;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals(CONSTRAINT)) {
            this.currentName = attributes.getValue(NAME);
            this.currentScope = this.extractVariablesFrom(attributes.getValue(SCOPE), this.mapOfVars);
            this.currentReference = attributes.getValue(REFERENCE);
        } else if (qName.equals(VARIABLE)) {
            Kit.control(this.configuration.problem.binaryEncoding == Enums.EBinaryEncoding.NO, () -> "No more possible to use binary encoding with XCSP2; Planned for XCSP3");
            String name = attributes.getValue(NAME);
            String domain = attributes.getValue(DOMAIN);
            Variable var = this.mapOfDomains.get(domain) != null ? (Variable)this.problem.api.var(name, this.problem.api.dom(this.mapOfDomains.get(domain)), new Types.TypeClass[0]) : (Variable)this.problem.api.var(name, this.problem.api.dom(this.mapOfDomainsSymbolic.get(domain)), new Types.TypeClass[0]);
            this.mapOfVars.put(name, var);
        } else if (qName.equals(RELATION)) {
            if (this.xextension != null) {
                this.currentBuffer.delete(0, this.currentBuffer.length());
                int arity = Integer.parseInt(attributes.getValue(ARITY));
                int nbTuples = Integer.parseInt(attributes.getValue(NB_TUPLES));
                Enums.ESemantics semantics = Enums.ESemantics.valueOf(attributes.getValue(SEMANTICS).toUpperCase());
                XConstraintExtension.XRelation relation = semantics != Enums.ESemantics.SOFT ? new XConstraintExtension.XRelationHard(arity, nbTuples, semantics) : new XConstraintExtension.XRelationSoft(arity, nbTuples, semantics, Long.parseLong(attributes.getValue(Types.TypeAtt.defaultCost.name())));
                this.currentName = attributes.getValue(NAME);
                this.mapOfRelations.put(this.currentName, relation);
            }
        } else if (qName.equals(PREDICATE)) {
            this.currentName = attributes.getValue(NAME);
        } else if (qName.equals(DOMAIN)) {
            this.currentBuffer.delete(0, this.currentBuffer.length());
            this.currentName = attributes.getValue(NAME);
        } else if (qName.equals(PARAMETERS) || qName.equals(FUNCTIONAL)) {
            this.currentBuffer.delete(0, this.currentBuffer.length());
        } else if (qName.equals(DOMAINS)) {
            this.mapOfDomains = new HashMap<String, int[]>((int)Math.ceil((double)Integer.parseInt(attributes.getValue(NB_DOMAINS)) / 0.7));
            this.mapOfDomainsSymbolic = new HashMap<String, String[]>((int)Math.ceil((double)Integer.parseInt(attributes.getValue(NB_DOMAINS)) / 0.7));
        } else if (!qName.equals("variables")) {
            if (qName.equals(RELATIONS)) {
                this.mapOfRelations = new HashMap<String, XConstraintExtension.XRelation>((int)Math.ceil((double)Integer.parseInt(attributes.getValue(NB_RELATIONS)) / 0.7));
                this.xextension = new XExtension(this);
            } else if (qName.equals(PREDICATES)) {
                this.mapOfPredicates = new HashMap<String, String[]>((int)Math.ceil((double)Integer.parseInt(attributes.getValue(NB_PREDICATES)) / 0.7));
                this.xintension = new XIntension(this);
            } else if (qName.equals("constraints")) {
                if (this.configuration.framework == Types.TypeFramework.WCSP) {
                    String s = attributes.getValue(INITIAL_COST);
                    this.configuration.updateBoundsForWCSP(s == null || s.length() == 0 ? 0L : Long.parseLong(s), Long.parseLong(attributes.getValue(MAXIMAL_COST)));
                }
                this.mapOfDomains.clear();
                this.mapOfDomainsSymbolic.clear();
            } else if (qName.equals(PRESENTATION)) {
                this.controlTypeAndFormat(attributes.getValue(Types.TypeAtt.type.name()), attributes.getValue(Types.TypeAtt.format.name()));
            } else if (qName.equals("objectives")) {
                if (this.problem.framework == Types.TypeFramework.COP) {
                    Kit.log.fine("objectives being loaded...");
                }
            } else if (qName.equals("objective") && this.problem.framework == Types.TypeFramework.COP) {
                this.currentType = attributes.getValue(OPTIMIZATION);
            }
        }
    }

    protected VariableInteger[] modifyConstraintScopeWrtSelectedVariables(String currentConstraintReference, VariableInteger[] currentConstraintScope) {
        if (currentConstraintReference.toLowerCase().equals(PREFIX_GLOBAL + ICtr.ALL_DIFFERENT.toLowerCase())) {
            ArrayList<VariableInteger> list = new ArrayList<VariableInteger>();
            for (VariableInteger var : currentConstraintScope) {
                if (var.num == -2) continue;
                list.add(var);
            }
            return currentConstraintScope.length == 0 ? null : (currentConstraintScope.length != list.size() ? list.toArray(new VariableInteger[list.size()]) : currentConstraintScope);
        }
        for (VariableInteger var : currentConstraintScope) {
            if (var.num != -2) continue;
            return null;
        }
        return currentConstraintScope;
    }

    private int[] buildValues(String stringOfValues) {
        if (Utilities.isInteger((String)stringOfValues)) {
            return new int[]{Integer.parseInt(stringOfValues)};
        }
        StringTokenizer st = new StringTokenizer(stringOfValues);
        if (st.countTokens() == 1) {
            int min = Integer.parseInt(st.nextToken(" \t\n\r\f.."));
            int max = st.hasMoreTokens() ? Integer.parseInt(st.nextToken()) : min;
            return new int[]{min, max, Integer.MAX_VALUE};
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int position = token.indexOf("..");
            if (position == -1) {
                list.add(new Integer(token));
                continue;
            }
            int min = Integer.parseInt(token.substring(0, position));
            int max = Integer.parseInt(token.substring(position + "..".length()));
            for (int i = min; i <= max; ++i) {
                list.add(new Integer(i));
            }
        }
        return Kit.intArray(list);
    }

    private String[] buildNewUniversalPostfixExpression(String[] universalPostfixExpression, String[] universalEffectiveParameters) {
        String[] tokens = new String[universalPostfixExpression.length];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = universalPostfixExpression[i].startsWith("%") ? universalEffectiveParameters[Integer.parseInt(universalPostfixExpression[i].substring(1))] : universalPostfixExpression[i];
        }
        return tokens;
    }

    private String[] extractUniversalEffectiveParameters(String effectiveParametersExpression, String[] variableNames) {
        StringTokenizer st = new StringTokenizer(effectiveParametersExpression);
        String[] effectiveParameters = new String[st.countTokens()];
        for (int i = 0; i < effectiveParameters.length; ++i) {
            String token = st.nextToken();
            if (!Utilities.isInteger((String)token)) {
                int position = Utilities.indexOf((String)token, (String[])variableNames);
                Kit.control(position != -1);
                token = "%" + position;
            }
            effectiveParameters[i] = token;
        }
        return effectiveParameters;
    }

    private String[] buildNewUniversalPostfixExpression(String[] universalPostfixExpression, String effectiveParametersExpression, String[] variableNames) {
        return this.buildNewUniversalPostfixExpression(universalPostfixExpression, this.extractUniversalEffectiveParameters(effectiveParametersExpression, variableNames));
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals(CONSTRAINT)) {
            if (this.configuration.cpv.selectedVars != null) {
                this.currentScope = this.modifyConstraintScopeWrtSelectedVariables(this.currentReference, this.currentScope);
                if (this.currentScope == null) {
                    ++this.problem.stuff.nDiscardedCtrs;
                    return;
                }
            }
            if (this.xextension != null && this.mapOfRelations.containsKey(this.currentReference)) {
                this.xextension.treat(this.currentName, this.currentScope, this.mapOfRelations.get(this.currentReference));
            } else if (this.xintension != null && this.mapOfPredicates.containsKey(this.currentReference)) {
                Arrays.sort(this.currentScope);
                String[] varNames = this.buildStringArrayWithNamesOf(this.currentScope);
                String[] predicate = this.buildNewUniversalPostfixExpression(this.mapOfPredicates.get(this.currentReference), this.parameters, varNames);
                this.xintension.treat(this.currentName, this.currentScope, predicate);
            } else {
                Constraint c = (Constraint)((CtrEntities.CtrAlone)this.buildGlobalConstraint()).ctr;
                if (c == null) {
                    ++this.problem.stuff.nDiscardedCtrs;
                } else {
                    c.setId(this.currentName);
                }
            }
        } else if (qName.equals(RELATION)) {
            if (this.xextension != null) {
                if (Kit.getUsedMemory() > this.configuration.hardCoding.relationContractionLimit && this.contractor == null) {
                    Kit.log.info("Contraction of relations, mem = " + Kit.getFormattedUsedMemorySize());
                    this.contractor = new Kit.Contractor();
                    for (XConstraintExtension.XRelation relation : this.mapOfRelations.values()) {
                        if (relation.tuples == null) continue;
                        this.contractor.contract(relation.tuples);
                    }
                }
                XConstraintExtension.XRelation relation = this.mapOfRelations.get(this.currentName);
                String s = this.currentBuffer.toString().trim();
                if (s.length() == 0 || Character.isDigit(s.charAt(0)) || s.charAt(0) == '-' || s.charAt(0) == '+') {
                    relation.setTuplesFrom(s);
                } else {
                    relation.setTuplesFrom(this.problem.symbolic.replaceSymbols(s));
                }
                if (this.contractor != null) {
                    this.contractor.contract(relation.tuples);
                }
            }
        } else if (qName.equals(PREDICATE)) {
            if (this.xintension != null) {
                this.mapOfPredicates.put(this.currentName, this.buildUniversalPostfixExpression(this.functional, this.parameters));
            }
        } else if (qName.equals(DOMAIN)) {
            String s = this.currentBuffer.toString().trim();
            if (Character.isDigit(s.charAt(0)) || s.charAt(0) == '-' || s.charAt(0) == '+') {
                this.mapOfDomains.put(this.currentName, this.buildValues(s));
            } else {
                Kit.control(!this.problem.rs.cp.export, () -> "Currently not possible to save a problem with symbolic values when loaded from an XML file");
                String[] symbols = s.split("\\s+");
                this.mapOfDomainsSymbolic.put(this.currentName, symbols);
                if (this.problem.symbolic == null) {
                    this.problem.symbolic = new Symbolic();
                }
                this.problem.symbolic.manageSymbols(symbols);
            }
        } else if (qName.equals("objective")) {
            this.treatObjective(this.functional);
        } else if (qName.equals(PARAMETERS)) {
            this.parameters = this.currentBuffer.toString();
        } else if (qName.equals(FUNCTIONAL)) {
            this.functional = this.currentBuffer.toString();
        } else if (qName.equals(DOMAINS)) {
            this.problem.nValuesRemoved = 0;
        } else if (!(qName.equals("variables") || qName.equals("constraints") || qName.equals("objectives"))) {
            if (qName.equals("instance")) {
                Kit.control(this.configuration.problem.binaryEncoding == Enums.EBinaryEncoding.NO || this.xextension != null);
                if (this.xextension != null) {
                    this.xextension.postConstraints();
                }
                if (this.xintension != null) {
                    this.xintension.postConstraints();
                }
                if (this.xextension != null) {
                    this.xextension.clear();
                    if (this.mapOfRelations != null) {
                        this.mapOfRelations.clear();
                    }
                }
                if (this.xintension != null) {
                    this.xintension.clear();
                    if (this.mapOfPredicates != null) {
                        this.mapOfPredicates.clear();
                    }
                }
                if (this.contractor != null) {
                    this.contractor.clear();
                }
                this.mapOfDomains.clear();
                this.mapOfDomainsSymbolic.clear();
                this.mapOfVars.clear();
                System.gc();
            } else {
                this.currentBuffer.append(" " + qName + " ");
            }
        }
    }

    private CtrEntities.CtrAlone buildWeightedSum() {
        int[] coefficients = new int[this.currentScope.length];
        StringTokenizer st = new StringTokenizer(this.parameters, " \t\n\r\f[{}");
        String coeffToken = st.nextToken();
        while (!coeffToken.equals("]")) {
            int vap;
            String token = st.nextToken();
            int n = vap = IntStream.range(0, this.currentScope.length).filter(i -> this.currentScope[i].id().equals(token)).findFirst().orElse(-1);
            coefficients[n] = coefficients[n] + Integer.parseInt(coeffToken);
            coeffToken = st.nextToken();
        }
        Types.TypeConditionOperatorRel operator = (Types.TypeConditionOperatorRel)Types.valueOf(Types.TypeConditionOperatorRel.class, (String)st.nextToken());
        int limit = Integer.parseInt(st.nextToken());
        return (CtrEntities.CtrAlone)this.problem.api.sum((IVar.Var[])this.currentScope, coefficients, operator, (long)limit);
    }

    private CtrEntities.CtrEntity buildElement() {
        StringTokenizer st = new StringTokenizer(this.parameters, " \t\n\r\f[]");
        VariableInteger varIndex = (VariableInteger)this.mapOfVars.get(st.nextToken());
        String token = st.nextToken();
        if (Utilities.isInteger((String)token)) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            while (st.hasMoreTokens()) {
                list.add(Integer.parseInt(token));
                token = st.nextToken();
            }
            int[] t = Kit.intArray(list);
            Kit.control(t.length == varIndex.dom.initSize());
            int offset = varIndex.dom.firstValue();
            Kit.control(IntStream.range(0, t.length).allMatch(i -> varIndex.dom.isPresentValue(i + offset)));
            int[][] tuples = (int[][])IntStream.range(0, t.length).mapToObj(i -> new int[]{i + offset, t[i]}).toArray(x$0 -> new int[x$0][]);
            return this.problem.api.extension((IVar.Var[])new VariableInteger[]{varIndex, (VariableInteger)this.mapOfVars.get(token)}, tuples);
        }
        ArrayList<VariableInteger> list = new ArrayList<VariableInteger>();
        while (st.hasMoreTokens()) {
            list.add((VariableInteger)this.mapOfVars.get(token));
            token = st.nextToken();
        }
        IVar.Var[] varsVector = list.toArray(new VariableInteger[list.size()]);
        System.out.println("VECT=" + Kit.join((Object)varsVector, new String[0]));
        if (Utilities.isInteger((String)token)) {
            return this.problem.api.element(varsVector, (IVar.Var)varIndex, Integer.parseInt(token));
        }
        return this.problem.api.element(varsVector, (IVar.Var)varIndex, (IVar.Var)((VariableInteger)this.mapOfVars.get(token)));
    }

    private CtrEntities.CtrAlone buildAtLeastAtMostExactly(String lowercaseReference) {
        StringTokenizer st = new StringTokenizer(this.parameters, " \t\n\r\f{}");
        int k = Integer.parseInt(st.nextToken());
        st.nextToken();
        String token = st.nextToken();
        while (!token.equals("]")) {
            token = st.nextToken();
        }
        int value = Integer.parseInt(st.nextToken());
        if (k > 1) {
            if (lowercaseReference.equals(PREFIX_GLOBAL + AT_LEAST.toLowerCase())) {
                return this.problem.addCtr(new Count.AtLeastK(this.problem, this.currentScope, value, k), new Types.TypeClass[0]);
            }
            if (lowercaseReference.equals(PREFIX_GLOBAL + AT_MOST.toLowerCase())) {
                return this.problem.addCtr(new Count.AtMostK(this.problem, this.currentScope, value, k), new Types.TypeClass[0]);
            }
            return this.problem.addCtr(new Count.ExactlyK(this.problem, this.currentScope, value, k), new Types.TypeClass[0]);
        }
        if (lowercaseReference.equals(PREFIX_GLOBAL + AT_LEAST.toLowerCase())) {
            return this.problem.addCtr(new Count.AtLeast1(this.problem, this.currentScope, value), new Types.TypeClass[0]);
        }
        if (lowercaseReference.equals(PREFIX_GLOBAL + AT_MOST.toLowerCase())) {
            return this.problem.addCtr(new Count.AtMost1(this.problem, this.currentScope, value), new Types.TypeClass[0]);
        }
        return this.problem.addCtr(new Count.Exactly1(this.problem, this.currentScope, value), new Types.TypeClass[0]);
    }

    private CtrEntities.CtrAlone buildAmong() {
        StringTokenizer st = new StringTokenizer(this.parameters, " \t\n\r\f{}");
        int k = Integer.parseInt(st.nextToken());
        st.nextToken();
        String token = st.nextToken();
        while (!token.equals("]")) {
            token = st.nextToken();
        }
        ArrayList<Integer> values = new ArrayList<Integer>();
        st.nextToken();
        token = st.nextToken();
        while (!token.equals("]")) {
            values.add(Integer.parseInt(token));
            token = st.nextToken();
        }
        return this.problem.addCtr(new Among(this.problem, this.currentScope, Kit.intArray(values), k), new Types.TypeClass[0]);
    }

    private CtrEntities.CtrAlone buildGlobalCardinality() {
        StringTokenizer st = new StringTokenizer(this.parameters, " \t\n\r\f{}");
        st.nextToken();
        String token = st.nextToken();
        while (!token.equals("]")) {
            token = st.nextToken();
        }
        ArrayList<Integer> keys = new ArrayList<Integer>();
        st.nextToken();
        token = st.nextToken();
        while (!token.equals("]")) {
            keys.add(Integer.parseInt(token));
            token = st.nextToken();
        }
        ArrayList<Integer> minOccurrences = new ArrayList<Integer>();
        st.nextToken();
        token = st.nextToken();
        while (!token.equals("]")) {
            minOccurrences.add(Integer.parseInt(token));
            token = st.nextToken();
        }
        ArrayList<Integer> maxOccurrences = new ArrayList<Integer>();
        if (st.hasMoreTokens()) {
            st.nextToken();
            token = st.nextToken();
            while (!token.equals("]")) {
                maxOccurrences.add(Integer.parseInt(token));
                token = st.nextToken();
            }
        } else {
            maxOccurrences = minOccurrences;
        }
        return this.problem.addCtr(new CardinalityConstant(this.problem, this.currentScope, Kit.intArray(keys), Kit.intArray(minOccurrences), Kit.intArray(maxOccurrences)), new Types.TypeClass[0]);
    }

    private CtrEntities.CtrEntity buildGlobalConstraint() {
        if (this.configuration.problem.binaryEncoding != Enums.EBinaryEncoding.NO) {
            return null;
        }
        String lowercaseReference = this.currentReference.toLowerCase();
        if (lowercaseReference.equals(PREFIX_GLOBAL + ICtr.ALL_DIFFERENT.toLowerCase())) {
            return this.problem.allDifferent(this.currentScope);
        }
        if (lowercaseReference.equals(PREFIX_GLOBAL + ICtr.ALL_EQUAL.toLowerCase())) {
            return this.problem.addCtr(new AllEqual(this.problem, this.currentScope), new Types.TypeClass[0]);
        }
        if (lowercaseReference.equals(PREFIX_GLOBAL + "notAllEqualTokens".toLowerCase())) {
            return this.problem.addCtr(new NotAllEqual(this.problem, this.currentScope), new Types.TypeClass[0]);
        }
        if (lowercaseReference.equals(PREFIX_GLOBAL + ICtr.MINIMUM.toLowerCase())) {
            return this.problem.addCtr(new Extremum.Minimum(this.problem, Arrays.copyOfRange(this.currentScope, 1, this.currentScope.length), this.currentScope[0]), new Types.TypeClass[0]);
        }
        if (lowercaseReference.equals(PREFIX_GLOBAL + ICtr.MAXIMUM.toLowerCase())) {
            return this.problem.addCtr(new Extremum.Maximum(this.problem, Arrays.copyOfRange(this.currentScope, 1, this.currentScope.length - 1), this.currentScope[0]), new Types.TypeClass[0]);
        }
        if (lowercaseReference.equals(PREFIX_GLOBAL + ICtr.ELEMENT.toLowerCase())) {
            return this.buildElement();
        }
        if (lowercaseReference.equals(PREFIX_GLOBAL + WEIGHTED_SUM.toLowerCase())) {
            return this.buildWeightedSum();
        }
        if (lowercaseReference.equals(PREFIX_GLOBAL + AT_LEAST.toLowerCase()) || lowercaseReference.equals(PREFIX_GLOBAL + AT_MOST.toLowerCase()) || lowercaseReference.equals(PREFIX_GLOBAL + EXACTLY.toLowerCase())) {
            return this.buildAtLeastAtMostExactly(lowercaseReference);
        }
        if (lowercaseReference.equals(PREFIX_GLOBAL + AMONG.toLowerCase())) {
            return this.buildAmong();
        }
        if (lowercaseReference.equals(PREFIX_GLOBAL + GLOBAL_CARDINALITY.toLowerCase())) {
            return this.buildGlobalCardinality();
        }
        Kit.log.info("Unrecognized (unimplemented) constraint " + this.currentReference + "\n");
        return null;
    }

    public class CumulativexCSP2
    extends CtrGlobal
    implements TagUnguaranteedGAC {
        private Task[] tasks;
        private int limit;
        private int firstTime;
        private int lastTime;

        @Override
        public int[] defineSymmetryMatching() {
            return Kit.range(1, this.scp.length);
        }

        public CumulativexCSP2(Problem problem, Variable[] scope, Task[] tasks, int limit) {
            super(problem, scope);
            this.tasks = tasks;
            String s = "";
            for (Task task : tasks) {
                if (!(task.getOrigin() instanceof Variable && task.getDuration() instanceof Integer && task.getEnd() == null && task.getHeight() instanceof Integer)) {
                    throw new MissingImplementationException();
                }
                task.setVariablePositions(scope);
                s = s + task + " ";
            }
            this.limit = limit;
            this.defineKey(s, limit);
            Domain domain = ((Variable)tasks[0].getOrigin()).dom;
            this.firstTime = domain.firstValue();
            this.lastTime = domain.lastValue();
            for (int i = 1; i < tasks.length; ++i) {
                domain = ((Variable)tasks[i].getOrigin()).dom;
                this.firstTime = Math.min(this.firstTime, domain.firstValue());
                this.lastTime = Math.max(this.lastTime, domain.lastValue());
            }
        }

        @Override
        public boolean checkValues(int[] vals) {
            for (Task task : this.tasks) {
                if (task.evaluate(vals) != 1) continue;
                return false;
            }
            for (int i = 0; i < this.tasks.length; ++i) {
                for (int period = this.tasks[i].getOriginValue(); period < this.tasks[i].getEndValue(); ++period) {
                    int heightSum = this.tasks[i].getHeightValue();
                    for (int j = i + 1; j < this.tasks.length; ++j) {
                        if (period < this.tasks[j].getOriginValue() || period >= this.tasks[j].getEndValue()) continue;
                        heightSum += this.tasks[j].getHeightValue();
                    }
                    if (heightSum <= this.limit) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean runPropagator(Variable evt) {
            for (int time = this.firstTime; time <= this.lastTime; ++time) {
                int cnt = 0;
                for (int i = 0; i < this.tasks.length; ++i) {
                    Domain domain = ((Variable)this.tasks[i].getOrigin()).dom;
                    int min = domain.firstValue();
                    int max = domain.lastValue();
                    int duration = (Integer)this.tasks[i].getDuration();
                    if (min <= time && time < min + duration && max <= time && time < max + duration) {
                        cnt += ((Integer)this.tasks[i].getHeight()).intValue();
                    }
                    if (cnt <= this.limit) continue;
                    return false;
                }
            }
            return true;
        }

        public final class Task {
            private Object origin;
            private int originPositionInScope;
            private int originValue;
            private Object duration;
            private int durationPositionInScope;
            private int durationValue;
            private Object end;
            private int endPositionInScope;
            private int endValue;
            private Object height;
            private int heightPositionInScope;
            private int heightValue;

            public Object getOrigin() {
                return this.origin;
            }

            public int getOriginValue() {
                return this.originValue;
            }

            public Object getDuration() {
                return this.duration;
            }

            public int getDurationValue() {
                return this.durationValue;
            }

            public Object getEnd() {
                return this.end;
            }

            public int getEndValue() {
                return this.endValue;
            }

            public Object getHeight() {
                return this.height;
            }

            public int getHeightValue() {
                return this.heightValue;
            }

            public Task(Object origin, Object duration, Object end, Object height) {
                this.origin = origin;
                this.duration = duration;
                this.end = end;
                this.height = height;
            }

            public void setVariablePositions(Object[] scope) {
                this.originPositionInScope = Utilities.indexOf((Object)this.origin, (Object[])scope);
                this.durationPositionInScope = Utilities.indexOf((Object)this.duration, (Object[])scope);
                this.endPositionInScope = Utilities.indexOf((Object)this.end, (Object[])scope);
                this.heightPositionInScope = Utilities.indexOf((Object)this.height, (Object[])scope);
            }

            public int evaluate(int[] tuple) {
                if (this.origin != null) {
                    int n = this.originValue = this.origin instanceof Integer ? (Integer)this.origin : tuple[this.originPositionInScope];
                }
                if (this.duration != null) {
                    int n = this.durationValue = this.duration instanceof Integer ? (Integer)this.duration : tuple[this.durationPositionInScope];
                }
                if (this.end != null) {
                    int n = this.endValue = this.end instanceof Integer ? (Integer)this.end : tuple[this.endPositionInScope];
                }
                if (this.origin != null && this.duration != null && this.end != null && this.originValue + this.durationValue != this.endValue) {
                    return 1;
                }
                if (this.origin == null) {
                    this.originValue = this.endValue - this.durationValue;
                }
                if (this.end == null) {
                    this.endValue = this.originValue + this.durationValue;
                }
                this.heightValue = this.height instanceof Integer ? (Integer)this.height : tuple[this.heightPositionInScope];
                return 0;
            }

            public void displayEvaluations() {
                System.out.println(this.originValue + " " + this.durationValue + " " + this.endValue + " " + this.heightValue);
            }

            public String toString() {
                return " [origin=" + this.origin + " duration=" + this.duration + " end=" + this.end + " height=" + this.height + "]\n\t";
            }
        }
    }
}

