/*
 * Decompiled with CFR 0.152.
 */
package problems.xcsp2;

import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;
import problem.Problem;
import problems.ProblemFile;
import problems.xcsp2.XHandler2;
import utility.Kit;

public class XCSP2
extends ProblemFile {
    public int greatestOriginalVariableId;

    @Override
    protected String[] defineSuffixFilters() {
        return new String[]{".xml", ".bz2", ".lzma"};
    }

    public void model() {
        try {
            XHandler2 handler = new XHandler2((Problem)this.imp());
            String fileName = this.currFileName();
            if (fileName == null) {
                SAXParserFactory.newInstance().newSAXParser().parse(System.in, (DefaultHandler)handler);
            } else if (fileName.endsWith(".bz2") || fileName.endsWith(".lzma")) {
                Process p = Runtime.getRuntime().exec((fileName.endsWith(".bz2") ? "bunzip2 -c " : "lzma -c -d ") + fileName);
                SAXParserFactory.newInstance().newSAXParser().parse(p.getInputStream(), (DefaultHandler)handler);
                p.waitFor();
                p.exitValue();
                p.destroy();
            } else {
                SAXParserFactory.newInstance().newSAXParser().parse(fileName, (DefaultHandler)handler);
            }
        }
        catch (Exception e) {
            Kit.exit("Pb when loading the XCSP instance", e);
        }
    }
}

