/*
 * Decompiled with CFR 0.152.
 */
package problems.tran;

import constraints.Constraint;
import constraints.hard.CtrExtension;
import constraints.hard.extension.structures.ExtensionStructureHard;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.xcsp.common.Utilities;
import problem.Problem;
import problems.xcsp2.XCSP2;
import utility.Kit;
import variables.Variable;

public class WcspWriter
extends XCSP2 {
    @Override
    public void model() {
        super.model();
        Problem pb = (Problem)this.imp();
        String s = pb.formattedPbParameters();
        s = s.substring(1, s.lastIndexOf("."));
        File file = new File(s + ".wcsp");
        System.out.println(s + ".wcsp");
        HashMap<ExtensionStructureHard, Integer> map = new HashMap<ExtensionStructureHard, Integer>();
        try {
            Variable[] vars = (Variable[])pb.stuff.collectedVarsAtInit.stream().toArray(Variable[]::new);
            Constraint[] ctrs = (Constraint[])pb.stuff.collectedCtrsAtInit.stream().toArray(Constraint[]::new);
            Kit.control(Stream.of(vars).allMatch(x -> x.dom.firstValue() == 0 && x.dom.lastValue() == x.dom.size() - 1));
            Kit.control(Stream.of(ctrs).allMatch(c -> c instanceof CtrExtension));
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file, false)));
            out.print(s);
            out.print(" " + vars.length);
            out.print(" " + Stream.of(vars).mapToInt(x -> x.dom.size()).max().getAsInt());
            out.print(" " + pb.stuff.collectedCtrsAtInit.size());
            out.println(" " + pb.stuff.collectedCtrsAtInit.size());
            out.println(Stream.of(vars).map(x -> x.dom.size() + "").collect(Collectors.joining(" ")));
            int cnt = 1;
            for (Constraint c2 : ctrs) {
                ExtensionStructureHard ec = (ExtensionStructureHard)c2.extStructure();
                int arity = c2.scp.length;
                int nTuples = ec.originalTuples.length;
                if (ec.registeredCtrs().size() > 1) {
                    if (ec.registeredCtrs().get(0) == c2) {
                        arity = -arity;
                        map.put(ec, cnt++);
                    } else {
                        nTuples = -((Integer)map.get(ec)).intValue();
                    }
                }
                out.println(arity + " " + Stream.of(c2.scp).map(x -> Utilities.indexOf((Object)x, (Object[])vars) + "").collect(Collectors.joining(" ")) + " 1 " + nTuples);
                if (nTuples <= 0) continue;
                for (int[] t : ec.originalTuples) {
                    out.println(Kit.join((Object)t, new String[0]) + " 0");
                }
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(pb.stuff.collectedCtrsAtInit.size());
    }
}

