/*
 * Decompiled with CFR 0.152.
 */
package problems.tran;

import constraints.soft.extension.CtrSoftExtension;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Scanner;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;
import problem.Problem;
import utility.Kit;
import utility.operations.Calculator;
import variables.Variable;

public class WcspReader
implements ProblemAPI {
    int nVars;
    int nCtrs;
    long c0;
    long ub;
    int[] domSizes;
    Soft[] ctrs;

    void data() {
        String fileName = this.imp().askString("Instance filename");
        ArrayList<Soft> list = new ArrayList<Soft>();
        try (Scanner scanner = new Scanner(new File(fileName));){
            scanner.next();
            this.nVars = scanner.nextInt();
            scanner.nextInt();
            this.nCtrs = scanner.nextInt();
            this.ub = scanner.nextLong();
            if (((Problem)this.imp()).rs.cp.optimizing.upperBound < this.ub) {
                Kit.log.warning("UpperBound given is less than the upperBound found in the file " + ((Problem)this.imp()).rs.cp.optimizing.upperBound + " < " + this.ub);
                this.ub = ((Problem)this.imp()).rs.cp.optimizing.upperBound;
            }
            this.domSizes = IntStream.range(0, this.nVars).map(i -> scanner.nextInt()).toArray();
            this.c0 = 0L;
            for (int cnt = 0; cnt < this.nCtrs; ++cnt) {
                int arity = scanner.nextInt();
                int[] scope = IntStream.range(0, arity).map(i -> scanner.nextInt()).toArray();
                long defaultCost = Math.min(this.ub, scanner.nextLong());
                if (arity == 0) {
                    this.c0 = Calculator.add(this.c0, defaultCost);
                    continue;
                }
                int nbTuples = scanner.nextInt();
                long[][] tuplesWithCosts = (long[][])IntStream.range(0, nbTuples).mapToObj(i -> IntStream.range(0, arity + 1).mapToLong(j -> j < arity ? (long)scanner.nextInt() : Math.min(this.ub, scanner.nextLong())).toArray()).toArray(x$0 -> new long[x$0][]);
                Arrays.sort(tuplesWithCosts, Kit.lexComparatorLong);
                int[][] tuples = (int[][])Stream.of(tuplesWithCosts).map(t -> Arrays.stream(t).mapToInt(i -> (int)i).toArray()).toArray(x$0 -> new int[x$0][]);
                long[] costs = Stream.of(tuplesWithCosts).mapToLong(t -> t[arity]).toArray();
                list.add(new Soft().set(scope, defaultCost, tuples, costs));
            }
        }
        catch (FileNotFoundException e) {
            Kit.exit("Error with File " + fileName, e);
        }
        this.ctrs = list.toArray(new Soft[list.size()]);
    }

    public void model() {
        IVar.Var[] x = this.array("x", this.size(this.nVars), i -> this.dom(this.range(this.domSizes[i])), new Types.TypeClass[0]);
        Stream.of(this.ctrs).forEach(c -> ((Problem)this.imp()).addCtr(new CtrSoftExtension((Problem)this.imp(), (Variable[])Arrays.stream(c.scope).mapToObj(i -> x[i]).toArray(Variable[]::new), c.tuples, c.costs, c.defaultCost), new Types.TypeClass[0]));
        Kit.log.info(" c0=" + this.c0 + " k=" + this.ub);
        ((Problem)this.imp()).rs.cp.updateBoundsForWCSP(this.c0, this.ub);
    }

    private class Soft {
        int[] scope;
        long defaultCost;
        int[][] tuples;
        long[] costs;

        private Soft() {
        }

        Soft set(int[] scope, long defaultCost, int[][] tuples, long[] costs) {
            this.scope = scope;
            this.defaultCost = defaultCost;
            this.tuples = tuples;
            this.costs = costs;
            return this;
        }
    }
}

