/*
 * Decompiled with CFR 0.152.
 */
package problems.tran;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Scanner;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.modeler.api.ProblemAPI;
import utility.Kit;
import variables.Variable;

public class Planning
implements ProblemAPI {
    String[] fluents;
    Action[] actions;
    int nActions;
    int timeLimit = 30;
    int nMaxPrecs;
    int nMaxSupps;
    int nMaxDels;
    int[][][] possibleSupporters;
    int[][][] deleters;

    void data() {
        int j2;
        int i2;
        String fileName = this.imp().askString("instance filename");
        try (Scanner scanner = new Scanner(new File(fileName));){
            while (scanner.hasNext("#.*")) {
                scanner.nextLine();
            }
            int nbFluents = scanner.nextInt();
            this.fluents = (String[])IntStream.range(0, nbFluents).mapToObj(i -> scanner.next()).toArray(String[]::new);
            while (scanner.hasNext("#.*")) {
                scanner.nextLine();
            }
            this.nActions = scanner.nextInt();
            this.actions = new Action[this.nActions];
            for (int i3 = 0; i3 < this.actions.length; ++i3) {
                String name = scanner.next();
                int duration = scanner.nextInt();
                int[] precs = IntStream.range(0, scanner.nextInt()).map(j -> scanner.nextInt()).toArray();
                int[] adds = IntStream.range(0, scanner.nextInt()).map(j -> scanner.nextInt()).toArray();
                int[] dels = IntStream.range(0, scanner.nextInt()).map(j -> scanner.nextInt()).toArray();
                dels = Arrays.stream(dels).filter(d -> !Kit.isPresent(d, adds)).toArray();
                this.actions[i3] = new Action(name, duration, precs, adds, dels);
            }
        }
        catch (IOException e) {
            Kit.exit("Erreur ouverture fichier", e);
        }
        this.nMaxPrecs = Stream.of(this.actions).mapToInt(a -> a.precs.length).max().orElse(-1);
        int[][][] t = new int[this.actions.length][][];
        for (i2 = 0; i2 < t.length; ++i2) {
            t[i2] = new int[this.actions[i2].precs.length][];
            for (j2 = 0; j2 < t[i2].length; ++j2) {
                t[i2][j2] = this.supportersOfExcept(this.actions[i2].precs[j2], i2);
                this.nMaxSupps = Math.max(this.nMaxSupps, t[i2][j2].length);
            }
        }
        this.possibleSupporters = t;
        t = new int[this.actions.length][][];
        for (i2 = 0; i2 < t.length; ++i2) {
            t[i2] = new int[this.actions[i2].precs.length][];
            for (j2 = 0; j2 < t[i2].length; ++j2) {
                t[i2][j2] = this.deletersOf(this.actions[i2].precs[j2]);
                this.nMaxDels = Math.max(this.nMaxDels, t[i2][j2].length);
            }
        }
        this.deleters = t;
    }

    int[] deletersOf(int prec) {
        return IntStream.range(0, this.actions.length).filter(i -> Arrays.binarySearch(this.actions[i].dels, prec) >= 0).toArray();
    }

    int[] supportersOfExcept(int prec, int action) {
        return IntStream.range(0, this.actions.length).filter(i -> i != action && Arrays.binarySearch(this.actions[i].adds, prec) >= 0).toArray();
    }

    XNodeParent<IVar> buildPreconditionPredicate(IVar x, IVar y, IVar z) {
        return this.or(new Object[]{this.eq(new Object[]{x, -1}), this.ne(new Object[]{y, ((Variable)z).num}), this.and(new Object[]{this.ne(new Object[]{z, -1}), this.le(this.add(new Object[]{z, this.actions[((Variable)z).num].duration}), x)})});
    }

    XNodeParent<IVar> buildCausalPredicate(IVar x, IVar y, IVar z, IVar w) {
        return this.or(new Object[]{this.eq(new Object[]{x, -1}), this.ne(new Object[]{y, ((Variable)z).num}), this.and(new Object[]{this.ne(new Object[]{z, -1}), this.or(new Object[]{this.eq(new Object[]{w, -1}), this.lt(this.add(new Object[]{w, this.actions[((Variable)w).num].duration}), z), this.lt(this.add(new Object[]{x, this.actions[((Variable)x).num].duration}), w)})})});
    }

    public void model() {
        IVar.Var[] a = this.array("a", this.size(this.actions.length), i -> i == 0 ? this.dom(0, new int[0]) : (i == 1 ? this.dom(this.range(this.timeLimit + 1)) : this.dom(this.range(-1, this.timeLimit + 1))), new Types.TypeClass[0]);
        IVar.Var[][] x = this.array("x", this.size(this.actions.length, this.nMaxPrecs), (i, j) -> j < this.actions[i].precs.length ? this.dom(this.supportersOfExcept(this.actions[i].precs[j], i)) : null, new Types.TypeClass[0]);
        this.forall(this.range(2, this.nActions), i -> this.intension(this.le(this.sub(a[i], a[1]), this.actions[i].duration)));
        this.forall(this.range(this.nActions).range(this.nMaxPrecs).range(this.nMaxSupps), (i, j, k) -> {
            if (j < this.actions[i].precs.length && k < this.possibleSupporters[i][j].length) {
                this.intension(this.buildPreconditionPredicate((IVar)a[i], (IVar)x[i][j], (IVar)a[this.possibleSupporters[i][j][k]]));
            }
        });
        this.forall(this.range(this.nActions).range(this.nMaxPrecs).range(this.nMaxSupps).range(this.nMaxDels), (i, j, k, l) -> {
            if (j < this.actions[i].precs.length && k < this.possibleSupporters[i][j].length && l < this.deleters[i][j].length && i != this.deleters[i][j][l]) {
                this.intension(this.buildCausalPredicate((IVar)a[i], (IVar)x[i][j], (IVar)a[this.possibleSupporters[i][j][k]], (IVar)a[this.deleters[i][j][l]]));
            }
        });
    }

    class Action {
        String name;
        int duration;
        int[] precs;
        int[] adds;
        int[] dels;

        Action() {
        }

        Action(String name, int duration, int[] precs, int[] adds, int[] dels) {
            this.name = name;
            this.duration = duration;
            this.precs = Kit.sort(precs);
            this.adds = Kit.sort(adds);
            this.dels = Kit.sort(dels);
        }

        public String toString() {
            return this.name + " " + this.duration + " precs = (" + Kit.join((Object)this.precs, new String[0]) + ") adds = (" + Kit.join((Object)this.adds, new String[0]) + ") dels = (" + Kit.join((Object)this.dels, new String[0]) + ")";
        }
    }
}

