/*
 * Decompiled with CFR 0.152.
 */
package problems.todo;

import constraints.hard.extension.structures.SmartTuple;
import constraints.hard.global.SeqBin;
import java.util.ArrayList;
import java.util.stream.IntStream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.modeler.api.ProblemAPI;
import org.xcsp.modeler.entities.CtrEntities;
import org.xcsp.modeler.implementation.NotData;
import problem.Problem;
import problems.ReaderFile;
import utility.Kit;
import variables.VariableInteger;

public class SportsBreaks
implements ProblemAPI,
ReaderFile.ReaderTxt {
    int nTeams;
    int nWeeks;
    int[][][] schedule;
    @NotData
    IVar.Var[] wo;
    @NotData
    IVar.Var[][] mo;
    @NotData
    IVar.Var[][] h;
    @NotData
    IVar.Var[] b;
    int[][][] newSchedule;

    void data() {
        int p = 0;
        while (this.hasNextLine()) {
            String[] toks = this.nextLine().split("\\s+");
            if (this.nTeams == 0) {
                this.nWeeks = toks.length;
                this.nTeams = toks.length + 1;
                this.schedule = new int[this.nTeams / 2][this.nWeeks][];
            }
            for (int w = 0; w < this.nWeeks; ++w) {
                this.schedule[p][w] = new int[]{Integer.parseInt(toks[w].split("vs")[0]), Integer.parseInt(toks[w].split("vs")[1])};
            }
            ++p;
        }
        Kit.control(p == this.nTeams / 2);
    }

    int periodOf(int w, int t) {
        return IntStream.range(0, this.nTeams / 2).filter(i -> this.schedule[i][w][0] == t || this.schedule[i][w][1] == t).findFirst().orElse(-1);
    }

    boolean homeOf(int w, int t) {
        return this.schedule[IntStream.range(0, this.nTeams / 2).filter(i -> this.schedule[i][w][0] == t || this.schedule[i][w][1] == t).findFirst().orElse(-1)][w][0] == t;
    }

    SmartTuple buildSmartTupleFor(IVar.Var[] scpKeeps, int t, int w, int weekNewPosition) {
        ArrayList<XNodeParent<? extends IVar>> list = new ArrayList<XNodeParent<? extends IVar>>();
        IntStream.range(0, this.nWeeks).forEach(i -> list.add(i == weekNewPosition ? this.eq(new Object[]{this.wo[i], w}) : this.ne(new Object[]{this.wo[i], w})));
        list.add(this.homeOf(weekNewPosition, t) ? this.eq(new Object[]{scpKeeps[weekNewPosition], this.h[t][w]}) : this.ne(new Object[]{scpKeeps[weekNewPosition], this.h[t][w]}));
        return new SmartTuple(list);
    }

    CtrEntities.CtrAlone buildSmart(int t, int w) {
        IVar.Var[] scpKeeps = (IVar.Var[])this.variablesFrom(this.range(this.nWeeks), wi -> this.mo[this.periodOf((int)wi, t)][wi]);
        SmartTuple[] smartTuples = (SmartTuple[])this.range(this.nWeeks).mapToObj(wi -> this.buildSmartTupleFor(scpKeeps, t, w, wi));
        return ((Problem)this.imp()).smart(this.vars(this.wo, new Object[]{scpKeeps, this.h[t][w]}), smartTuples);
    }

    public void model() {
        this.wo = this.array("wo", this.size(this.nWeeks), this.dom(this.range(this.nWeeks)), "Weeks Order: wo[w] is the position of the week w of the initial schedule after reordering", new Types.TypeClass[0]);
        this.mo = this.array("mo", this.size(this.nTeams / 2, this.nWeeks), this.dom(0, new int[]{1}), "Keep Matchs Order: mo[p][w] is true iff we keep the order (home/away) of the match on period p and week w before reordering", new Types.TypeClass[0]);
        this.h = this.array("h", this.size(this.nTeams, this.nWeeks), this.dom(0, new int[]{1}), "h[t][w] is true iff team t plays at home on week w after reordering", new Types.TypeClass[0]);
        this.b = this.array("b", this.size(this.nTeams), this.dom(this.rangeClosed(1, this.nWeeks)), "b[t] counts the number of breaks for team t in the solution", new Types.TypeClass[0]);
        this.allDifferent(this.wo);
        this.forall(this.range(this.nTeams).range(this.nWeeks), (t, w) -> this.buildSmart(t, w));
        this.forall(this.range(this.nTeams), t -> ((Problem)this.imp()).addCtr(new SeqBin((Problem)this.imp(), (VariableInteger)this.b[t], (VariableInteger[])this.h[t], EQ, null), new Types.TypeClass[0]));
        this.equal(new Object[]{this.mo[0][0], 0});
        this.intension(this.le(this.wo[0], this.nWeeks / 2 + 1));
        this.minimize(SUM, (IVar[])this.b);
    }
}

