/*
 * Decompiled with CFR 0.152.
 */
package problems.soft;

import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;
import problem.Problem;
import utility.operations.GraphSimpleUndirected;

public class LinearArrangementSoft
implements ProblemAPI {
    String fileName = this.imp().askString("Graph");
    GraphSimpleUndirected graph = GraphSimpleUndirected.loadGraph(this.fileName);
    int nNodes;
    IVar.Var[] primal;
    IVar.Var[] dual;
    IVar.Var[][] distance;

    public LinearArrangementSoft() {
        this.nNodes = this.graph.nNodes;
        this.primal = this.array("primal", this.size(this.nNodes), this.dom(this.range(this.nNodes)), "The primal variables: p_i denotes the 'node' at the i-th position of the stack to be built", new Types.TypeClass[0]);
        this.dual = this.array("dual", this.size(this.nNodes), this.dom(this.range(this.nNodes + 1)), "The dual variables: n_i denotes the position of the 'node' whose value is i", new Types.TypeClass[0]);
        this.distance = this.array("d", this.size(this.nNodes, this.nNodes), (i, j) -> i < j && this.graph.adjacency[i][j] == 1L ? this.dom(this.range(1, this.nNodes)) : null, new Types.TypeClass[0]);
    }

    public void model() {
        int j;
        int i;
        this.allDifferent(this.primal);
        this.allDifferent(this.dual);
        int[][] tuples = new int[this.graph.nNodes * this.graph.nNodes][];
        int[] costs = new int[tuples.length];
        for (i = 0; i < this.graph.nNodes; ++i) {
            for (j = 0; j < this.graph.nNodes; ++j) {
                tuples[i * this.graph.nNodes + j] = new int[]{i, j};
                costs[i * this.graph.nNodes + j] = i == j ? Integer.MAX_VALUE : Math.abs(i - j);
            }
        }
        for (i = 0; i < this.graph.nNodes; ++i) {
            for (j = i + 1; j < this.graph.nNodes; ++j) {
                if (this.graph.adjacency[i][j] != 1L) continue;
                ((Problem)this.imp()).ctrSoft(this.vars(this.primal[i], (IVar)this.primal[j]), (int[][])tuples, costs, Integer.MAX_VALUE);
            }
        }
        for (i = 0; i < this.primal.length; ++i) {
            this.element(this.dual, this.primal[i], i);
        }
        for (i = 0; i < this.graph.nNodes; ++i) {
            for (j = i + 1; j < this.graph.nNodes; ++j) {
                if (this.graph.adjacency[i][j] != 1L) continue;
                this.intension(this.eq(new Object[]{this.distance[i][j], this.abs(this.sub(this.primal[i], this.primal[j]))}));
            }
        }
        for (i = 0; i < this.graph.nNodes; ++i) {
            for (j = i + 1; j < this.graph.nNodes; ++j) {
                if (this.graph.adjacency[i][j] != 1L) continue;
                for (int k = 0; k < this.graph.nNodes; ++k) {
                    if (k == i || k == j || this.graph.adjacency[i][k] != 1L || this.graph.adjacency[j][k] != 1L) continue;
                    this.intension(this.le(this.distance[i][j], this.add(new Object[]{i < k ? this.distance[i][k] : this.distance[k][i], j < k ? this.distance[j][k] : this.distance[k][j]})));
                }
            }
        }
    }
}

