/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.structures.Table;
import org.xcsp.modeler.api.ProblemAPI;

public class Rack2
implements ProblemAPI {
    int nRacks;
    RackModel[] rackModels;
    CardType[] cardTypes;

    public void model() {
        this.rackModels = (RackModel[])this.addObject(this.rackModels, new RackModel(), 0);
        int nModels = this.rackModels.length;
        int nTypes = this.cardTypes.length;
        int[] powers = this.valuesFrom(this.rackModels, rackModel -> rackModel.power);
        int[] sizes = this.valuesFrom(this.rackModels, rackModel -> rackModel.nConnectors);
        int[] costs = this.valuesFrom(this.rackModels, rackModel -> rackModel.price);
        int[] cardPowers = this.valuesFrom(this.cardTypes, cardType -> cardType.power);
        int maxCapacity = this.maxOf(sizes);
        Table table = this.table().addFrom(this.range(nModels), i -> this.tuple((int)i, new int[]{powers[i], sizes[i], costs[i]}));
        IVar.Var[] m = this.array("m", this.size(this.nRacks), this.dom(this.range(nModels)), "m[i] is the model used for the ith rack", new Types.TypeClass[0]);
        IVar.Var[][] nc = this.array("nc", this.size(this.nRacks, nTypes), (i, j) -> this.dom(this.range(Math.min(maxCapacity, this.cardTypes[j].demand) + 1)), "nc[i][j] is the number of cards of type j put in the ith rack", new Types.TypeClass[0]);
        IVar.Var[] p = this.array("p", this.size(this.nRacks), this.dom(powers), "p[i] is the power of the ith rack", new Types.TypeClass[0]);
        IVar.Var[] s = this.array("s", this.size(this.nRacks), this.dom(sizes), "s[i] is the size of the ith rack", new Types.TypeClass[0]);
        IVar.Var[] c = this.array("c", this.size(this.nRacks), this.dom(costs), "c[i] is the cost of the ith rack", new Types.TypeClass[0]);
        this.forall(this.range(this.nRacks), i -> this.extension((IVar.Var[])this.vars((IVar)m[i], (IVar[])new IVar.Var[]{p[i], s[i], c[i]}), table)).note("linking model with power, size and cost of the ith rack");
        this.forall(this.range(this.nRacks), i -> this.sum(nc[i], LE, s[i])).note("connector-capacity constraints");
        this.forall(this.range(this.nRacks), i -> this.sum(nc[i], this.weightedBy(cardPowers), LE, p[i])).note("power-capacity constraints");
        this.forall(this.range(nTypes), i -> this.sum((IVar.Var[])this.columnOf(nc, i), EQ, this.cardTypes[i].demand)).note("demand constraints");
        this.block(() -> {
            this.decreasing(m);
            this.disjunction(new Object[]{this.ne(new Object[]{m[0], m[1]}), this.ge(nc[0][0], nc[1][0])});
        }).tag(new Types.TypeClass[]{SYMMETRY_BREAKING});
        this.minimize(SUM, (IVar[])c).note("minimizing the total cost paid for all racks");
    }

    class CardType {
        int power;
        int demand;

        CardType() {
        }
    }

    class RackModel {
        int power;
        int nConnectors;
        int price;

        RackModel() {
        }
    }
}

