/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.structures.Table;
import org.xcsp.modeler.api.ProblemAPI;
import org.xcsp.modeler.implementation.NotData;

public class CrosswordDesignSho
implements ProblemAPI {
    private static final int N_LETTERS = 26;
    int n;
    int nMaxWords;
    int wordSizeLimit;
    String mainDict;
    String thematicDict;
    @NotData
    String[] words;
    @NotData
    int[] wordsPoints;
    @NotData
    int[] oneLetterPositions;

    private static Stream<String> oneLetterWords() {
        return IntStream.range(0, 26).mapToObj(i -> (char)(i + 97) + "");
    }

    private static Stream<String> twoLetterWords() {
        return IntStream.range(0, 26).mapToObj(i -> IntStream.range(0, 26).mapToObj(j -> (char)(i + 97) + "" + (char)(j + 97))).flatMap(s -> s);
    }

    private void loadWords() {
        this.words = (String[])Stream.concat(Stream.concat(CrosswordDesignSho.oneLetterWords(), CrosswordDesignSho.twoLetterWords()), Stream.concat(this.readFileLines(this.mainDict), this.readFileLines(this.thematicDict))).filter(w -> w.length() <= (this.wordSizeLimit == -1 ? this.n : this.wordSizeLimit)).distinct().sorted().toArray(String[]::new);
        this.wordsPoints = new int[this.words.length];
        List<String> list = Arrays.asList(this.words);
        this.readFileLines(this.thematicDict).forEach(w -> {
            int pos = list.indexOf(w);
            if (pos != -1) {
                this.wordsPoints[pos] = w.length();
            }
        });
        this.oneLetterPositions = CrosswordDesignSho.oneLetterWords().mapToInt(w -> list.indexOf(w)).toArray();
    }

    private Table shortTableFor(int k) {
        int[] possiblePositions;
        int[] nArray;
        boolean lastWord = k == this.nMaxWords - 1;
        ArrayList<int[]> list = new ArrayList<int[]>();
        if (k != 0) {
            list.add(this.range(this.n + 4).map(i -> i == 0 || i == 1 | i == 3 ? -1 : (i == 2 ? 0 : 0x7FFFFFFE)));
        }
        if (k == 0) {
            int[] nArray2 = new int[2];
            nArray2[0] = 0;
            nArray = nArray2;
            nArray2[1] = 1;
        } else {
            nArray = this.vals(new Object[]{this.range(2 * k, this.n)});
        }
        for (int p : possiblePositions = nArray) {
            for (int i2 = 0; i2 < this.words.length; ++i2) {
                int bp = p + this.words[i2].length();
                if (bp > this.n) continue;
                int[] tuple = new int[this.n + 4];
                tuple[0] = p;
                tuple[1] = i2;
                tuple[2] = this.wordsPoints[i2];
                if (lastWord && bp < this.n - 1) continue;
                tuple[3] = lastWord ? -1 : (bp <= this.n - 2 ? bp + 1 : -1);
                for (int j = 4; j < tuple.length; ++j) {
                    tuple[j] = j - 4 == p - 1 || j - 4 == bp ? 26 : (p <= j - 4 && j - 4 < p + this.words[i2].length() ? this.words[i2].charAt(j - 4 - p) - 97 : 0x7FFFFFFE);
                }
                list.add(tuple);
            }
        }
        return this.table().add(list);
    }

    public void model() {
        this.loadWords();
        this.nMaxWords = this.nMaxWords == -1 ? (this.n + 1) / 2 : this.nMaxWords;
        IVar.Var[][] x = this.array("x", this.size(this.n, this.n), this.dom(this.range(27)), "x[i][j] is the (number of) letter at row i and col j; 26 stands for a black point", new Types.TypeClass[0]);
        IVar.Var[][] r = this.array("r", this.size(this.n, this.nMaxWords), this.dom(this.range(-1, this.words.length)), "r[i][k] is the (index of) kth word at row i; -1 means 'no word'", new Types.TypeClass[0]);
        IVar.Var[][] c = this.array("c", this.size(this.n, this.nMaxWords), this.dom(this.range(-1, this.words.length)), "c[j][k] is the (index of) kth word at col j; -1 means 'no word'", new Types.TypeClass[0]);
        IVar.Var[][] pr = this.array("pr", this.size(this.n, this.nMaxWords + 1), (i, k) -> k == 0 ? this.dom(0, new int[]{1}) : (k == this.nMaxWords ? this.dom(-1, new int[0]) : this.dom(this.range(-1, this.n))), "pr[i][k] is the position (index of col) of the kth word at row i; -1 means 'no position' because 'no word'", new Types.TypeClass[0]);
        IVar.Var[][] pc = this.array("pc", this.size(this.n, this.nMaxWords + 1), (j, k) -> k == 0 ? this.dom(0, new int[]{1}) : (k == this.nMaxWords ? this.dom(-1, new int[0]) : this.dom(this.range(-1, this.n))), "pc[j][k] is the position (index of row) of the kth word at col j; -1 means 'no position' because 'no word'", new Types.TypeClass[0]);
        IVar.Var[][] br = this.array("br", this.size(this.n, this.nMaxWords), this.dom(this.range(this.n + 1)), "br[i][k] is the benefit of the kth word at row i; 0 means that the word is either absent or from the full dictionary", new Types.TypeClass[0]);
        IVar.Var[][] bc = this.array("bc", this.size(this.n, this.nMaxWords), this.dom(this.range(this.n + 1)), "bc[j][k] is the benfit of the kth word at col j; 0 means that the word is either absent or from the full dictionary", new Types.TypeClass[0]);
        Table[] tables = (Table[])IntStream.range(0, this.nMaxWords).mapToObj(k -> this.shortTableFor(k)).toArray(Table[]::new);
        this.forall(this.range(this.n).range(this.nMaxWords), (i, k) -> this.extension((IVar.Var[])this.vars(pr[i][k], new Object[]{r[i][k], br[i][k], pr[i][k + 1], x[i]}), tables[k]));
        this.forall(this.range(this.n).range(this.nMaxWords), (j, k) -> this.extension((IVar.Var[])this.vars(pc[j][k], new Object[]{c[j][k], bc[j][k], pc[j][k + 1], this.columnOf(x, j)}), tables[k]));
        this.atMost((IVar.Var[])this.vars((IVar[][])x), 26, this.n * 2);
        this.maximize(SUM, this.vars(br, (IVar[][])bc)).note("maximizing the summed benefit of words put in the grid");
    }
}

