/*
 * Decompiled with CFR 0.152.
 */
package problems.g3_pattern;

import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;

public class Warehouse
implements ProblemAPI {
    int fixedCost;
    int[] warehouseCapacities;
    int[][] storeSupplyCosts;

    public void model() {
        int nWarehouses = this.warehouseCapacities.length;
        int nStores = this.storeSupplyCosts.length;
        IVar.Var[] sw = this.array("sw", this.size(nStores), this.dom(this.range(nWarehouses)), "sw[i] is the supplying warehouse for the ith store", new Types.TypeClass[0]);
        IVar.Var[] sc = this.array("sc", this.size(nStores), i -> this.dom(this.storeSupplyCosts[i]), "sc[i] is the supplying cost for the ith store", new Types.TypeClass[0]);
        IVar.Var[] open = this.array("open", this.size(nWarehouses), this.dom(0, new int[]{1}), "open[i] is 1 if the ith warehouse is open", new Types.TypeClass[0]);
        this.forall(this.range(nWarehouses), i -> this.atMost(sw, this.takingValue(i), this.warehouseCapacities[i])).note("Capacities of warehouses must not be exceeded.");
        this.forall(this.range(nStores), i -> this.element(open, this.at(sw[i]), this.takingValue(1))).note("The warehouse supplier of the ith store must be open.");
        this.forall(this.range(nStores), i -> this.element(this.storeSupplyCosts[i], this.at(sw[i]), this.takingValue(sc[i]))).note("Computing the cost of supplying the ith store.");
        int[] coeffs = this.vals(new Object[]{this.repeat(1, nStores), this.repeat(this.fixedCost, nWarehouses)});
        this.minimize(SUM, this.vars(sc, (IVar[])open), this.weightedBy(coeffs)).note("minimizing the overall cost");
    }
}

