/*
 * Decompiled with CFR 0.152.
 */
package problems.g3_pattern;

import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.structures.Table;
import org.xcsp.modeler.api.ProblemAPI;

public class VesselLoading
implements ProblemAPI {
    int containerWidth;
    int containerHeight;
    Container[] containers;
    int[][] separations;

    Table shortTable(int i, int j, int separation) {
        Table table = this.table();
        int min = Math.min(this.containers[i].width, this.containers[i].height);
        int max = Math.max(this.containers[i].width, this.containers[i].height);
        for (int xi = 0; xi < this.containerWidth - min; ++xi) {
            for (int k = min; k < max; ++k) {
                table.add(xi, new int[]{min, xi + k + separation, 0x7FFFFFFE, 0x7FFFFFFE, 0x7FFFFFFE, 0x7FFFFFFE, 0x7FFFFFFE});
            }
            int xj = xi + max + separation;
            while (xj < this.containerWidth) {
                table.add(xi, new int[]{0x7FFFFFFE, xj++, 0x7FFFFFFE, 0x7FFFFFFE, 0x7FFFFFFE, 0x7FFFFFFE, 0x7FFFFFFE});
            }
        }
        return table;
    }

    public void model() {
        int nContainers = this.containers.length;
        IVar.Var[] x = this.array("x", this.size(nContainers), this.dom(this.range(this.containerWidth)), "x[i] is the x-coordinate of the ith container", new Types.TypeClass[0]);
        IVar.Var[] y = this.array("y", this.size(nContainers), this.dom(this.range(this.containerHeight)), "y[i] is the y-coordinate of the ith container", new Types.TypeClass[0]);
        IVar.Var[] w = this.array("w", this.size(nContainers), i -> this.dom(this.containers[i].width, new int[]{this.containers[i].height}), "w[i] is the width of the ith container", new Types.TypeClass[0]);
        IVar.Var[] h = this.array("h", this.size(nContainers), i -> this.dom(this.containers[i].width, new int[]{this.containers[i].height}), "h[i] is the height of the ith container", new Types.TypeClass[0]);
        IVar.Var[] r = this.array("r", this.size(nContainers), this.dom(0, new int[]{1}), "r[i] is 1 iff the ith container is rotated by 90 degrees", new Types.TypeClass[0]);
        this.forall(this.range(nContainers), i -> this.lessEqual(this.add(new Object[]{x[i], w[i]}), this.containerWidth)).note("horizontal control");
        this.forall(this.range(nContainers), i -> this.lessEqual(this.add(new Object[]{y[i], h[i]}), this.containerHeight)).note("vertical control");
        this.forall(this.range(nContainers), i -> {
            Table table = this.table(0, new int[]{this.containers[i].width, this.containers[i].height}).add(1, new int[]{this.containers[i].height, this.containers[i].width});
            this.extension((IVar.Var[])this.vars((IVar)r[i], (IVar[])new IVar.Var[]{w[i], h[i]}), table);
        }).note("managing rotation");
        this.noOverlap((IVar.Var[][])this.transpose(new IVar.Var[][]{x, y}), (IVar.Var[][])this.transpose(new IVar.Var[][]{w, h})).note("no overlapping between rectangles");
    }

    class Container {
        int width;
        int height;
        int type;

        Container() {
        }
    }
}

